/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.editors;

import com.blixx.boom.editors.PathEditorInput;
import com.blixx.boom.editors.SimplePartitionScanner;
import com.blixx.boom.engine.ServerClient;
import com.blixx.log.RTLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class SimpleDocumentProvider
extends AbstractDocumentProvider {
    protected IDocument createDocument(Object element) throws CoreException {
        if (element instanceof IEditorInput) {
            boolean ok;
            Document document = new Document();
            if (document != null && (ok = this.setDocumentContent((IDocument)document, (IEditorInput)element))) {
                this.setupDocument((IDocument)document);
            }
            return document;
        }
        return null;
    }

    private boolean setDocumentContent(IDocument document, IEditorInput input) throws CoreException {
        FileReader reader;
        block5: {
            try {
                if (input instanceof IPathEditorInput) {
                    reader = new FileReader(((IPathEditorInput)input).getPath().toFile());
                    break block5;
                }
                return false;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return true;
            }
        }
        try {
            this.setDocumentContent(document, reader);
            return true;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.blixx.boom.editors", 0, "error reading file", (Throwable)e));
        }
    }

    private void setDocumentContent(IDocument document, Reader reader) throws IOException {
        try (BufferedReader in = new BufferedReader(reader);){
            StringBuffer buffer = new StringBuffer(512);
            char[] readBuffer = new char[512];
            int n = in.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
            document.set(buffer.toString());
        }
    }

    protected void setupDocument(IDocument document) {
        if (document != null) {
            SimplePartitionScanner scanner = new SimplePartitionScanner();
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)scanner, SimplePartitionScanner.PARTITION_TYPES);
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        block8: {
            if (element instanceof IPathEditorInput) {
                IPathEditorInput pei = (IPathEditorInput)element;
                IPath path = pei.getPath();
                File file = path.toFile();
                try {
                    if (file.exists()) {
                        if (file.canWrite()) {
                            FileWriter writer = new FileWriter(file);
                            this.writeDocumentContent(document, writer, monitor);
                            if (file.getPath().contains(String.valueOf(File.separator) + "packages")) {
                                String[] s = file.getPath().split("packages");
                                String srvPath = "srv/packages" + s[s.length - 1].replaceAll("\\\\", "/");
                                ServerClient sc = ServerClient.putFile(srvPath, file.getPath());
                                sc.runInUIThread(null);
                                if (sc.isSuccess()) {
                                    RTLogger.print(5, "file sent to server: " + file.getPath());
                                } else {
                                    RTLogger.print(5, "Error sending file to server: " + file.getPath());
                                }
                            }
                            break block8;
                        }
                        throw new CoreException((IStatus)new Status(4, "com.blixx.boom.editors", 0, "file is read-only", null));
                    }
                    throw new CoreException((IStatus)new Status(4, "com.blixx.boom.editors", 0, "error creating file", null));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.blixx.boom.editors", 0, "error when saving file", (Throwable)e));
                }
            }
        }
    }

    protected void writeDocumentContent(IDocument document, Writer writer, IProgressMonitor monitor) throws IOException {
        try (BufferedWriter out = new BufferedWriter(writer);){
            out.write(document.get());
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isModifiable(Object element) {
        if (element instanceof IPathEditorInput) {
            IPathEditorInput pei = (IPathEditorInput)element;
            File file = pei.getPath().toFile();
            return file.canWrite() || !file.exists();
        }
        return false;
    }

    public boolean isReadOnly(Object element) {
        return !this.isModifiable(element);
    }

    public boolean isStateValidated(Object element) {
        return true;
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        super.disposeElementInfo(element, info);
        File file = ((PathEditorInput)element).getPath().toFile();
        String[] s = file.getPath().split("tmp\\\\srv\\\\packages");
        if (s[0].length() < file.getPath().length()) {
            if (file.delete()) {
                RTLogger.print(5, "Close and delete tmp file: " + file.getPath());
            } else {
                RTLogger.print(5, "Cannot delete tmp file: " + file.getPath());
            }
        }
    }

    public void aboutToChange(Object element) {
        super.aboutToChange(element);
    }

    public boolean canSaveDocument(Object element) {
        return super.canSaveDocument(element);
    }

    public void changed(Object element) {
        super.changed(element);
    }

    protected boolean invalidatesState(Object element, boolean wasReadOnly) {
        return super.invalidatesState(element, wasReadOnly);
    }

    public void validateState(Object element, Object computationContext) throws CoreException {
        super.validateState(element, computationContext);
    }
}

