/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.editors;

import com.blixx.boom.editors.IEditorMenuListener;
import com.blixx.boom.editors.SimpleConfiguration;
import com.blixx.boom.editors.SimpleDocumentProvider;
import com.blixx.boom.editors.SimpleDocumentProviderReadOnly;
import com.blixx.boom.editors.xml.ColorManager;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class SimpleEditor
extends AbstractTextEditor
implements SelectionListener {
    private static final String SHOWWS = "SHOWWS";
    private static final String WINCRLF2 = "WINCRLF";
    private static final String UNIXLF2 = "UNIXLF";
    public static final String WINDOWS_CRLF = "Windows CRLF";
    public static final String UNIX_LF = "Unix LF";
    public static final String ENCODING_TEXT = "encoding.text";
    private static String ID = "com.blixx.boom.editors.SimpleEditor";
    private ColorManager colorManager;
    public String m_mode;
    protected SimpleDocumentProvider m_provider;
    private static String SAVE = "SAVE";
    private static String REVERT = "REVERT";
    private Button m_save_btn = null;
    private Button m_revert_btn = null;
    private ISharedImages m_sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
    private boolean enableButtons = true;
    List<IEditorMenuListener> m_listeners = new ArrayList<IEditorMenuListener>();
    private Button unixLF;
    private Button winCRLF;
    private Button showWhiteSpaces;

    public SimpleEditor() {
        this.setKeyBinding();
        this.internal_init();
    }

    public SimpleEditor(SimpleDocumentProvider provider) {
        this.m_provider = provider;
        this.setKeyBinding();
        this.internal_init();
        this.enableButtons = false;
    }

    public void setKeyBinding() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope"});
    }

    protected void internal_init() {
        this.configureInsertMode(SMART_INSERT, false);
        this.colorManager = new ColorManager();
        this.setSourceViewerConfiguration(new SimpleConfiguration(this.colorManager));
        if (this.m_provider == null) {
            this.m_provider = new SimpleDocumentProvider();
        }
        this.setDocumentProvider((IDocumentProvider)this.m_provider);
    }

    public void dispose() {
        super.dispose();
    }

    public static String getID() {
        return ID;
    }

    protected IVerticalRuler createVerticalRuler() {
        CompositeRuler cr = new CompositeRuler(20);
        LineNumberRulerColumn lnrc = new LineNumberRulerColumn();
        lnrc.setBackground(BMUI.color_light_yellow);
        lnrc.setForeground(BMUI.color_blue);
        cr.addDecorator(0, (IVerticalRulerColumn)lnrc);
        return cr;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.contributeToStatusLine();
    }

    protected void handleEditorInputChanged() {
        this.contributeToStatusLine();
        super.handleEditorInputChanged();
    }

    public void updateActions(boolean isActive) {
        IAction a;
        if (isActive) {
            a = this.getAction(ITextEditorActionConstants.SAVE);
            this.setAction(a.getId(), a);
            a = this.getAction(ITextEditorActionConstants.REDO);
            this.setAction(a.getId(), a);
            a = this.getAction(ITextEditorActionConstants.UNDO);
            this.setAction(a.getId(), a);
            a = this.getAction(ITextEditorActionConstants.FIND);
            this.setAction(a.getId(), a);
            a = this.getAction(ITextEditorActionConstants.REVERT);
            this.setAction(a.getId(), a);
            a = this.getAction(ITextEditorActionConstants.CUT);
            this.setAction(a.getId(), a);
            a = this.getAction(ITextEditorActionConstants.COPY);
            this.setAction(a.getId(), a);
            a = this.getAction(ITextEditorActionConstants.PASTE);
            this.setAction(a.getId(), a);
        }
        if ((a = this.getAction(ITextEditorActionConstants.SAVE)) != null && this.isEditable()) {
            a.setEnabled(this.isDirty());
        }
    }

    private void contributeToStatusLine() {
        try {
            this.m_mode = UNIX_LF;
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            int i = 0;
            while (i < doc.getNumberOfLines()) {
                try {
                    String lineEnd = doc.getLineDelimiter(i);
                    if (lineEnd != null && lineEnd.indexOf(13) != -1) {
                        this.m_mode = WINDOWS_CRLF;
                        break;
                    }
                }
                catch (BadLocationException badLocationException) {}
                ++i;
            }
            if (UNIX_LF == this.m_mode) {
                this.unixLF.setSelection(true);
                this.winCRLF.setSelection(false);
            } else {
                this.unixLF.setSelection(false);
                this.winCRLF.setSelection(true);
            }
        }
        catch (Throwable throwable) {}
    }

    public void setFocus() {
        super.setFocus();
        this.contributeToStatusLine();
    }

    public void setMode(boolean unix) {
        this.unixLF.removeSelectionListener((SelectionListener)this);
        this.winCRLF.removeSelectionListener((SelectionListener)this);
        try {
            if (unix) {
                this.convertCR(true);
                this.m_mode = UNIX_LF;
                this.unixLF.setSelection(true);
                this.winCRLF.setSelection(false);
            } else {
                this.convertCR(false);
                this.m_mode = WINDOWS_CRLF;
                this.unixLF.setSelection(false);
                this.winCRLF.setSelection(true);
            }
        }
        catch (Exception exception) {}
        this.unixLF.addSelectionListener((SelectionListener)this);
        this.winCRLF.addSelectionListener((SelectionListener)this);
    }

    public boolean isEditable() {
        if (this.m_provider instanceof SimpleDocumentProviderReadOnly) {
            return false;
        }
        return super.isEditable();
    }

    public boolean isDirty() {
        if (this.m_provider instanceof SimpleDocumentProviderReadOnly) {
            return false;
        }
        boolean dirty = super.isDirty();
        return dirty;
    }

    public Control getControl() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        return sourceViewer.getTextWidget();
    }

    public void createActionsForce() {
        this.createActions();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IAction find = this.getAction(ITextEditorActionConstants.FIND);
        menu.add(find);
        for (IEditorMenuListener l : this.m_listeners) {
            l.editorContextMenuAboutToShow(menu);
        }
    }

    public void addEditorMenuListener(IEditorMenuListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void removeEditorMenuListener(IEditorMenuListener listener) {
        this.m_listeners.remove(listener);
    }

    public void createPartControl(Composite parent) {
        Composite compInCTab = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compInCTab.setLayout((Layout)gl);
        super.createPartControl(compInCTab);
        this.getVerticalRuler().getControl().getParent().setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.enableButtons) {
            Composite compBtn = new Composite(compInCTab, 0);
            GridData gd = new GridData(4, 1024, true, false);
            gd.verticalIndent = 10;
            compBtn.setLayoutData((Object)gd);
            GUIDisplayElements mgui = new GUIDisplayElements();
            if (this.isEditable()) {
                gl = new GridLayout(7, false);
                gl.horizontalSpacing = 0;
                compBtn.setLayout((Layout)gl);
                this.m_save_btn = mgui.addButton(compBtn, SAVE, " Save ", false, 60, 0, 0, this);
                ((GridData)this.m_save_btn.getLayoutData()).horizontalAlignment = 4;
                this.m_save_btn.setImage(this.m_sharedImages.getImage("IMG_ETOOL_SAVE_EDIT"));
                this.m_revert_btn = mgui.addButton(compBtn, REVERT, " Revert File ", true, 60, 0, 0, this);
                ((GridData)this.m_revert_btn.getLayoutData()).horizontalAlignment = 4;
            } else {
                gl = new GridLayout(5, false);
                gl.horizontalSpacing = 0;
                compBtn.setLayout((Layout)gl);
                this.m_revert_btn = mgui.addButton(compBtn, REVERT, " Revert File ", true, 60, 0, 0, this);
                ((GridData)this.m_revert_btn.getLayoutData()).horizontalAlignment = 4;
            }
            GridData gdWs = new GridData(16384, 0x1000000, false, false);
            GridData gdWs2 = new GridData(16384, 0x1000000, false, false);
            gdWs2.horizontalIndent = 20;
            this.unixLF = mgui.addRadioButton(compBtn, UNIXLF2, UNIX_LF, false, 0, 0, 20, 0, this);
            this.unixLF.setLayoutData((Object)gdWs2);
            this.winCRLF = mgui.addRadioButton(compBtn, WINCRLF2, "Windows CR/LF", false, 0, 0, 0, 0, this);
            this.winCRLF.setLayoutData((Object)gdWs);
            this.showWhiteSpaces = mgui.addCheckbox(compBtn, SHOWWS, "Show whitespace characters", false, this);
            GridData lastGD = new GridData(4, 0x1000000, true, false);
            lastGD.horizontalIndent = 20;
            this.showWhiteSpaces.setLayoutData((Object)lastGD);
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        return super.createSourceViewer(parent, ruler, styles);
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o instanceof Button) {
            Button btn = (Button)o;
            String name = (String)btn.getData();
            if (name.equals(SAVE)) {
                this.getAction(ITextEditorActionConstants.SAVE).runWithEvent(new Event());
            } else if (name.equals(REVERT)) {
                this.getAction(ITextEditorActionConstants.REVERT).runWithEvent(new Event());
            } else if (name.equals(UNIXLF2)) {
                if (btn.getSelection()) {
                    this.setMode(true);
                }
            } else if (name.equals(WINCRLF2)) {
                if (btn.getSelection()) {
                    this.setMode(false);
                }
            } else if (name.equals(SHOWWS)) {
                IAction action = this.getAction("ShowWhitespaceCharacters");
                action.setChecked(btn.getSelection());
                action.run();
            }
        }
    }

    public void convertCR(boolean unix) {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (unix) {
            String content = doc.get();
            content = content.replace("\r", "");
            doc.set(content);
        } else {
            String content = doc.get();
            content = content.replace("\r", "");
            content = content.replace("\n", "\r\n");
            doc.set(content);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void updateContentDependentActions() {
        super.updateContentDependentActions();
        try {
            this.m_save_btn.setEnabled(this.getAction(ITextEditorActionConstants.SAVE).isEnabled());
            this.m_revert_btn.setEnabled(this.getAction(ITextEditorActionConstants.REVERT).isEnabled());
        }
        catch (Throwable throwable) {}
    }

    protected void editorSaved() {
        super.editorSaved();
        try {
            this.m_save_btn.setEnabled(this.getAction(ITextEditorActionConstants.SAVE).isEnabled());
            this.m_revert_btn.setEnabled(this.getAction(ITextEditorActionConstants.REVERT).isEnabled());
        }
        catch (Throwable throwable) {}
    }
}

