/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.emu;

import com.blixx.boom.emu.DualBrowser;
import com.blixx.boom.emu.Image;
import com.blixx.boom.emu.Link;
import com.blixx.boom.emu.Step;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;

public class AddTransactionAction
extends Action {
    private DualBrowser m_dualBrowser = null;
    private GroupTreeObject m_selectedStepGTO = null;
    private ArrayList<GroupTreeObject> m_elements = null;

    public AddTransactionAction(DualBrowser dualBrowser) {
        super("AddTransactionAction");
        GroupTreeObject gto;
        Object o;
        this.setId("AddTransactionAction");
        this.setText("Add Transaction");
        this.m_dualBrowser = dualBrowser;
        this.m_elements = new ArrayList();
        if (this.m_dualBrowser == null) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection ssel = (StructuredSelection)this.m_dualBrowser.m_treeViewer_steps.getSelection();
        if (!ssel.isEmpty() && (o = ssel.getFirstElement()) instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast) && (gto = (GroupTreeObject)o).getTreeObject() instanceof Step && gto.getTreeObject().getType().equals(Step.STEP)) {
            this.m_selectedStepGTO = gto;
        }
        if (this.m_selectedStepGTO == null) {
            this.setEnabled(false);
            return;
        }
        List<GroupTreeObject> allElements = this.m_selectedStepGTO.getAllElements();
        int i = 0;
        while (i < allElements.size()) {
            GroupTreeObject gtobj = allElements.get(i);
            if (!gtobj.equals(this.m_selectedStepGTO) && this.m_dualBrowser.m_treeViewer_steps.getChecked((Object)gtobj)) {
                GroupTreeObject newStepGTO;
                Step step;
                String objType = gtobj.getTreeObject().getType();
                if (objType.equals(Step.STEP)) {
                    step = (Step)gtobj.getTreeObject();
                    newStepGTO = new GroupTreeObject(step);
                    this.m_elements.add(newStepGTO);
                } else if (objType.equals(Step.FORM)) {
                    step = (Step)gtobj.getTreeObject();
                    newStepGTO = new GroupTreeObject(step);
                    this.m_elements.add(newStepGTO);
                } else if (objType.equals(Link.TYPE_LINK)) {
                    Link link = (Link)gtobj.getTreeObject();
                    newStepGTO = new GroupTreeObject(link);
                    this.m_elements.add(newStepGTO);
                } else if (objType.equals(Image.TYPE_IMAGE)) {
                    Image image = (Image)gtobj.getTreeObject();
                    newStepGTO = new GroupTreeObject(image);
                    this.m_elements.add(newStepGTO);
                }
            }
            ++i;
        }
        if (this.m_selectedStepGTO == null || this.m_elements.size() == 0) {
            this.setEnabled(false);
            return;
        }
    }

    public void run() {
        if (this.m_selectedStepGTO == null) {
            return;
        }
        int count = this.getMaxtCount();
        this.m_dualBrowser.m_currTransactionName = "(" + (count + 1) + ") " + this.m_selectedStepGTO.getName();
        GroupTreeObject newTransactionGTO = new GroupTreeObject(new TreeObject(this.m_dualBrowser.m_currTransactionName, DualBrowser.TYPE_TRANSACTION, null));
        int i = 0;
        while (i < this.m_elements.size()) {
            newTransactionGTO.addElement(this.m_elements.get(i));
            ++i;
        }
        GroupTreeObject topElement = this.m_dualBrowser.m_transactionTree.getChild(newTransactionGTO.getName(), newTransactionGTO.getType());
        if (topElement != null) {
            this.m_dualBrowser.m_transactionTree.removeElement(topElement);
        }
        this.m_dualBrowser.m_transactionTree.addElement(newTransactionGTO);
        this.m_dualBrowser.m_treeViewer_transaction.refresh();
        this.m_dualBrowser.m_treeViewer_transaction.collapseAll();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.m_dualBrowser.m_treeViewer_steps);
        list.add(newTransactionGTO);
        DualBrowser.stepsTransactionMap.put(this.m_dualBrowser.m_currTransactionName, list);
    }

    public int getMaxtCount() {
        int count = 1;
        int maxCount = 0;
        List<GroupTreeObject> elements = this.m_dualBrowser.m_transactionTree.getElements();
        int i = 0;
        while (i < elements.size()) {
            String name = elements.get(i).getName();
            int end = name.indexOf(")");
            String subStr = name.substring(1, end);
            try {
                count = Integer.valueOf(subStr);
                if (count > maxCount) {
                    maxCount = count;
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return maxCount;
    }
}

