/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.emu;

import com.blixx.boom.emu.CheckResult;
import com.blixx.boom.emu.Image;
import com.blixx.boom.emu.Link;
import com.blixx.boom.emu.Step;
import com.blixx.shared.utils.ITreeObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Check
implements ITreeObject {
    String m_name = null;
    String m_type = null;
    public static final String NOT_CHECKED = "not checked";
    public static final String CHECK_IMAGES = "CHECK_IMAGES";
    public static final String CHECK_TEXT = "CHECK_TEXT";
    public static final String CHECK_LINKS = "CHECK_LINKS";
    double sizeMB = 0.0;
    long timeSec = 0L;
    private String oid = null;

    public Check(String name, String type) {
        this.m_name = name;
        this.m_type = type;
    }

    @Override
    public String getComparableName() {
        return this.m_name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public void setObject(Object obj) {
    }

    @Override
    public void setType(String type) {
        this.m_type = type;
    }

    public boolean doCheck(Step step) {
        boolean isOK = true;
        if (this.m_type == CHECK_IMAGES) {
            Hashtable images = step.getImages();
            this.checkURLs(images, step.getMainUrl());
        } else if (this.m_type == CHECK_LINKS) {
            Hashtable links = step.getLinks();
            this.checkURLs(links, step.getMainUrl());
        }
        return isOK;
    }

    private void checkURLs(Map links, String mainURL) {
        this.sizeMB = 0.0;
        this.timeSec = 0L;
        Iterator it = links.keySet().iterator();
        while (it.hasNext()) {
            Link link = null;
            Image image = null;
            String urlStr = null;
            Object o = it.next();
            if (o instanceof Link) {
                link = (Link)o;
                urlStr = link.getUrl().trim();
            } else if (o instanceof Image) {
                image = (Image)o;
                urlStr = image.getUrl().trim();
            }
            CheckResult cr = new CheckResult();
            try {
                String resolvedUrlStr = urlStr;
                if (!urlStr.startsWith("http")) {
                    resolvedUrlStr = String.valueOf(mainURL) + urlStr;
                }
                String HTTPRESPONSE = null;
                URL url = new URL(resolvedUrlStr);
                try {
                    URLConnection conn = url.openConnection();
                    long time = System.currentTimeMillis();
                    conn.connect();
                    Map<String, List<String>> headers = conn.getHeaderFields();
                    HTTPRESPONSE = "" + headers.get(null);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    InputStream inputStream = conn.getInputStream();
                    byte[] arr = new byte[16000];
                    int len = -1;
                    while ((len = inputStream.read(arr)) != -1 && bos.size() < 2000000) {
                        bos.write(arr, 0, len);
                    }
                    bos.close();
                    inputStream.close();
                    cr.time = (int)(System.currentTimeMillis() - time);
                    cr.monitorValue = 1;
                    cr.httpStatus = HTTPRESPONSE;
                    if (bos.size() > 0) {
                        cr.size = bos.size();
                    }
                }
                catch (IOException e) {
                    cr.httpStatus = HTTPRESPONSE;
                    cr.error = "ERR002 " + e.getMessage();
                }
            }
            catch (Throwable e) {
                cr.error = "ERR001 " + e.getMessage();
            }
            this.sizeMB += (double)cr.size;
            this.timeSec += (long)cr.time;
            if (o instanceof Link && link != null) {
                link.setResult(cr);
                links.put(link, "");
                continue;
            }
            if (!(o instanceof Image) || image == null) continue;
            image.setResult(cr);
            links.put(image, "");
        }
        this.sizeMB /= 1048576.0;
        this.timeSec /= 1000L;
    }

    @Override
    public String getOID() {
        return this.oid;
    }

    @Override
    public void setOID(String oid) {
        this.oid = oid;
    }
}

