/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.emu;

import com.blixx.boom.emu.AddStepAction;
import com.blixx.boom.emu.AddTransactionAction;
import com.blixx.boom.emu.CancelAction;
import com.blixx.boom.emu.Check;
import com.blixx.boom.emu.CheckPageElementAction;
import com.blixx.boom.emu.CheckResult;
import com.blixx.boom.emu.DeleteStepAction;
import com.blixx.boom.emu.DeleteTransactionAction;
import com.blixx.boom.emu.EditTransactionAction;
import com.blixx.boom.emu.IgnoreLink;
import com.blixx.boom.emu.Image;
import com.blixx.boom.emu.InputParamsDialog;
import com.blixx.boom.emu.Link;
import com.blixx.boom.emu.ListSelectionDialog;
import com.blixx.boom.emu.LocationListenerImpl;
import com.blixx.boom.emu.PageElementManager;
import com.blixx.boom.emu.Proxy;
import com.blixx.boom.emu.Step;
import com.blixx.boom.emu.StepsTreeManager;
import com.blixx.boom.emu.TransactionTreeManager;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.TreeElementComparer;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.TreeObject;
import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.net.ssl.internal.www.protocol.https.HttpsURLConnectionOldImpl;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class DualBrowser
extends Dialog
implements IDoubleClickListener,
ISelectionChangedListener,
SelectionListener {
    public static final String DEFINE_VALUE = "???";
    private DualBrowser dualBrowser = null;
    private SashForm m_sashForm;
    private Shell m_parent = null;
    private Browser m_br;
    private LocationListenerImpl locListener;
    public GroupTreeObject m_stepsTree = new GroupTreeObject(new TreeObject("root", TYPE_FOLDER, null));
    public GroupTreeObject m_transactionTree = new GroupTreeObject(new TreeObject("root", TYPE_TRANSACTION, null));
    private PageElementManager m_pageElementManager = null;
    private TransactionTreeManager m_TTreeManager = null;
    private StepsTreeManager m_STreeManager = null;
    private Proxy m_proxy;
    public CheckboxTreeViewer m_treeViewer_steps = null;
    public TreeViewer m_treeViewer_transaction = null;
    public TableViewer m_tableViewer = null;
    private CTabItem m_browserTab = null;
    private CTabItem m_htmlSourceCTab = null;
    public Composite m_jerichoTop;
    private Composite n_compTable = null;
    public Label m_jerichostatus;
    private Label m_currSelStep_label = null;
    private Text m_results_field = null;
    private Text m_htmlTextField = null;
    public String m_currTransactionName = "New Transaction";
    private Button m_editTransaction_btn = null;
    private Button m_addTransaction_btn = null;
    public static String ADD_TRANSACTION_BTN = "ADD_TRANSACTION_BTN";
    public static String EDIT_TRANSACTION_BTN = "EDIT_TRANSACTION_BTN";
    public static String TYPE = "TYPE";
    public static String TYPE_FOLDER = "FOLDER";
    public static String TYPE_TRANSACTION = "TRANSACTION";
    public static String TYPE_TRANSACTION_TREE = "TTREE";
    public static String TYPE_STEPS_TREE = "STREE";
    public static String IMAGES = "Images";
    public static String LINKS = "Links";
    public static HashMap<String, ArrayList> stepsTransactionMap = new HashMap();

    public DualBrowser(Shell parent) {
        super(parent);
        this.m_parent = parent;
        this.setShellStyle(1265);
        this.dualBrowser = this;
        try {
            DualBrowser.trustAllHttpsCertificates();
        }
        catch (Exception exception) {}
        parent.setMinimumSize(800, 600);
        this.m_proxy = new Proxy(80);
        Thread pr = new Thread(this.m_proxy);
        pr.start();
    }

    protected void configureShell(Shell newShell) {
        newShell.setLayout((Layout)new FillLayout());
    }

    protected Control createContents(Composite parent) {
        String urlToOpen = "http://www.google.de";
        InputDialog id = new InputDialog(this.m_parent, "Enter start URL", "URL", urlToOpen, null);
        id.open();
        String url = id.getValue();
        Step one = null;
        try {
            one = new Step(null, url.trim(), Step.STEP);
        }
        catch (IgnoreLink e) {
            e.printStackTrace();
        }
        this.m_stepsTree.addElement(new GroupTreeObject(one));
        this.m_sashForm = new SashForm(parent, 256);
        SashForm m_sashForm1 = new SashForm((Composite)this.m_sashForm, 2560);
        this.getShell().setText(" Synthetic WEB Transaction Builder");
        this.createTransactionTree(m_sashForm1);
        this.createTable((Composite)m_sashForm1);
        this.createStepsTree((Composite)m_sashForm1);
        this.createResultsField(m_sashForm1);
        Composite compBtn = new Composite((Composite)m_sashForm1, 0);
        compBtn.setLayout((Layout)new GridLayout(2, false));
        compBtn.setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite comp = new Composite(compBtn, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.m_addTransaction_btn = new Button(compBtn, 0);
        this.m_addTransaction_btn.setText("Add new Transaction");
        this.m_addTransaction_btn.setData((Object)ADD_TRANSACTION_BTN);
        this.m_addTransaction_btn.addSelectionListener((SelectionListener)this);
        SashForm m_sashForm2 = new SashForm((Composite)this.m_sashForm, 512);
        if (one != null) {
            this.createBrowser(m_sashForm2, one.getPage());
        } else {
            this.createBrowser(m_sashForm2, "Error occured");
        }
        m_sashForm1.setWeights(new int[]{25, 25, 35, 10, 5});
        parent.setSize(800, 600);
        return parent;
    }

    private void createBrowser(SashForm sashForm, String page) {
        CTabFolder folder = new CTabFolder((Composite)sashForm, 768);
        folder.setSimple(true);
        folder.setBorderVisible(true);
        folder.setLayout((Layout)new GridLayout(1, false));
        folder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_browserTab = new CTabItem(folder, 0);
        this.m_browserTab.setText("BROWSER");
        this.m_browserTab.setData((Object)"BROWSER");
        Composite browserComp = new Composite((Composite)folder, 0);
        browserComp.setLayout((Layout)new GridLayout(1, false));
        browserComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_browserTab.setControl((Control)browserComp);
        try {
            this.m_br = new Browser(browserComp, 32832);
            this.m_br.setLayoutData((Object)new GridData(1808));
            this.m_br.setText(page);
        }
        catch (Error error) {
            try {
                this.m_br = new Browser(browserComp, 64);
                this.m_br.setLayoutData((Object)new GridData(1808));
                this.m_br.setText(page);
            }
            catch (Error error2) {}
        }
        if (this.m_br != null) {
            this.locListener = new LocationListenerImpl(this);
            this.m_br.addLocationListener((LocationListener)this.locListener);
        }
        this.m_htmlSourceCTab = new CTabItem(folder, 0);
        this.m_htmlSourceCTab.setText("HTML Source");
        this.m_htmlSourceCTab.setData((Object)"HTML Source");
        Composite htmlSourceComp = new Composite((Composite)folder, 0);
        htmlSourceComp.setLayout((Layout)new GridLayout());
        htmlSourceComp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_htmlSourceCTab.setControl((Control)htmlSourceComp);
        this.m_htmlTextField = new Text(htmlSourceComp, 578);
        this.m_htmlTextField.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_htmlTextField.setBackground(Display.getDefault().getSystemColor(1));
        this.m_htmlTextField.setEditable(false);
        this.m_htmlTextField.setText("not yet requested");
        folder.setSelection(this.m_browserTab);
    }

    private void createTransactionTree(SashForm sash) {
        Composite compTree = new Composite((Composite)sash, 0);
        compTree.setLayout((Layout)new GridLayout(1, false));
        compTree.setLayoutData((Object)new GridData(4, 4, true, true));
        Label title = new Label(compTree, 0);
        title.setText("Transaction List");
        Color color = title.getBackground();
        this.m_TTreeManager = new TransactionTreeManager();
        this.m_treeViewer_transaction = new STreeViewer(compTree, 268438274);
        this.m_treeViewer_transaction.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_treeViewer_transaction.setData(TYPE, (Object)TYPE_TRANSACTION_TREE);
        this.m_treeViewer_transaction.getTree().setBackground(color);
        this.m_treeViewer_transaction.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_treeViewer_transaction.setLabelProvider((IBaseLabelProvider)this.m_TTreeManager);
        this.m_treeViewer_transaction.setInput((Object)this.m_transactionTree);
        this.m_treeViewer_transaction.expandToLevel(1);
        this.m_treeViewer_transaction.addDoubleClickListener((IDoubleClickListener)this);
        this.m_treeViewer_transaction.addSelectionChangedListener((ISelectionChangedListener)this);
        this.createTransactionTree_CM(this.m_treeViewer_transaction);
        Composite compBtn = new Composite(compTree, 0);
        compBtn.setLayout((Layout)new GridLayout(2, false));
        compBtn.setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite comp = new Composite(compBtn, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.m_editTransaction_btn = new Button(compBtn, 0);
        this.m_editTransaction_btn.setText("Edit Transaction");
        this.m_editTransaction_btn.setData((Object)EDIT_TRANSACTION_BTN);
        this.m_editTransaction_btn.setEnabled(false);
        this.m_editTransaction_btn.addSelectionListener((SelectionListener)this);
    }

    public void createTransactionTree_CM(TreeViewer treeViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        treeViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)DualBrowser.this.m_treeViewer_transaction.getSelection();
                    if (!ssel.isEmpty()) {
                        Object o = ssel.getFirstElement();
                        if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                            GroupTreeObject gto = (GroupTreeObject)o;
                            if (gto.getTreeObject().getType().equals(TYPE_TRANSACTION)) {
                                manager.add((IAction)new EditTransactionAction(gto, DualBrowser.this.dualBrowser));
                                manager.add((IAction)new DeleteTransactionAction(gto, DualBrowser.this.dualBrowser));
                            }
                        } else {
                            boolean cfr_ignored_0 = o instanceof GroupTreeObjectLast;
                        }
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(4, "", e);
                }
            }
        });
    }

    public void createTable(Composite sash) {
        this.n_compTable = new Composite(sash, 0);
        this.n_compTable.setLayout((Layout)new GridLayout(1, false));
        this.n_compTable.setLayoutData((Object)new GridData(4, 4, true, true));
        Label title = new Label(this.n_compTable, 0);
        title.setText("Page Elements");
        this.m_currSelStep_label = new Label(this.n_compTable, 0);
        this.m_currSelStep_label.setLayoutData((Object)new GridData(4, 128, true, false));
        Table m_table = new Table(this.n_compTable, 68354);
        m_table.setHeaderVisible(true);
        m_table.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 100;
        gd.widthHint = 200;
        m_table.setLayoutData((Object)gd);
        TableColumn col0 = new TableColumn(m_table, 16384);
        col0.setText("Type");
        col0.setWidth(40);
        TableColumn col1 = new TableColumn(m_table, 16384);
        col1.setText("Name");
        col1.setWidth(100);
        TableColumn col2 = new TableColumn(m_table, 16384);
        col2.setText("Value");
        col2.setWidth(250);
        TableColumn col3 = new TableColumn(m_table, 16384);
        col3.setText("Check Result");
        col3.setWidth(300);
        this.m_pageElementManager = PageElementManager.getInstance();
        this.m_tableViewer = new TableViewer(m_table);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_pageElementManager);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_pageElementManager);
        this.m_tableViewer.setInput((Object)this.m_pageElementManager.getElements(null));
    }

    public void updateTable(Step step) {
        if (step.getType().equals(Step.STEP)) {
            this.m_pageElementManager.setStep(step);
            this.m_tableViewer.setInput((Object)this.m_pageElementManager.getElements(null));
            this.m_currSelStep_label.setText(step.getName());
        }
    }

    public void createTable_CM(Viewer tableViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
        tableViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                char cfr_ignored_0 = e.character;
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IContributionItem)new Separator("Switch view"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(4, "", e);
                }
            }
        });
    }

    public void createStepsTree(Composite sash) {
        this.m_STreeManager = new StepsTreeManager();
        Composite comp = new Composite(sash, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_treeViewer_steps = new CheckboxTreeViewer(comp, 268438306);
        this.m_treeViewer_steps.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_treeViewer_steps.setData(TYPE, (Object)TYPE_STEPS_TREE);
        this.m_treeViewer_steps.setComparer((IElementComparer)new TreeElementComparer());
        this.m_treeViewer_steps.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_treeViewer_steps.setLabelProvider((IBaseLabelProvider)this.m_STreeManager);
        this.m_treeViewer_steps.setInput((Object)this.m_stepsTree);
        this.m_treeViewer_steps.expandToLevel(1);
        this.createStepsTree_CM((TreeViewer)this.m_treeViewer_steps);
        this.m_treeViewer_steps.addDoubleClickListener((IDoubleClickListener)this);
        this.m_treeViewer_steps.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_treeViewer_steps.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CheckboxTreeViewer checkTreeViewer = (CheckboxTreeViewer)event.getSource();
                GroupTreeObject gto = (GroupTreeObject)event.getElement();
                if (gto.getTreeObject().getType().equals(Step.FORM)) {
                    checkTreeViewer.setChecked((Object)gto, false);
                    return;
                }
                DualBrowser.this.m_treeViewer_steps.setSubtreeChecked(event.getElement(), event.getChecked());
            }
        });
    }

    public void refreshStepsTree(CheckboxTreeViewer treeViewer, GroupTreeObject transactionGTO) {
        List<GroupTreeObject> elem = transactionGTO.getAllElements();
        Object[] objects = new Object[elem.size()];
        int i = 0;
        while (i < elem.size()) {
            objects[i] = elem.get(i);
            ++i;
        }
        i = transactionGTO.getName().indexOf(")");
        String name = transactionGTO.getName().substring(i + 1, transactionGTO.getName().length());
        GroupTreeObject gtoInStepsTree = this.m_stepsTree.findFirstGroupByName(name.trim());
        if (gtoInStepsTree != null) {
            this.m_treeViewer_steps.setCheckedElements(objects);
            this.m_treeViewer_steps.refresh(true);
        }
    }

    public void updateStepsTree(GroupTreeObject selGTO) {
        if (selGTO.getTreeObject() instanceof Check && selGTO.getParent().getTreeObject() instanceof Step) {
            Check check = (Check)selGTO.getTreeObject();
            GroupTreeObject stepGTO = selGTO.getParent();
            Step step = (Step)selGTO.getParent().getTreeObject();
            if (check.getType() == "CHECK_IMAGES") {
                GroupTreeObject oldGTO = stepGTO.getChild(IMAGES, check.getType());
                if (oldGTO != null) {
                    oldGTO.clean();
                } else {
                    oldGTO = new GroupTreeObject(new Check(IMAGES, check.getType()));
                    stepGTO.addElement(oldGTO);
                }
                Hashtable map = step.getImages();
                for (Object o : map.keySet()) {
                    Image image;
                    GroupTreeObjectLast gtol;
                    if (o == null || !(o instanceof Image) || oldGTO.getChild((gtol = new GroupTreeObjectLast(image = (Image)o, null, null)).getName(), check.getType()) != null) continue;
                    oldGTO.addElement(gtol);
                }
            } else if (check.getType().equals("CHECK_LINKS")) {
                GroupTreeObject oldGTO = stepGTO.getChild(LINKS, check.getType());
                if (oldGTO != null) {
                    oldGTO.clean();
                } else {
                    oldGTO = new GroupTreeObject(new Check(LINKS, check.getType()));
                    stepGTO.addElement(oldGTO);
                }
                Hashtable map = step.getLinks();
                for (Object o : map.keySet()) {
                    Link link;
                    GroupTreeObjectLast gtol;
                    if (o == null || !(o instanceof Link) || oldGTO.getChild((gtol = new GroupTreeObjectLast(link = (Link)o, null, null)).getName(), gtol.getType()) != null) continue;
                    oldGTO.addElement(gtol);
                }
            } else {
                check.getType();
            }
            this.m_treeViewer_steps.expandToLevel((Object)selGTO, 1);
            this.m_treeViewer_steps.refresh();
        }
    }

    public void createStepsTree_CM(TreeViewer treeViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        treeViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)DualBrowser.this.m_treeViewer_steps.getSelection();
                    if (!ssel.isEmpty()) {
                        GroupTreeObjectLast gtol;
                        Object o = ssel.getFirstElement();
                        if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                            GroupTreeObject gto = (GroupTreeObject)o;
                            if (gto.getTreeObject() instanceof Step) {
                                Step step = (Step)gto.getTreeObject();
                                manager.add((IAction)new CheckPageElementAction(gto, DualBrowser.this.dualBrowser));
                                if (step.isManual()) {
                                    manager.add((IAction)new DeleteStepAction(gto, DualBrowser.this.dualBrowser));
                                }
                            } else if (gto.getTreeObject() instanceof Check) {
                                manager.add((IAction)new CheckPageElementAction(gto, DualBrowser.this.dualBrowser));
                            }
                        } else if (o instanceof GroupTreeObjectLast && (gtol = (GroupTreeObjectLast)o).getTreeObject() instanceof Link) {
                            manager.add((IAction)new AddStepAction(gtol, DualBrowser.this.dualBrowser));
                        }
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(4, "", e);
                }
            }
        });
    }

    public void createResultsField(SashForm sash) {
        Composite comp = new Composite((Composite)sash, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_results_field = new Text(comp, 2626);
        this.m_results_field.setEditable(true);
        GridData gd = new GridData(4, 4, true, true);
        this.m_results_field.setLayoutData((Object)gd);
    }

    public void processPage(GroupTreeObject stepGTO) {
        Step step = (Step)stepGTO.getTreeObject();
        try {
            String paramstr = null;
            Hashtable<String, Collection<String>> paramsStored = step.getParameters();
            if (paramsStored != null) {
                try {
                    paramstr = this.askParameters(step);
                    if (paramstr == null || paramstr.length() == 0) {
                        return;
                    }
                }
                catch (CancelAction cancelAction) {
                    return;
                }
            }
            StringBuffer page = new StringBuffer();
            String redirect = "start";
            URL url = null;
            while (redirect != null) {
                GroupTreeObject newGTO;
                page = new StringBuffer();
                url = new URL(step.getURLString());
                System.out.println("\n" + step.getURLString());
                URLConnection conn = url.openConnection();
                if (step.isPOST()) {
                    conn.setDoOutput(true);
                    conn.setUseCaches(false);
                    this.addCookies(conn, step);
                    OutputStreamWriter ow = new OutputStreamWriter(conn.getOutputStream());
                    System.out.println("POST: " + paramstr);
                    ow.write(paramstr);
                    ow.flush();
                    ow.close();
                    conn.connect();
                } else {
                    conn.setUseCaches(false);
                    this.addCookies(conn, step);
                    conn.connect();
                }
                redirect = this.getCookiesRefreshAndCode(conn, step);
                String received = conn.getURL().toString();
                step.setURL(received);
                if (step.m_httpResponse >= 400) {
                    step.m_page = "HTTP Error: " + step.m_httpResponse;
                    break;
                }
                InputStream inputStream = conn.getInputStream();
                byte[] arr = new byte[16000];
                int len = -1;
                while ((len = inputStream.read(arr)) != -1) {
                    page.append(new String(arr, 0, len));
                }
                if (redirect != null) {
                    String newUrlStr = redirect;
                    if (!redirect.startsWith("http")) {
                        newUrlStr = String.valueOf(step.getMainUrl()) + redirect;
                    }
                    if (newUrlStr.equalsIgnoreCase(step.getURLString())) {
                        redirect = null;
                        break;
                    }
                    step.parse(page.toString());
                    step.setRedirect(true);
                    Step newStep = new Step(step.getURLString(), newUrlStr, Step.STEP);
                    newStep.setCookies(step.getCookies());
                    newGTO = new GroupTreeObject(newStep);
                    try {
                        stepGTO.addElement(newGTO);
                    }
                    catch (RuntimeException runtimeException) {
                        newGTO = stepGTO.getChild(newGTO.getName(), newGTO.getType());
                        newStep = (Step)newGTO.getTreeObject();
                    }
                    step = newStep;
                    stepGTO = newGTO;
                    this.m_treeViewer_steps.setSelection((ISelection)new StructuredSelection((Object)newGTO));
                    System.out.println("Redirecting to: " + newUrlStr);
                    continue;
                }
                List<Step> followStepsList = step.parse(page.toString());
                this.setBrowserProxyURL(url, step);
                if (step.getLinks().size() > 0 && stepGTO.getChild(LINKS, "CHECK_LINKS") == null) {
                    GroupTreeObject checkGTO = new GroupTreeObject(new Check(LINKS, "CHECK_LINKS"));
                    try {
                        stepGTO.addElement(checkGTO);
                    }
                    catch (RuntimeException runtimeException) {}
                }
                if (step.getImages().size() > 0 && stepGTO.getChild(IMAGES, "CHECK_IMAGES") == null) {
                    GroupTreeObject check = new GroupTreeObject(new Check(IMAGES, "CHECK_IMAGES"));
                    try {
                        stepGTO.addElement(check);
                    }
                    catch (RuntimeException runtimeException) {}
                }
                this.m_treeViewer_steps.setSelection((ISelection)new StructuredSelection((Object)stepGTO));
                int i = 0;
                while (i < followStepsList.size()) {
                    followStepsList.get(i).setCookies(step.getCookies());
                    newGTO = new GroupTreeObject(followStepsList.get(i));
                    try {
                        stepGTO.addElement(newGTO);
                    }
                    catch (RuntimeException runtimeException) {}
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.m_htmlTextField.setText(step.getHTMLSource());
        this.m_treeViewer_steps.expandToLevel((Object)stepGTO, 1);
        this.m_treeViewer_steps.refresh(true);
    }

    private String getCookiesRefreshAndCode(URLConnection conn, Step step) {
        String redirect = null;
        String header2 = null;
        Map<String, List<String>> headers = conn.getHeaderFields();
        for (String header2 : headers.keySet()) {
            int i;
            if ("Set-Cookie".equalsIgnoreCase(header2)) {
                List<String> cookieList = headers.get(header2);
                i = 0;
                while (i < cookieList.size()) {
                    String cookie = cookieList.get(i);
                    System.out.println("Received cookie: " + cookie);
                    String old = step.getCookies();
                    if (old == null) {
                        step.setCookies(cookie);
                    } else {
                        String[] arr;
                        String[] stringArray = arr = cookie.split(";");
                        int n = arr.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            if (old.indexOf(s) == -1) {
                                old = String.valueOf(old) + "; " + s;
                            }
                            ++n2;
                        }
                        step.setCookies(old);
                    }
                    ++i;
                }
            } else if ("Refresh".equalsIgnoreCase(header2)) {
                List<String> refreshList = headers.get(header2);
                i = 0;
                while (i < refreshList.size()) {
                    String refresh = refreshList.get(i);
                    System.out.println(">> Refresh: " + refresh);
                    String[] spl = refresh.split(";");
                    int seconds = Integer.parseInt(spl[0].trim());
                    if (seconds <= 10) {
                        redirect = spl[1].substring(spl[1].indexOf(61) + 1);
                    }
                    ++i;
                }
            } else if (header2 == null) {
                try {
                    int stati = CheckResult.parseHTTPResponseCode(headers);
                    step.setHttpResponse(stati);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            System.out.println(String.valueOf(header2) + "=" + headers.get(header2));
        }
        return redirect;
    }

    private void addCookies(URLConnection conn, Step step) {
        if (step.getCookies() != null) {
            conn.setRequestProperty("Cookie", step.getCookies());
        } else {
            conn.setRequestProperty("Cookie", "none");
        }
    }

    public String askParameters1(Step step) throws CancelAction {
        String res = "";
        try {
            Hashtable<String, Collection<String>> parameters = step.getParameters();
            Hashtable<String, Collection<String>> parametersCollections = step.getParametersCollections();
            Enumeration<String> names = parameters.keys();
            while (names.hasMoreElements()) {
                String key = names.nextElement();
                Collection<String> col = parameters.get(key);
                if (parametersCollections.containsKey(key)) {
                    ListSelectionDialog id = new ListSelectionDialog(this.getShell(), parametersCollections.get(key).toArray(), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new LabelProvider(), key);
                    id.setTitle(" Set Parameter value ");
                    id.setBlockOnOpen(true);
                    int r = id.open();
                    if (r == 0) {
                        Object[] resa = id.getResult();
                        ArrayList<String> array = new ArrayList<String>();
                        int i = 0;
                        while (i < resa.length) {
                            String val = "" + resa[i];
                            array.add(val);
                            if (res.length() > 0) {
                                res = String.valueOf(res) + "&";
                            }
                            res = String.valueOf(res) + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(val, "UTF-8");
                            ++i;
                        }
                        parameters.put(key, array);
                        continue;
                    }
                    throw new CancelAction();
                }
                String value = col.iterator().next();
                InputDialog id = new InputDialog(this.getShell(), " Set Parameter value ", key, value, null);
                id.setBlockOnOpen(true);
                int r = id.open();
                if (r == 0) {
                    String val = id.getValue();
                    if (val.length() == 0) continue;
                    ArrayList<String> array = new ArrayList<String>();
                    array.add(val);
                    parameters.put(key, array);
                    if (res.length() > 0) {
                        res = String.valueOf(res) + "&";
                    }
                    res = String.valueOf(res) + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(val, "UTF-8");
                    continue;
                }
                throw new CancelAction();
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String askParameters(Step step) throws CancelAction {
        String res = "";
        Hashtable<String, Object[]> paramsColl = new Hashtable<String, Object[]>();
        Hashtable<String, String> params = new Hashtable<String, String>();
        Hashtable<String, Collection<String>> parameters = step.getParameters();
        Hashtable<String, Collection<String>> parametersCollections = step.getParametersCollections();
        Enumeration<String> names = parameters.keys();
        while (names.hasMoreElements()) {
            String key = names.nextElement();
            Collection<String> col = parameters.get(key);
            if (parametersCollections.containsKey(key)) {
                paramsColl.put(key, parametersCollections.get(key).toArray());
                continue;
            }
            params.put(key, col.iterator().next());
        }
        InputParamsDialog dialog = new InputParamsDialog(this.getShell(), step, paramsColl, params);
        dialog.setBlockOnOpen(true);
        int returnCode = dialog.open();
        if (returnCode == 0) {
            res = dialog.getResult();
        }
        return res;
    }

    private void setBrowserProxyURL(URL url, Step step) {
        this.m_proxy.setRemoteHost(url.getHost());
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        this.m_proxy.setRemotePort(port);
        this.m_proxy.setCookie(step.getCookies());
        this.m_proxy.setCurrentStep(step);
        String url2 = String.valueOf(url.getProtocol()) + "://localhost:" + this.m_proxy.localport + url.getPath();
        if (url.getQuery() != null) {
            url2 = String.valueOf(url2) + "?" + url.getQuery();
        } else if (step.isPOST()) {
            url2 = String.valueOf(url2) + "?" + step.getParametersString();
        }
        this.m_br.setUrl(url2);
    }

    private static void trustAllHttpsCertificates() throws Exception {
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        Security.addProvider((java.security.Provider)new Provider());
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public boolean isServerTrusted(X509Certificate[] certs) {
                return true;
            }

            public boolean isClientTrusted(X509Certificate[] certs) {
                return true;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(new X509KeyManager[0], trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnectionOldImpl.setDefaultSSLSocketFactory((SSLSocketFactory)sc.getSocketFactory());
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public boolean verify(String urlHostname, String certHostname) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        HttpsURLConnectionOldImpl.setDefaultHostnameVerifier((com.sun.net.ssl.HostnameVerifier)new com.sun.net.ssl.HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public boolean verify(String urlHostname, String certHostname) {
                return true;
            }
        });
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String name = (String)b.getData();
            if (name.equals(ADD_TRANSACTION_BTN)) {
                AddTransactionAction addAction = new AddTransactionAction(this.dualBrowser);
                addAction.run();
            } else if (name.equals(EDIT_TRANSACTION_BTN)) {
                EditTransactionAction editAction = new EditTransactionAction(this.dualBrowser);
                editAction.run();
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getSource() instanceof TreeViewer) {
            TreeViewer viewer = (TreeViewer)event.getSource();
            if (viewer.getData(TYPE).equals(TYPE_TRANSACTION_TREE)) {
                GroupTreeObject gto;
                IStructuredSelection ssel = (IStructuredSelection)viewer.getSelection();
                if (!ssel.isEmpty() && !((gto = (GroupTreeObject)ssel.getFirstElement()) instanceof GroupTreeObjectLast)) {
                    this.m_treeViewer_transaction.setExpandedState((Object)gto, !this.m_treeViewer_transaction.getExpandedState((Object)gto));
                }
            } else if (viewer.getData(TYPE).equals(TYPE_STEPS_TREE)) {
                GroupTreeObject gto = (GroupTreeObject)((IStructuredSelection)viewer.getSelection()).getFirstElement();
                CheckPageElementAction checkElementsAction = new CheckPageElementAction(gto, this.dualBrowser);
                checkElementsAction.run();
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)event.getSource();
            String treeType = (String)treeViewer.getData(TYPE);
            if (treeType.equals(TYPE_TRANSACTION_TREE)) {
                IStructuredSelection ssel = (IStructuredSelection)treeViewer.getSelection();
                if (!ssel.isEmpty()) {
                    GroupTreeObject gto = (GroupTreeObject)ssel.getFirstElement();
                    if (gto instanceof GroupTreeObjectLast || !gto.getTreeObject().getType().equals(TYPE_TRANSACTION)) {
                        this.m_editTransaction_btn.setEnabled(false);
                    } else {
                        this.m_editTransaction_btn.setEnabled(true);
                    }
                }
            } else if (treeType.equals(TYPE_STEPS_TREE)) {
                GroupTreeObject gto = (GroupTreeObject)((IStructuredSelection)treeViewer.getSelection()).getFirstElement();
                if (gto == null) {
                    return;
                }
                ITreeObject ito = gto.getTreeObject();
                if (ito != null && ito instanceof Step) {
                    Step step = (Step)gto.getTreeObject();
                    this.updateTable(step);
                } else if (ito != null) {
                    boolean cfr_ignored_0 = gto.getTreeObject() instanceof Check;
                }
                if (!(gto instanceof GroupTreeObjectLast) && gto.getTreeObject() instanceof Step && gto.getTreeObject().getType().equals(Step.STEP) && this.m_treeViewer_steps.getChecked((Object)gto)) {
                    this.m_addTransaction_btn.setEnabled(true);
                } else {
                    this.m_addTransaction_btn.setEnabled(false);
                }
            }
        }
    }

    public static void main(String[] args) {
        Shell shell = new Shell(Display.getDefault());
        shell.setLayout((Layout)new FillLayout());
        DualBrowser db = new DualBrowser(shell);
        db.open();
    }
}

