/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.emu;

import com.blixx.boom.emu.Step;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputParamsDialog
extends StatusDialog
implements DisposeListener {
    private ScrolledComposite m_sc = null;
    private Composite m_mainComp = null;
    private Step m_step = null;
    private Hashtable m_paramsCollection = null;
    private Hashtable m_params = null;
    private Hashtable m_elements = null;
    private int m_counter = 0;
    private String m_result = "";

    public InputParamsDialog(Shell parentShell, Step step, Hashtable paramsCollection, Hashtable params) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setTitle(" Process Form");
        this.m_step = step;
        this.m_elements = new Hashtable();
        this.m_paramsCollection = paramsCollection;
        this.m_params = params;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gl = null;
        this.m_sc = new ScrolledComposite(parent, 2816);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        this.m_sc.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 600;
        gd.heightHint = 350;
        this.m_sc.setLayoutData((Object)gd);
        this.m_mainComp = new Composite((Composite)this.m_sc, 0);
        this.m_mainComp.addDisposeListener((DisposeListener)this);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginTop = 10;
        gl.marginLeft = 5;
        this.m_mainComp.setLayout((Layout)gl);
        this.m_mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_counter = 0;
        this.createParamsSection(this.m_mainComp);
        this.createParamsCollSection(this.m_mainComp);
        this.m_sc.setContent((Control)this.m_mainComp);
        this.m_sc.setMinSize(this.m_mainComp.computeSize(-1, -1, true));
        return this.m_sc;
    }

    public void createParamsSection(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 20;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        Enumeration names = this.m_params.keys();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            String value = (String)this.m_params.get(key);
            Text text = this.createInputField(comp, key, value, key);
            this.m_elements.put(key, text);
            ++this.m_counter;
        }
    }

    public void createParamsCollSection(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginTop = 10;
        gl.horizontalSpacing = 20;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        Enumeration names2 = this.m_paramsCollection.keys();
        while (names2.hasMoreElements()) {
            ArrayList<Button> list = new ArrayList<Button>();
            String key = (String)names2.nextElement();
            Object[] objects = (Object[])this.m_paramsCollection.get(key);
            this.createTitle(comp, key);
            Composite compCheck = new Composite(comp, 2048);
            compCheck.setBackground(Display.getDefault().getSystemColor(1));
            compCheck.setLayout((Layout)new GridLayout(1, false));
            compCheck.setLayoutData((Object)new GridData(4, 4, true, false));
            int i = 0;
            while (i < objects.length) {
                String elem = (String)objects[i];
                Button checkbox = this.createCheckbox(compCheck, elem, key);
                list.add(checkbox);
                ++i;
            }
            this.m_elements.put(key, list);
        }
    }

    public void createTitle(Composite comp, String value) {
        Label label = new Label(comp, 0);
        label.setText(value);
    }

    public Text createInputField(Composite comp, String label, String value, String data) {
        if (label == null) {
            label = "";
        }
        Label l = new Label(comp, 0);
        l.setText(label);
        l.setLayoutData((Object)new GridData(1, 128, false, false));
        Text inputField = new Text(comp, 2052);
        inputField.setLayoutData((Object)new GridData(4, 128, true, false));
        inputField.setData((Object)data);
        inputField.setEditable(true);
        if (value != null) {
            inputField.setText(value);
        }
        return inputField;
    }

    public Button createCheckbox(Composite comp, String label, String data) {
        Button button = new Button(comp, 32);
        button.setBackground(Display.getDefault().getSystemColor(1));
        if (label != null) {
            button.setText(label);
        }
        button.setData((Object)data);
        button.setSelection(false);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        Hashtable<String, Collection<String>> parameters = this.m_step.getParameters();
        this.m_result = "";
        try {
            Enumeration e = this.m_elements.keys();
            while (e.hasMoreElements()) {
                Text inputField;
                String key = (String)e.nextElement();
                Object element = this.m_elements.get(key);
                if (element instanceof ArrayList) {
                    ArrayList<String> array = new ArrayList<String>();
                    ArrayList list = (ArrayList)element;
                    int i = 0;
                    while (i < list.size()) {
                        Button b = (Button)list.get(i);
                        if (b.getSelection()) {
                            String value = b.getText();
                            array.add(value);
                            if (this.m_result.length() > 0) {
                                this.m_result = String.valueOf(this.m_result) + "&";
                            }
                            this.m_result = String.valueOf(this.m_result) + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
                        }
                        ++i;
                    }
                    parameters.put(key, array);
                    continue;
                }
                if (!(element instanceof Text) || (inputField = (Text)element).getText() == null || inputField.getText().length() == 0) continue;
                ArrayList<String> array = new ArrayList<String>();
                String value = inputField.getText();
                array.add(value);
                if (this.m_result.length() > 0) {
                    this.m_result = String.valueOf(this.m_result) + "&";
                }
                this.m_result = String.valueOf(this.m_result) + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
                parameters.put(key, array);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    public String getResult() {
        return this.m_result;
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_mainComp.dispose();
        }
        catch (Throwable throwable) {}
    }

    public boolean close() {
        return super.close();
    }
}

