/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.emu;

import com.blixx.boom.emu.CheckResult;
import com.blixx.boom.emu.IgnoreLink;
import com.blixx.boom.emu.Image;
import com.blixx.boom.emu.Link;
import com.blixx.shared.utils.ITreeObject;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.FormField;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.MasonTagTypes;
import net.htmlparser.jericho.MicrosoftTagTypes;
import net.htmlparser.jericho.PHPTagTypes;
import net.htmlparser.jericho.Source;

public class Step
implements ITreeObject {
    public static final String NOT_YET_REQUESTED = "not yet requested";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static String FORM = "FORM";
    public static String STEP = "STEP";
    public static final Collection<String> DEFINE_VALUE = new ArrayList<String>();
    private String m_url = null;
    String m_page = "not yet requested";
    String m_method = "GET";
    String m_type = null;
    Hashtable<String, Collection<String>> m_parameters = null;
    Hashtable<String, Collection<String>> m_parametersCollections = new Hashtable();
    boolean m_isRedirect = false;
    String m_parsedPage = "not yet requested";
    String m_htmlSource = "";
    String m_cookies = null;
    String m_name = null;
    int m_httpResponse = 0;
    boolean m_isManual = false;
    ArrayList<Step> m_forms = new ArrayList();
    Hashtable<Link, String> m_links = new Hashtable();
    Hashtable<Image, String> m_images = new Hashtable();
    private static Pattern fpou = Pattern.compile("(\\w+):.*");
    public static ArrayList htmlCodes;
    private String oid = null;

    static {
        DEFINE_VALUE.add("???");
        MicrosoftTagTypes.register();
        PHPTagTypes.register();
        MasonTagTypes.register();
        Config.CurrentCompatibilityMode.setFormFieldNameCaseInsensitive(false);
        htmlCodes = new ArrayList();
        String[] tmp = new String[]{"&quot;", "&amp;", "&lt;", "&gt;", "&nbsp;", "&iexcl;", "&cent;", "&pound;", "&curren;", "&yen;", "&brvbar;", "&sect;", "&uml;", "&copy;", "&ordf;", "&laquo;", "&not;", "&shy;", "&reg;", "&macr;", "&deg;", "&plusmn;", "&sup2;", "&sup3;", "&acute;", "&micro;", "&para;", "&middot;", "&cedil;", "&sup1;", "&ordm;", "&raquo;", "&frac14;", "&frac12;", "&frac34;", "&iquest;", "&Agrave;", "&Aacute;", "&Acirc;", "&Atilde;", "&Auml;", "&Aring;", "&AElig;", "&Ccedil;", "&Egrave;", "&Eacute;", "&Ecirc;", "&Euml;", "&Igrave;", "&Iacute;", "&Icirc;", "&Iuml;", "&ETH;", "&Ntilde;", "&Ograve;", "&Oacute;", "&Ocirc;", "&Otilde;", "&Ouml;", "&times;", "&Oslash;", "&Ugrave;", "&Uacute;", "&Ucirc;", "&Uuml;", "&Yacute;", "&THORN;", "&szlig;", "&agrave;", "&aacute;", "&acirc;", "&atilde;", "&auml;", "&aring;", "&aelig;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&igrave;", "&iacute;", "&icirc;", "&iuml;", "&eth;", "&ntilde;", "&ograve;", "&oacute;", "&ocirc;", "&otilde;", "&ouml;", "&divide;", "&oslash;", "&ugrave;", "&uacute;", "&ucirc;", "&uuml;", "&yacute;", "&thorn;", "&yuml;", "&euro;", "<font", "</font>", "<u", "</u>", "<b", "</b>", "<i", "</i>", "<sup", "</sup>", "<tt", "</tt>", "<small", "</small>", "<big", "</big>", "<center", "</center>", "<br", "<nobr", "</nobr>", "<blockquote", "</blockquote>", "<p", "</p>", "<h1", "</h1>", "<h2", "</h2>", "<h3", "</h3>", "<h4", "</h4>", "<h5", "</h5>", "<h6", "</h6>"};
        int i = 0;
        while (i < tmp.length) {
            htmlCodes.add(tmp[i]);
            ++i;
        }
    }

    public Step(String parentUrl, String url, String type) throws IgnoreLink {
        this.m_url = url = Step.normalizeURL(parentUrl, url);
        this.m_name = url;
        this.m_type = type;
    }

    public void setURL(String url) {
        this.m_url = url.split("\\Q?\\E")[0];
    }

    public static String normalizeURL(String parentUrl, String url) throws IgnoreLink {
        if (url == null) {
            throw new IgnoreLink("no url");
        }
        if (url.startsWith("#")) {
            throw new IgnoreLink("Local reference");
        }
        int colon = url.indexOf(":");
        if (colon != -1) {
            try {
                URL uu = new URL(url);
                if (!uu.getProtocol().equalsIgnoreCase("http") && !uu.getProtocol().equalsIgnoreCase("https")) {
                    throw new IgnoreLink("Unsupported protocol");
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new IgnoreLink("invalid URL");
            }
        }
        if (!url.startsWith("http") && !url.startsWith("/") && parentUrl != null) {
            int lastIndexOf = parentUrl.indexOf("/", parentUrl.indexOf("://") + 3);
            url = lastIndexOf == -1 ? String.valueOf(parentUrl) + "/" + url : String.valueOf(parentUrl.substring(0, lastIndexOf + 1)) + url;
        } else if (url.startsWith("/") && parentUrl != null) {
            url = String.valueOf(parentUrl) + url;
        }
        return url;
    }

    public int getHttpResponse() {
        return this.m_httpResponse;
    }

    public void setHttpResponse(int response) {
        this.m_httpResponse = response;
    }

    @Override
    public String getComparableName() {
        return this.m_url;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public void setObject(Object obj) {
    }

    @Override
    public void setType(String type) {
        this.m_type = type;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        String url = "";
        if (!this.m_name.endsWith(this.m_url)) {
            url = this.m_url;
        }
        return String.valueOf(this.m_method) + " " + this.m_name + " [" + this.m_httpResponse + "] " + this.m_page.length() + " " + url;
    }

    public void setMethodToPOST() {
        this.m_method = POST;
    }

    public void setMethodToGET() {
        this.m_method = GET;
    }

    public boolean isPOST() {
        return POST.equals(this.m_method);
    }

    public void setParameters(Hashtable<String, Collection<String>> parameters) {
        this.m_parameters = parameters;
    }

    public void setParametersCollections(Hashtable<String, Collection<String>> parameters) {
        this.m_parametersCollections = parameters;
    }

    public Hashtable<String, Collection<String>> getParameters() {
        return this.m_parameters;
    }

    public Hashtable<String, Collection<String>> getParametersCollections() {
        return this.m_parametersCollections;
    }

    public String toString() {
        return this.m_name;
    }

    public boolean isPerformed() {
        return !this.m_page.equals(NOT_YET_REQUESTED);
    }

    public String getURLString() {
        String url = null;
        url = this.m_url;
        if (!this.isPOST()) {
            int qm = url.indexOf(63);
            if (qm != -1) {
                if (this.m_parameters != null) {
                    if (!url.endsWith("?")) {
                        url = String.valueOf(url) + "&";
                    }
                    url = String.valueOf(url) + this.getParametersString();
                }
            } else if (this.m_parameters != null) {
                url = String.valueOf(url) + "?" + this.getParametersString();
            }
        }
        return url;
    }

    public String getParametersString() {
        String res = "";
        if (this.m_parameters != null) {
            for (String key : this.m_parameters.keySet()) {
                Collection<String> col = this.m_parameters.get(key);
                for (String value : col) {
                    try {
                        if (res.length() > 0) {
                            res = String.valueOf(res) + "&";
                        }
                        res = String.valueOf(res) + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
        }
        return res;
    }

    public int getParameterSize() {
        if (this.m_parameters == null) {
            return 0;
        }
        return this.m_parameters.size();
    }

    public List<Step> parse(String page) {
        Step follow;
        this.m_forms = new ArrayList();
        this.m_links = new Hashtable();
        this.m_images = new Hashtable();
        this.m_page = page;
        StringBuffer output = new StringBuffer();
        Source source = null;
        source = new Source((CharSequence)page.toString());
        source.fullSequentialParse();
        List list = source.getAllElements("form");
        for (Element el : list) {
            String method = el.getAttributeValue("method");
            String action = el.getAttributeValue("action");
            String formname = el.getAttributeValue("name");
            output.append("FORM: (" + formname + ") method=").append(method).append(" URL=").append(action).append("\n");
            Hashtable<String, Collection<String>> params = new Hashtable<String, Collection<String>>();
            Hashtable<String, Collection<String>> parametersCollections = new Hashtable<String, Collection<String>>();
            FormFields elementList = el.getContent().getFormFields();
            if (elementList.size() > 0) {
                for (FormField element : elementList) {
                    String paramName = element.getName();
                    Collection<String> col = element.getPredefinedValues();
                    Collection<String> value = DEFINE_VALUE;
                    if (col != null && col.iterator().hasNext()) {
                        if (col.size() > 1) {
                            value = DEFINE_VALUE;
                            parametersCollections.put(paramName, col);
                        } else {
                            value = col;
                        }
                    } else {
                        List col2 = element.getValues();
                        if (col2 != null && col2.iterator().hasNext() && (value = col2).size() == 0) {
                            value = DEFINE_VALUE;
                        }
                    }
                    params.put(paramName, value);
                    output.append("\t").append(paramName).append("=").append(value).append("\n");
                }
                follow = null;
                try {
                    follow = new Step(this.getURLString(), action, FORM);
                }
                catch (IgnoreLink ignoreLink) {
                    continue;
                }
                follow.setName("form:" + formname);
                follow.setParameters(params);
                follow.setParametersCollections(parametersCollections);
                if (POST.equalsIgnoreCase(method)) {
                    follow.setMethodToPOST();
                }
                this.m_forms.add(follow);
                continue;
            }
            elementList = source.getFormFields();
            for (FormField element : elementList) {
                output.append("\t").append(element).append("\n");
            }
        }
        List list2 = source.getAllElements("a");
        list2.addAll(source.getAllElements("link"));
        for (Element el : list2) {
            Object href = el.getAttributeValue("href");
            try {
                href = Step.normalizeURL(this.getURLString(), (String)href);
            }
            catch (IgnoreLink ignoreLink) {
                continue;
            }
            String linkName = "" + el.getContent();
            linkName = this.removeHTMLElements(linkName);
            this.m_links.put(new Link(linkName, (String)href, new CheckResult()), "");
            output.append("LINK: ").append((CharSequence)el).append("\n");
        }
        List list3 = source.getAllElements("img");
        for (Element el : list3) {
            Object src = el.getAttributeValue("src");
            try {
                src = Step.normalizeURL(this.getURLString(), (String)src);
            }
            catch (IgnoreLink ignoreLink) {
                continue;
            }
            String imageName = el.getAttributes().getValue("alt");
            this.m_images.put(new Image(imageName, (String)src, new CheckResult()), "");
            output.append("IMG: ").append((CharSequence)el).append("\n");
        }
        List list4 = source.getAllElements("frame");
        for (Element el : list4) {
            output.append("FRAME: ").append((CharSequence)el).append("\n");
            Object src = el.getAttributeValue("src");
            try {
                src = Step.normalizeURL(this.getURLString(), (String)src);
            }
            catch (IgnoreLink ignoreLink) {
                continue;
            }
            String name = el.getAttributeValue("name");
            Step follow2 = null;
            try {
                follow2 = new Step(this.getURLString(), (String)src, FORM);
            }
            catch (IgnoreLink ignoreLink) {
                continue;
            }
            follow2.setName("frame:" + name);
            this.m_forms.add(follow2);
        }
        List list5 = source.getAllElements("iframe");
        for (Element el : list5) {
            output.append("IFRAME: ").append((CharSequence)el).append("\n");
            String src = el.getAttributeValue("src");
            try {
                src = Step.normalizeURL(this.getURLString(), src);
            }
            catch (IgnoreLink ignoreLink) {
                continue;
            }
            String name = el.getAttributeValue("name");
            follow = null;
            try {
                follow = new Step(this.getURLString(), src, FORM);
            }
            catch (IgnoreLink ignoreLink) {
                continue;
            }
            follow.setName("iframe:" + name);
            this.m_forms.add(follow);
        }
        StringBuffer html = new StringBuffer();
        List allList = source.getAllElements();
        for (Element el : allList) {
            html.append((CharSequence)el).append("\n");
        }
        this.m_parsedPage = output.toString();
        this.m_htmlSource = html.toString();
        return this.m_forms;
    }

    public String removeHTMLElements(String elem) {
        String html_elem = null;
        int i = 0;
        while (i < htmlCodes.size()) {
            html_elem = (String)htmlCodes.get(i);
            if (elem.contains(html_elem)) {
                if (html_elem.startsWith("&") || html_elem.startsWith("</")) {
                    elem = elem.replaceAll(html_elem, "").trim();
                } else {
                    int start = elem.indexOf(html_elem);
                    int end = elem.indexOf(">", start);
                    elem = String.valueOf(elem.substring(0, start)) + elem.substring(end + 1, elem.length()).trim();
                }
            }
            ++i;
        }
        return elem.trim();
    }

    public String getPage() {
        return this.m_page;
    }

    public String getMainUrl() {
        try {
            URL url = new URL(this.m_url);
            int to = url.toString().indexOf(url.getPath());
            return url.toString().substring(0, to);
        }
        catch (MalformedURLException malformedURLException) {
            return "";
        }
    }

    public void setCookies(String cookies) {
        this.m_cookies = cookies;
    }

    public String getCookies() {
        return this.m_cookies;
    }

    public String getParsedPage() {
        return this.m_parsedPage;
    }

    public boolean isRedirect() {
        return this.m_isRedirect;
    }

    public void setRedirect(boolean isredirect) {
        this.m_isRedirect = isredirect;
    }

    public Hashtable getLinks() {
        return this.m_links;
    }

    public Hashtable getImages() {
        return this.m_images;
    }

    public ArrayList getForms() {
        return this.m_forms;
    }

    public String getHTMLSource() {
        return this.m_htmlSource;
    }

    public void setManual(boolean manual) {
        this.m_isManual = manual;
    }

    public boolean isManual() {
        return this.m_isManual;
    }

    @Override
    public String getOID() {
        return this.oid;
    }

    @Override
    public void setOID(String oid) {
        this.oid = oid;
    }
}

