/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.ctrl.sc.in.ScGetAgentInventoryCard;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.AgentInventoryCard;
import com.blixx.shared.IID;
import com.blixx.shared.IODataStream;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.EventsAndStatus;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.TreeObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.swt.graphics.Image;

public class AgentCard
extends AbstractAgentCard
implements IODataStream,
ITreeObject,
IID {
    public static final String NOT_APPROVED_AGENTS = "  Not approved Agents ";
    public static final String NOT_APPROVED_EXTERNAL = "  Not approved _External ";
    public static final String DISABLED_PREFIX = "(X) ";
    public Map<String, String> m_assignedMonitorPolicies = new HashMap<String, String>();
    public Map<String, String> m_assignedMessagePolicies = new HashMap<String, String>();
    public Map<String, String> m_assignedBinaries = new HashMap<String, String>();
    public GroupTreeObject m_asn = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
    private String m_toStringPrepared = null;
    public int m_forceRefresh = 0;
    public long m_lastMessageReceived = -1L;
    private AgentInventoryCard m_inventory = null;
    private AgentCardCM m_extendedInfo = null;
    private EventsAndStatus m_eventsAndStatus = new EventsAndStatus();
    public static AtomicLong m_lastNodeGroupsRefresh = new AtomicLong(0L);
    private String m_relatedGroupsRuntimeOnly = null;
    private long m_lastNodeGroupsRefreshLocal = 0L;
    private List<String> m_nodeGroups = new ArrayList<String>();
    private String oid = null;
    public static ConcurrentHashMap<String, Image> m_osIcons = new ConcurrentHashMap(20, 0.9f, 2);
    public static ConcurrentHashMap<String, String> m_parentOsImageName = new ConcurrentHashMap(7, 0.9f, 2);

    public AgentCard() {
        this.setLabel("");
    }

    public long getLastMessageReceived() {
        try {
            Long lit;
            if (this.m_extendedInfo != null && (lit = (Long)this.m_extendedInfo.getValue("LIT")) != null && lit > 0L) {
                return lit;
            }
        }
        catch (Throwable throwable) {}
        return this.m_lastMessageReceived;
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        super.read(dis);
        if (!this.m_approved) {
            String prefix = "";
            if (this.m_os.startsWith("(BS:")) {
                int slaveMarker2 = this.m_os.indexOf(41);
                prefix = this.m_os.substring(0, slaveMarker2 + 1);
            }
            this.m_os = this.isExternal() ? String.valueOf(prefix) + NOT_APPROVED_EXTERNAL : String.valueOf(prefix) + NOT_APPROVED_AGENTS;
        }
        return this;
    }

    public int updateFrom(AgentCard card) {
        this.m_forceRefresh = 0;
        if (card != null && card.m_agentID != null) {
            if (this.equalsExceptMode(card)) {
                if (this.getMode() == card.getMode() && this.getIconnameForAgent().equals(card.getIconnameForAgent())) {
                    return 0;
                }
                this.m_forceRefresh = 1;
                this.mode.set(card.getMode());
            } else {
                this.m_agentFlags = card.getAgentFlags();
                this.mode.set(card.getMode());
                this.m_desc = card.m_desc;
                this.m_hostIP = card.getAgentIP();
                String host = card.getAgentHost();
                int split = host.lastIndexOf(58);
                if (split != -1) {
                    this.m_hostname = host.substring(0, split);
                    String port = host.substring(split + 1);
                    try {
                        this.m_port = Integer.parseInt(port);
                    }
                    catch (Throwable throwable) {}
                } else {
                    this.m_hostname = host;
                }
                this.m_label = card.m_label;
                this.m_forceRefresh = this.m_os != null && this.m_os.equals(card.m_os) ? 1 : 2;
                this.m_os = card.m_os;
                if (this.m_approved != card.m_approved) {
                    this.m_forceRefresh = 2;
                }
                this.m_approved = card.m_approved;
                this.m_disabled = card.m_disabled;
                this.m_port = card.m_port;
                if (!this.m_approved) {
                    if (this.isExternal()) {
                        if (this.m_os.indexOf(NOT_APPROVED_EXTERNAL) == -1) {
                            this.m_os = NOT_APPROVED_EXTERNAL;
                        }
                    } else if (this.m_os.indexOf(NOT_APPROVED_AGENTS) == -1) {
                        this.m_os = NOT_APPROVED_AGENTS;
                    }
                }
                this.resetPreparedToString();
            }
        }
        return this.m_forceRefresh;
    }

    @Override
    public String toString() {
        if (this.m_toStringPrepared == null) {
            this.m_toStringPrepared = this.getToString();
        }
        return this.m_toStringPrepared;
    }

    public void resetPreparedToString() {
        this.m_toStringPrepared = null;
    }

    private String getToString() {
        if (this.m_label == null) {
            this.m_label = "";
        }
        StringBuffer sb = new StringBuffer(this.m_label);
        if (this.m_label.isEmpty() && this.m_hostname != null && this.m_hostname.length() > 0 && !this.m_hostname.equals(this.m_hostIP)) {
            sb.append(this.m_hostname);
        }
        if (this.m_disabled) {
            sb.append(DISABLED_PREFIX);
        }
        sb.append(" (").append(this.m_hostIP).append(")");
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.getID();
    }

    @Override
    public String getComparableName() {
        return this.getLabel().isEmpty() ? this.toString() : this.getLabel();
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getType() {
        return BMUI.type_agt;
    }

    @Override
    public void setName(String name) {
        this.setLabel(name);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
        this.resetPreparedToString();
    }

    @Override
    public void setType(String type) {
    }

    @Override
    public void setObject(Object obj) {
    }

    @Override
    public int hashCode() {
        return this.getID() == null ? 0 : this.getID().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AgentCard) || obj == null) {
            return false;
        }
        AgentCard ac = (AgentCard)obj;
        if (this.getMode() == ac.getMode()) {
            return this.equalsExceptMode(obj);
        }
        return false;
    }

    public boolean equalsExceptMode(Object obj) {
        if (!(obj instanceof AgentCard) || obj == null) {
            return false;
        }
        AgentCard ac = (AgentCard)obj;
        return this.m_agentID != null && this.m_agentID.equals(ac.m_agentID) && this.getAgentPort() == ac.getAgentPort() && this.m_approved == ac.m_approved && this.m_disabled == ac.m_disabled && this.m_agentFlags == ac.m_agentFlags && (this.m_hostIP == null ? ac.m_hostIP == null : this.m_hostIP.equals(ac.m_hostIP)) && (this.m_label == null ? ac.m_label == null : this.m_label.equals(ac.m_label)) && (this.m_hostname == null ? ac.m_hostname == null : this.m_hostname.equals(ac.m_hostname)) && (this.m_os == null ? ac.m_os == null : this.m_os.equals(ac.m_os)) && (this.m_desc == null ? ac.m_desc == null : this.m_desc.equals(ac.m_desc));
    }

    public void applyEvent(SEventFwd e, int inc) {
        this.m_lastMessageReceived = this.m_lastMessageReceived < 0L ? e.getSTime() : Math.max(this.m_lastMessageReceived, e.getSTime());
        if (inc > 0) {
            this.getEvents().add(e);
        } else {
            this.getEvents().remove(e);
        }
    }

    public EventsAndStatus getEvents() {
        return this.m_eventsAndStatus;
    }

    @Override
    public String getRelatedServer() {
        if (this.m_server == null && this.m_os.indexOf(40) != -1) {
            try {
                String meta = this.m_os.substring(1, this.m_os.indexOf(41));
                String[] arr = meta.split(":", 3);
                this.m_server = arr[2];
            }
            catch (Throwable throwable) {}
        }
        return this.m_server;
    }

    public AgentInventoryCard getInventoryCard(boolean force) {
        if (this.m_inventory == null && force) {
            this.m_inventory = new AgentInventoryCard(this.getAgentID());
            ScGetAgentInventoryCard sc = new ScGetAgentInventoryCard(Repository.getInstance(), this.getAgentID());
            Repository.getJobManager().schedule(sc, 1L);
        }
        return this.m_inventory;
    }

    public void setInventoryCard(AgentInventoryCard aci) {
        if (this.m_inventory == null) {
            this.m_inventory = aci;
        } else {
            this.m_inventory.updateFrom(aci);
        }
    }

    public AgentCardCM getAgentCardCM() {
        if (this.m_extendedInfo == null) {
            this.m_extendedInfo = new AgentCardCM(this.getAgentID());
        }
        return this.m_extendedInfo;
    }

    public void setAgentCardCM(AgentCardCM acm) {
        if (this.m_extendedInfo == null) {
            this.m_extendedInfo = acm;
        } else {
            this.m_extendedInfo.getAttributes().clear();
            this.m_extendedInfo.getAttributes().putAll(acm.getAttributes());
        }
    }

    public String getRelatedNodeGroups() {
        GroupTreeObject root;
        if ((this.m_relatedGroupsRuntimeOnly == null || m_lastNodeGroupsRefresh.get() != this.m_lastNodeGroupsRefreshLocal) && (root = Repository.getInstance().getAgentTree()) != null) {
            String GRP_ROOT = "/root/_Groups/";
            LinkedList<String> nodeGroups = new LinkedList<String>();
            GroupTreeObject groupGTO = root.getChild("_Groups", BMUI.type_folder);
            List<GroupTreeObjectLast> links = groupGTO.findLinksByName(this.getAgentID());
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < links.size()) {
                GroupTreeObjectLast gto = links.get(i);
                String parentPath = gto.getParentPath();
                parentPath = parentPath.replace(GRP_ROOT, "");
                sb.append(parentPath);
                nodeGroups.add(parentPath);
                if (i < links.size() - 1) {
                    sb.append('|');
                }
                ++i;
            }
            this.m_nodeGroups = new ArrayList<String>(nodeGroups);
            this.m_relatedGroupsRuntimeOnly = sb.toString();
            this.m_lastNodeGroupsRefreshLocal = m_lastNodeGroupsRefresh.get();
        }
        if (this.m_relatedGroupsRuntimeOnly == null) {
            return "";
        }
        return this.m_relatedGroupsRuntimeOnly;
    }

    public List<String> getRelatedNodeGroupsList() {
        this.getRelatedNodeGroups();
        return this.m_nodeGroups;
    }

    @Override
    public String getOID() {
        return this.oid;
    }

    @Override
    public void setOID(String oid) {
        this.oid = oid;
    }

    public static Image getOSIcon(String operatingSystem) {
        Image OSImage = m_osIcons.get(operatingSystem);
        if (OSImage == null) {
            int index;
            OSImage = BMUI.IMAGE_TRANSPARENT_12x12;
            String os = operatingSystem.toLowerCase();
            if (os.indexOf("win", index = os.lastIndexOf(")")) != -1) {
                OSImage = BMUI.IMAGE_FOLDER_WIN;
            } else if (os.indexOf("hp", index) != -1) {
                OSImage = BMUI.IMAGE_FOLDER_HPUX;
            } else if (os.indexOf("linux", index) != -1) {
                OSImage = BMUI.IMAGE_FOLDER_LINUX;
            } else if (os.indexOf("sun", index) != -1 || os.indexOf("solaris", index) != -1) {
                OSImage = BMUI.IMAGE_FOLDER_SUN;
            } else if (os.indexOf("mac", index) != -1 || os.indexOf("apple", index) != -1) {
                OSImage = BMUI.IMAGE_FOLDER_MAC;
            } else if (os.indexOf("freebsd", index) != -1) {
                OSImage = BMUI.IMAGE_FOLDER_FREEBSD;
            } else if (os.indexOf("aix", index) != -1) {
                OSImage = BMUI.IMAGE_FOLDER_AIX;
            } else if (os.indexOf("400", index) != -1) {
                OSImage = BMUI.IMAGE_FOLDER_OS400;
            }
            m_osIcons.put(operatingSystem, OSImage);
        }
        return OSImage;
    }

    public static String getParentOSImageName(String os_lowercase) {
        String type = m_parentOsImageName.get(os_lowercase);
        if (type == null) {
            type = "IMAGE_FOLDER_24";
            if (os_lowercase.indexOf("win") != -1) {
                type = "IMAGE_FOLDER_WIN";
            } else if (os_lowercase.indexOf("hp") != -1) {
                type = "IMAGE_FOLDER_HPUX";
            } else if (os_lowercase.indexOf("linux") != -1) {
                type = "IMAGE_FOLDER_LINUX";
            } else if (os_lowercase.indexOf("sun") != -1 || os_lowercase.indexOf("solaris") != -1) {
                type = "IMAGE_FOLDER_SUN";
            } else if (os_lowercase.indexOf("mac") != -1 || os_lowercase.indexOf("apple") != -1) {
                type = "IMAGE_FOLDER_MAC";
            } else if (os_lowercase.indexOf("freebsd") != -1) {
                type = "IMAGE_FOLDER_FREEBSD";
            } else if (os_lowercase.indexOf("aix") != -1) {
                type = "IMAGE_FOLDER_AIX";
            } else if (os_lowercase.indexOf("400") != -1) {
                type = "IMAGE_FOLDER_OS400";
            } else if (os_lowercase.indexOf("approved") != -1) {
                type = "IMAGE_PC_REG";
            }
            m_parentOsImageName.put(os_lowercase, type);
        }
        return type;
    }

    public String getIconnameForAgent() {
        if (!this.isApproved()) {
            return "IMAGE_PC_REG";
        }
        String iii = "IMAGE_PC";
        switch (this.getMode()) {
            case 0: 
            case 1: {
                iii = "IMAGE_PC_NORM";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                iii = "IMAGE_PC_CRIT";
                break;
            }
            case 7: {
                iii = "IMAGE_PC_FWOFF";
                break;
            }
            case 8: {
                iii = "IMAGE_PC_FWOK";
                break;
            }
        }
        if (!Repository.getInstance().isPermittedAgentModify(this)) {
            iii = String.valueOf(iii) + "-";
        }
        return iii;
    }

    public void setHost(String hostname) {
        this.m_hostname = hostname;
        this.resetPreparedToString();
    }

    public void setIP(String IP) {
        this.m_hostIP = IP;
        this.resetPreparedToString();
    }

    public boolean isExternal() {
        return this.getAgentPort() == 0;
    }

    public String getOSNameOnly() {
        String osName = super.getOSName();
        if (osName == null) {
            osName = "";
        } else {
            try {
                int slaveMarker2;
                if (osName.startsWith("(BS:") && (slaveMarker2 = this.m_os.indexOf(41)) != -1) {
                    osName = this.m_os.substring(slaveMarker2 + 1).trim();
                }
            }
            catch (Throwable throwable) {}
        }
        return osName;
    }
}

