/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.GAssignments;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.views.AgentOverviewTableProvider;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.shared.Assignment;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class AllAssignmentTableProvider
implements IStructuredContentProvider {
    private List<Assignment> m_elements = null;
    private boolean m_singleDeployed = false;
    private SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public CellLabelProvider labelProvider = new CellLabelProvider(){

        public String getToolTipText(Object element) {
            StringBuffer htmlStr = new StringBuffer();
            htmlStr.append("<html>").append("<head><style type=\"text/css\">").append("body { margin-left:5px; margin-right:5px; margin-top:5px; margin-bottom:5px }").append("</style></head>").append("<body bgcolor='#FFFFE1'>");
            if (element instanceof Assignment) {
                Assignment asn = (Assignment)element;
                String oid = asn.getOID();
                if (oid != null && oid.length() == 32) {
                    GroupTreeObject nodeGroup = Repository.getInstance().getAgentTree().findByOID(oid);
                    if (nodeGroup != null) {
                        String path = nodeGroup.getPath().replace("/root/", "");
                        htmlStr.append("<table border='0' cellspacing='0' cellpadding='0'>").append("<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Name:</font></td>").append("<td nowrap ><font face='Arial' size='1' color='#000000'>").append("NodeGroup:<br><b>").append(path).append("</b>").append("</font></td></tr>").append("</table>");
                    }
                } else {
                    htmlStr.append("<p><font face='Arial' size='1' color='#000000'>").append(asn.getComparableName().trim()).append("</font></p>");
                }
                htmlStr.append("</body></html>");
            }
            return htmlStr.toString();
        }

        public Point getToolTipShift(Object object) {
            return new Point(3, 3);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 50;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 9999999;
        }

        public void update(ViewerCell cell) {
            Assignment asn = null;
            int columnIndex = cell.getColumnIndex();
            if (!(cell.getElement() instanceof Assignment)) {
                return;
            }
            asn = (Assignment)cell.getElement();
            String result = AllAssignmentTableProvider.this.getColumnText(asn, columnIndex);
            Image image = AllAssignmentTableProvider.this.getColumnImage(asn, columnIndex);
            cell.setText(result);
            cell.setImage(image);
        }
    };

    public AllAssignmentTableProvider(boolean singleDeployed) {
        this.m_singleDeployed = singleDeployed;
        this.m_elements = new ArrayList<Assignment>();
        if (this.m_singleDeployed) {
            List<Assignment> binaryList = Repository.getInstance().getAllAssignments().getSingleAssignedBinaries();
            List<Assignment> policyList = Repository.getInstance().getAllAssignments().getSingleAssignedPolicies();
            if (binaryList != null && binaryList.size() > 0) {
                this.m_elements.addAll(binaryList);
            }
            if (policyList != null && policyList.size() > 0) {
                this.m_elements.addAll(policyList);
            }
        } else {
            GAssignments ga = Repository.getInstance().getAllAssignments();
            this.m_elements.addAll(ga.getPendingAssignments());
        }
    }

    public Object[] getElements(Object inputElement) {
        this.m_elements.clear();
        if (this.m_singleDeployed) {
            List<Assignment> binaryList = Repository.getInstance().getAllAssignments().getSingleAssignedBinaries();
            List<Assignment> policyList = Repository.getInstance().getAllAssignments().getSingleAssignedPolicies();
            if (binaryList != null && binaryList.size() > 0) {
                this.m_elements.addAll(binaryList);
            }
            if (policyList != null && policyList.size() > 0) {
                this.m_elements.addAll(policyList);
            }
        } else {
            List<Assignment> pendingAssignments = Repository.getInstance().getAllAssignments().getPendingAssignments();
            for (Assignment asn : pendingAssignments) {
                if (GAssignments.isAssignmentRunning(asn)) continue;
                this.m_elements.add(asn);
            }
        }
        return this.m_elements.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Assignment asn, int columnIndex) {
        AgentCard ac;
        if (this.m_singleDeployed && columnIndex == 0 || !this.m_singleDeployed && columnIndex == 1) {
            if (asn.getType().equals(BMUI.type_assignment_bin)) {
                return BMUI.IMAGE_PKG;
            }
            if (asn.getType().equals(BMUI.type_mon)) {
                return BMUI.IMAGE_MON;
            }
            if (asn.getType().equals(BMUI.type_msg)) {
                return BMUI.IMAGE_MSG;
            }
            if (asn.getType().equals(BMUI.type_assignment_pol)) {
                if (asn.getOID() != null && asn.getOID().length() == 32) {
                    return BMUI.IMAGE_FOLDER;
                }
                return BMUI.IMAGE_ASN;
            }
        }
        if ((this.m_singleDeployed && columnIndex == 2 || !this.m_singleDeployed && columnIndex == 3) && (ac = Repository.getInstance().getAgentCard(asn.getAgentID())) != null) {
            return AgentOverviewTableProvider.getStatusIcon(ac.getIconnameForAgent());
        }
        return null;
    }

    public String getColumnText(Assignment asn, int columnIndex) {
        if (this.m_singleDeployed) {
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return asn.getName();
                }
                case 2: {
                    AgentCard ac = Repository.getInstance().getAgentCard(asn.getAgentID());
                    if (ac != null && ac.isDisabled()) {
                        return "(X)";
                    }
                    return "";
                }
                case 3: {
                    String str = asn.getAgentID();
                    AgentCard ac1 = Repository.getInstance().getAgentCard(asn.getAgentID());
                    if (ac1 != null) {
                        str = ac1.toString().replace("(X)", "");
                    }
                    return str;
                }
                case 4: {
                    return asn.getUser().intern();
                }
                case 5: {
                    return this.m_sdf.format(new Date(asn.getFtime()));
                }
                case 6: {
                    if (asn.getUtime() == 0L) {
                        return "";
                    }
                    return this.m_sdf.format(new Date(asn.getUtime()));
                }
                case 7: {
                    if (asn.getLock() > 0) {
                        return "locked";
                    }
                    return "unlocked";
                }
            }
        } else {
            switch (columnIndex) {
                case 0: {
                    return this.getAllRelatedAsnGroups(asn);
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return asn.getName();
                }
                case 3: {
                    AgentCard ac = Repository.getInstance().getAgentCard(asn.getAgentID());
                    if (ac != null && ac.isDisabled()) {
                        return "(X)";
                    }
                    return "";
                }
                case 4: {
                    String oid = asn.getAgentID();
                    if (oid != null && oid.length() == 32) {
                        GroupTreeObject nodeGroup = Repository.getInstance().getAgentTree().findByOID(oid);
                        if (nodeGroup != null) {
                            oid = nodeGroup.getPath();
                        }
                        return oid;
                    }
                    String str = asn.getAgentID();
                    AgentCard ac1 = Repository.getInstance().getAgentCard(asn.getAgentID());
                    if (ac1 != null) {
                        str = ac1.toString().replace("(X)", "");
                    }
                    return str;
                }
                case 5: {
                    String action = "";
                    switch (asn.getLock()) {
                        case 1: {
                            action = AssignmentsSummaryView.DEPLOY;
                            break;
                        }
                        case 2: {
                            action = AssignmentsSummaryView.REDEPLOY;
                            break;
                        }
                        case 3: {
                            action = AssignmentsSummaryView.UNDEPLOY;
                            break;
                        }
                        case 4: {
                            action = AssignmentsSummaryView.CANCEL_DEPLOYMENT;
                            break;
                        }
                        default: {
                            action = "";
                        }
                    }
                    return action;
                }
                case 6: {
                    return asn.getUser().intern();
                }
                case 7: {
                    if (asn.getUtime() != 0L) {
                        return this.m_sdf.format(new Date(asn.getUtime()));
                    }
                    return this.m_sdf.format(new Date(asn.getFtime()));
                }
            }
        }
        return "";
    }

    public String getAllRelatedAsnGroups(Assignment asn) {
        GroupTreeObject nodeGroupGTO;
        GroupTreeObjectLast gtol;
        GroupTreeObject asnGrp;
        int ii;
        List<GroupTreeObject> asnGroupList;
        ArrayList<String> collectedAsnGroups = new ArrayList<String>();
        GroupTreeObject root = Repository.getInstance().getAllAssignments().getAllAgentsRoot();
        String agentOrNodeGroupID = asn.getAgentID();
        if (agentOrNodeGroupID == null) {
            return "";
        }
        if (agentOrNodeGroupID.length() == 36) {
            GroupTreeObject agentGTO = root.findSubGroupByName(agentOrNodeGroupID);
            if (agentGTO != null) {
                asnGroupList = agentGTO.getElements();
                ii = 0;
                while (ii < asnGroupList.size()) {
                    if (asnGroupList.get(ii) instanceof GroupTreeObject && (asnGrp = asnGroupList.get(ii)).getTreeObject().getType().equals(BMUI.type_assignment_pol) && (gtol = asnGrp.findElement(asn.getName(), asn.getType())) != null) {
                        collectedAsnGroups.add(asnGrp.getName());
                    }
                    ++ii;
                }
            }
        } else if (agentOrNodeGroupID.length() == 32 && (nodeGroupGTO = Repository.getInstance().getAllAssignments().getAllNodeGroupsRoot().findByOID(agentOrNodeGroupID)) != null) {
            asnGroupList = nodeGroupGTO.getElements();
            ii = 0;
            while (ii < asnGroupList.size()) {
                if (asnGroupList.get(ii) instanceof GroupTreeObject && (asnGrp = asnGroupList.get(ii)).getTreeObject().getType().equals(BMUI.type_assignment_pol) && (gtol = asnGrp.findElement(asn.getName(), asn.getType())) != null) {
                    collectedAsnGroups.add(asnGrp.getName());
                }
                ++ii;
            }
        }
        StringBuffer asnStr = new StringBuffer();
        int i = 0;
        while (i < collectedAsnGroups.size()) {
            if (i == 0) {
                asnStr.append((String)collectedAsnGroups.get(i));
            } else {
                asnStr.append(", ").append((String)collectedAsnGroups.get(i));
            }
            ++i;
        }
        return asnStr.toString();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

