/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.AllAssignmentTableProvider;
import com.blixx.boom.engine.GAssignments;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.log.RTLogger;
import com.blixx.shared.Assignment;
import com.blixx.shared.DeploymentStatus;
import com.blixx.shared.utils.GroupTreeObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.TableColumn;

public class AssignmentFilter
extends ViewerFilter {
    public static final int START_WITH = 1;
    public static final int ENDS_WITH = 2;
    public static final int CONTAINS = 3;
    public static final int EXACTLY = 4;
    private TableViewer m_tv = null;
    public boolean m_isLocked = false;
    private String m_column = null;
    private int m_columnInt = -1;
    private String m_pattern = null;
    private Pattern m_filter = null;
    private int m_mode = 0;
    public boolean m_isActive = true;
    public boolean m_isDefault = false;
    private SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat m_sdf_milliSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");

    public AssignmentFilter(String columnName, String pattern, boolean caseSensitive, int mode, TableViewer tv, boolean isLocked) {
        this.m_isLocked = isLocked;
        this.m_tv = tv;
        try {
            this.m_column = columnName;
            this.m_columnInt = this.getColumnPosition(this.m_column);
            if (this.m_columnInt == -1) {
                this.m_filter = Pattern.compile(".*");
            }
            this.m_mode = mode;
            this.m_pattern = pattern;
            switch (mode) {
                case 1: {
                    this.m_filter = Pattern.compile("^\\Q" + this.m_pattern + "\\E" + ".*");
                    break;
                }
                case 2: {
                    this.m_filter = Pattern.compile(".*\\Q" + this.m_pattern + "\\E$");
                    break;
                }
                case 3: {
                    this.m_filter = Pattern.compile(".*\\Q" + this.m_pattern + "\\E" + ".*");
                    break;
                }
                case 4: {
                    this.m_filter = Pattern.compile("\\Q" + this.m_pattern + "\\E");
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(4, "", e);
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!this.m_isActive) {
            return true;
        }
        String text = this.getValue(this.m_columnInt, element);
        Matcher m = this.m_filter.matcher(text);
        return m.matches();
    }

    public int getColumnPosition(String colName) {
        int index = -1;
        TableColumn[] cols = this.m_tv.getTable().getColumns();
        int i = 0;
        while (i < cols.length) {
            TableColumn col = cols[i];
            if (col.getText().equalsIgnoreCase(colName)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public String getValue(int columnNumber, Object element) {
        String res;
        block40: {
            String viewerType;
            block41: {
                block39: {
                    res = "";
                    Date d = null;
                    viewerType = (String)this.m_tv.getData(AssignmentsSummaryView.VIEWER_TYPE);
                    if (!viewerType.equals(AssignmentsSummaryView.SINGLE_DEPLOYED_TABLE_VIEWER)) break block39;
                    Assignment a = (Assignment)element;
                    switch (columnNumber) {
                        case 0: {
                            res = a.getType();
                            break;
                        }
                        case 1: {
                            res = a.getName();
                            break;
                        }
                        case 2: {
                            res = "";
                            break;
                        }
                        case 3: {
                            AgentCard ac = Repository.getInstance().getAgentCard(a.getAgentID());
                            res = ac.toString();
                            break;
                        }
                        case 4: {
                            res = a.getUser();
                            break;
                        }
                        case 5: {
                            d = new Date(a.getFtime());
                            res = this.m_sdf_milliSec.format(d);
                            break;
                        }
                        case 6: {
                            d = new Date(a.getUtime());
                            res = this.m_sdf_milliSec.format(d);
                            break;
                        }
                    }
                    break block40;
                }
                if (!viewerType.equals(AssignmentsSummaryView.DEPLOYMENT_QUEUE_TABLE_VIEWER)) break block41;
                Assignment a = (Assignment)element;
                switch (columnNumber) {
                    case 0: {
                        AllAssignmentTableProvider p = AssignmentsSummaryView.getInstance().getTableProvider_deploymentQueue();
                        res = p.getAllRelatedAsnGroups(a);
                        break;
                    }
                    case 1: {
                        res = a.getType();
                        break;
                    }
                    case 2: {
                        res = a.getName();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        AgentCard ac = Repository.getInstance().getAgentCard(a.getAgentID());
                        if (ac != null) {
                            res = ac.toString();
                            break;
                        }
                        break block40;
                    }
                    case 5: {
                        if (a.getLock() == 1) {
                            res = AssignmentsSummaryView.DEPLOY;
                            break;
                        }
                        if (a.getLock() == 2) {
                            res = AssignmentsSummaryView.REDEPLOY;
                            break;
                        }
                        if (a.getLock() == 3) {
                            res = AssignmentsSummaryView.UNDEPLOY;
                            break;
                        }
                        if (a.getLock() > 3) {
                            res = AssignmentsSummaryView.CANCEL_DEPLOYMENT;
                            break;
                        }
                        res = "";
                        break;
                    }
                    case 6: {
                        res = a.getUser();
                        break;
                    }
                    case 7: {
                        if (a.getUtime() != 0L) {
                            res = this.m_sdf.format(new Date(a.getUtime()));
                            break;
                        }
                        res = this.m_sdf.format(new Date(a.getFtime()));
                    }
                }
                break block40;
            }
            if (viewerType.equals(AssignmentsSummaryView.DEPLOYMENTS_RUNNING_TABLE_VIEWER)) {
                DeploymentStatus ds = (DeploymentStatus)element;
                switch (columnNumber) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        res = "" + ds.getFileNames().size();
                        break;
                    }
                    case 2: {
                        res = ds.getFileNames().toString();
                        break;
                    }
                    case 3: {
                        res = GAssignments.getDeploymentState(ds.getState());
                        break;
                    }
                    case 4: {
                        res = ds.getType().startsWith("U") ? "Undeploy" : "Deploy";
                        break;
                    }
                    case 5: {
                        String oid = ds.getAcid();
                        if (oid != null && oid.length() == 32) {
                            GroupTreeObject nodeGroup = Repository.getInstance().getAgentTree().findByOID(oid);
                            if (nodeGroup != null) {
                                oid = nodeGroup.getPath();
                            }
                            res = oid;
                            break;
                        }
                        String str = ds.getAcid();
                        AgentCard ac1 = Repository.getInstance().getAgentCard(ds.getAcid());
                        if (ac1 != null) {
                            str = ac1.toString().replace("(X)", "");
                        }
                        res = str;
                        break;
                    }
                    case 6: {
                        res = this.m_sdf.format(new Date(ds.getInitTime()));
                        break;
                    }
                    case 7: {
                        res = this.m_sdf.format(new Date(ds.getExpireTime()));
                        break;
                    }
                }
            }
        }
        return res;
    }

    public String toString() {
        String res = this.m_column;
        switch (this.m_mode) {
            case 1: {
                res = String.valueOf(res) + " STARTS WITH ";
                break;
            }
            case 2: {
                res = String.valueOf(res) + " ENDS WITH ";
                break;
            }
            case 3: {
                res = String.valueOf(res) + " CONTAINS ";
                break;
            }
            case 4: {
                res = String.valueOf(res) + " == ";
                break;
            }
        }
        res = String.valueOf(res) + this.m_pattern;
        if (this.m_column == null || this.m_column.length() == 0) {
            res = "";
        }
        return res;
    }

    public TableViewer getTableViewer() {
        return this.m_tv;
    }
}

