/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.ICommandListener;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.ConcurrentHashMapMap;
import java.util.Map;

public class CmdRouter {
    private ICommandListener m_nullCmdListener = new ICommandListener(){

        @Override
        public void onCommand(String command, String action) {
        }
    };
    private ConcurrentHashMapMap<String, ICommandListener> m_cmdListener = new ConcurrentHashMapMap();

    public void registerCmd4Listeners(String command) {
        this.m_cmdListener.putV(command, this.m_nullCmdListener);
    }

    public void addCmdListener(String command, ICommandListener listener) {
        this.m_cmdListener.putV(command, listener);
        RTLogger.print(2, "CmdRouter +" + command);
    }

    public void removeCmdListener(String command, ICommandListener listener) {
        Map<ICommandListener, Object> map = this.m_cmdListener.getHashMap(command);
        if (map != null) {
            map.remove(listener);
        }
    }

    public boolean informCmdListeners(String command, String action) {
        boolean isRegistered = false;
        Map<ICommandListener, Object> map = this.m_cmdListener.getHashMap(command);
        if (map != null) {
            isRegistered = true;
            for (ICommandListener l : map.keySet()) {
                l.onCommand(command, action);
            }
        }
        return isRegistered;
    }
}

