/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.DSRow;
import com.blixx.boom.engine.EventStorage;
import com.blixx.boom.engine.IEventProvider;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.log.RTLogger;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DiskEventStorage {
    public static final String ACTIVE = "A_";
    public static final String CLOSED = "C_";
    private static final String FILETYPE = ".tmp";
    public String m_type = "C_";
    public Map<String, File> m_hostPolicy_File_map = new ConcurrentHashMap<String, File>();
    public Map<String, Collection<SEventFwd>> m_hostPolicy_Collection_map = new ConcurrentHashMap<String, Collection<SEventFwd>>();
    public Map<String, Long> m_hostPolicy_COUNT_map = new ConcurrentHashMap<String, Long>();
    public static Map<String, DSRow> m_rows = new HashMap<String, DSRow>();
    public static Map<String, Object> m_archivedEvents = new ConcurrentHashMap<String, Object>();
    public static Map<String, Object> m_closedEvents = new ConcurrentHashMap<String, Object>();
    public static DiskEventStorage m_active = new DiskEventStorage("A_");
    public static DiskEventStorage m_closed = new DiskEventStorage("C_");
    public static List<String> m_loadedShortKeys = null;
    private static IEventProvider m_eventStorage = EventStorage.getInstance();
    public static final Object nothing = new Object();

    public static DiskEventStorage getActiveStorage() {
        return m_active;
    }

    public static DiskEventStorage getClosedStorage() {
        return m_closed;
    }

    public DiskEventStorage(String activeOrClosed) {
        this.m_type = activeOrClosed;
    }

    public static Object[] getElements() {
        DSRow row;
        m_rows.clear();
        for (Map.Entry<String, Long> entry : DiskEventStorage.getActiveStorage().m_hostPolicy_COUNT_map.entrySet()) {
            row = new DSRow(entry.getKey());
            row.setActiveCount(entry.getValue());
            m_rows.put(row.getKeyShort(), row);
        }
        for (Map.Entry<String, Long> entry : DiskEventStorage.getClosedStorage().m_hostPolicy_COUNT_map.entrySet()) {
            row = new DSRow(entry.getKey());
            String shortKey = row.getKeyShort();
            DSRow rowInMap = m_rows.get(shortKey);
            if (rowInMap != null) {
                rowInMap.setClosedCount(entry.getValue());
                continue;
            }
            row.setClosedCount(entry.getValue());
            m_rows.put(row.getKeyShort(), row);
        }
        return m_rows.values().toArray();
    }

    public void cleanDisk() {
        File dir = new File(String.valueOf(Repository.getUserTmpDirectory()) + "/");
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(DiskEventStorage.this.m_type) && name.endsWith(DiskEventStorage.FILETYPE);
            }
        });
        int i = 0;
        while (i < files.length) {
            files[i].delete();
            ++i;
        }
    }

    public void clearCache() {
        this.m_hostPolicy_Collection_map.clear();
        this.m_hostPolicy_COUNT_map.clear();
        this.m_hostPolicy_File_map.clear();
    }

    public void flush() {
        for (Map.Entry<String, Collection<SEventFwd>> en : this.m_hostPolicy_Collection_map.entrySet()) {
            SDataOutputStream sdos;
            BufferedOutputStream bos;
            FileOutputStream fos;
            String key = en.getKey();
            Collection<SEventFwd> col = en.getValue();
            if (col == null || col.size() == 0) continue;
            File storage = this.m_hostPolicy_File_map.get(key);
            if (storage == null) {
                storage = this.getDefaultFile(key);
                this.m_hostPolicy_File_map.put(key, storage);
                try {
                    fos = new FileOutputStream(storage, false);
                    bos = new BufferedOutputStream(fos);
                    sdos = new SDataOutputStream(bos, 2);
                    for (SEventFwd se : col) {
                        se.sendSv2(sdos);
                    }
                    col.clear();
                    sdos.close();
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(3, "MM01", e);
                }
                continue;
            }
            try {
                fos = new FileOutputStream(storage, true);
                bos = new BufferedOutputStream(fos);
                sdos = new SDataOutputStream(bos, 2);
                for (SEventFwd se : col) {
                    se.sendSv2(sdos);
                }
                col.clear();
                sdos.close();
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable e) {
                RTLogger.print(3, "MM02", e);
            }
        }
    }

    public File getDefaultFile(String key) {
        File storage = new File(String.valueOf(Repository.getUserTmpDirectory()) + "/" + key.replace(':', '_') + FILETYPE);
        return storage;
    }

    public static void addClosed(String id) {
        m_closedEvents.put(id, nothing);
        try {
            String key;
            Long oldA;
            SEventFwd se = (SEventFwd)m_eventStorage.getEvent(id);
            if (se != null && (oldA = DiskEventStorage.getActiveStorage().m_hostPolicy_COUNT_map.get(key = DiskEventStorage.getActiveStorage().getKey(se))) != null && oldA > 0L) {
                DiskEventStorage.getActiveStorage().m_hostPolicy_COUNT_map.put(key, new Long(oldA - 1L));
                key = DiskEventStorage.getClosedStorage().getKey(se);
                Long oldC = DiskEventStorage.getClosedStorage().m_hostPolicy_COUNT_map.get(key);
                if (oldC == null) {
                    oldC = 0L;
                }
                DiskEventStorage.getClosedStorage().m_hostPolicy_COUNT_map.put(key, new Long(oldC + 1L));
            }
        }
        catch (Throwable e) {
            RTLogger.print(3, "MM03", e);
        }
    }

    public static void addArchived(String id) {
        String key;
        Long oldC;
        m_archivedEvents.put(id, nothing);
        SEventFwd se = (SEventFwd)m_eventStorage.getEvent(id);
        if (se != null && (oldC = DiskEventStorage.getClosedStorage().m_hostPolicy_COUNT_map.get(key = DiskEventStorage.getClosedStorage().getKey(se))) != null && oldC > 0L) {
            DiskEventStorage.getClosedStorage().m_hostPolicy_COUNT_map.put(key, new Long(oldC - 1L));
        }
    }

    public static void clearAllCache() {
        m_closedEvents.clear();
        m_archivedEvents.clear();
        DiskEventStorage.getActiveStorage().clearCache();
        DiskEventStorage.getClosedStorage().clearCache();
    }

    public static void clearAllDisk() {
        DiskEventStorage.getActiveStorage().cleanDisk();
        DiskEventStorage.getClosedStorage().cleanDisk();
    }

    public static void clearAll() {
        m_loadedShortKeys = null;
        DiskEventStorage.clearAllCache();
        DiskEventStorage.clearAllDisk();
    }

    public void addEvents(SEventFwd se) {
        String key = this.getKey(se);
        Collection<SEventFwd> collection = this.m_hostPolicy_Collection_map.get(key);
        if (collection == null) {
            collection = new LinkedList<SEventFwd>();
            this.m_hostPolicy_Collection_map.put(key, collection);
            Long counter = 1L;
            this.m_hostPolicy_COUNT_map.put(key, counter);
        } else {
            Long counter = this.m_hostPolicy_COUNT_map.get(key);
            counter = counter + 1L;
            this.m_hostPolicy_COUNT_map.put(key, counter);
        }
        collection.add(se);
    }

    public String getShortKey(SEventFwd se) {
        StringBuffer sb = new StringBuffer();
        String[] arr = se.getSource().split(":");
        sb.append(se.getNode()).append(":");
        if (arr.length == 3) {
            sb.append(arr[1]);
        } else {
            sb.append(arr[0]);
        }
        String key = sb.toString();
        return key;
    }

    public String getKey(SEventFwd se) {
        StringBuffer sb = new StringBuffer();
        String[] arr = se.getSource().split(":");
        sb.append(this.m_type);
        sb.append(se.getNode()).append(":");
        if (arr.length == 3) {
            sb.append(arr[1]);
        } else {
            sb.append(arr[0]);
        }
        String key = sb.toString();
        return key;
    }

    public static void loadStorages(List<String> shortKeys) {
        if (shortKeys != null) {
            m_loadedShortKeys = shortKeys;
        }
        if (m_loadedShortKeys == null) {
            return;
        }
        Iterator<String> it = m_loadedShortKeys.iterator();
        while (it.hasNext()) {
            int active = m_eventStorage.getActiveMap().size();
            int closed = m_eventStorage.getClosedMap().size();
            String skey = it.next();
            DiskEventStorage.getActiveStorage().loadEventStorage(skey);
            DiskEventStorage.getClosedStorage().loadEventStorage(skey);
            Repository.getEventStorageSubmit().fillTable();
            DiskEventStorage.getActiveStorage().m_hostPolicy_COUNT_map.put(ACTIVE + skey, new Long(m_eventStorage.getActiveMap().size() - active));
            DiskEventStorage.getClosedStorage().m_hostPolicy_COUNT_map.get(CLOSED + skey);
            Long nnew = new Long(m_eventStorage.getClosedMap().size() - closed);
            DiskEventStorage.getClosedStorage().m_hostPolicy_COUNT_map.put(CLOSED + skey, nnew);
        }
    }

    public static void moveActiveToClosed(String shortKey, long count) {
        try {
            String activeKey = ACTIVE + shortKey;
            File source = DiskEventStorage.getActiveStorage().m_hostPolicy_File_map.get(activeKey);
            String closedKey = CLOSED + shortKey;
            File destination = DiskEventStorage.getClosedStorage().getDefaultFile(closedKey);
            FileUtils.appendFile(source, destination);
            source.delete();
            DiskEventStorage.getActiveStorage().m_hostPolicy_COUNT_map.remove(activeKey);
            DiskEventStorage.getActiveStorage().m_hostPolicy_Collection_map.remove(activeKey);
            DiskEventStorage.getActiveStorage().m_hostPolicy_File_map.remove(activeKey);
            Long prev = DiskEventStorage.getClosedStorage().m_hostPolicy_COUNT_map.get(closedKey);
            if (prev == null) {
                prev = 0L;
                DiskEventStorage.getClosedStorage().m_hostPolicy_File_map.put(closedKey, destination);
            }
            if (!m_loadedShortKeys.contains(shortKey)) {
                prev = prev + count;
                DiskEventStorage.getClosedStorage().m_hostPolicy_COUNT_map.put(closedKey, prev);
            }
        }
        catch (Throwable e) {
            RTLogger.print(3, "MM04", e);
        }
    }

    private void loadEventStorage(String skey) {
        String a_key = String.valueOf(this.m_type) + skey;
        this.load(a_key, skey);
    }

    private void load(String a_key, String shortKey) {
        block35: {
            File evfile;
            Long count = this.m_hostPolicy_COUNT_map.get(a_key);
            if (count == null) {
                count = 1L;
            }
            if ((evfile = this.m_hostPolicy_File_map.get(a_key)) != null) {
                int intCount = count.intValue();
                ProgressDialog pd = new ProgressDialog("Loading indications", a_key, 0, intCount);
                pd.setBlockOnOpen(false);
                pd.open();
                intCount = 0;
                SDataInputStream sdis = null;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(evfile);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    sdis = new SDataInputStream(bis);
                    while (sdis.available() > 0) {
                        SEventFwd ev = new SEventFwd();
                        ev.readSv2(sdis);
                        pd.setProgress(String.valueOf(a_key) + ": " + ++intCount, intCount);
                        boolean isClosed = m_closedEvents.containsKey(ev.getID());
                        boolean isArchived = m_archivedEvents.containsKey(ev.getID());
                        if ('-' == ev.getState()) {
                            if (!isClosed && !isArchived) {
                                Repository.getEventStorageSubmit().addEvent(ev);
                                continue;
                            }
                            if (!isClosed || isArchived) continue;
                            Repository.getEventStorageSubmit().addAcknowledgedInitial(ev);
                            continue;
                        }
                        if (isArchived) continue;
                        Repository.getEventStorageSubmit().addAcknowledgedInitial(ev);
                    }
                }
                catch (FileNotFoundException e) {
                    RTLogger.print(3, "MM05", e);
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        sdis.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {}
                    break block35;
                }
                catch (Throwable e) {
                    try {
                        RTLogger.print(3, "MM06", e);
                    }
                    catch (Throwable throwable) {
                        try {
                            pd.close();
                        }
                        catch (Throwable throwable2) {}
                        try {
                            sdis.close();
                        }
                        catch (Throwable throwable3) {}
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable4) {}
                        throw throwable;
                    }
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        sdis.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {}
                    break block35;
                }
                try {
                    pd.close();
                }
                catch (Throwable throwable) {}
                try {
                    sdis.close();
                }
                catch (Throwable throwable) {}
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public List<String> loadIDs(String shortKey) {
        LinkedList<String> list;
        block24: {
            list = new LinkedList<String>();
            String a_key = String.valueOf(this.m_type) + shortKey;
            File evfile = this.m_hostPolicy_File_map.get(a_key);
            if (evfile != null) {
                SDataInputStream sdis = null;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(evfile);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    sdis = new SDataInputStream(bis);
                    SEventFwd ev = new SEventFwd();
                    while (sdis.available() > 0) {
                        ev.readSv2(sdis);
                        list.add(ev.getID());
                    }
                }
                catch (FileNotFoundException e) {
                    RTLogger.print(3, "MM07", e);
                    try {
                        sdis.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {}
                    break block24;
                }
                catch (Throwable e) {
                    try {
                        RTLogger.print(3, "MM08", e);
                    }
                    catch (Throwable throwable) {
                        try {
                            sdis.close();
                        }
                        catch (Throwable throwable2) {}
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable3) {}
                        throw throwable;
                    }
                    try {
                        sdis.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {}
                    break block24;
                }
                try {
                    sdis.close();
                }
                catch (Throwable throwable) {}
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return list;
    }

    public void clean(String shortKey) {
        String key = String.valueOf(this.m_type) + shortKey;
        this.m_hostPolicy_Collection_map.remove(key);
        this.m_hostPolicy_COUNT_map.remove(key);
        File f = this.m_hostPolicy_File_map.remove(key);
        if (f != null) {
            f.delete();
        }
    }
}

