/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.IEventProvider;
import com.blixx.boom.engine.ITableBrowserProvider;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.settings.PredefinedTab;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.shared.IEvent;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class EventBrowserProvider
implements ITableBrowserProvider {
    protected boolean m_isShowActive = true;
    protected IEventProvider m_eventStorage = null;

    public EventBrowserProvider(IEventProvider storage) {
        this.m_eventStorage = storage;
    }

    @Override
    public boolean isShowActive() {
        return this.m_isShowActive;
    }

    @Override
    public void setShowActive(boolean isShowActive) {
        this.m_isShowActive = isShowActive;
    }

    @Override
    public int getNumUnknMessages() {
        if (!this.isShowActive()) {
            return this.m_eventStorage.getNumUnknMessagesClosed();
        }
        return this.m_eventStorage.getNumUnknMessagesActive();
    }

    @Override
    public int getNumNormMessages() {
        if (!this.isShowActive()) {
            return this.m_eventStorage.getNumNormMessagesClosed();
        }
        return this.m_eventStorage.getNumNormMessagesActive();
    }

    @Override
    public int getNumWarnMessages() {
        if (!this.isShowActive()) {
            return this.m_eventStorage.getNumWarnMessagesClosed();
        }
        return this.m_eventStorage.getNumWarnMessagesActive();
    }

    @Override
    public int getNumMinorMessages() {
        if (!this.isShowActive()) {
            return this.m_eventStorage.getNumMinorMessagesClosed();
        }
        return this.m_eventStorage.getNumMinorMessagesActive();
    }

    @Override
    public int getNumMajorMessages() {
        if (!this.isShowActive()) {
            return this.m_eventStorage.getNumMajorMessagesClosed();
        }
        return this.m_eventStorage.getNumMajorMessagesActive();
    }

    @Override
    public int getNumCritMessages() {
        if (!this.isShowActive()) {
            return this.m_eventStorage.getNumCritMessagesClosed();
        }
        return this.m_eventStorage.getNumCritMessagesActive();
    }

    public Object[] getElements(Object inputElement) {
        Object[] res = null;
        res = this.isShowActive() ? this.m_eventStorage.getActiveMap().values().toArray() : this.m_eventStorage.getClosedMap().values().toArray();
        return res;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    @Override
    public IEventProvider getEventProvider() {
        return this.m_eventStorage;
    }

    @Override
    public int getTotalAcknMessages() {
        return this.m_eventStorage.getTotalAcknMessages();
    }

    @Override
    public int getTotalActualMessages() {
        return this.m_eventStorage.getTotalActualMessages();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public Color getBackground(Object element, int columnIndex_orig) {
        Color bgColor = null;
        boolean active = this.isBGColoringActive(columnIndex_orig);
        if (active && element != null && element instanceof IEvent) {
            IEvent sef = (IEvent)element;
            switch (sef.getSeverityInt()) {
                case 0: {
                    bgColor = BMUI.color_unknown;
                    break;
                }
                case 1: {
                    bgColor = BMUI.color_normal;
                    break;
                }
                case 2: {
                    bgColor = BMUI.color_warning;
                    break;
                }
                case 3: {
                    bgColor = BMUI.color_minor;
                    break;
                }
                case 4: {
                    bgColor = BMUI.color_major;
                    break;
                }
                case 5: {
                    bgColor = BMUI.color_critical;
                    break;
                }
            }
        }
        return bgColor;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        SEventFwd sef;
        String res;
        Image image = null;
        SEvent e = (SEvent)element;
        if (columnIndex == 0) {
            switch (e.getSeverityInt()) {
                case 5: {
                    image = BMUI.IMAGE_CRITICAL;
                    break;
                }
                case 4: {
                    image = BMUI.IMAGE_MAJOR;
                    break;
                }
                case 3: {
                    image = BMUI.IMAGE_MINOR;
                    break;
                }
                case 2: {
                    image = BMUI.IMAGE_WARNING;
                    break;
                }
                case 1: {
                    image = BMUI.IMAGE_NORMAL;
                    break;
                }
                case 0: {
                    image = BMUI.IMAGE_UNKNOWN;
                    break;
                }
                case -1: {
                    image = BMUI.IMAGE_CRITICAL_F;
                    break;
                }
                case -2: {
                    image = BMUI.IMAGE_MAJOR_F;
                    break;
                }
                case -3: {
                    image = BMUI.IMAGE_MINOR_F;
                    break;
                }
                case -4: {
                    image = BMUI.IMAGE_WARNING_F;
                    break;
                }
                case -5: {
                    image = BMUI.IMAGE_NORMAL_F;
                    break;
                }
                case -6: {
                    image = BMUI.IMAGE_UNKNOWN_F;
                    break;
                }
            }
        } else if (columnIndex == 31 && e instanceof SEventFwd && (res = (sef = (SEventFwd)e).getT5()) != null && res.indexOf(10) != -1) {
            image = res.startsWith(String.valueOf(Repository.m_user) + '\n') ? BMUI.IMAGE_OWNED_ME : BMUI.IMAGE_OWNED;
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        SEvent e = (SEvent)element;
        String label = EventStorageUtils.getLabel(e, columnIndex);
        return label;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    @Override
    public void enable(boolean enable) {
        this.m_eventStorage.enable(enable);
    }

    @Override
    public int getType() {
        return this.m_eventStorage.getType();
    }

    public boolean isBGColoringActive(int colIndexOrig) {
        boolean isBGColorActive = false;
        try {
            MessageBrowserTab activeBrowserTab = (MessageBrowserTab)MessagesView.getInstance().m_folder.getSelection();
            if (activeBrowserTab != null) {
                PredefinedTab tab;
                String colName = EventStorageUtils.getColumnNameByID(colIndexOrig);
                isBGColorActive = UISettings.getInstance().IB_isBGColoringActive(colName);
                if ((activeBrowserTab.isPredefinedTab() || activeBrowserTab.isUserTab()) && (tab = activeBrowserTab.m_predefinedOrUserTab) != null) {
                    isBGColorActive = tab.getColumn(colName).isColoringActive();
                }
            }
        }
        catch (Throwable throwable) {}
        return isBGColorActive;
    }
}

