/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.Repository;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class EventFilter
extends ViewerFilter {
    public static final String NG_ROOT = "/root/_Groups/";
    public static final int START_WITH = 1;
    public static final int ENDS_WITH = 2;
    public static final int CONTAINS = 3;
    public static final int EXACTLY = 4;
    public static final int BIGGER = 5;
    public static final int LESS = 6;
    public static final String COL_CA_NAME = "CA name";
    public static final String COL_CA_VALUE = "CA value";
    public static final String COL_NODE_GROUP = "Node group";
    public static final String COL_NODE_GROUP_EXT = "Node group [Hosts]";
    public static final int COL_CA_NAME_INT = 100;
    public static final int COL_CA_VALUE_INT = 101;
    public static final int COL_NODE_GROUP_INT = 102;
    public static final int COL_NODE_GROUP_EXT_INT = 103;
    public String m_column = null;
    public int m_columnInt = -1;
    public String m_pattern = null;
    Pattern m_filter = null;
    Set<String> m_virtualAgents = new HashSet<String>(1);
    public int m_mode = 0;
    public boolean m_caseSensitive = true;
    public boolean m_isNOT = false;
    public double m_doubleVal = 0.0;
    public TableViewer m_tv = null;
    public int m_filtered = 0;
    public int m_inactiveUnknown = 0;
    public int m_inactiveNormal = 0;
    public int m_inactiveWarning = 0;
    public int m_inactiveMinor = 0;
    public int m_inactiveMajor = 0;
    public int m_inactiveCritical = 0;
    public boolean m_isLocked = false;
    public int m_Availability = 0;
    public int m_KPIs = 0;
    public boolean m_isActive = true;
    private String m_label = null;
    public static final String COL_TIME_PLUSDUPLICATE = "TimePlusDuplicates";
    public static final String OWNED_ME = "Me";
    public static final String OWNED_ME_NOBODY = "Me+Nobody";
    public static final String OWNED_NOBODY = "Nobody";
    public static final String OWNED_OTHER = "Other";
    static Map<String, String> m_dbnames = new HashMap<String, String>();

    static {
        m_dbnames.put("Application", "EVENTS_A.APPLICATION");
        m_dbnames.put("Group", "EVENTS_A.MSGGRP");
        m_dbnames.put("Object", "EVENTS_A.OBJECT");
        m_dbnames.put("Host", "EVENTS_A.NODE");
        m_dbnames.put("Agent", "EVENTS_A.AGENTNODE");
        m_dbnames.put("Text", "EVENTS_A.MSGTEXT");
    }

    protected EventFilter() {
    }

    public EventFilter(String label, String columnName, String pattern, boolean caseSensitive, int mode, TableViewer tv, boolean isLocked, int typeA, int typeK, boolean isNOT) {
        this(label, columnName, pattern, caseSensitive, mode, tv, isLocked, typeA, typeK);
        this.m_isNOT = isNOT;
    }

    public EventFilter(String label, String columnName, String pattern, boolean caseSensitive, int mode, TableViewer tv, boolean isLocked, int typeA, int typeK) {
        this.m_label = label == null ? "" : label.trim();
        this.m_Availability = typeA;
        this.m_KPIs = typeK;
        this.m_isLocked = isLocked;
        this.m_tv = tv;
        this.m_caseSensitive = caseSensitive;
        try {
            this.m_column = columnName;
            if (this.m_column.equals(COL_CA_NAME)) {
                this.m_columnInt = 100;
            } else if (this.m_column.equals(COL_CA_VALUE)) {
                this.m_columnInt = 101;
            } else if (this.m_column.equals(COL_NODE_GROUP)) {
                this.m_columnInt = 102;
                pattern = pattern.replace(NG_ROOT, "");
            } else if (this.m_column.equals(COL_NODE_GROUP_EXT)) {
                this.m_columnInt = 103;
                pattern = pattern.replace(NG_ROOT, "");
            } else {
                this.m_columnInt = this.m_column.equals(COL_TIME_PLUSDUPLICATE) ? EventStorageUtils.getColumnPosition("Time") : EventStorageUtils.getColumnPosition(columnName);
            }
            if (this.m_columnInt == -1) {
                this.m_filter = Pattern.compile(".*", 40);
                return;
            }
            String patternToCompile = ".*";
            this.m_mode = mode;
            this.m_pattern = pattern;
            if (this.m_columnInt == 102 || this.m_columnInt == 103) {
                if (pattern.indexOf(124) == -1) {
                    patternToCompile = this.getPatternToCompileNodeGroup(pattern, mode);
                } else {
                    String[] spl = pattern.split("\\Q|\\E");
                    int i = 0;
                    while (i < spl.length) {
                        patternToCompile = String.valueOf(patternToCompile) + this.getPatternToCompileNodeGroup(spl[i], mode);
                        if (i < spl.length - 1) {
                            patternToCompile = String.valueOf(patternToCompile) + "|";
                        }
                        ++i;
                    }
                }
            } else if (pattern.indexOf(124) == -1) {
                patternToCompile = this.m_columnInt == 101 ? this.getPatternToCompileCAValue(pattern, mode) : this.getPatternToCompile(pattern, mode);
            } else {
                patternToCompile = "";
                String[] spl = pattern.split("\\Q|\\E");
                int i = 0;
                while (i < spl.length) {
                    patternToCompile = this.m_columnInt == 101 ? String.valueOf(patternToCompile) + this.getPatternToCompileCAValue(spl[i], mode) : String.valueOf(patternToCompile) + this.getPatternToCompile(spl[i], mode);
                    if (i < spl.length - 1) {
                        patternToCompile = String.valueOf(patternToCompile) + "|";
                    }
                    ++i;
                }
            }
            this.m_filter = caseSensitive ? Pattern.compile(patternToCompile, 40) : Pattern.compile(patternToCompile, 42);
            if (this.m_columnInt == 102 || this.m_columnInt == 103) {
                this.collectRelatedExternalHosts();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void collectRelatedExternalHosts() {
        this.m_virtualAgents.clear();
        Collection<AgentCard> col = Repository.getInstance().getAgentCards();
        block0: for (AgentCard ac : col) {
            if (103 != this.m_columnInt && !ac.isExternal()) continue;
            List<String> nodeGroups = ac.getRelatedNodeGroupsList();
            for (String path : nodeGroups) {
                if (!this.m_filter.matcher(path).matches()) continue;
                this.m_virtualAgents.addAll(AbstractAgentCard.getAllHostnames(ac));
                this.m_virtualAgents.addAll(AbstractAgentCard.getAllIPs(ac));
                continue block0;
            }
        }
    }

    private String getPatternToCompile(String pattern, int mode) throws ParseException {
        String patternToCompile = ".*";
        switch (mode) {
            case 1: {
                patternToCompile = "(?:^\\Q" + pattern + "\\E" + ".*)";
                break;
            }
            case 2: {
                patternToCompile = "(?:.*\\Q" + pattern + "\\E$)";
                break;
            }
            case 3: {
                patternToCompile = "(?:.*\\Q" + pattern + "\\E" + ".*)";
                break;
            }
            case 4: {
                patternToCompile = "(?:\\Q" + pattern + "\\E)";
                break;
            }
            case 5: 
            case 6: {
                if (this.m_column.equals("Time") || this.m_column.equals("SrvTime") || this.m_column.equals(COL_TIME_PLUSDUPLICATE)) {
                    Date date = BMUI.m_sdf_milliSec.parse(pattern);
                    this.m_doubleVal = date.getTime();
                    break;
                }
                this.m_doubleVal = Double.parseDouble(pattern);
                break;
            }
        }
        return patternToCompile;
    }

    private String getPatternToCompileCAValue(String pattern, int mode) throws ParseException {
        String patternToCompile = ".*";
        switch (mode) {
            case 1: {
                patternToCompile = "(?:[^=]*=\\Q" + pattern + "\\E" + ".*)";
                break;
            }
            case 2: {
                patternToCompile = "(?:[^=\r\n]*=.*\\Q" + pattern + "\\E$)";
                break;
            }
            case 3: {
                patternToCompile = "(?:[^=]*=\\Q" + pattern + "\\E" + ".*)";
                break;
            }
            case 4: {
                patternToCompile = "(?:[^=]*=\\Q" + pattern + "\\E$)";
                break;
            }
        }
        return patternToCompile;
    }

    private String getPatternToCompileNodeGroup(String pattern, int mode) throws ParseException {
        String patternToCompile = ".*";
        switch (mode) {
            case 1: {
                if (pattern.endsWith("/")) {
                    pattern = pattern.substring(0, pattern.length() - 1);
                    patternToCompile = "^(?:\\Q" + pattern + "\\E" + ")(|/.*)";
                    break;
                }
                patternToCompile = "^(?:\\Q" + pattern + "\\E" + ").*";
                break;
            }
            case 2: {
                patternToCompile = ".*(?:\\Q" + pattern + "\\E/?)$";
                break;
            }
            case 3: {
                patternToCompile = ".*(?:\\Q" + pattern + "\\E).*";
                break;
            }
            case 4: {
                patternToCompile = "(?:\\Q" + pattern + "\\E/?)(|/)";
                break;
            }
        }
        return patternToCompile;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!this.m_isActive) {
            return true;
        }
        if (element instanceof SEvent) {
            SEvent e = (SEvent)element;
            if (this.m_columnInt == -1) {
                if (this.m_isNOT) {
                    return e.getTypeA() < this.m_Availability || e.getTypeK() < this.m_KPIs;
                }
                return e.getTypeA() >= this.m_Availability && e.getTypeK() >= this.m_KPIs;
            }
            switch (this.m_columnInt) {
                case 100: 
                case 101: {
                    return this.checkCANameOrValue(e);
                }
                case 102: 
                case 103: {
                    AgentCard ac;
                    SEventFwd sef;
                    String agentID;
                    if (this.m_virtualAgents.contains(e.getNode())) {
                        return true;
                    }
                    if (e instanceof SEventFwd && (agentID = (sef = (SEventFwd)e).getT1()) != null && (ac = Repository.getInstance().getAgentCard(agentID)) != null) {
                        boolean doesMatch = false;
                        List<String> nodeGroups = ac.getRelatedNodeGroupsList();
                        for (String path : nodeGroups) {
                            doesMatch = this.m_filter.matcher(path).matches();
                            if (doesMatch) break;
                        }
                        return this.m_isNOT ? !doesMatch : doesMatch;
                    }
                    return false;
                }
                case 31: {
                    if (e instanceof SEventFwd) {
                        SEventFwd sef = (SEventFwd)e;
                        String owned = sef.getT5();
                        if (owned == null) {
                            owned = "";
                        }
                        String userUIn = String.valueOf(Repository.m_user) + '\n';
                        if (OWNED_ME.equalsIgnoreCase(this.m_pattern)) {
                            return owned.startsWith(userUIn);
                        }
                        if (OWNED_ME_NOBODY.equalsIgnoreCase(this.m_pattern)) {
                            return owned.length() == 0 || owned.startsWith(userUIn);
                        }
                        if (OWNED_NOBODY.equalsIgnoreCase(this.m_pattern)) {
                            return owned.length() == 0;
                        }
                        if (OWNED_OTHER.equalsIgnoreCase(this.m_pattern)) {
                            return owned.length() != 0 && !owned.startsWith(userUIn);
                        }
                        if (this.m_pattern != null) {
                            return owned.length() != 0 && owned.toLowerCase().startsWith(String.valueOf(this.m_pattern.toLowerCase()) + '\n');
                        }
                    }
                    return false;
                }
            }
            return this.checkAttribute(e);
        }
        return true;
    }

    private boolean checkAttribute(SEvent e) {
        if (this.m_mode >= 5) {
            if (this.m_column.equals(COL_TIME_PLUSDUPLICATE)) {
                try {
                    double d1 = e.getFirstTime();
                    double d2 = e.getTime();
                    double d3 = -1.0;
                    if (e instanceof SEventFwd) {
                        d3 = ((SEventFwd)e).getTFA();
                    }
                    boolean isMatch = true;
                    if (this.m_mode == 5) {
                        boolean bl = isMatch = d1 > this.m_doubleVal || d2 > this.m_doubleVal;
                        if (d3 > 0.0) {
                            isMatch = isMatch || d3 > this.m_doubleVal;
                        }
                    } else if (this.m_mode == 6) {
                        boolean bl = isMatch = d1 < this.m_doubleVal || d2 < this.m_doubleVal;
                        if (d3 > 0.0) {
                            boolean bl2 = isMatch = isMatch || d3 < this.m_doubleVal;
                        }
                    }
                    if (this.m_isNOT) {
                        return !isMatch;
                    }
                    return isMatch;
                }
                catch (Throwable throwable) {
                    return true;
                }
            }
            try {
                double d = 0.0;
                if (this.m_column.equals("Time")) {
                    d = e.getTime();
                } else if (this.m_column.equals("SrvTime")) {
                    d = e.getSTime();
                } else {
                    String text = EventStorageUtils.getText(e, this.m_columnInt);
                    d = Double.parseDouble(text);
                }
                boolean isMatch = true;
                if (this.m_mode == 5) {
                    isMatch = d > this.m_doubleVal;
                } else if (this.m_mode == 6) {
                    boolean bl = isMatch = d < this.m_doubleVal;
                }
                if (this.m_isNOT) {
                    return !isMatch;
                }
                return isMatch;
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
        }
        String text = EventStorageUtils.getText(e, this.m_columnInt);
        Matcher m = this.m_filter.matcher(text);
        if (this.m_isNOT) {
            return !m.matches() && e.getTypeA() >= this.m_Availability && e.getTypeK() >= this.m_KPIs;
        }
        return m.matches() && e.getTypeA() >= this.m_Availability && e.getTypeK() >= this.m_KPIs;
    }

    private boolean checkCANameOrValue(SEvent e) {
        if (e instanceof SEventFwd) {
            SEventFwd sef = (SEventFwd)e;
            if (this.m_columnInt == 100) {
                boolean res = false;
                for (String key : sef.m_CustomAttributes.keySet()) {
                    String spl;
                    Matcher m;
                    String name;
                    int EQ;
                    if (!key.startsWith("CA") || (EQ = (name = sef.m_CustomAttributes.get(key)).indexOf(61)) == -1 || !(m = this.m_filter.matcher(spl = name.substring(0, EQ))).matches()) continue;
                    res = true;
                    break;
                }
                if (this.m_isNOT) {
                    boolean bl = res = !res;
                }
                return res && e.getTypeA() >= this.m_Availability && e.getTypeK() >= this.m_KPIs;
            }
            boolean res = false;
            for (Map.Entry<String, String> en : sef.m_CustomAttributes.entrySet()) {
                Matcher m;
                if (!en.getKey().startsWith("CA") || !(m = this.m_filter.matcher(en.getValue())).matches()) continue;
                res = true;
                break;
            }
            if (this.m_isNOT) {
                boolean bl = res = !res;
            }
            return res && e.getTypeA() >= this.m_Availability && e.getTypeK() >= this.m_KPIs;
        }
        return !this.m_isNOT;
    }

    public void setLabel(String label) {
        this.m_label = label;
        if (label == null) {
            this.m_label = "";
        }
    }

    public String getLabel() {
        if (this.m_label == null) {
            this.m_label = "";
        }
        return this.m_label;
    }

    public String getLabelOrName() {
        if (this.m_label != null && this.m_label.length() > 0) {
            return this.m_label;
        }
        return this.toString2();
    }

    private String toString2() {
        if (this.m_column == null || this.m_column.length() == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        String colLabel = Repository.getInstance().getBrowserLabelManager().getLabel(this.m_column);
        res.append(colLabel);
        if (this.m_isNOT) {
            res.append(" NOT");
        }
        switch (this.m_mode) {
            case 1: {
                res.append(" STARTS WITH ");
                break;
            }
            case 2: {
                res.append(" ENDS WITH ");
                break;
            }
            case 3: {
                res.append(" CONTAINS ");
                break;
            }
            case 4: {
                res.append(" == ");
                break;
            }
            case 5: {
                res.append(" > ");
                break;
            }
            case 6: {
                res.append(" < ");
                break;
            }
        }
        res.append(this.m_pattern);
        if (this.m_Availability > 0) {
            res.append(" +Availabilty");
        }
        if (this.m_KPIs > 0) {
            res.append(" +KPI");
        }
        if (this.m_caseSensitive) {
            res.append(" +case sensitive");
        }
        return res.toString();
    }

    public String toString() {
        if (this.m_column == null || this.m_column.length() == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        res.append(this.m_column);
        if (this.m_isNOT) {
            res.append(" NOT");
        }
        switch (this.m_mode) {
            case 1: {
                res.append(" STARTS WITH ");
                break;
            }
            case 2: {
                res.append(" ENDS WITH ");
                break;
            }
            case 3: {
                res.append(" CONTAINS ");
                break;
            }
            case 4: {
                res.append(" == ");
                break;
            }
            case 5: {
                res.append(" > ");
                break;
            }
            case 6: {
                res.append(" < ");
                break;
            }
        }
        res.append(this.m_pattern);
        if (this.m_Availability > 0) {
            res.append(" +Availabilty");
        }
        if (this.m_KPIs > 0) {
            res.append(" +KPI");
        }
        if (this.m_caseSensitive) {
            res.append(" +case sensitive");
        }
        return res.toString();
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        this.cleanCounters();
        if (!this.m_isActive) {
            return elements;
        }
        if (this.m_columnInt == 102 || this.m_columnInt == 103) {
            this.collectRelatedExternalHosts();
        }
        int size = elements.length;
        ArrayList<Object> out = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            Object element = elements[i];
            if (this.select(viewer, parent, element)) {
                out.add(element);
            } else {
                this.countInvisible(element);
            }
            ++i;
        }
        this.m_filtered = elements.length - out.size();
        return out.toArray();
    }

    private void countInvisible(Object element) {
        int sev = ((SEvent)element).getSeverityInt();
        if (sev < 0) {
            sev += 6;
        }
        switch (sev) {
            case 0: {
                ++this.m_inactiveUnknown;
                break;
            }
            case 1: {
                ++this.m_inactiveNormal;
                break;
            }
            case 2: {
                ++this.m_inactiveWarning;
                break;
            }
            case 3: {
                ++this.m_inactiveMinor;
                break;
            }
            case 4: {
                ++this.m_inactiveMajor;
                break;
            }
            case 5: {
                ++this.m_inactiveCritical;
                break;
            }
        }
    }

    private void cleanCounters() {
        this.m_inactiveUnknown = 0;
        this.m_inactiveNormal = 0;
        this.m_inactiveWarning = 0;
        this.m_inactiveMinor = 0;
        this.m_inactiveMajor = 0;
        this.m_inactiveCritical = 0;
        this.m_filtered = 0;
    }

    public Object[] filter(Viewer viewer, TreePath parentPath, Object[] elements) {
        Object[] arr = this.filter(viewer, parentPath.getLastSegment(), elements);
        return arr;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventFilter) {
            return this.toString().equals("" + obj);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static String getSQLWhere(String colName, int mode, String value) {
        StringBuffer sb = new StringBuffer();
        String dbname = m_dbnames.get(colName);
        if (dbname == null) {
            return "";
        }
        switch (mode) {
            case 1: {
                sb.append(dbname).append(" LIKE '").append(value).append("%'");
                break;
            }
            case 2: {
                sb.append(dbname).append(" LIKE '%").append(value).append("'");
                break;
            }
            case 3: {
                sb.append(dbname).append(" LIKE '%").append(value).append("%'");
                break;
            }
            case 4: {
                sb.append(dbname).append(" = '").append(value).append("'");
                break;
            }
        }
        return sb.toString();
    }
}

