/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.EventFilter;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.EventsAndStatus;
import com.blixx.shared.ext.IServiceStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class EventFilterGroup
extends EventsAndStatus
implements IServiceStatus {
    private String m_name = null;
    private ArrayList<EventFilter> m_filters = new ArrayList();
    private int maxAV = 0;
    private int maxKPI = 0;
    private int maxOther = 0;
    private List<String> m_impactedAgents = new LinkedList<String>();

    public EventFilterGroup(String name) {
        this.m_name = name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public List<EventFilter> getFilters() {
        return this.m_filters;
    }

    @Override
    public void clear() {
        this.m_filters.clear();
    }

    public void addFilter(EventFilter filter) {
        if (filter != null) {
            int i = 0;
            while (i < this.m_filters.size()) {
                if (this.m_filters.get(i).equals((Object)filter)) {
                    return;
                }
                ++i;
            }
            this.m_filters.add(filter);
        }
    }

    public void addFilters(List<EventFilter> filterList) {
        if (filterList != null && filterList.size() > 0) {
            if (filterList.size() > 1) {
                this.m_filters.ensureCapacity(this.m_filters.size() + filterList.size());
            }
            int i = 0;
            while (i < filterList.size()) {
                this.addFilter(filterList.get(i));
                ++i;
            }
        }
    }

    public void setFilter(EventFilter filter, int position) {
        if (filter != null) {
            this.m_filters.set(position, filter);
        }
    }

    public void removeFilter(int position) {
        this.m_filters.remove(position);
    }

    public void removeFilter(EventFilter filter) {
        if (filter != null) {
            Iterator<EventFilter> it = this.m_filters.iterator();
            while (it.hasNext()) {
                EventFilter ef = it.next();
                if (!ef.toString().equals(filter.toString())) continue;
                it.remove();
                break;
            }
        }
    }

    public boolean isMatched(SEvent event) {
        if (this.m_filters.size() == 0) {
            return false;
        }
        boolean isMatched = true;
        int j = 0;
        while (j < this.m_filters.size()) {
            boolean bl = isMatched = isMatched && this.m_filters.get(j).select(null, null, event);
            if (!isMatched) break;
            ++j;
        }
        if (isMatched) {
            String sef;
            if (event.getState() == '-') {
                if (event.getTypeA() > 0) {
                    this.maxAV = Math.max(this.maxAV, event.getSeverityInt());
                } else if (event.getTypeK() > 0) {
                    this.maxKPI = Math.max(this.maxKPI, event.getSeverityInt());
                } else {
                    this.maxOther = Math.max(this.maxOther, event.getSeverityInt());
                }
            }
            if (event instanceof SEventFwd && (sef = ((SEventFwd)event).getT1()) != null && !this.m_impactedAgents.contains(sef)) {
                this.m_impactedAgents.add(sef);
            }
        }
        return isMatched;
    }

    public boolean hasFilter(EventFilter filter) {
        for (EventFilter ef : this.m_filters) {
            if (!ef.toString().equals(filter.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getStatusAV() {
        return this.maxAV;
    }

    @Override
    public int getStatusKPI() {
        return this.maxKPI;
    }

    @Override
    public int getStatusOther() {
        return this.maxOther;
    }

    public void cleanMaxis() {
        this.maxAV = 0;
        this.maxKPI = 0;
        this.maxOther = 0;
    }

    public List<String> getImpactedAgents() {
        return this.m_impactedAgents;
    }

    @Override
    public EventsAndStatus getEvents() {
        return this;
    }

    @Override
    public void invalidateStatus() {
    }

    public boolean containsOneOf(Collection col) {
        for (SEvent se : col) {
            if (!this.isMatched(se)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventFilterGroup) {
            EventFilterGroup second = (EventFilterGroup)obj;
            if (this.getName().equals(second.getName()) && this.m_filters.size() == second.m_filters.size()) {
                return this.m_filters.containsAll(second.m_filters);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.m_name == null) {
            return 0;
        }
        return this.m_name.hashCode();
    }
}

