/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.shared.SEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class EventSorter
extends ViewerSorter
implements IElementComparer,
Comparator,
Serializable {
    private static final long serialVersionUID = 1803279124795645833L;
    private String column = null;
    private int columnNumber = -1;
    private int dir = 1024;
    public static final String SORT_ALL_TIMES = "ALLT";
    public static final int SORT_ALL_TIMES_INT = 99999;

    public EventSorter(String column, int dir) {
        this.setConfig(column, dir);
    }

    public void setConfig(String column, int direction) {
        this.column = column;
        this.dir = direction;
        this.columnNumber = SORT_ALL_TIMES.equalsIgnoreCase(column) ? 99999 : EventStorageUtils.getColumnPosition(column);
    }

    public String getCurrentSorting() {
        String direction = "up";
        if (this.dir == 1024) {
            direction = "down";
        }
        return String.valueOf(this.column) + "|" + direction;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.compare(e1, e2);
    }

    public int compare(Object e1, Object e2) {
        if (!(e1 instanceof SEvent) || !(e2 instanceof SEvent)) {
            return 0;
        }
        SEvent e1event = (SEvent)e1;
        SEvent e2event = (SEvent)e2;
        int returnValue = this._compare(e1event, e2event);
        if (this.dir == 1024) {
            returnValue *= -1;
        }
        return returnValue;
    }

    private int _compare(SEvent e1event, SEvent e2event) {
        int returnValue = 0;
        if (this.columnNumber < 0) {
            return this._oldCompare(e1event, e2event);
        }
        switch (this.columnNumber) {
            case 0: {
                int s1 = e1event.getSeverityInt();
                int s2 = e2event.getSeverityInt();
                if (s1 < 0) {
                    s1 += 6;
                }
                if (s2 < 0) {
                    s2 += 6;
                }
                if ((returnValue = s1 - s2) == 0) {
                    long diffL = e1event.getTime() - e2event.getTime();
                    if (diffL > 0L) {
                        returnValue = 1;
                        break;
                    }
                    if (diffL < 0L) {
                        returnValue = -1;
                        break;
                    }
                    returnValue = 0;
                    break;
                }
                if (returnValue < 0) {
                    returnValue = -1;
                    break;
                }
                returnValue = 1;
                break;
            }
            case 1: {
                returnValue = e1event.getDuplicates() - e2event.getDuplicates();
                break;
            }
            case 2: {
                long diff = e1event.getTime() - e2event.getTime();
                if (diff > 0L) {
                    returnValue = 1;
                    break;
                }
                if (diff < 0L) {
                    returnValue = -1;
                    break;
                }
                returnValue = 0;
                break;
            }
            case 10: {
                returnValue = e1event.getTypeA() - e2event.getTypeA();
                break;
            }
            case 11: {
                returnValue = e1event.getTypeK() - e2event.getTypeK();
                break;
            }
            case 14: 
            case 99999: {
                long diffS = e1event.getSTime() - e2event.getSTime();
                if (diffS > 0L) {
                    returnValue = 1;
                    break;
                }
                if (diffS < 0L) {
                    returnValue = -1;
                    break;
                }
                diffS = e1event.getTime() - e2event.getTime();
                if (diffS > 0L) {
                    returnValue = 1;
                    break;
                }
                if (diffS < 0L) {
                    returnValue = -1;
                    break;
                }
                returnValue = 0;
                break;
            }
            default: {
                String e1Str = EventStorageUtils.getLabel(e1event, this.columnNumber);
                String e2Str = EventStorageUtils.getLabel(e2event, this.columnNumber);
                returnValue = e1Str.compareTo(e2Str);
                if (returnValue != 0) break;
                long diffL = e1event.getTime() - e2event.getTime();
                returnValue = diffL > 0L ? 1 : (diffL < 0L ? -1 : 0);
                if (this.dir != 1024) break;
                returnValue *= -1;
            }
        }
        return returnValue;
    }

    private int _oldCompare(SEvent e1event, SEvent e2event) {
        int returnValue = 0;
        long normal = 1L;
        if (this.dir == 1024) {
            normal = Long.MAX_VALUE;
        }
        if (this.column.equals("Application")) {
            String e1Str = String.valueOf(e1event.getApplication()) + (normal - e1event.getTime());
            String e2Str = String.valueOf(e2event.getApplication()) + (normal - e2event.getTime());
            returnValue = e1Str.compareTo(e2Str);
        } else if (this.column.equals("Group")) {
            String e1Str = String.valueOf(e1event.getGroup()) + (normal - e1event.getTime());
            String e2Str = String.valueOf(e2event.getGroup()) + (normal - e2event.getTime());
            returnValue = e1Str.compareTo(e2Str);
        } else if (this.column.equals("Host")) {
            String e1Str = String.valueOf(e1event.getNode()) + (normal - e1event.getTime());
            String e2Str = String.valueOf(e2event.getNode()) + (normal - e2event.getTime());
            returnValue = e1Str.compareTo(e2Str);
        } else if (this.column.equals("Object")) {
            String e1Str = String.valueOf(e1event.getObject()) + (normal - e1event.getTime());
            String e2Str = String.valueOf(e2event.getObject()) + (normal - e2event.getTime());
            returnValue = e1Str.compareTo(e2Str);
        } else if (this.column.equals("Severity")) {
            int s1 = e1event.getSeverityInt();
            int s2 = e2event.getSeverityInt();
            if (s1 < 0) {
                s1 += 6;
            }
            if (s2 < 0) {
                s2 += 6;
            }
            String e1Str = "" + s1 + e1event.getTime();
            String e2Str = "" + s2 + e2event.getTime();
            returnValue = e1Str.compareTo(e2Str);
        } else if (this.column.equals("Time")) {
            long diff = e1event.getTime() - e2event.getTime();
            returnValue = diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        } else if (this.column.equals("SrvTime")) {
            long diff = e1event.getSTime() - e2event.getSTime();
            returnValue = diff > 0L ? 1 : (diff < 0L ? -1 : ((diff = e1event.getTime() - e2event.getTime()) > 0L ? 1 : (diff < 0L ? -1 : 0)));
        } else if (this.column.equals("Text")) {
            String e1Str = String.valueOf(e1event.getText()) + (normal - e1event.getTime());
            String e2Str = String.valueOf(e2event.getText()) + (normal - e2event.getTime());
            returnValue = e1Str.compareTo(e2Str);
        } else if (this.column.equals("Duplicates")) {
            returnValue = e1event.getDuplicates() - e2event.getDuplicates();
        } else if (this.column.equals("!AV")) {
            returnValue = e1event.getTypeA() - e2event.getTypeA();
        } else if (this.column.equals("^KPI")) {
            returnValue = e1event.getTypeK() - e2event.getTypeK();
        } else if (this.column.equals("Agent")) {
            String e1Str = String.valueOf(e1event.getAgentNode()) + (normal - e1event.getTime());
            String e2Str = String.valueOf(e2event.getAgentNode()) + (normal - e2event.getTime());
            returnValue = e1Str.compareTo(e2Str);
        } else if (this.column.equals("Source")) {
            String e1Str = String.valueOf(e1event.getSource()) + (normal - e1event.getTime());
            String e2Str = String.valueOf(e2event.getSource()) + (normal - e2event.getTime());
            returnValue = e1Str.compareTo(e2Str);
        } else if (this.column.equals("ID")) {
            String e1Str = e1event.getID();
            String e2Str = e2event.getID();
            returnValue = e1Str.compareTo(e2Str);
        } else if (this.column.equals(SORT_ALL_TIMES)) {
            long diff2;
            long diff = e1event.getSTime() - e2event.getSTime();
            returnValue = diff > 0L ? 1 : (diff < 0L ? -1 : ((diff2 = e1event.getTime() - e2event.getTime()) > 0L ? 1 : (diff2 < 0L ? -1 : 0)));
        }
        return returnValue;
    }

    public void sort(Viewer viewer, Object[] elements) {
        Arrays.sort(elements, this);
    }

    public boolean equals(Object a, Object b) {
        if (a instanceof SEvent && b instanceof SEvent) {
            return a == null ? b == null : ((SEvent)a).getID().equals(((SEvent)b).getID());
        }
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode(Object element) {
        if (element instanceof SEvent) {
            return ((SEvent)element).getID().hashCode();
        }
        return element.hashCode();
    }
}

