/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ISEventUpdateListener;
import com.blixx.ctrl.sc.IRunnableExt;
import com.blixx.log.RTLogger;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.utils.HashMapMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class EventStatusRefreshJob
implements IRunnableExt,
ISEventUpdateListener {
    boolean isFinished = false;
    Collection<AgentCard> m_agentsToRefresh = null;
    Collection<SEvent> m_closedEventsCache = new ConcurrentSkipListSet<SEvent>();

    public EventStatusRefreshJob(Collection<AgentCard> agentsToRefresh) {
        this.m_agentsToRefresh = agentsToRefresh;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        try {
            try {
                Repository.getEventProvider().registerSEventUpdateLitener(this);
                HashMapMap<String, AgentCard> acMapByIDorName = new HashMapMap<String, AgentCard>();
                for (AgentCard ac : this.m_agentsToRefresh) {
                    if (!ac.isExternal()) {
                        acMapByIDorName.putV(ac.getID(), ac);
                        continue;
                    }
                    Set<String> hostnames = AgentCard.getAllHostnames(ac);
                    for (String string : hostnames) {
                        acMapByIDorName.putV(string, ac);
                    }
                }
                Map<String, SEvent> allActive = Repository.getEventProvider().getActiveMap();
                for (Map.Entry<String, SEvent> entry : allActive.entrySet()) {
                    SEventFwd sEventFwd = (SEventFwd)entry.getValue();
                    this.processSEvent(acMapByIDorName, sEventFwd, 1);
                }
                for (SEvent sEvent : this.m_closedEventsCache) {
                    this.processSEvent(acMapByIDorName, (SEventFwd)sEvent, -1);
                }
            }
            catch (Throwable e) {
                RTLogger.print(5, "", e);
                this.isFinished = true;
                long delta = System.currentTimeMillis() - start;
                RTLogger.print(4, "EventStatusRefreshJob job time(sec): " + delta / 1000L);
            }
        }
        finally {
            this.isFinished = true;
            long delta = System.currentTimeMillis() - start;
            RTLogger.print(4, "EventStatusRefreshJob job time(sec): " + delta / 1000L);
        }
    }

    private void processSEvent(HashMapMap<String, AgentCard> acMapByIDorName, SEventFwd se, int addOrdel) {
        Map<AgentCard, Object> extAC;
        Map<AgentCard, Object> realAC = acMapByIDorName.getHashMap(se.getT1());
        if (realAC != null) {
            for (AgentCard acr : realAC.keySet()) {
                acr.applyEvent(se, addOrdel);
            }
        }
        if ((extAC = acMapByIDorName.getHashMap(se.getT1())) != null) {
            for (AgentCard acv : extAC.keySet()) {
                acv.applyEvent(se, addOrdel);
            }
        }
    }

    @Override
    public void cleanAll() {
    }

    @Override
    public void update(Set<SEvent> set) {
        for (SEvent se : set) {
            this.update(se);
        }
    }

    @Override
    public void update(SEvent se) {
        if (!se.isActive()) {
            this.m_closedEventsCache.add(se);
        }
    }

    @Override
    public void start() {
        Thread tr = new Thread(this);
        tr.setName("EventStatusRefreshJob");
        tr.start();
    }
}

