/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventStatus;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.IEventProvider;
import com.blixx.boom.engine.IEventStorageSubmit;
import com.blixx.boom.engine.IEventsSummary;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.ApplicationActionBarAdvisor;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.gui.dialogs.ISEventUpdateListener;
import com.blixx.boom.gui.views.CleaningModeView;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.log.RTLogger;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.utils.HashMapArray;
import com.blixx.shared.utils.TreeMapSortedSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWTException;

public class EventStorage
implements IEventProvider,
IEventStorageSubmit,
IEventsSummary {
    protected Map<String, SEvent> m_active = new ConcurrentHashMap<String, SEvent>(2000, 0.85f, 2);
    protected Map<String, SEvent> m_eventsToAdd = new ConcurrentHashMap<String, SEvent>(2000, 0.85f, 2);
    protected Map<String, Character> m_eventsToClose = new ConcurrentHashMap<String, Character>(2000, 0.85f, 2);
    protected Map<String, SEvent> m_acknowledged = new ConcurrentHashMap<String, SEvent>(20000, 0.95f, 2);
    protected Map<String, Integer> m_eventsToArchive = new ConcurrentHashMap<String, Integer>(2000, 0.85f, 2);
    protected HashMapArray<String, Integer> m_hosts = new HashMapArray();
    protected HashMapArray<String, Integer> m_applications = new HashMapArray();
    protected HashMapArray<String, Integer> m_msggrps = new HashMapArray();
    protected HashMapArray<String, Integer> m_objects = new HashMapArray();
    protected HashMapArray<String, Integer> m_GRP_and_APP = new HashMapArray();
    protected HashMapArray<String, Integer> m_App_and_Host = new HashMapArray();
    protected HashMapArray<String, Integer> m_GRP_and_Host = new HashMapArray();
    protected TreeMapSortedSet m_TYPE_A = new TreeMapSortedSet();
    protected TreeMapSortedSet m_TYPE_K = new TreeMapSortedSet();
    protected AtomicInteger m_unknown = new AtomicInteger(0);
    protected AtomicInteger m_normal = new AtomicInteger(0);
    protected AtomicInteger m_warning = new AtomicInteger(0);
    protected AtomicInteger m_minor = new AtomicInteger(0);
    protected AtomicInteger m_major = new AtomicInteger(0);
    protected AtomicInteger m_critical = new AtomicInteger(0);
    protected AtomicInteger m_Aunknown = new AtomicInteger(0);
    protected AtomicInteger m_Anormal = new AtomicInteger(0);
    protected AtomicInteger m_Awarning = new AtomicInteger(0);
    protected AtomicInteger m_Aminor = new AtomicInteger(0);
    protected AtomicInteger m_Amajor = new AtomicInteger(0);
    protected AtomicInteger m_Acritical = new AtomicInteger(0);
    protected Set<TableViewer> m_hostListener = Collections.newSetFromMap(new ConcurrentHashMap());
    protected Set<IRefreshable> m_refreshable = Collections.newSetFromMap(new ConcurrentHashMap());
    protected Set<IRefreshable> m_refreshableAll = Collections.newSetFromMap(new ConcurrentHashMap());
    protected Set<ISEventUpdateListener> m_updateSEventListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<TableViewer> m_tableViewers = Collections.newSetFromMap(new ConcurrentHashMap());
    protected boolean m_TYPES_UPDATED = false;
    protected boolean m_isShowActive = true;
    protected static EventStorage m_instance = null;

    protected EventStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventStorage getInstance() {
        if (m_instance != null) return m_instance;
        Class<EventStorage> clazz = EventStorage.class;
        synchronized (EventStorage.class) {
            if (m_instance != null) return m_instance;
            m_instance = new EventStorage();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instance;
        }
    }

    @Override
    public void registerRefreshable(IRefreshable rcomp, boolean TypeXonly) {
        if (TypeXonly && !this.m_refreshable.contains(rcomp)) {
            this.m_refreshable.add(rcomp);
        } else if (!TypeXonly && !this.m_refreshableAll.contains(rcomp)) {
            this.m_refreshableAll.add(rcomp);
        }
    }

    @Override
    public void unregisterRefreshable(IRefreshable rcomp, boolean TypeXonly) {
        if (TypeXonly && this.m_refreshable.contains(rcomp)) {
            try {
                this.m_refreshable.remove(rcomp);
            }
            catch (Throwable throwable) {}
        } else if (!TypeXonly && !this.m_refreshableAll.contains(rcomp)) {
            try {
                this.m_refreshableAll.remove(rcomp);
            }
            catch (Throwable throwable) {}
        }
    }

    protected void refreshRefreshable() {
        Iterator<IRefreshable> it0 = this.m_refreshableAll.iterator();
        while (it0.hasNext()) {
            IRefreshable r = it0.next();
            if (r != null) {
                try {
                    r.refresh();
                }
                catch (SWTException swte) {
                    if (swte.code != 39) continue;
                    it0.remove();
                }
                catch (Throwable throwable) {}
                continue;
            }
            it0.remove();
        }
        if (!this.m_TYPES_UPDATED) {
            return;
        }
        Iterator<IRefreshable> it = this.m_refreshable.iterator();
        while (it.hasNext()) {
            IRefreshable r = it.next();
            if (r != null) {
                try {
                    r.refresh();
                }
                catch (SWTException swte) {
                    if (swte.code != 39) continue;
                    it.remove();
                }
                catch (Throwable throwable) {}
                continue;
            }
            it.remove();
        }
        this.m_TYPES_UPDATED = false;
    }

    @Override
    public void registerSEventUpdateLitener(ISEventUpdateListener listener) {
        this.m_updateSEventListeners.add(listener);
    }

    @Override
    public void unregisterSEventUpdateLitener(ISEventUpdateListener listener) {
        this.m_updateSEventListeners.remove(listener);
    }

    public void notifySEventUpdate(SEvent se) {
        Iterator<ISEventUpdateListener> it = this.m_updateSEventListeners.iterator();
        while (it.hasNext()) {
            ISEventUpdateListener listener = it.next();
            try {
                listener.update(se);
            }
            catch (Throwable throwable) {
                it.remove();
            }
        }
    }

    public void notifySEventUpdate(Set<SEvent> list) {
        Iterator<ISEventUpdateListener> it = this.m_updateSEventListeners.iterator();
        while (it.hasNext()) {
            ISEventUpdateListener listener = it.next();
            try {
                listener.update(list);
            }
            catch (Throwable throwable) {
                it.remove();
            }
        }
    }

    @Override
    public void addTableToRefresh(TableViewer tv) {
        if (!this.m_tableViewers.contains(tv)) {
            this.m_tableViewers.add(tv);
        }
    }

    @Override
    public void removeTableFromRefresh(TableViewer tv) {
        if (tv != null) {
            this.m_tableViewers.remove(tv);
        }
    }

    @Override
    public void addEvent(SEvent e) {
        if (BMUI.m_ignoreAllIndications) {
            return;
        }
        this.addEventForced(e);
    }

    @Override
    public void addEventForced(SEvent e) {
        e.setAgentNode(EventStorageUtils.getCanonicalVersion(e.getAgentNode()));
        e.setNode(EventStorageUtils.getCanonicalVersion(e.getNode()));
        this.m_eventsToAdd.put(e.getID(), e);
        this.notifySEventUpdate(e);
    }

    protected void applyHostCounters(SEvent e, int pos, int inc) {
        String nodeViaAgent = String.valueOf(e.getNode()) + '\u25ba' + e.getAgentNode();
        if (!this.m_hosts.containsKey(nodeViaAgent = nodeViaAgent.intern())) {
            ArrayList<Integer> sevs = new ArrayList<Integer>(EventStorageUtils.sevEmpty);
            sevs.set(pos, inc);
            this.m_hosts.put(nodeViaAgent, sevs);
        } else {
            List<Integer> currSevArr = this.m_hosts.getArray(nodeViaAgent);
            Integer currVal = currSevArr.get(pos);
            currSevArr.set(pos, currVal + inc);
        }
    }

    public void applyApplicationsCounters(SEvent e, int pos, int inc) {
        String apps = e.getApplication();
        if (apps == null) {
            return;
        }
        if (!this.m_applications.containsKey(apps)) {
            ArrayList<Integer> sevs = new ArrayList<Integer>(EventStorageUtils.sevEmpty);
            sevs.set(pos, inc);
            this.m_applications.put(apps, sevs);
        } else {
            List<Integer> currSevArr = this.m_applications.getArray(apps);
            Integer currVal = currSevArr.get(pos);
            currSevArr.set(pos, currVal + inc);
        }
    }

    public void apply_GRPandAPP_Counters(SEvent e, int pos, int inc) {
        String app = e.getApplication();
        String grp = e.getGroup();
        String key = new StringBuffer().append(grp).append('\u25ba').append(app).toString();
        if (!this.m_GRP_and_APP.containsKey(key)) {
            ArrayList<Integer> sevs = new ArrayList<Integer>(EventStorageUtils.sevEmpty);
            sevs.set(pos, inc);
            this.m_GRP_and_APP.put(key, sevs);
        } else {
            List<Integer> currSevArr = this.m_GRP_and_APP.getArray(key);
            Integer currVal = currSevArr.get(pos);
            currSevArr.set(pos, currVal + inc);
        }
    }

    protected void apply_AppAndHost_Counters(SEvent e, int pos, int inc) {
        String node = e.getNode();
        String app = e.getApplication();
        String key = new StringBuffer().append(app).append('\u25ba').append(node).toString();
        if (!this.m_App_and_Host.containsKey(key)) {
            ArrayList<Integer> sevs = new ArrayList<Integer>(EventStorageUtils.sevEmpty);
            sevs.set(pos, inc);
            this.m_App_and_Host.put(key, sevs);
        } else {
            List<Integer> currSevArr = this.m_App_and_Host.getArray(key);
            Integer currVal = currSevArr.get(pos);
            currSevArr.set(pos, currVal + inc);
        }
    }

    protected void apply_GrpAndHost_Counters(SEvent e, int pos, int inc) {
        String node = e.getNode();
        String grp = e.getGroup();
        String key = new StringBuffer().append(grp).append('\u25ba').append(node).toString();
        if (!this.m_GRP_and_Host.containsKey(key)) {
            ArrayList<Integer> sevs = new ArrayList<Integer>(EventStorageUtils.sevEmpty);
            sevs.set(pos, inc);
            this.m_GRP_and_Host.put(key, sevs);
        } else {
            List<Integer> currSevArr = this.m_GRP_and_Host.getArray(key);
            Integer currVal = currSevArr.get(pos);
            currSevArr.set(pos, currVal + inc);
        }
    }

    protected void applyObjectsCounters(SEvent e, int pos, int inc) {
        String apps = e.getObject();
        if (apps == null || apps.length() == 0) {
            return;
        }
        if (!this.m_objects.containsKey(apps)) {
            ArrayList<Integer> sevs = new ArrayList<Integer>(EventStorageUtils.sevEmpty);
            sevs.set(pos, inc);
            this.m_objects.put(apps, sevs);
        } else {
            List<Integer> currSevArr = this.m_objects.getArray(apps);
            Integer currVal = currSevArr.get(pos);
            currSevArr.set(pos, currVal + inc);
        }
    }

    protected void applyMsgGrpsCounters(SEvent e, int pos, int inc) {
        String apps = e.getGroup();
        if (apps == null) {
            return;
        }
        if (!this.m_msggrps.containsKey(apps)) {
            ArrayList<Integer> sevs = new ArrayList<Integer>(EventStorageUtils.sevEmpty);
            sevs.set(pos, inc);
            this.m_msggrps.put(apps, sevs);
        } else {
            List<Integer> currSevArr = this.m_msggrps.getArray(apps);
            Integer currVal = currSevArr.get(pos);
            currSevArr.set(pos, currVal + inc);
        }
    }

    protected void applyTYPES(SEvent e, int inc) {
        if (e.getTypeA() == 0 && e.getTypeK() == 0) {
            return;
        }
        this.m_TYPES_UPDATED = true;
        EventStatus st = new EventStatus(e);
        try {
            if (e.getTypeA() > 0) {
                String keySTR = EventStorageUtils.getHAOKey(e);
                if (inc > 0) {
                    this.m_TYPE_A.put((Object)keySTR, st);
                } else {
                    this.m_TYPE_A.getArray(keySTR).remove(st);
                }
            }
            if (e.getTypeK() > 0) {
                String keySTR2 = EventStorageUtils.getHAOMKey(e);
                if (inc > 0) {
                    this.m_TYPE_K.put((Object)keySTR2, st);
                } else {
                    this.m_TYPE_K.getArray(keySTR2).remove(st);
                }
            }
        }
        catch (RuntimeException e1) {
            RTLogger.print(4, "", e1);
        }
    }

    protected void applyCounters(SEvent e, int inc) {
        SEventFwd sef;
        String agentID;
        int severityInt = e.getSeverityInt();
        if (severityInt < 0) {
            severityInt += 6;
        }
        switch (severityInt) {
            case 0: {
                this.m_unknown.addAndGet(inc);
                break;
            }
            case 1: {
                this.m_normal.addAndGet(inc);
                break;
            }
            case 2: {
                this.m_warning.addAndGet(inc);
                break;
            }
            case 3: {
                this.m_minor.addAndGet(inc);
                break;
            }
            case 4: {
                this.m_major.addAndGet(inc);
                break;
            }
            case 5: {
                this.m_critical.addAndGet(inc);
                break;
            }
        }
        this.applyHostCounters(e, severityInt, inc);
        this.applyApplicationsCounters(e, severityInt, inc);
        this.applyObjectsCounters(e, severityInt, inc);
        this.applyMsgGrpsCounters(e, severityInt, inc);
        this.apply_GRPandAPP_Counters(e, severityInt, inc);
        this.apply_AppAndHost_Counters(e, severityInt, inc);
        this.apply_GrpAndHost_Counters(e, severityInt, inc);
        this.applyTYPES(e, inc);
        if (e instanceof SEventFwd && (agentID = (sef = (SEventFwd)e).getT1()) != null) {
            AgentCard ac = Repository.getInstance().getAgentCard(agentID);
            if (ac != null) {
                List<AgentCard> externals;
                ac.applyEvent(sef, inc);
                if (Repository.getInstance().isExternalHost(e.getNode()) && (externals = Repository.getInstance().getExternalHosts(e.getNode())) != null && externals.size() > 0) {
                    for (AgentCard a : externals) {
                        a.applyEvent(sef, inc);
                    }
                }
            } else {
                ac = Repository.getInstance().getAgentCardByHostname(sef.getAgentNode());
                if (ac != null) {
                    ac.applyEvent(sef, inc);
                }
            }
        }
    }

    public void applyAcknCounters(SEvent e, int inc) {
        int sev = e.getSeverityInt();
        if (sev < 0) {
            sev += 6;
        }
        switch (sev) {
            case 0: {
                this.m_Aunknown.addAndGet(inc);
                break;
            }
            case 1: {
                this.m_Anormal.addAndGet(inc);
                break;
            }
            case 2: {
                this.m_Awarning.addAndGet(inc);
                break;
            }
            case 3: {
                this.m_Aminor.addAndGet(inc);
                break;
            }
            case 4: {
                this.m_Amajor.addAndGet(inc);
                break;
            }
            case 5: {
                this.m_Acritical.addAndGet(inc);
                break;
            }
        }
    }

    @Override
    public void removeID(String id, char state) {
        this.m_eventsToClose.put(id, Character.valueOf(state));
    }

    @Override
    public void removeClosedID(String id) {
        this.m_eventsToArchive.put(id, EventStorageUtils.NULL_VALUE);
    }

    @Override
    public void updateEvent(SEvent e) {
        if (this.m_eventsToAdd.containsKey(e.getID())) {
            this.m_eventsToAdd.put(e.getID(), e);
        } else {
            SEvent old = this.getEvent(e.getID());
            if (old != null) {
                if (old.getState() != e.getState()) {
                    if ('-' == e.getState()) {
                        this.removeAcknowledged(e.getID(), true);
                        this.m_eventsToAdd.put(e.getID(), e);
                    } else if ('D' == e.getState()) {
                        this.removeClosedID(e.getID());
                    } else {
                        if (this.m_active.containsKey(e.getID())) {
                            this.m_active.put(e.getID(), e);
                        }
                        this.removeID(e.getID(), e.getState());
                    }
                } else if ('-' == e.getState()) {
                    this.m_active.put(e.getID(), e);
                } else if ('D' == e.getState()) {
                    this.removeClosedID(e.getID());
                } else {
                    this.m_acknowledged.put(e.getID(), e);
                }
                this.notifySEventUpdate(e);
            } else {
                RTLogger.print(5, "Event not found: " + e.getID() + " " + e.getText());
            }
        }
    }

    @Override
    public void addAcknowledged(SEvent e) {
        if (BMUI.m_ignoreAllIndications || BMUI.m_ignoreClosedIndications) {
            return;
        }
        if (!this.m_acknowledged.containsKey(e.getID())) {
            this.applyAcknCounters(e, 1);
        }
        e.setAgentNode(EventStorageUtils.getCanonicalVersion(e.getAgentNode()));
        e.setNode(EventStorageUtils.getCanonicalVersion(e.getNode()));
        this.m_acknowledged.put(e.getID(), e);
        this.notifySEventUpdate(e);
    }

    @Override
    public void addAcknowledgedForced(SEvent e) {
        if (!this.m_acknowledged.containsKey(e.getID())) {
            this.applyAcknCounters(e, 1);
        }
        this.m_acknowledged.put(e.getID(), e);
        this.notifySEventUpdate(e);
    }

    @Override
    public void addAcknowledgedInitial(SEvent e) {
        if (BMUI.m_ignoreAllIndications || BMUI.m_ignoreClosedIndications) {
            return;
        }
        this.applyAcknCounters(e, 1);
        e.setAgentNode(EventStorageUtils.getCanonicalVersion(e.getAgentNode()));
        e.setNode(EventStorageUtils.getCanonicalVersion(e.getNode()));
        this.m_acknowledged.put(e.getID(), e);
        this.notifySEventUpdate(e);
    }

    @Override
    public SEvent removeAcknowledged(String ID, boolean notifySubscribers) {
        SEvent e = this.m_acknowledged.remove(ID);
        if (e != null) {
            e.setState('D');
            this.applyAcknCounters(e, -1);
            if (notifySubscribers) {
                this.notifySEventUpdate(e);
            }
        } else {
            e = this.m_active.remove(ID);
            if (e != null) {
                e.setState('D');
                this.applyCounters(e, -1);
                if (notifySubscribers) {
                    this.notifySEventUpdate(e);
                }
            }
        }
        return e;
    }

    @Override
    public void removeAcknowledged() {
        this.m_acknowledged.clear();
        this.m_Aunknown.set(0);
        this.m_Anormal.set(0);
        this.m_Awarning.set(0);
        this.m_Aminor.set(0);
        this.m_Amajor.set(0);
        this.m_Acritical.set(0);
    }

    @Override
    public void removeAll() {
        this.m_eventsToAdd.clear();
        this.m_eventsToClose.clear();
        this.m_eventsToArchive.clear();
        this.removeActive();
        this.removeAcknowledged();
        Iterator<ISEventUpdateListener> it = this.m_updateSEventListeners.iterator();
        while (it.hasNext()) {
            ISEventUpdateListener listener = it.next();
            try {
                listener.cleanAll();
            }
            catch (Throwable throwable) {
                it.remove();
            }
        }
    }

    @Override
    public void removeActive() {
        this.m_active.clear();
        this.m_unknown.set(0);
        this.m_normal.set(0);
        this.m_warning.set(0);
        this.m_minor.set(0);
        this.m_major.set(0);
        this.m_critical.set(0);
        this.m_hosts.clear();
        this.m_applications.clear();
        this.m_GRP_and_APP.clear();
        this.m_App_and_Host.clear();
        this.m_GRP_and_Host.clear();
        this.m_msggrps.clear();
        this.m_objects.clear();
        for (AgentCard ac : Repository.getInstance().getAgentCards()) {
            ac.getEvents().clear();
        }
    }

    @Override
    public Map<String, SEvent> getActiveMap() {
        return this.m_active;
    }

    @Override
    public Map<String, SEvent> getClosedMap() {
        return this.m_acknowledged;
    }

    @Override
    public Iterator<String> getActive() {
        return this.m_active.keySet().iterator();
    }

    @Override
    public Iterator<String> getAckn() {
        return this.m_acknowledged.keySet().iterator();
    }

    @Override
    public SEvent getActive(String id) {
        return this.m_active.get(id);
    }

    @Override
    public SEvent getAckn(String id) {
        return this.m_acknowledged.get(id);
    }

    @Override
    public boolean fillTable() {
        boolean isUpdated;
        block10: {
            isUpdated = false;
            isUpdated = isUpdated || this.m_eventsToAdd.size() > 0;
            Iterator<Map.Entry<String, SEvent>> it = this.m_eventsToAdd.entrySet().iterator();
            try {
                while (it.hasNext()) {
                    Map.Entry<String, SEvent> en = it.next();
                    SEvent e = en.getValue();
                    this.m_active.put(e.getID(), e);
                    it.remove();
                    this.applyCounters(e, 1);
                }
            }
            catch (Throwable e) {
                RTLogger.print(5, "Event processing failed.", e);
            }
            isUpdated = isUpdated || this.m_eventsToClose.size() > 0;
            Iterator<Map.Entry<String, Character>> itD = this.m_eventsToClose.entrySet().iterator();
            while (itD.hasNext()) {
                Map.Entry<String, Character> en = itD.next();
                String id = en.getKey();
                SEvent event = this.m_active.remove(id);
                itD.remove();
                if (event == null) continue;
                event.setAnnotationFlag(true);
                event.setState(en.getValue().charValue());
                this.applyCounters(event, -1);
                this.addAcknowledged(event);
            }
            isUpdated = isUpdated || this.m_eventsToArchive.size() > 0;
            Iterator<Map.Entry<String, Integer>> it2 = this.m_eventsToArchive.entrySet().iterator();
            HashSet<SEvent> removedEvents = new HashSet<SEvent>();
            try {
                try {
                    while (it2.hasNext()) {
                        Map.Entry<String, Integer> en = it2.next();
                        it2.remove();
                        SEvent removed = this.removeAcknowledged(en.getKey(), false);
                        if (removed == null) continue;
                        removedEvents.add(removed);
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(5, "ARCH Event processing failed.", e);
                    this.notifySEventUpdate(removedEvents);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.notifySEventUpdate(removedEvents);
                throw throwable;
            }
            this.notifySEventUpdate(removedEvents);
        }
        final boolean isUpdatedF = isUpdated;
        UIJob uiJob = new UIJob("RefreshBrowsers"){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean isUpdated = isUpdatedF;
                if (!ApplicationActionBarAdvisor.showHotSpotAction.isEnabled()) {
                    isUpdated = true;
                    EventStorage.this.m_TYPES_UPDATED = true;
                }
                if (Repository.getInstance().getRights(1000) > 1 && Repository.getInstance().getRights(1002) > 1) {
                    ApplicationActionBarAdvisor.showHotSpotAction.setEnabled(true);
                }
                if (isUpdated || BMUI.m_cleaningMode) {
                    EventStorage.this.refreshHostListeners();
                    EventStorage.this.refreshRefreshable();
                }
                EventStorage.this.refreshBrowsersDirect();
                return Status.OK_STATUS;
            }
        };
        Repository.getUIJobManager().schedule(uiJob);
        return isUpdated;
    }

    @Override
    public int getTotalActualMessages() {
        return this.m_active.size();
    }

    @Override
    public int getTotalAcknMessages() {
        return this.m_acknowledged.size();
    }

    @Override
    public HashMapArray<String, Integer> getHosts() {
        return this.m_hosts;
    }

    @Override
    public HashMapArray<String, Integer> getGRPandAPP() {
        return this.m_GRP_and_APP;
    }

    @Override
    public HashMapArray<String, Integer> getAppAndHost() {
        return this.m_App_and_Host;
    }

    @Override
    public HashMapArray<String, Integer> getGrpAndHost() {
        return this.m_GRP_and_Host;
    }

    @Override
    public HashMapArray<String, Integer> getApplications() {
        return this.m_applications;
    }

    @Override
    public HashMapArray<String, Integer> getObjects() {
        return this.m_objects;
    }

    @Override
    public HashMapArray<String, Integer> getMsgGrps() {
        return this.m_msggrps;
    }

    @Override
    public TreeMapSortedSet getTypeA() {
        return this.m_TYPE_A;
    }

    @Override
    public TreeMapSortedSet getTypeK() {
        return this.m_TYPE_K;
    }

    @Override
    public SEvent getEvent(String ID) {
        SEvent e = this.m_active.get(ID);
        if (e == null) {
            e = this.m_acknowledged.get(ID);
        }
        return e;
    }

    protected void refreshHostListeners() {
        Iterator<TableViewer> it2 = this.m_hostListener.iterator();
        while (it2.hasNext()) {
            TableViewer v = it2.next();
            try {
                v.setInput(null);
                v.refresh(true, false);
            }
            catch (RuntimeException runtimeException) {
                try {
                    if (!v.getTable().isDisposed()) continue;
                    it2.remove();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void checkAcknIDs(List<String> idsFromServer) {
        Iterator<String> it = this.m_acknowledged.keySet().iterator();
        while (it.hasNext()) {
            String id = it.next();
            if (idsFromServer.contains(id)) continue;
            SEvent se = this.m_acknowledged.get(id);
            it.remove();
            this.applyAcknCounters(se, -1);
        }
    }

    protected void refreshBrowsersDirect() {
        Iterator<TableViewer> it = this.m_tableViewers.iterator();
        while (it.hasNext()) {
            TableViewer tv = it.next();
            if (tv == null || tv.getControl().isDisposed()) {
                it.remove();
                continue;
            }
            try {
                Object data = tv.getData("SUMMARY");
                if (data == null) continue;
                if (data instanceof MessageBrowserTab) {
                    try {
                        MessageBrowserTab messageBrowserTab = (MessageBrowserTab)((Object)data);
                        if (tv.isBusy() || messageBrowserTab.getParent().getSelection() != messageBrowserTab) continue;
                        tv.setInput((Object)messageBrowserTab.getEventProvider().getElements(null));
                        messageBrowserTab.createSummary();
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (!(data instanceof CleaningModeView)) continue;
                try {
                    CleaningModeView cmw = (CleaningModeView)((Object)data);
                    cmw.refresh();
                }
                catch (Throwable throwable) {}
            }
            catch (SWTException sWTException) {
                it.remove();
            }
        }
    }

    @Override
    public void enable(boolean enable) {
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getNumCritMessagesActive() {
        return this.m_critical.get();
    }

    @Override
    public int getNumCritMessagesClosed() {
        return this.m_Acritical.get();
    }

    @Override
    public int getNumMajorMessagesActive() {
        return this.m_major.get();
    }

    @Override
    public int getNumMajorMessagesClosed() {
        return this.m_Amajor.get();
    }

    @Override
    public int getNumMinorMessagesActive() {
        return this.m_minor.get();
    }

    @Override
    public int getNumMinorMessagesClosed() {
        return this.m_Aminor.get();
    }

    @Override
    public int getNumNormMessagesActive() {
        return this.m_normal.get();
    }

    @Override
    public int getNumNormMessagesClosed() {
        return this.m_Anormal.get();
    }

    @Override
    public int getNumUnknMessagesActive() {
        return this.m_unknown.get();
    }

    @Override
    public int getNumUnknMessagesClosed() {
        return this.m_Aunknown.get();
    }

    @Override
    public int getNumWarnMessagesActive() {
        return this.m_warning.get();
    }

    @Override
    public int getNumWarnMessagesClosed() {
        return this.m_Awarning.get();
    }
}

