/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.EventStorage;
import com.blixx.boom.engine.GuiClient;
import com.blixx.boom.gui.views.CleaningModeView;
import com.blixx.boom.gui.views.MessageBrowserTab;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWTException;

public class EventStorageOutage
extends EventStorage {
    protected static EventStorageOutage m_instanceOutage = null;
    protected AtomicBoolean m_enabled = new AtomicBoolean(false);

    protected EventStorageOutage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventStorage getInstance() {
        if (m_instanceOutage != null) return m_instanceOutage;
        Class<EventStorageOutage> clazz = EventStorageOutage.class;
        synchronized (EventStorageOutage.class) {
            if (m_instanceOutage != null) return m_instanceOutage;
            m_instanceOutage = new EventStorageOutage();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instanceOutage;
        }
    }

    @Override
    protected void refreshBrowsersDirect() {
        Iterator it = this.m_tableViewers.iterator();
        while (it.hasNext()) {
            TableViewer tv = (TableViewer)it.next();
            if (tv == null || tv.getControl().isDisposed()) {
                it.remove();
                continue;
            }
            try {
                Object data = tv.getData("SUMMARY");
                if (data == null) continue;
                if (data instanceof MessageBrowserTab) {
                    try {
                        MessageBrowserTab messageBrowserTab = (MessageBrowserTab)((Object)data);
                        if (!tv.isBusy()) {
                            tv.setInput((Object)messageBrowserTab.getEventProvider().getElements(null));
                        }
                        messageBrowserTab.createSummary();
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (!(data instanceof CleaningModeView)) continue;
                try {
                    CleaningModeView cmw = (CleaningModeView)((Object)data);
                    cmw.refresh();
                }
                catch (Throwable throwable) {}
            }
            catch (SWTException sWTException) {
                it.remove();
            }
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
    }

    @Override
    public void enable(boolean enable) {
        if (this.m_enabled.compareAndSet(!enable, enable)) {
            GuiClient.getInstance().activateOutageFetch(enable);
            if (!enable) {
                this.removeAll();
            }
        }
    }

    @Override
    public boolean fillTable() {
        boolean res = super.fillTable();
        if (this.m_tableViewers.size() == 0) {
            this.enable(false);
        }
        return res;
    }

    @Override
    public void removeTableFromRefresh(TableViewer tv) {
        super.removeTableFromRefresh(tv);
        if (this.m_tableViewers.size() == 0) {
            this.enable(false);
        }
    }

    @Override
    public int getType() {
        return 1;
    }
}

