/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.ServerClient;
import com.blixx.log.RTLogger;
import com.blixx.shared.Action;
import com.blixx.shared.IODataStream;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class GActionsRepository {
    public static final String ACTIONS_DIR = "actions";
    public static GActionsRepository m_instance = null;
    public File m_actDir = null;
    protected GroupTreeObject m_treeRoot = new GroupTreeObject(new TreeObject("Actions", BMUI.type_folder, null));
    protected String m_actDirPath;
    public Map<String, Action> m_knownActions = Collections.synchronizedMap(new HashMap(500, 0.95f));
    public Map<String, ArrayList<String>> m_fileActions = Collections.synchronizedMap(new HashMap(500, 0.95f));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GActionsRepository getInstance(String dir) {
        if (m_instance != null) return m_instance;
        Class<GActionsRepository> clazz = GActionsRepository.class;
        synchronized (GActionsRepository.class) {
            if (m_instance != null) return m_instance;
            m_instance = new GActionsRepository(dir);
            m_instance.init();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return m_instance;
        }
    }

    public String getActionsDirectory() {
        return String.valueOf(this.m_actDirPath) + File.separator;
    }

    protected GActionsRepository(String dir) {
        this.m_actDirPath = dir;
        this.m_actDir = new File(this.m_actDirPath);
    }

    protected void init() {
        this.m_treeRoot.clean();
        this.m_fileActions.clear();
        this.m_knownActions.clear();
        XMLFactory factory = new XMLFactory("ACTIONS", "ACTION");
        if (this.m_actDir.isDirectory()) {
            File[] farr = this.m_actDir.listFiles();
            int i = 0;
            while (i < farr.length) {
                block13: {
                    try {
                        if (!farr[i].getName().endsWith(BMUI.file_extension_act)) break block13;
                        String filename = farr[i].getName();
                        String groupName = filename.replace(BMUI.file_extension_act, "");
                        GroupTreeObject currentGroup = new GroupTreeObject(new TreeObject(groupName, BMUI.type_folder, null));
                        this.m_treeRoot.addElementNoSorting(currentGroup);
                        ArrayList<Object> actionIds = new ArrayList();
                        if (!this.m_fileActions.containsKey(filename)) {
                            this.m_fileActions.put(filename, actionIds);
                        } else {
                            actionIds = this.m_fileActions.get(filename);
                        }
                        ArrayList<Properties> actionPropList = factory.loadFile(farr[i]);
                        int j = 0;
                        while (j < actionPropList.size()) {
                            block14: {
                                Properties p = actionPropList.get(j);
                                Action a = new Action(p);
                                this.m_knownActions.put(a.m_ID, a);
                                actionIds.add(a.m_ID);
                                TreeObject to = new TreeObject(a.m_label, BMUI.type_act, a);
                                if (RTLogger.getCurrentLevel() > 5) {
                                    RTLogger.print(6, "Add action: " + a.m_label);
                                }
                                try {
                                    if (a.m_serverAction) {
                                        currentGroup.addElementNoSorting(new GroupTreeObjectLast(to, null, "IMAGE_ACTION_SERVER"));
                                    } else {
                                        currentGroup.addElementNoSorting(new GroupTreeObjectLast(to, null, "IMAGE_ACTION"));
                                    }
                                }
                                catch (Throwable e) {
                                    if (RTLogger.getCurrentLevel() <= 4) break block14;
                                    RTLogger.print(6, "Error add action: " + to, e);
                                }
                            }
                            ++j;
                        }
                    }
                    catch (Throwable throwable) {}
                }
                ++i;
            }
            this.m_treeRoot.sortElementsRecursive();
        } else {
            RTLogger.print(5, "ActionRepo: directory not yet fetched: " + this.m_actDir);
        }
    }

    public int getActionFilesCount() {
        return this.m_fileActions.size();
    }

    public Iterator<String> getFilesIterator() {
        return this.m_fileActions.keySet().iterator();
    }

    public GroupTreeObject getTree() {
        return this.m_treeRoot;
    }

    public ServerClient saveAction(Action act, String group) {
        ServerClient sc = new ServerClient("UPDATEACTION", group, new IODataStream[]{act});
        sc.runInUIThread(null);
        return sc;
    }

    public boolean isActionGroupExist(String groupName) {
        return this.m_fileActions.containsKey(String.valueOf(groupName) + ".act.xml");
    }

    public List<Action> loadActions(File xml) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (xml.exists()) {
            XMLFactory factory = new XMLFactory("ACTIONS", "ACTION");
            ArrayList<Properties> actionPropList = factory.loadFile(xml);
            int j = 0;
            while (j < actionPropList.size()) {
                Properties p = actionPropList.get(j);
                Action a = new Action(p);
                actions.add(a);
                ++j;
            }
        }
        return actions;
    }
}

