/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.in.ScGetJson;
import com.blixx.log.RTLogger;
import com.blixx.shared.Assignment;
import com.blixx.shared.DeploymentStatus;
import com.blixx.shared.HashCode;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.HashMapMap;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.TreeObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class GAssignments {
    private static final String SINGLE_DEPLOYED = "Single deployed";
    private GroupTreeObject m_assignments = new GroupTreeObject(new TreeObject("root", BMUI.type_toplevel, null));
    private GroupTreeObject m_assignmentsHostBased = new GroupTreeObject(new TreeObject("root", BMUI.type_toplevel, null));
    private GroupTreeObject m_assignmentsNodeGroupBased = new GroupTreeObject(new TreeObject("root", BMUI.type_toplevel, null));
    private HashMapMap<String, ITreeObject> m_cachedAssignments = new HashMapMap();
    private HashMapMap<String, String> m_cachedPoliciesToAgents = new HashMapMap();
    private HashMapMap<String, String> m_cachedBinariesToAgents = new HashMapMap();
    private Repository m_rep = null;
    private GroupTreeObject assignmentsTree;
    private List<Assignment> m_singlePolicies = new LinkedList<Assignment>();
    private List<Assignment> m_singleBinaries = new LinkedList<Assignment>();
    private List<Assignment> m_pendingAssign = new LinkedList<Assignment>();
    private List<Assignment> m_pgaAssignments = new LinkedList<Assignment>();
    private GroupTreeObject m_policyTree = null;
    private LinkedList<DeploymentStatus> m_deploymentsRunning = new LinkedList();
    private HashCode m_runningDeploymentsHash = new HashCode("");
    AtomicBoolean needQuickRefresh4RunningDC = new AtomicBoolean(false);
    private List<Assignment> lastProcessed = new ArrayList<Assignment>();
    private boolean m_isSupported = true;
    private Map<String, String> m_policiesGTOLs = new HashMap<String, String>();
    public boolean m_stopDeplymentRequests = false;

    public GAssignments(Repository rep) {
        this.m_rep = rep;
        this.m_policyTree = PolicyManager.getInstance().getPolicyTree();
    }

    public GroupTreeObject getAllNodeGroupsRoot() {
        return this.m_assignmentsNodeGroupBased;
    }

    public GroupTreeObject getAllAgentsRoot() {
        return this.m_assignmentsHostBased;
    }

    public GroupTreeObject getAllAssignmentRoot() {
        return this.m_assignments;
    }

    public List<Assignment> getPendingAssignments() {
        return this.m_pendingAssign;
    }

    public List<Assignment> getSingleAssignedPolicies() {
        return this.m_singlePolicies;
    }

    public List<Assignment> getSingleAssignedBinaries() {
        return this.m_singleBinaries;
    }

    public LinkedList<DeploymentStatus> getRunningDeployments() {
        return this.m_deploymentsRunning;
    }

    public boolean isSupported() {
        return this.m_isSupported;
    }

    public void startServerClient(long delay_ms, IServerAuth auth) {
        ServerClient sc = ServerClient.getAllAssignments();
        Repository.getJobManager().schedule(sc, delay_ms);
        this.m_stopDeplymentRequests = false;
        this.startRequestDeploymentRunning(delay_ms + 500L, auth);
    }

    private void startRequestDeploymentRunning(long delay_ms, final IServerAuth auth) {
        if (this.m_stopDeplymentRequests) {
            return;
        }
        ScGetJson scj = new ScGetJson(auth, "/json/dc", null);
        scj.addCmdPostProcess(new ICmdPostProcess<ScGetJson>(){

            @Override
            public void postProcess(ScGetJson sc) {
                if (sc.isSuccess()) {
                    String jsonString = (String)sc.getResultObject();
                    HashCode hc = new HashCode(jsonString);
                    if (!hc.equals(GAssignments.this.m_runningDeploymentsHash)) {
                        GAssignments.this.m_runningDeploymentsHash = hc;
                        JsonElement el = new JsonParser().parse(jsonString);
                        if (el instanceof JsonArray) {
                            JsonArray arr = (JsonArray)el;
                            LinkedList<DeploymentStatus> dstat = new LinkedList<DeploymentStatus>();
                            boolean waitingDCfound = false;
                            int i = 0;
                            while (i < arr.size()) {
                                JsonElement jsonel = arr.get(i);
                                if (jsonel instanceof JsonObject) {
                                    DeploymentStatus ds = new DeploymentStatus();
                                    try {
                                        ds.initFromJson((JsonObject)jsonel);
                                        dstat.add(ds);
                                        if (ds.getState() < 15) {
                                            waitingDCfound = true;
                                        }
                                    }
                                    catch (Throwable e) {
                                        RTLogger.print(2, "", e);
                                    }
                                }
                                ++i;
                            }
                            if (GAssignments.this.needQuickRefresh4RunningDC.compareAndSet(!waitingDCfound, waitingDCfound)) {
                                RTLogger.print(5, "Running assignments QuickRefresh=" + GAssignments.this.needQuickRefresh4RunningDC.get());
                            }
                            GAssignments.this.m_deploymentsRunning.clear();
                            GAssignments.this.m_deploymentsRunning.addAll(dstat);
                            final AssignmentsSummaryView instance = AssignmentsSummaryView.getInstance();
                            if (instance != null) {
                                UIJob runnungDeployments = new UIJob("rfrRD"){

                                    @Override
                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        instance.refreshRunningDeployments();
                                        return null;
                                    }
                                };
                                UIJobManager.getInstance().schedule(runnungDeployments);
                            }
                        }
                    }
                    int delay = 10000;
                    if (GAssignments.this.needQuickRefresh4RunningDC.get()) {
                        delay = 5000;
                    }
                    GAssignments.this.startRequestDeploymentRunning(delay, auth);
                } else if (sc.isSupported()) {
                    int delay = 10000;
                    GAssignments.this.startRequestDeploymentRunning(delay, auth);
                } else {
                    GAssignments.this.m_isSupported = false;
                }
            }
        });
        Repository.getJobManager().schedule(scj, delay_ms + 1L);
    }

    public void refresh() {
        final AssignmentsSummaryView instance = AssignmentsSummaryView.getInstance();
        if (instance != null) {
            UIJob ui = new UIJob("rfrassovv" + System.currentTimeMillis() / 1000L){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    instance.refresh();
                    return null;
                }
            };
            Repository.getUIJobManager().schedule(ui);
        }
        RTLogger.print(5, "GAssignments end");
    }

    public synchronized void processResult(List<Assignment> result) {
        if (this.lastProcessed.size() == result.size() && !this.lastProcessed.retainAll(result)) {
            RTLogger.print(4, "ASN no updates found. skipped.");
            return;
        }
        try {
            this.clearBuffers();
            RTLogger.print(5, "GAssignments start");
            this.lastProcessed = new ArrayList<Assignment>(result);
            this.processAssignmentGroups(result);
            RTLogger.print(5, "GAssignments 1");
            Iterator<Assignment> it = result.iterator();
            long time = 0L;
            while (it.hasNext()) {
                Assignment asn = it.next();
                String agentID = asn.getAgentID();
                if (asn.getType().equals(BMUI.type_mon) || asn.getType().equals(BMUI.type_msg)) {
                    long st = System.currentTimeMillis();
                    this.m_cachedPoliciesToAgents.putV(asn.getName(), agentID);
                    time += System.currentTimeMillis() - st;
                } else if (asn.getType().equals(BMUI.type_assignment_bin)) {
                    long st = System.currentTimeMillis();
                    this.m_cachedBinariesToAgents.putV(asn.getName(), agentID);
                    time += System.currentTimeMillis() - st;
                }
                boolean isSingle = true;
                if (asn.getType().equals(BMUI.type_assignment_pol)) {
                    isSingle = false;
                } else {
                    Map<ITreeObject, Object> agentAssigned = this.m_cachedAssignments.getHashMap(agentID);
                    if (agentAssigned != null) {
                        for (ITreeObject to : agentAssigned.keySet()) {
                            if (!to.getName().equals(asn.getName()) || !to.getType().equals(asn.getType())) continue;
                            isSingle = false;
                            break;
                        }
                    }
                }
                if (isSingle) {
                    String type = asn.getType();
                    if (type.equals(BMUI.type_assignment_bin)) {
                        this.addSingleBinaryToAgent(asn);
                    } else if (type.equals(BMUI.type_mon) || type.equals(BMUI.type_msg)) {
                        this.addSinglePolicyToAgent(asn);
                    }
                }
                if (asn.getLock() == 0 || GAssignments.isAssignmentRunning(asn)) continue;
                this.m_pendingAssign.add(asn);
            }
            RTLogger.print(4, "GAssignments TTime = " + time);
            this.m_assignments.sortElementsRecursive();
            this.m_assignmentsHostBased.sortElementsRecursive();
            this.refresh();
            RTLogger.print(5, "GAssignments stopped");
        }
        catch (Throwable e) {
            RTLogger.print(5, "GAssignments failed", e);
        }
    }

    public static boolean isAssignmentRunning(Assignment asn) {
        return asn.getLock() >= 100;
    }

    public void clearBuffers() {
        this.m_pgaAssignments.clear();
        this.m_assignments.clean();
        this.m_assignmentsHostBased.clean();
        this.m_assignmentsNodeGroupBased.clean();
        this.m_cachedAssignments.clear();
        this.assignmentsTree = PolicyManager.getInstance().getAsnTree().getFirstChild("Assignments");
        if (this.assignmentsTree == null) {
            this.assignmentsTree = new GroupTreeObject(new TreeObject("Assignments", BMUI.type_folder, null));
        }
        this.m_singlePolicies.clear();
        this.m_singleBinaries.clear();
        this.m_pendingAssign.clear();
        this.m_cachedPoliciesToAgents.clear();
        this.m_cachedBinariesToAgents.clear();
        this.m_policiesGTOLs.clear();
    }

    private Map<AgentCard, Object> getRelatedAgents(String name, String type) {
        HashMap<AgentCard, Object> map;
        block5: {
            GroupTreeObject PGAAssigned;
            block6: {
                block4: {
                    map = new HashMap<AgentCard, Object>();
                    if (!type.equals(BMUI.type_assignment_bin)) break block4;
                    Map<String, Object> agentIds = this.m_cachedBinariesToAgents.getHashMap(name);
                    if (agentIds == null) break block5;
                    for (String agentID : agentIds.keySet()) {
                        map.put(this.m_rep.getAgentCard(agentID), null);
                    }
                    break block5;
                }
                if (!type.equals(BMUI.type_mon) && !type.equals(BMUI.type_msg)) break block6;
                Map<String, Object> agentIds = this.m_cachedPoliciesToAgents.getHashMap(name);
                if (agentIds == null) break block5;
                for (String agentID : agentIds.keySet()) {
                    map.put(this.m_rep.getAgentCard(agentID), null);
                }
                break block5;
            }
            if (type.equals(BMUI.type_assignment_pol) && (PGAAssigned = this.m_assignments.getChild(name, type)) != null && PGAAssigned.getElements() != null) {
                for (GroupTreeObject acGTO : PGAAssigned.getElements()) {
                    if (!(acGTO.getTreeObject() instanceof AgentCard)) continue;
                    map.put((AgentCard)acGTO.getTreeObject(), null);
                }
            }
        }
        return map;
    }

    private void addSingleBinaryToAgent(Assignment asn) {
        try {
            AgentCard ac = this.m_rep.getAgentCard(asn.getAgentID());
            if (ac != null) {
                GroupTreeObject folder;
                GroupTreeObject gtoHB = this.m_assignmentsHostBased.getChild(ac.getAgentID(), BMUI.type_agt);
                if (gtoHB == null) {
                    gtoHB = new GroupTreeObject(ac);
                    gtoHB.setLabel(ac.getLabel());
                    this.m_assignmentsHostBased.addElementNoSorting(gtoHB);
                }
                if ((folder = gtoHB.getChild(SINGLE_DEPLOYED, BMUI.type_folder)) == null) {
                    folder = new GroupTreeObject(new TreeObject(SINGLE_DEPLOYED, BMUI.type_folder, null));
                    gtoHB.addElementNoSorting(folder);
                }
                GroupTreeObjectLast singleBinary = new GroupTreeObjectLast(new TreeObject(asn.getName(), asn.getType(), null), "/root/Packages/" + asn.getName().intern(), "IMAGE_PKG_LNK");
                folder.addElementNoSorting(singleBinary);
            }
            this.m_singleBinaries.add(asn);
        }
        catch (Throwable throwable) {}
    }

    private void addSinglePolicyToAgent(Assignment asn) {
        AgentCard ac = this.m_rep.getAgentCard(asn.getAgentID());
        if (ac != null) {
            String name_type;
            String cached;
            GroupTreeObject folder;
            GroupTreeObject gtoHB = this.m_assignmentsHostBased.getChild(ac.getAgentID(), BMUI.type_agt);
            if (gtoHB == null) {
                gtoHB = new GroupTreeObject(ac);
                gtoHB.setLabel(ac.getLabel());
                this.m_assignmentsHostBased.addElementNoSorting(gtoHB);
            }
            if ((folder = gtoHB.getChild(SINGLE_DEPLOYED, BMUI.type_folder)) == null) {
                folder = new GroupTreeObject(new TreeObject(SINGLE_DEPLOYED, BMUI.type_folder, null));
                gtoHB.addElementNoSorting(folder);
            }
            String icon = "IMAGE_MON_LNK";
            if (asn.getType().equals(BMUI.type_msg)) {
                icon = "IMAGE_MSG_LNK";
            }
            if ((cached = this.m_policiesGTOLs.get(name_type = String.valueOf(asn.getName()) + "_" + asn.getType())) == null) {
                GroupTreeObject gtl = null;
                if (this.m_policyTree == null) {
                    this.m_policyTree = PolicyManager.getInstance().getPolicyTree();
                }
                if (this.m_policyTree != null) {
                    gtl = this.m_policyTree.findElement(asn.getName(), asn.getType());
                }
                if (gtl == null) {
                    this.m_policiesGTOLs.put(name_type, "");
                } else {
                    cached = gtl.getPath();
                    this.m_policiesGTOLs.put(name_type, cached);
                }
            }
            GroupTreeObjectLast singlePolicy = new GroupTreeObjectLast(asn, cached, icon);
            if ("".equals(cached)) {
                singlePolicy.setLinkOK(false);
            }
            try {
                folder.addElementNoSorting(singlePolicy);
                this.m_singlePolicies.add(asn);
            }
            catch (Throwable e) {
                RTLogger.print(5, "", e);
            }
        }
    }

    private void processAssignmentGroups(List<Assignment> result) {
        Iterator<Assignment> it = result.iterator();
        HashMap<String, GroupTreeObject> insertedAgents = new HashMap<String, GroupTreeObject>();
        this.m_assignments.ensureCapacity(this.assignmentsTree.numberOfElements());
        this.m_assignmentsHostBased.ensureCapacity(this.m_rep.getAgentCards().size());
        while (it.hasNext()) {
            GroupTreeObject asnMain;
            Assignment asn;
            block33: {
                String oid;
                GroupTreeObject nodeGroup;
                GroupTreeObject agentTree;
                AgentCard ac;
                asn = it.next();
                if (!asn.getType().equals(BMUI.type_assignment_pol)) continue;
                this.m_pgaAssignments.add(asn);
                String name = asn.getName();
                asnMain = this.assignmentsTree.getChild(name, BMUI.type_assignment_pol);
                GroupTreeObject gtoAsnInLeftTree = this.m_assignments.getChild(name, BMUI.type_assignment_pol);
                if (gtoAsnInLeftTree == null) {
                    String finalName;
                    String suffix = "";
                    if (asnMain == null) {
                        suffix = " (DELETED)";
                    }
                    if ((gtoAsnInLeftTree = this.m_assignments.getChild(finalName = String.valueOf(name) + suffix, BMUI.type_assignment_pol)) == null) {
                        gtoAsnInLeftTree = new GroupTreeObject(new TreeObject(finalName, BMUI.type_assignment_pol, null));
                        this.m_assignments.addElementNoSortingNoChecking(gtoAsnInLeftTree);
                    }
                }
                if ((ac = this.m_rep.getAgentCard(asn.getAgentID())) == null) {
                    RTLogger.print(4, "pga processing before agent known. {}" + asn.getAgentID() + "   " + this.m_rep.getAgentCards().size());
                } else {
                    GroupTreeObject gtoHB = (GroupTreeObject)insertedAgents.get(ac.getAgentID());
                    if (gtoHB == null) {
                        gtoHB = new GroupTreeObject(ac);
                        gtoHB.setLabel(ac.getLabel());
                        this.m_assignmentsHostBased.addElementNoSortingNoChecking(gtoHB);
                        insertedAgents.put(ac.getAgentID(), gtoHB);
                    }
                    try {
                        GroupTreeObject assignGroup;
                        if (asnMain == null) {
                            assignGroup = new GroupTreeObject(new TreeObject(String.valueOf(name) + " (DELETED)", asn.getType(), asn));
                            gtoHB.addElementNoSorting(assignGroup);
                        } else {
                            assignGroup = asnMain.clone();
                            gtoHB.addElementNoSorting(assignGroup);
                        }
                    }
                    catch (Throwable throwable) {}
                }
                if (ac != null) {
                    GroupTreeObjectLast agent = new GroupTreeObjectLast(ac, "", "IMAGE_PC");
                    try {
                        gtoAsnInLeftTree.addElementNoSortingNoChecking(agent);
                    }
                    catch (Throwable throwable) {}
                } else if (asn.getAgentID().length() == 32 && (agentTree = this.m_rep.getAgentTree()) != null && (nodeGroup = agentTree.findByOID(asn.getAgentID())) != null) {
                    try {
                        String parentPath = nodeGroup.getParentPath().replaceFirst("/root/_Groups", "/root/" + name);
                        GroupTreeObject parent = this.m_assignments.searchPath(parentPath, BMUI.type_folder);
                        if (parent == null) {
                            parent = GroupTreeObject.createPath(parentPath, this.m_assignments);
                        }
                        if (parent != null) {
                            GroupTreeObject clone = nodeGroup.clone();
                            if (parent.getChild(clone.getName(), clone.getType()) == null) {
                                parent.addElementNoSortingNoChecking(clone);
                            }
                            GroupTreeObject parentTMP = parent;
                            GroupTreeObject ngTMP = clone.getParent();
                            boolean isOk = true;
                            while (isOk) {
                                if (ngTMP == null || parentTMP == null || parentTMP.getType().equals(BMUI.type_assignment_pol)) {
                                    isOk = false;
                                    continue;
                                }
                                if (parentTMP.getTreeObject().getOID() == null || parentTMP.getTreeObject().getOID().length() == 0) {
                                    parentTMP.getTreeObject().setOID(ngTMP.getTreeObject().getOID());
                                }
                                ngTMP = ngTMP.getParent();
                                parentTMP = parentTMP.getParent();
                            }
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                if ((oid = asn.getAgentID()) != null && oid.length() == 32) {
                    try {
                        nodeGroup = this.m_rep.getAgentTree().findByOID(oid);
                        String ngPath = nodeGroup.getPath().replaceFirst("/root/_Groups", "/root");
                        GroupTreeObject ngNew = this.m_assignmentsNodeGroupBased.searchPath(ngPath, BMUI.type_folder);
                        if (ngNew == null) {
                            ngNew = GroupTreeObject.createPath(ngPath, this.m_assignmentsNodeGroupBased);
                        }
                        if (ngNew == null) break block33;
                        try {
                            GroupTreeObject assignGroup = asnMain.clone();
                            ngNew.addElementNoSorting(assignGroup);
                        }
                        catch (Throwable throwable) {}
                        GroupTreeObject newTMP = ngNew;
                        GroupTreeObject ngTMP = nodeGroup;
                        while (!newTMP.getName().equals("root")) {
                            if (newTMP.getTreeObject().getOID() == null || newTMP.getTreeObject().getOID().length() == 0) {
                                newTMP.getTreeObject().setOID(ngTMP.getTreeObject().getOID());
                            }
                            ngTMP = ngTMP.getParent();
                            newTMP = newTMP.getParent();
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
            this.cacheAssignmentChildren(asn, asnMain);
            if (asn.getLock() != 0) {
                this.m_pendingAssign.add(asn);
            }
            it.remove();
        }
        insertedAgents = null;
    }

    private void cacheAssignmentChildren(Assignment asn, GroupTreeObject asnMain) {
        if (asn.getType().equals(BMUI.type_assignment_pol) && asnMain != null) {
            List<GroupTreeObject> children = asnMain.getAllElements();
            for (GroupTreeObject gto : children) {
                if (!(gto instanceof GroupTreeObjectLast)) continue;
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto;
                this.m_cachedAssignments.putV(asn.getAgentID(), gtol.getTreeObject());
            }
        }
    }

    public Map<AgentCard, Object> getAllRelatedAgents(String objName, String type) {
        Map<AgentCard, Object> singleDeployed;
        HashMap<AgentCard, Object> map = new HashMap<AgentCard, Object>();
        if (BMUI.type_mon.equals(type) || BMUI.type_msg.equals(type) || BMUI.type_assignment_bin.equals(type)) {
            List<GroupTreeObject> elements;
            Map<AgentCard, Object> singleDeployed2 = this.getRelatedAgents(objName, type);
            if (singleDeployed2 != null && singleDeployed2.size() > 0) {
                map.putAll(singleDeployed2);
            }
            if ((elements = PolicyManager.getInstance().getAsnTree().findElements(objName, type)) != null && elements.size() > 0) {
                for (GroupTreeObject el : elements) {
                    GroupTreeObject PGAAssigned;
                    GroupTreeObject PGA = el.findFirstParent(BMUI.type_assignment_pol);
                    if (PGA == null || (PGAAssigned = this.m_assignments.getChild(PGA.getName(), PGA.getType())) == null || PGAAssigned.getElements() == null) continue;
                    for (GroupTreeObject acGTO : PGAAssigned.getElements()) {
                        if (!(acGTO.getTreeObject() instanceof AgentCard)) continue;
                        map.put((AgentCard)acGTO.getTreeObject(), null);
                    }
                }
            }
        } else if (BMUI.type_assignment_pol.equals(type) && (singleDeployed = this.getRelatedAgents(objName, type)) != null && singleDeployed.size() > 0) {
            map.putAll(singleDeployed);
        }
        return map;
    }

    public synchronized Map<AgentCard, String> getAgentID2AssignmentGroupID(String pgaName) {
        LinkedHashMap<AgentCard, String> res = new LinkedHashMap<AgentCard, String>();
        for (Assignment asn : this.m_pgaAssignments) {
            AgentCard ac;
            if (!pgaName.equals(asn.getName()) || (ac = this.m_rep.getAgentCard(asn.getAgentID())) == null) continue;
            res.put(ac, asn.getID());
        }
        return res;
    }

    public static String getDeploymentState(int state) {
        switch (state) {
            case 0: {
                return "waiting for agent";
            }
            case 1: {
                return "waiting for free slot";
            }
            case 2: {
                return "waiting for agent request";
            }
            case 10: {
                return "running";
            }
            case 15: {
                return "expired";
            }
            case 20: {
                return "failed to process";
            }
            case 25: {
                return "canceled";
            }
            case 30: {
                return "finished ok";
            }
        }
        return "";
    }
}

