/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.authentication.UserManagementView;
import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.DiskEventStorage;
import com.blixx.boom.engine.IEventStorageSubmit;
import com.blixx.boom.engine.ProgressBarJob;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.ServiceDashBoardProvider;
import com.blixx.boom.engine.StatusJob;
import com.blixx.boom.engine.StatusJob1;
import com.blixx.boom.engine.TlsUtils;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.exception.ConnectionException;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.ApplicationActionBarAdvisor;
import com.blixx.boom.gui.ApplicationWorkbenchWindowAdvisor;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.SendMessageDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.graph.NodeGroupsView;
import com.blixx.boom.gui.views.ActionView;
import com.blixx.boom.gui.views.ActionsListView;
import com.blixx.boom.gui.views.AgentCardView;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.boom.gui.views.DashBoardServicesView;
import com.blixx.boom.gui.views.DashBoardView2;
import com.blixx.boom.gui.views.MaintenanceView;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.NodeListView;
import com.blixx.boom.gui.views.PerfView;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.boom.gui.views.ServerJobsView;
import com.blixx.ctrl.sc.in.ScGetAgentCards;
import com.blixx.ctrl.sc.in.ScGetAllAsn;
import com.blixx.ctrl.sc.in.ScGetUserAttributes;
import com.blixx.ctrl.sc.in.ScRefreshNodes;
import com.blixx.log.RTLogger;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSocket;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GuiClient
extends Thread {
    private Socket m_sock = null;
    private static GuiClient m_client = null;
    private AtomicBoolean isONLINE = new AtomicBoolean(false);
    private int isReconnectDone = 0;
    public static boolean m_ignorePending = false;
    private boolean m_isOldServer = false;
    private boolean m_isEXTZIP = true;
    private int m_defaultTimeout = 60000;
    private long m_lastGetAgentCardsCommand = 0L;
    private boolean m_uiRunning = true;
    private boolean m_stopped = false;
    public boolean m_isnewConnect;
    protected IEventStorageSubmit m_eventStorage = null;
    protected IEventStorageSubmit m_eventStorageOutage = null;
    protected AtomicBoolean m_sendDisableOutage = new AtomicBoolean(false);
    protected SDataInputStream is = null;
    protected SDataOutputStream os = null;
    protected boolean isTlsActive = false;
    protected String tlsVersion = "";
    protected AtomicInteger m_askOutage = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GuiClient getInstance() {
        if (m_client != null) return m_client;
        Class<GuiClient> clazz = GuiClient.class;
        synchronized (GuiClient.class) {
            if (m_client != null) return m_client;
            m_client = new GuiClient("serverPollClient");
            m_client.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_client;
        }
    }

    private GuiClient(String name) {
        super(name);
        this.m_eventStorage = Repository.getEventStorageSubmit();
        this.m_eventStorageOutage = Repository.getOuEventStorageSubmit();
    }

    public void activateOutageFetch(boolean activate) {
        if (activate) {
            if (this.m_askOutage.compareAndSet(0, 1)) {
                RTLogger.print(2, "Outage data will be loaded");
            }
        } else {
            this.m_askOutage.set(0);
            this.m_sendDisableOutage.compareAndSet(false, true);
            RTLogger.print(2, "Outage data processing disabled");
        }
    }

    private void performGetActiveMessages() {
        Repository.getJobManager().clean();
        try {
            this.m_isnewConnect = false;
            if (this.m_sock == null) {
                this.m_sock = new Socket();
                this.m_sock.bind(null);
                this.m_sock.setSoTimeout(60000);
                this.m_sock.setReceiveBufferSize(1024000);
                this.m_sock.setPerformancePreferences(0, 1, 2);
                this.m_sock.setTcpNoDelay(true);
                this.m_sock.setSoLinger(true, 1);
                this.m_sock.setKeepAlive(true);
                this.m_sock.connect(new InetSocketAddress(BMUI.localhost, (int)BMUI.port), 10000);
                this.m_isnewConnect = true;
                this.is = new SDataInputStream(this.m_sock.getInputStream());
                this.os = new SDataOutputStream(this.m_sock.getOutputStream(), ServerClient.getDetectedServerProtocolVersion());
                if (BMUI.m_activateTls) {
                    this.m_sock = TlsUtils.upgradeToTLS(this.m_sock);
                    this.tlsVersion = ((SSLSocket)this.m_sock).getSession().getProtocol();
                    this.isTlsActive = true;
                    this.os.setVersion(0);
                }
            }
            if (!this.m_isnewConnect) {
                this.os.writeUTF("PING");
            }
            String str = this.is.readUTF();
            int res = this.processServerQuestion(str, this.os, this.is);
            boolean isUpdated = false;
            if (res == 0) {
                this.setStatus(true);
                this.startProgressBar("Connecting");
                ServerClient.detectProtocolVersion(this.os, this.is);
                this.m_eventStorage.removeAll();
                if (this.isReconnectDone == 2) {
                    Repository.getInstance().cleanDataOnReconnect();
                    if (BMUI.m_cleaningMode) {
                        DiskEventStorage.clearAll();
                    }
                    this.refreshMessageBrowsers();
                    try {
                        Repository.getInstance().fetchUserRole();
                    }
                    catch (ConnectionException connectionException) {}
                    if (Repository.getInstance().getRights(1002) > 1) {
                        ScGetAgentCards scga = new ScGetAgentCards(Repository.getInstance(), AgentCard.class);
                        scga.addCmdPostProcess(Repository.getInstance());
                        Repository.getJobManager().schedule(scga, 50L);
                        ScRefreshNodes scrn = new ScRefreshNodes(Repository.getInstance(), Repository.getUserTmpDirectory());
                        scrn.addCmdPostProcess(Repository.getInstance());
                        Repository.getJobManager().schedule(scrn, 100L);
                    }
                    if (Repository.getInstance().getRights(1008) > 1) {
                        ScGetAllAsn sc = new ScGetAllAsn(Repository.getInstance(), Repository.getInstance());
                        Repository.getJobManager().schedule(sc, 500L);
                    }
                }
                if (!BMUI.m_ignoreAllIndications) {
                    if (Repository.getInstance().getRights(1000) > 1) {
                        this.startProgressBar("Loading active indications");
                        RTLogger.print(3, "Start loading active messages");
                        long start = System.currentTimeMillis();
                        this.requestServer("GETACTIVEMESSAGES_EXT_ZIP", this.os, this.is);
                        RTLogger.print(3, "Finish loading active messages. sec:" + (System.currentTimeMillis() - start) / 1000L);
                    }
                    if (!BMUI.m_cleaningMode) {
                        this.refreshMessageBrowsers();
                    }
                    if (!BMUI.m_ignoreClosedIndications && !BMUI.m_ignoreAllIndications && Repository.getInstance().getRights(1000) > 1) {
                        this.startProgressBar("Loading closed indications");
                        RTLogger.print(3, "Start loading ackn messages");
                        long start = System.currentTimeMillis();
                        this.requestServer("GETACKNMESSAGES_EXT_ZIP", this.os, this.is);
                        RTLogger.print(3, "Finish loading ackn messages. sec:" + (System.currentTimeMillis() - start) / 1000L);
                        this.refreshMessageBrowsers();
                    }
                    if (this.isReconnectDone == 0) {
                        this.isReconnectDone = 1;
                    } else if (this.isReconnectDone == 2) {
                        this.isReconnectDone = 1;
                        this.refreshData();
                    }
                }
                if (this.isONLINE.compareAndSet(false, true)) {
                    this.setMessage(String.valueOf(this.isTlsActive ? "[" + this.tlsVersion + "] " : "") + "Server online", false);
                }
                RTLogger.print(3, "Stop loading messages");
                this.m_isnewConnect = false;
            } else {
                this.setStatus(true);
                long start = System.currentTimeMillis();
                isUpdated = this.requestServer("GETUPDATENEW_EXT", this.os, this.is) || isUpdated;
                long rtime = System.currentTimeMillis() - start;
                if (rtime > 10000L) {
                    RTLogger.print(3, "CMD_GETUPDATENEW_EXT rtime(sec): " + rtime / 1000L);
                }
                start = System.currentTimeMillis();
                isUpdated = this.requestServer("GETUPDATEDELETED", this.os, this.is) || isUpdated;
                rtime = System.currentTimeMillis() - start;
                if (rtime > 10000L) {
                    RTLogger.print(3, "CMD_GETUPDATEDELETED rtime(sec): " + rtime / 1000L);
                }
                start = System.currentTimeMillis();
                isUpdated = this.requestServer("GETUPDATEUPDATED_EXT", this.os, this.is) || isUpdated;
                rtime = System.currentTimeMillis() - start;
                if (rtime > 10000L) {
                    RTLogger.print(3, "CMD_GETUPDATEUPDATED_EXT rtime(sec): " + rtime / 1000L);
                }
                start = System.currentTimeMillis();
                isUpdated = this.requestServer("GETARCHIVED", this.os, this.is) || isUpdated;
                rtime = System.currentTimeMillis() - start;
                if (rtime > 10000L) {
                    RTLogger.print(3, "CMD_GETARCHIVED rtime(sec): " + rtime / 1000L);
                }
                switch (this.m_askOutage.get()) {
                    case 1: {
                        this.m_eventStorageOutage.removeAll();
                        this.initialLoadOutages(this.is, this.os);
                        this.m_askOutage.compareAndSet(1, 2);
                        break;
                    }
                    case 2: {
                        this.requestNotificationsOutage(this.is, this.os);
                    }
                    default: {
                        if (!this.m_sendDisableOutage.get()) break;
                        this.os.writeUTF("DISABLEOUTAGE_O");
                        String result = this.is.readUTF();
                        if (!result.startsWith("T")) break;
                        this.m_sendDisableOutage.set(false);
                    }
                }
            }
            if (isUpdated) {
                this.refreshMessageBrowsers();
            }
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {}
            if (!m_ignorePending) {
                this.askForPending(this.os, this.is);
            }
        }
        catch (OutOfMemoryError e) {
            Thread.yield();
            this.m_eventStorage.removeAll();
            this.m_eventStorageOutage.removeAll();
            Runtime.getRuntime().runFinalization();
            RTLogger.print(1, "Client failed", e);
            UIJob ui = new UIJob("OutOfMemory"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        try {
                            new ShowMessageBox("Out of Memory", "Not enough memory to load data from the server!\nApplication will exit.", 1);
                        }
                        catch (Throwable throwable) {
                            PlatformUI.getWorkbench().close();
                        }
                    }
                    finally {
                        PlatformUI.getWorkbench().close();
                    }
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(ui);
            this.m_uiRunning = false;
            this.m_askOutage.compareAndSet(2, 1);
        }
        catch (Throwable e) {
            RTLogger.print(2, "", e);
            if (this.isONLINE.compareAndSet(true, false)) {
                this.setMessage("Reconnecting to server...", !this.isONLINE.get());
                ServerClient.resetDetectedServerProtocolVersion();
                RTLogger.print(1, "Client failed", e);
                this.isReconnectDone = 2;
            }
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (Throwable throwable) {}
            }
            if (this.os != null) {
                try {
                    this.os.close();
                }
                catch (Throwable throwable) {}
            }
            if (this.m_sock != null) {
                try {
                    this.m_sock.close();
                }
                catch (Throwable throwable) {}
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {}
            this.m_sock = null;
            this.m_askOutage.compareAndSet(2, 1);
            throw new RuntimeException("Server is offline");
        }
    }

    protected void requestNotificationsOutage(SDataInputStream is, SDataOutputStream os) throws IOException {
        boolean refreshOutage = false;
        refreshOutage = this.requestServerOutages("GETUPDATENEW_EXT_O", os, is) || refreshOutage;
        refreshOutage = this.requestServerOutages("GETUPDATEDELETED_O", os, is) || refreshOutage;
        refreshOutage = this.requestServerOutages("GETUPDATEUPDATED_EXT_O", os, is) || refreshOutage;
        boolean bl = refreshOutage = this.requestServerOutages("GETARCHIVED_O", os, is) || refreshOutage;
        if (refreshOutage) {
            this.refreshOutageMessageBrowsers();
        }
    }

    protected void initialLoadOutages(SDataInputStream is, SDataOutputStream os) throws IOException {
        this.m_eventStorageOutage.removeAll();
        RTLogger.print(3, "Start loading outage messages");
        this.requestServerOutages("GETACTIVEMESSAGES_EXT_ZIP_O", os, is);
        this.refreshOutageMessageBrowsers();
        if (!BMUI.m_ignoreClosedIndications && !BMUI.m_ignoreAllIndications && Repository.getInstance().getRights(2016) > 1) {
            RTLogger.print(3, "Start loading outage closed messages");
            this.requestServerOutages("GETACKNMESSAGES_EXT_ZIP_O", os, is);
            this.refreshMessageBrowsers();
        }
        RTLogger.print(3, "Stop loading outage messages");
    }

    public void refreshMessageBrowsers() {
        long start = System.currentTimeMillis();
        this.m_eventStorage.fillTable();
        long rtime = System.currentTimeMillis() - start;
        if (rtime > 1000L) {
            RTLogger.print(5, "RfrshBrs = " + rtime / 1000L + " sec!");
        }
    }

    public void refreshOutageMessageBrowsers() {
        this.m_eventStorageOutage.fillTable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processServerQuestion(String question, SDataOutputStream os, SDataInputStream is) throws IOException {
        int res = 0;
        if (question.equalsIgnoreCase("login")) {
            os.writeUTF(String.valueOf(Repository.m_user) + '\u25ba' + Repository.m_sessionUUID);
            String nextToken = is.readUTF();
            if (!nextToken.equalsIgnoreCase("password")) throw new RuntimeException("login name unknown");
            os.writeUTF(Repository.m_pass);
            String response = is.readUTF();
            if (response.equals("OK")) return res;
            throw new RuntimeException(response);
        }
        if (!question.equalsIgnoreCase("valid")) return res;
        return 7;
    }

    protected boolean requestServer(String command, SDataOutputStream os, SDataInputStream is) throws IOException {
        String res = "F";
        boolean isUpdated = false;
        if (command.equals("GETACTIVEMESSAGES_EXT") || command.equals("GETUPDATENEW_EXT")) {
            os.writeUTF(command);
            is.readInt();
            while (is.readBoolean()) {
                SEventFwd e = new SEventFwd();
                long start = System.nanoTime();
                e.readSv2(is);
                System.nanoTime();
                if (BMUI.m_cleaningMode) continue;
                if (e.getState() == '-') {
                    this.m_eventStorage.addEvent(e);
                } else {
                    this.m_eventStorage.addAcknowledged(e);
                }
                isUpdated = true;
            }
            res = is.readUTF();
        } else if (command.equals("GETACTIVEMESSAGES_EXT_ZIP")) {
            if (!this.m_isEXTZIP) {
                throw new SocketTimeoutException();
            }
            RTLogger.print(5, "GETACTIVEMESSAGES_EXT_ZIP");
            os.writeUTF("GETACTIVEMESSAGES_EXT_ZIP");
            int bbbSize = -1;
            int count = 0;
            while ((bbbSize = is.readInt()) > 0) {
                if (bbbSize > 50000000) {
                    throw new IOException("transport notok " + bbbSize);
                }
                byte[] bbi = new byte[bbbSize];
                is.readFully(bbi);
                ByteArrayInputStream bis = new ByteArrayInputStream(bbi);
                SDataInputStream byteIS = new SDataInputStream(bis);
                while (byteIS.readBoolean()) {
                    isUpdated = true;
                    SEventFwd e = new SEventFwd();
                    e.readSv2(byteIS);
                    ++count;
                    if (e.getState() == '-') {
                        if (!BMUI.m_cleaningMode) {
                            this.m_eventStorage.addEvent(e);
                            continue;
                        }
                        DiskEventStorage.getActiveStorage().addEvents(e);
                        continue;
                    }
                    if (!BMUI.m_cleaningMode) {
                        this.m_eventStorage.addAcknowledgedInitial(e);
                        continue;
                    }
                    if (BMUI.m_ignoreClosedIndications) continue;
                    DiskEventStorage.getClosedStorage().addEvents(e);
                }
                this.startProgressBar("Loading active indications ... (" + count + ")");
                if (!BMUI.m_cleaningMode || count <= 10000) continue;
                count = 0;
                DiskEventStorage.getActiveStorage().flush();
                DiskEventStorage.getClosedStorage().flush();
            }
            res = is.readUTF();
            DiskEventStorage.getActiveStorage().flush();
            DiskEventStorage.getClosedStorage().flush();
        } else if (command.equals("GETUPDATEDELETED")) {
            os.writeUTF(command);
            int processed = 0;
            while (is.readBoolean()) {
                String s = is.readUTF();
                try {
                    String id = s.substring(0, 36);
                    char state = 'A';
                    try {
                        state = s.charAt(36);
                    }
                    catch (Throwable throwable) {}
                    if (BMUI.m_cleaningMode) {
                        DiskEventStorage.addClosed(id);
                    }
                    this.m_eventStorage.removeID(id, state);
                    ++processed;
                }
                catch (Throwable e) {
                    RTLogger.print(5, e.getMessage());
                }
                isUpdated = true;
            }
            res = is.readUTF();
            if (processed > 1) {
                RTLogger.print(4, "closed indications " + processed);
            }
        } else if (command.equals("GETUPDATEUPDATED_EXT")) {
            os.writeUTF("GETUPDATEUPDATED_EXT");
            while (is.readBoolean()) {
                SEventFwd e = new SEventFwd();
                e.readSv2(is);
                isUpdated = true;
                try {
                    if (BMUI.m_cleaningMode) continue;
                    this.m_eventStorage.updateEvent(e);
                }
                catch (Throwable throwable) {}
            }
            res = is.readUTF();
        } else if (command.equals("GETACKNMESSAGES_EXT") || command.equals("GETACKNMESSAGES_EXT_ZIP") && !this.m_isEXTZIP) {
            os.writeUTF("GETACKNMESSAGES_EXT");
            is.readInt();
            while (is.readBoolean()) {
                isUpdated = true;
                SEventFwd e = new SEventFwd();
                e.readSv2(is);
                this.m_eventStorage.addAcknowledged(e);
            }
            res = is.readUTF();
        } else if (command.equals("GETACKNMESSAGES_EXT_ZIP")) {
            os.writeUTF("GETACKNMESSAGES_EXT_ZIP");
            int bbbSize = -1;
            int count = 0;
            while ((bbbSize = is.readInt()) > 0) {
                if (bbbSize > 50000000) {
                    throw new IOException("transport notok " + bbbSize);
                }
                byte[] bbi = new byte[bbbSize];
                is.readFully(bbi);
                ByteArrayInputStream bis = new ByteArrayInputStream(bbi);
                SDataInputStream byteIS = new SDataInputStream(bis);
                while (byteIS.readBoolean()) {
                    isUpdated = true;
                    SEventFwd e = new SEventFwd();
                    e.readSv2(byteIS);
                    if (!BMUI.m_cleaningMode) {
                        this.m_eventStorage.addAcknowledgedInitial(e);
                    } else {
                        DiskEventStorage.getClosedStorage().addEvents(e);
                    }
                    ++count;
                }
                if (BMUI.m_cleaningMode) {
                    DiskEventStorage.getClosedStorage().flush();
                }
                this.startProgressBar("Loading closed indications ... (" + count + ")");
            }
            res = is.readUTF();
        } else if (command.equals("GETARCHIVED")) {
            os.writeUTF(command);
            try {
                while (is.readBoolean()) {
                    String id = is.readUTF();
                    if (BMUI.m_cleaningMode) {
                        DiskEventStorage.addArchived(id);
                    }
                    this.m_eventStorage.removeClosedID(id);
                    isUpdated = true;
                }
                res = is.readUTF();
            }
            catch (Throwable throwable) {}
        }
        if (!"T".equals(res)) {
            RTLogger.print(3, "Failed " + command);
        }
        return isUpdated;
    }

    protected boolean requestServerOutages(String command, SDataOutputStream os, SDataInputStream is) throws IOException {
        String res = "F";
        boolean isUpdated = false;
        if (command.equals("GETUPDATENEW_EXT_O")) {
            os.writeUTF(command);
            is.readInt();
            while (is.readBoolean()) {
                SEventFwd e = new SEventFwd();
                e.readSv2(is);
                if (e.getState() == '-') {
                    this.m_eventStorageOutage.addEvent(e);
                } else {
                    this.m_eventStorageOutage.addAcknowledged(e);
                }
                isUpdated = true;
            }
            res = is.readUTF();
        } else if (command.equals("GETACTIVEMESSAGES_EXT_ZIP_O")) {
            RTLogger.print(5, command);
            os.writeUTF(command);
            int bbbSize = -1;
            int count = 0;
            while ((bbbSize = is.readInt()) > 0) {
                byte[] bbi = new byte[bbbSize];
                is.readFully(bbi);
                ByteArrayInputStream bis = new ByteArrayInputStream(bbi);
                SDataInputStream byteIS = new SDataInputStream(bis);
                while (byteIS.readBoolean()) {
                    isUpdated = true;
                    SEventFwd e = new SEventFwd();
                    e.readSv2(byteIS);
                    ++count;
                    if (e.getState() == '-') {
                        this.m_eventStorageOutage.addEvent(e);
                        continue;
                    }
                    this.m_eventStorageOutage.addAcknowledgedInitial(e);
                }
                this.startProgressBar("Loading active maintenance indications ... (" + count + ")");
            }
            res = is.readUTF();
        } else if (command.equals("GETUPDATEDELETED_O")) {
            os.writeUTF(command);
            int processed = 0;
            while (is.readBoolean()) {
                String s = is.readUTF();
                try {
                    String id = s.substring(0, 36);
                    char state = 'A';
                    try {
                        state = s.charAt(36);
                    }
                    catch (Throwable throwable) {}
                    this.m_eventStorageOutage.removeID(id, state);
                    ++processed;
                }
                catch (Throwable e) {
                    RTLogger.print(5, e.getMessage());
                }
                isUpdated = true;
            }
            res = is.readUTF();
            if (processed > 1 && RTLogger.getCurrentLevel() >= 4) {
                RTLogger.print(4, "closed indications " + processed);
            }
        } else if (command.equals("GETUPDATEUPDATED_EXT_O")) {
            os.writeUTF(command);
            while (is.readBoolean()) {
                SEventFwd e = new SEventFwd();
                e.readSv2(is);
                isUpdated = true;
                this.m_eventStorageOutage.updateEvent(e);
            }
            res = is.readUTF();
        } else if (command.equals("GETACKNMESSAGES_EXT_ZIP_O")) {
            os.writeUTF(command);
            int bbbSize = -1;
            int count = 0;
            while ((bbbSize = is.readInt()) > 0) {
                byte[] bbi = new byte[bbbSize];
                is.readFully(bbi);
                ByteArrayInputStream bis = new ByteArrayInputStream(bbi);
                SDataInputStream byteIS = new SDataInputStream(bis);
                while (byteIS.readBoolean()) {
                    isUpdated = true;
                    SEventFwd e = new SEventFwd();
                    e.readSv2(byteIS);
                    this.m_eventStorageOutage.addAcknowledgedInitial(e);
                    ++count;
                }
                this.startProgressBar("Loading closed maintenance indications ... (" + count + ")");
            }
            res = is.readUTF();
        } else if (command.equals("GETARCHIVED_O")) {
            os.writeUTF(command);
            try {
                while (is.readBoolean()) {
                    String id = is.readUTF();
                    this.m_eventStorageOutage.removeClosedID(id);
                    isUpdated = true;
                }
                res = is.readUTF();
            }
            catch (Throwable throwable) {}
        }
        if (!res.equals("T")) {
            RTLogger.print(3, "Failed " + command);
        }
        return isUpdated;
    }

    /*
     * Unable to fully structure code
     */
    private void askForPending(SDataOutputStream os, SDataInputStream is) throws IOException {
        res = "F";
        os.writeUTF("GETPENDING");
        cmdArr = null;
        distinct = new ArrayList<String>();
        cmdList = new ArrayList<Object[]>();
        size = is.readInt();
        if (size > 10) {
            RTLogger.print(4, "pending " + size + " actions");
        }
        commandToProcess = null;
        i = 0;
        try {
            while (i < size) {
                block28: {
                    block27: {
                        commandToProcess = is.readUTF();
                        actionToProcess = is.readUTF();
                        if (actionToProcess.length() == 0) {
                            actionToProcess = null;
                        }
                        arr = null;
                        paramSize = is.readInt();
                        if (paramSize > 0) {
                            arr = new String[paramSize];
                            j = 0;
                            while (j < paramSize) {
                                arr[j] = is.readUTF();
                                ++j;
                            }
                        }
                        cmdArr = new Object[]{commandToProcess, actionToProcess, arr};
                        if (commandToProcess == null || actionToProcess != null || arr != null) break block27;
                        if (distinct.contains(commandToProcess)) break block28;
                        distinct.add(commandToProcess);
                    }
                    cmdList.add(cmdArr);
                    if ("FORCE_EXIT".equals(commandToProcess) && !Repository.m_user.equals(user = actionToProcess)) {
                        this.forceExit(user);
                    }
                }
                ++i;
            }
            res = is.readUTF();
            if (!res.equals("T")) {
                RTLogger.print(3, "Failed GETPENDING");
            }
        }
        catch (Throwable v0) {
            RTLogger.print(3, "Pending failed on number: " + i + " lastSuccessCmd:" + commandToProcess);
        }
        if (cmdList.size() > 5) {
            RTLogger.print(5, "distinct pending actions" + cmdList.size());
        }
        i = 0;
        while (i < cmdList.size()) {
            block29: {
                arr = (Object[])cmdList.get(i);
                cmdToProcess = (String)arr[0];
                RTLogger.print(5, "Processing pending cmd : " + cmdToProcess);
                if (!this.m_isOldServer && cmdToProcess.equals("REFRESH_ACKNMESSAGES")) break block29;
                delay = 0;
                actionToProcess = (String)arr[1];
                if (!"GETAGENTCARDS".equals(cmdToProcess)) ** GOTO lbl71
                if (actionToProcess == null) {
                    ssc = new ScGetAgentCards(Repository.getInstance(), AgentCard.class);
                    if (!Repository.getJobManager().isScheduledOrDelayedOrRunning(ssc)) {
                        diffWithLastGAC = System.currentTimeMillis() - this.m_lastGetAgentCardsCommand;
                        if (diffWithLastGAC < (long)(BMUI.m_minRefreshTime * 1000)) {
                            delay = (int)((long)(BMUI.m_minRefreshTime * 1000) - diffWithLastGAC);
                        } else {
                            this.m_lastGetAgentCardsCommand = System.currentTimeMillis();
                        }
                        RTLogger.print(5, "GAC will be scheduled " + delay);
                        ssc.addCmdPostProcess(Repository.getInstance());
                        Repository.getJobManager().schedule(ssc, delay);
                    } else {
                        RTLogger.print(5, "GAC skipped 1");
                    }
                } else {
                    cmdToProcess = "GETAGENTCARD_SINGLE";
lbl71:
                    // 2 sources

                    if ("SHOW_MESSAGE".equals(cmdToProcess)) {
                        this.showMessage(arr, actionToProcess);
                    } else if ("GET_ANYUPDATE".equals(cmdToProcess)) {
                        Repository.scheduleAnyUpdate();
                    } else if (!Repository.getInstance().getCmdRouter().informCmdListeners(cmdToProcess, actionToProcess)) {
                        if ("GET_ALL_ASSIGNMENTS".equals(cmdToProcess)) {
                            delay = 5000;
                        }
                        sc = new ServerClient(cmdToProcess, actionToProcess, (String[])arr[2]);
                        Repository.getJobManager().schedule(sc, delay);
                    }
                }
            }
            ++i;
        }
    }

    private void showMessage(Object[] arr, String actionToProcess) {
        final String user = actionToProcess;
        if (Repository.m_user.equals(user)) {
            return;
        }
        final String[] msgs = (String[])arr[2];
        UIJob job = new UIJob("Message " + System.currentTimeMillis()){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                HashMap<String, String> vars = new HashMap<String, String>();
                StringBuffer sb = new StringBuffer();
                int k = 0;
                while (k < msgs.length) {
                    if (msgs[k].contains("SEPARATOR")) {
                        try {
                            String[] pa = msgs[k].split("\\QSEPARATOR\\E");
                            vars.put(pa[0], pa[1]);
                        }
                        catch (Throwable throwable) {}
                    } else {
                        sb.append(msgs[k]);
                        if (k < msgs.length - 1) {
                            sb.append("\r\n");
                        }
                    }
                    ++k;
                }
                SendMessageDialog smd = new SendMessageDialog(user, sb.toString());
                smd.setBlockOnOpen(false);
                smd.open();
                return Status.OK_STATUS;
            }
        };
        Repository.getUIJobManager().schedule(job);
    }

    private void forceExit(final String user) {
        this.isONLINE.set(false);
        UIJob ui = new UIJob("ForceExit"){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    RTLogger.print(1, "GUI will exit now! Exit forced by user: " + user);
                    ProgressDialog pd = new ProgressDialog("GUI will exit now!", "Exit forced by user: " + user, 0, 5);
                    pd.setBlockOnOpen(false);
                    pd.open();
                    int i = 1;
                    while (i < 6) {
                        try {
                            GuiClient.sleep(1000L);
                        }
                        catch (Throwable throwable) {}
                        pd.setProgress("Exit forced by user: " + user, i);
                        ++i;
                    }
                    try {
                        PlatformUI.getWorkbench().close();
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        Repository.getUIJobManager().schedule(ui);
        try {
            GuiClient.sleep(15000L);
        }
        catch (Throwable throwable) {}
        System.exit(0);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setMessage(String message, boolean isERROR) {
        try {
            StatusJob mag = new StatusJob("StatusUpdate");
            mag.m_message = message;
            mag.m_isERROR = isERROR;
            UIJobManager.getInstance().schedule(mag);
        }
        catch (Throwable throwable) {}
    }

    private void setStatus(boolean isGreen) {
        try {
            UIJobManager.getInstance().schedule(new StatusJob1("STLIGHT", isGreen));
        }
        catch (Throwable throwable) {}
    }

    private void startProgressBar(String message) {
        if (BMUI.m_LoadIndiStatusBarShow && !BMUI.m_cleaningMode) {
            ProgressBarJob pbJob = new ProgressBarJob("PBUpdateStart-" + System.currentTimeMillis() / 1000L, message);
            UIJobManager.getInstance().schedule(pbJob);
        }
    }

    private void stopProgressBar() {
        if (BMUI.m_LoadIndiStatusBarShow && !BMUI.m_cleaningMode) {
            ProgressBarJob pbJob = new ProgressBarJob("PBUpdateStop");
            UIJobManager.getInstance().schedule(pbJob);
        }
    }

    private void refreshData() {
        UIJob ui = new UIJob("RefreshData"){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                HashMap<Integer, Integer> userRrights_bkp = new HashMap<Integer, Integer>();
                userRrights_bkp.put(1000, Repository.getInstance().getRights(1000));
                userRrights_bkp.put(2016, Repository.getInstance().getRights(2016));
                userRrights_bkp.put(1002, Repository.getInstance().getRights(1002));
                userRrights_bkp.put(1001, Repository.getInstance().getRights(1001));
                userRrights_bkp.put(1008, Repository.getInstance().getRights(1008));
                userRrights_bkp.put(1006, Repository.getInstance().getRights(1006));
                userRrights_bkp.put(1007, Repository.getInstance().getRights(1007));
                userRrights_bkp.put(1004, Repository.getInstance().getRights(1004));
                userRrights_bkp.put(1009, Repository.getInstance().getRights(1009));
                userRrights_bkp.put(2003, Repository.getInstance().getRights(2003));
                userRrights_bkp.put(2004, Repository.getInstance().getRights(2004));
                userRrights_bkp.put(2010, Repository.getInstance().getRights(2010));
                userRrights_bkp.put(2011, Repository.getInstance().getRights(2011));
                userRrights_bkp.put(2012, Repository.getInstance().getRights(2012));
                userRrights_bkp.put(2014, Repository.getInstance().getRights(2014));
                userRrights_bkp.put(ServiceDashBoardProvider.VIEW_ID, Repository.getInstance().getRights(ServiceDashBoardProvider.VIEW_ID));
                userRrights_bkp.put(DashBoardServicesView.VIEW_ID, Repository.getInstance().getRights(1000));
                userRrights_bkp.put(1010, Repository.getInstance().getRights(1010));
                userRrights_bkp.put(1003, Repository.getInstance().getRights(1003));
                try {
                    Repository.getInstance().fetchUserRole();
                }
                catch (ConnectionException connectionException) {}
                ApplicationWorkbenchWindowAdvisor.m_instance.postWindowOpen();
                IWorkbenchWindow[] arr = Activator.getDefault().getWorkbench().getWorkbenchWindows();
                int oldRights = (Integer)userRrights_bkp.get(1000);
                int currentRights = Repository.getInstance().getRights(1000);
                if (currentRights <= 1) {
                    try {
                        try {
                            IViewReference wp = MessagesView.getInstance().getSite().getPage().findViewReference("com.blixx.boom.gui.views.msgview", "MsgView2");
                            MessagesView.getInstance().getSite().getPage().hideView(wp);
                        }
                        catch (Throwable throwable) {}
                        this.closeView(arr, (IViewPart)MessagesView.getInstance(), "com.blixx.boom.gui.views.msgview");
                    }
                    catch (Throwable throwable) {}
                    try {
                        this.closeView(arr, (IViewPart)DashBoardView2.getInstance(), "com.blixx.boom.gui.views.dashboardview2");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(2016);
                currentRights = Repository.getInstance().getRights(2016);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, (IViewPart)MaintenanceView.getInstance(), "com.blixx.boom.gui.views.MaintenanceView");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(1002);
                currentRights = Repository.getInstance().getRights(1002);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, (IViewPart)AgentCardView.getInstance(), "com.blixx.boom.gui.views.agentcardview");
                    }
                    catch (Throwable throwable) {}
                    try {
                        this.closeView(arr, (IViewPart)NodeListView.getInstance(), "com.blixx.boom.gui.views.nodelistview");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights <= 1) {
                    GuiClient.this.processCommand("GETAGENTCARDS", true);
                } else {
                    GuiClient.this.processCommand("GETAGENTCARDS", true);
                    try {
                        AgentCardView.getInstance().closeOpenTabs("CLOSE_ALL");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(1001);
                currentRights = Repository.getInstance().getRights(1001);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, (IViewPart)PolicyView.getInstance(), "com.blixx.boom.gui.views.policyview");
                    }
                    catch (Throwable throwable) {}
                    try {
                        this.closeView(arr, (IViewPart)PolicyListView.getInstance(), "com.blixx.boom.gui.views.policylistview");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights <= 1) {
                    GuiClient.this.processCommand("GETPOLICIES", true);
                } else {
                    GuiClient.this.processCommand("GETPOLICIES", true);
                    try {
                        PolicyView.getInstance().closeOpenTabs();
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(1008);
                currentRights = Repository.getInstance().getRights(1008);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, (IViewPart)AssignmentListView.getInstance(), "com.blixx.boom.gui.views.assignmentlistview");
                    }
                    catch (Throwable throwable) {}
                    try {
                        this.closeView(arr, (IViewPart)AssignmentsSummaryView.getInstance(), "com.blixx.boom.gui.views.assignmentssummaryview");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights <= 1) {
                    GuiClient.this.processCommand("GETASSIGNMENTS", true);
                } else {
                    GuiClient.this.processCommand("GETASSIGNMENTS", true);
                }
                oldRights = (Integer)userRrights_bkp.get(1007);
                currentRights = Repository.getInstance().getRights(1007);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, (IViewPart)ActionsListView.getInstance(), "com.blixx.boom.gui.views.actlistview");
                    }
                    catch (Throwable throwable) {}
                    try {
                        this.closeView(arr, (IViewPart)ActionView.getInstance(), "com.blixx.boom.gui.views.actionview");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights <= 1) {
                    GuiClient.this.processCommand("GETACTIONS", true);
                } else {
                    GuiClient.this.processCommand("GETACTIONS", true);
                    try {
                        this.closeView(arr, (IViewPart)ActionView.getInstance(), "com.blixx.boom.gui.views.actionview");
                    }
                    catch (Throwable throwable) {}
                }
                GuiClient.this.processCommand("GET_HELPS", true);
                oldRights = (Integer)userRrights_bkp.get(1009);
                currentRights = Repository.getInstance().getRights(1009);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, (IViewPart)ServerFilterView.getInstance(), "com.blixx.boom.gui.views.serverfilterview");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights <= 1) {
                    GuiClient.this.processCommand("GET_FORWARD_FILTERS", false);
                    GuiClient.this.processCommand("GET_FORWARD_POLICIES", true);
                } else {
                    GuiClient.this.processCommand("GET_FORWARD_FILTERS", false);
                    GuiClient.this.processCommand("GET_FORWARD_POLICIES", true);
                    try {
                        this.closeView(arr, (IViewPart)ServerFilterView.getInstance(), "com.blixx.boom.gui.views.serverfilterview");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(1006);
                currentRights = Repository.getInstance().getRights(1006);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, (IViewPart)BinariesListView.getInstance(), "com.blixx.boom.gui.views.binlistview");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights <= 1) {
                    BinariesListView.getInstance().refreshTree(true);
                } else {
                    BinariesListView.getInstance().refreshTree(true);
                    try {
                        IEditorReference[] editors = BinariesListView.getInstance().getSite().getPage().getEditorReferences();
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditors(editors, false);
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(1010);
                currentRights = Repository.getInstance().getRights(1010);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, (IViewPart)NodeGroupsView.getInstance(), "com.blixx.boom.gui.graph.nodegroupsview");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights > 1) {
                    try {
                        this.closeView(arr, (IViewPart)NodeGroupsView.getInstance(), "com.blixx.boom.gui.graph.nodegroupsview");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(DashBoardServicesView.VIEW_ID);
                currentRights = Repository.getInstance().getRights(DashBoardServicesView.VIEW_ID);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, (IViewPart)DashBoardServicesView.getInstance(), "com.blixx.boom.gui.views.dashboardcustomerview");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights > 1) {
                    try {
                        this.closeView(arr, (IViewPart)DashBoardServicesView.getInstance(), "com.blixx.boom.gui.views.dashboardcustomerview");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(1003);
                currentRights = Repository.getInstance().getRights(1003);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, (IViewPart)PerfView.getInstance(), "com.blixx.boom.gui.views.perfview");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights > 1) {
                    try {
                        this.closeView(arr, (IViewPart)PerfView.getInstance(), "com.blixx.boom.gui.views.perfview");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(1004);
                currentRights = Repository.getInstance().getRights(1004);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, (IViewPart)UserManagementView.getInstance(), "com.blixx.boom.authentication.usermanagementview");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights <= 1) {
                    GuiClient.this.processCommand("GET_USERS", true);
                } else {
                    GuiClient.this.processCommand("GET_USERS", true);
                    try {
                        this.closeView(arr, (IViewPart)UserManagementView.getInstance(), "com.blixx.boom.authentication.usermanagementview");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(2003);
                currentRights = Repository.getInstance().getRights(2003);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, (IViewPart)ServerJobsView.getInstance(), "com.blixx.boom.gui.views.serverjobsview");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights > 1) {
                    try {
                        this.closeView(arr, (IViewPart)ServerJobsView.getInstance(), "com.blixx.boom.gui.views.serverjobsview");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(2004);
                currentRights = Repository.getInstance().getRights(2004);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, null, "com.blixx.boom.gui.views.configurationview");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights > 1) {
                    try {
                        this.closeView(arr, null, "com.blixx.boom.gui.views.configurationview");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(2010);
                currentRights = Repository.getInstance().getRights(2010);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, null, "com.blixx.boom.gui.views.agentScheduledMaintenanceView");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights > 1) {
                    try {
                        this.closeView(arr, null, "com.blixx.boom.gui.views.agentScheduledMaintenanceView");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(2011);
                currentRights = Repository.getInstance().getRights(2011);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, null, "com.blixx.boom.gui.views.agentAdHocMaintenanceView");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights > 1) {
                    try {
                        this.closeView(arr, null, "com.blixx.boom.gui.views.agentAdHocMaintenanceView");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(2012);
                currentRights = Repository.getInstance().getRights(2012);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, null, "com.blixx.boom.gui.views.serverPolicyView");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights > 1) {
                    try {
                        this.closeView(arr, null, "com.blixx.boom.gui.views.serverPolicyView");
                    }
                    catch (Throwable throwable) {}
                }
                oldRights = (Integer)userRrights_bkp.get(2014);
                currentRights = Repository.getInstance().getRights(2014);
                if (currentRights <= 1) {
                    try {
                        this.closeView(arr, null, "com.blixx.boom.gui.notify.NotificationView");
                    }
                    catch (Throwable throwable) {}
                } else if (oldRights > 1) {
                    try {
                        this.closeView(arr, null, "com.blixx.boom.gui.notify.NotificationView");
                    }
                    catch (Throwable throwable) {}
                }
                ScGetUserAttributes scgua = new ScGetUserAttributes(Repository.getInstance());
                scgua.addCmdPostProcess(Repository.getInstance());
                scgua.start();
                Repository.getInstance().requestServerTime();
                ApplicationActionBarAdvisor.refreshCoolBar();
                ApplicationActionBarAdvisor.showHotSpotAction.setEnabled(true);
                return null;
            }

            private void closeView(IWorkbenchWindow[] arr, IViewPart view, String ID) {
                if (arr == null) {
                    return;
                }
                int i = 0;
                while (i < arr.length) {
                    IWorkbenchPage[] arrP = arr[i].getPages();
                    if (arrP != null) {
                        int j = 0;
                        while (j < arrP.length) {
                            try {
                                arrP[j].hideView(view);
                            }
                            catch (Throwable throwable) {}
                            try {
                                arrP[j].hideView(arrP[j].findViewReference(ID));
                            }
                            catch (Throwable throwable) {}
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        };
        Repository.getUIJobManager().schedule(ui);
    }

    private void processCommand(String commandToProcess, boolean processRepository) {
        ServerClient sc = new ServerClient(commandToProcess, null, null);
        Repository.getJobManager().schedule(sc);
    }

    public void resetLastRefreshTime() {
        this.m_lastGetAgentCardsCommand = 0L;
    }

    public void stopClient() {
        this.m_uiRunning = false;
        try {
            this.m_sock.close();
        }
        catch (Throwable throwable) {}
        while (!this.m_stopped) {
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {}
        }
        m_client = null;
    }

    public boolean isONLINE() {
        return this.isONLINE.get();
    }
}

