/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.Repository;
import com.blixx.shared.utils.HashMapArray;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class HostsTableProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private ArrayList<Map<String, Object>> m_hosts = new ArrayList();
    private ArrayList<String> m_columnNames = new ArrayList();
    private String m_agentHostName = null;

    public HostsTableProvider(String agentHostName, String[] columns) {
        this.m_agentHostName = agentHostName;
        int i = 0;
        while (i < columns.length) {
            this.m_columnNames.add(columns[i]);
            ++i;
        }
    }

    public void refresh() {
        this.m_hosts.clear();
        HashMapArray<String, Integer> hosts = Repository.getEventsSummary().getHosts();
        TreeSet<String> hostNames = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1 == null ? 0 : o1.compareToIgnoreCase(o2);
            }
        });
        hostNames.addAll(hosts.keySet());
        for (String key : hostNames) {
            if (!key.endsWith(String.valueOf('\u25ba') + this.m_agentHostName)) continue;
            TreeMap<String, Object> m = new TreeMap<String, Object>();
            m.put(this.m_columnNames.get(0), key.replace(String.valueOf('\u25ba') + this.m_agentHostName, ""));
            List<Integer> sevs = hosts.getArray(key);
            int i = 0;
            while (i < sevs.size()) {
                m.put(this.m_columnNames.get(i + 1), sevs.get(i));
                ++i;
            }
            this.m_hosts.add(m);
        }
    }

    public Object[] getElements(Object inputElement) {
        this.refresh();
        return this.m_hosts.toArray();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        Map assignment = (Map)element;
        return "" + assignment.get(this.m_columnNames.get(columnIndex));
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.refresh();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

