/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.ctrl.sc.IRunnableExt;
import com.blixx.log.RTLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class JobManager
extends Thread {
    public static int m_maxThreads = 3;
    public LinkedBlockingQueue<IRunnableExt> m_queue = new LinkedBlockingQueue();
    public Map<IRunnableExt, Long> m_queueDelayed = new ConcurrentHashMap<IRunnableExt, Long>(5);
    public List<IRunnableExt> m_queueRunning = new ArrayList<IRunnableExt>(m_maxThreads);
    private Object m_lock = new Object();
    private static JobManager m_instance = null;
    boolean isPaused = false;
    private static final RTLogger logger = new RTLogger(JobManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobManager getInstance() {
        if (m_instance != null) return m_instance;
        Class<JobManager> clazz = JobManager.class;
        synchronized (JobManager.class) {
            if (m_instance != null) return m_instance;
            m_instance = new JobManager("JobManager");
            m_instance.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instance;
        }
    }

    private JobManager() {
    }

    private JobManager(IRunnableExt target, String name) {
        super((Runnable)target, name);
    }

    private JobManager(IRunnableExt target) {
        super(target);
    }

    private JobManager(String name) {
        super(name);
    }

    private JobManager(ThreadGroup group, IRunnableExt target, String name, long stackSize) {
        super(group, target, name, stackSize);
    }

    private JobManager(ThreadGroup group, IRunnableExt target, String name) {
        super(group, target, name);
    }

    private JobManager(ThreadGroup group, IRunnableExt target) {
        super(group, target);
    }

    private JobManager(ThreadGroup group, String name) {
        super(group, name);
    }

    public int getQueueSize() {
        return this.m_queue.size();
    }

    public int getQueueDelayedSize() {
        return this.m_queueDelayed.size();
    }

    public boolean isScheduledOrDelayedOrRunning(IRunnableExt client) {
        return this.m_queueDelayed.containsKey(client) || this.m_queue.contains(client) || this.m_queueRunning.contains(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(IRunnableExt client, long delay_ms) {
        long scheduledStart = System.currentTimeMillis() + delay_ms;
        Long scheduledStartStored = this.m_queueDelayed.get(client);
        if (scheduledStartStored == null) {
            this.m_queueDelayed.put(client, scheduledStart);
            Object object = this.m_lock;
            synchronized (object) {
                this.m_lock.notifyAll();
            }
        }
        if (scheduledStartStored > scheduledStart) {
            this.m_queueDelayed.put(client, scheduledStart);
            Object object = this.m_lock;
            synchronized (object) {
                this.m_lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void schedule(IRunnableExt client) {
        if (client != null && !this.m_queue.contains(client) && !this.m_queueDelayed.containsKey(client)) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Throwable v0) {}
lbl7:
            // 3 sources

            ** while (!this.m_queue.add((IRunnableExt)client))
        }
lbl8:
        // 1 sources

        var2_2 = this.m_lock;
        synchronized (var2_2) {
            this.m_lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (this.m_queue.size() == 0 && this.m_queueDelayed.size() == 0) {
                Object object = this.m_lock;
                synchronized (object) {
                    try {
                        this.m_lock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.isInterrupted()) {
                        break;
                    }
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {}
            if (this.isPaused) {
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {}
                if (!this.isInterrupted()) continue;
                break;
            }
            try {
                Iterator<IRunnableExt> it = this.m_queueRunning.iterator();
                while (it.hasNext()) {
                    IRunnableExt running = it.next();
                    if (!running.isFinished()) continue;
                    it.remove();
                }
                if (this.m_queueRunning.size() < m_maxThreads) {
                    Iterator<Map.Entry<IRunnableExt, Long>> itc = this.m_queueDelayed.entrySet().iterator();
                    while (itc.hasNext()) {
                        Map.Entry<IRunnableExt, Long> en = itc.next();
                        if (System.currentTimeMillis() < en.getValue()) continue;
                        this.m_queue.add(en.getKey());
                        itc.remove();
                    }
                    IRunnableExt job = this.m_queue.poll();
                    if (job != null) {
                        if (this.m_queueRunning.contains(job)) {
                            RTLogger.print(5, "JobDelayAlreadyRunning " + job);
                            this.schedule(job, 1000L);
                        } else {
                            job.start();
                            RTLogger.print(5, "JobStart " + job);
                            this.m_queueRunning.add(job);
                        }
                    }
                } else {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable throwable) {}
            if (this.m_queue.size() <= 10) continue;
            logger.trace("JM queue sizes: {}", (Object)this.m_queue.size());
        }
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void setPaused(boolean isPaused) {
        this.isPaused = isPaused;
    }

    public void clean() {
        try {
            this.m_queue.clear();
            this.m_queueDelayed.clear();
        }
        catch (Throwable throwable) {}
    }
}

