/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.BMUI;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class MonitorHistoryTableProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private List<String> m_columnNames = new ArrayList<String>();
    private List<SEvent> m_events = null;

    public MonitorHistoryTableProvider(String[] columns, List<SEvent> events) {
        int i = 0;
        while (i < columns.length) {
            this.m_columnNames.add(columns[i]);
            ++i;
        }
        this.m_events = events;
    }

    public void refresh() {
    }

    public Object[] getElements(Object inputElement) {
        this.refresh();
        return this.m_events.toArray();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        SEvent e = (SEvent)element;
        if (columnIndex == 0) {
            switch (e.getSeverityInt()) {
                case 5: {
                    image = BMUI.IMAGE_CRITICAL;
                    break;
                }
                case 4: {
                    image = BMUI.IMAGE_MAJOR;
                    break;
                }
                case 3: {
                    image = BMUI.IMAGE_MINOR;
                    break;
                }
                case 2: {
                    image = BMUI.IMAGE_WARNING;
                    break;
                }
                case 1: {
                    image = BMUI.IMAGE_NORMAL;
                    break;
                }
                case 0: {
                    image = BMUI.IMAGE_UNKNOWN;
                    break;
                }
                case -1: {
                    image = BMUI.IMAGE_CRITICAL_F;
                    break;
                }
                case -2: {
                    image = BMUI.IMAGE_MAJOR_F;
                    break;
                }
                case -3: {
                    image = BMUI.IMAGE_MINOR_F;
                    break;
                }
                case -4: {
                    image = BMUI.IMAGE_WARNING_F;
                    break;
                }
                case -5: {
                    image = BMUI.IMAGE_NORMAL_F;
                    break;
                }
                case -6: {
                    image = BMUI.IMAGE_UNKNOWN_F;
                    break;
                }
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        SEvent e = (SEvent)element;
        String label = MonitorHistoryTableProvider.getLabel(e, columnIndex);
        return label;
    }

    public static String getLabel(SEvent e, int columnNumber) {
        String res = "";
        block0 : switch (columnNumber) {
            case 0: {
                res = e.getSeverity();
                break;
            }
            case 1: {
                res = "" + e.getDuplicates();
                break;
            }
            case 2: {
                Date d = new Date(e.getFirstTime());
                res = BMUI.m_sdf_milliSec.format(d);
                break;
            }
            case 3: {
                Date d1 = new Date(e.getTime());
                res = BMUI.m_sdf_milliSec.format(d1);
                break;
            }
            case 4: {
                res = e.getText();
                break;
            }
            case 5: {
                if (e.getValue() == -1.0 && e.getMonitor().length() == 0) {
                    res = "";
                    break;
                }
                res = "" + e.getValue();
                break;
            }
            case 6: {
                if (e instanceof SEventFwd) {
                    SEventFwd sef = (SEventFwd)e;
                    if (sef.getTFA() == 0L) {
                        res = "";
                        break;
                    }
                    res = "" + sef.getVFA();
                    break;
                }
                res = "";
                break;
            }
            case 7: {
                if (e instanceof SEventFwd) {
                    SEventFwd sef = (SEventFwd)e;
                    if (sef.getTFA() == 0L) {
                        res = "";
                        break;
                    }
                    Date d2 = new Date(sef.getTFA());
                    res = BMUI.m_sdf_milliSec.format(d2);
                    break;
                }
                res = "";
                break;
            }
            case 8: {
                Date d3 = new Date(e.getSTime());
                res = BMUI.m_sdf_milliSec.format(d3);
                break;
            }
            case 9: {
                res = "Unknown";
                switch (e.getState()) {
                    case 'A': {
                        res = "Auto Closed Message";
                        break block0;
                    }
                    case 'O': {
                        res = "Closed By Operator";
                        break block0;
                    }
                    case '-': {
                        res = "Active";
                        break block0;
                    }
                    case 'D': {
                        res = "Archived";
                        break block0;
                    }
                }
                break;
            }
            case 10: {
                res = e.getNode();
                break;
            }
        }
        return res;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.refresh();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

