/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.RefreshAgentTreeUIJob;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class NodeGroupFileJob
extends Job {
    public static final Object lock = new Object();

    public NodeGroupFileJob(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        Object object = lock;
        synchronized (object) {
            String dstr = "";
            String ngXML = "";
            try {
                ngXML = FileUtils.readFile(new File(String.valueOf(Repository.getUserTmpDirectory()) + "/" + "nodeGroups.xml"));
            }
            catch (IOException iOException) {}
            try {
                MessageDigest algorithm = MessageDigest.getInstance("MD5");
                algorithm.reset();
                algorithm.update(ngXML.getBytes());
                byte[] digest = algorithm.digest();
                dstr = new String(digest);
                if (Repository.getInstance().m_nodeGroupLastDigest != null && Repository.getInstance().m_nodeGroupLastDigest.equals(dstr)) {
                    LinkedList<String> processedPathes = new LinkedList<String>();
                    HashMap<String, String> processedAgentIDs = new HashMap<String, String>();
                    List<GroupTreeObject> list = Repository.getInstance().getNodeGroupTree().getAllElements();
                    LinkedList<GroupTreeObject> refreshList = new LinkedList<GroupTreeObject>();
                    int i = 0;
                    while (i < list.size()) {
                        GroupTreeObject o = list.get(i);
                        if (!(o instanceof GroupTreeObjectLast)) {
                            processedPathes.add(o.getPath());
                        } else {
                            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                            String agentID = gtol.getLinkedPath();
                            if (agentID != null) {
                                processedAgentIDs.put(agentID, agentID);
                                GroupTreeObject parent = gtol.getParent();
                                while (parent != Repository.getInstance().getNodeGroupTree()) {
                                    Repository.getInstance().m_nodeGroups_pathToID.putV(parent.getPath(), agentID);
                                    Repository.getInstance().m_nodeGroups_IDToPath.putV(agentID, parent.getPath());
                                    parent = parent.getParent();
                                }
                                AgentCard ac = Repository.getInstance().getAgentCard(agentID);
                                if (ac != null && !(gtol.getTreeObject() instanceof AgentCard)) {
                                    gtol.setTreeObject(ac);
                                    refreshList.add(gtol);
                                } else if (ac == null) {
                                    gtol.setName(agentID);
                                    refreshList.add(gtol);
                                }
                            }
                        }
                        ++i;
                    }
                    Repository.getInstance().m_nodeGroups_IDToPath.keySet().retainAll(processedAgentIDs.keySet());
                    Repository.getInstance().m_nodeGroups_IDToPath.retainFromAllMaps(processedPathes);
                    Repository.getInstance().m_nodeGroups_pathToID.retainFromAllMaps(processedAgentIDs.keySet());
                    if (refreshList.size() > 0) {
                        Repository.getInstance().getNodeGroupTree().sortElementsRecursive();
                        RefreshAgentTreeUIJob uijob = new RefreshAgentTreeUIJob(true, refreshList);
                        Repository.getUIJobManager().schedule(uijob);
                    } else {
                        refreshList.add(Repository.getInstance().getNodeGroupTree());
                        RefreshAgentTreeUIJob uijob = new RefreshAgentTreeUIJob(false, refreshList);
                        Repository.getUIJobManager().schedule(uijob);
                    }
                    return Status.OK_STATUS;
                }
            }
            catch (Throwable e1) {
                RTLogger.print(3, "NGR1 ", e1);
            }
            try {
                RTLogger.print(4, " - NodeGroupParsing  start");
                XMLTree xt = new XMLTree();
                GroupTreeObject parsedXML = xt.parseXML(new ByteArrayInputStream(ngXML.getBytes()), true);
                GroupTreeObject incoming_Groups = parsedXML.getChild("_Groups", BMUI.type_folder);
                List<GroupTreeObject> elements = incoming_Groups.getElements();
                Repository.getInstance().getNodeGroupTree().clean();
                Repository.getInstance().getNodeGroupTree().clearAttributes();
                if (elements != null && elements.size() > 0) {
                    Map<String, String> attributes = incoming_Groups.getAttributes();
                    if (attributes != null) {
                        for (Map.Entry<String, String> aatr : attributes.entrySet()) {
                            Repository.getInstance().getNodeGroupTree().setAttribute(aatr.getKey(), aatr.getValue());
                        }
                    }
                    Repository.getInstance().getNodeGroupTree().addElements(elements);
                    RTLogger.print(6, " - NodeGroupParsing  1");
                    for (GroupTreeObjectLast o : Repository.getInstance().getNodeGroupTree().getAllGTOLs()) {
                        GroupTreeObjectLast gtol = o;
                        String agentID = gtol.getLinkedPath();
                        if (agentID == null) continue;
                        AgentCard ac = Repository.getInstance().getAgentCard(agentID);
                        if (ac != null) {
                            gtol.setTreeObject(ac);
                            continue;
                        }
                        ITreeObject nodename = gtol.getTreeObject();
                        if (nodename != null && nodename.getObject() != null && !"".equals(nodename.getObject())) {
                            gtol.setName(nodename.getObject().toString());
                        }
                        gtol.setIcon("IMAGE_PC_REG");
                    }
                    RTLogger.print(4, " - NodeGroupParsing  end. nodegroups: %s, %s", elements.size(), Repository.getInstance().getNodeGroupTree().getElements().size());
                } else {
                    RTLogger.print(4, " - NodeGroupParsing no groups found");
                }
                AgentCard.m_lastNodeGroupsRefresh.set(System.currentTimeMillis());
                Repository.getInstance().getNodeGroupTree().sortElementsRecursive();
                RefreshAgentTreeUIJob uijob = new RefreshAgentTreeUIJob(true, elements);
                Repository.getUIJobManager().schedule(uijob);
                Repository.getInstance().m_nodeGroupLastDigest = dstr;
            }
            catch (Throwable e) {
                RTLogger.print(5, "NGR2 ", e);
            }
        }
        return Status.OK_STATUS;
    }
}

