/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.settings.GenAttribute;
import com.blixx.boom.gui.settings.GenAttributeProps;
import com.blixx.boom.gui.settings.UISettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.StatusLineManager;

public class ProgressBarJob
extends UIJob {
    public static StatusLineManager statusLineManager;
    private boolean start = true;
    private String message;

    public ProgressBarJob(String uiJobName) {
        super(uiJobName);
        this.start = false;
    }

    public ProgressBarJob(String uiJobName, String message) {
        super(uiJobName);
        this.message = message;
        this.start = true;
    }

    @Override
    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (this.start) {
            try {
                GenAttribute ga = UISettings.getInstance().getGenAttributes().get(GenAttributeProps.GEN_SHOW_LOADINDI_PROGRESSBAR);
                if (statusLineManager != null && (ga == null || "true".equalsIgnoreCase(ga.getValue()))) {
                    IProgressMonitor progressMonitor = statusLineManager.getProgressMonitor();
                    progressMonitor.beginTask(this.message, -1);
                    statusLineManager.setMessage(this.message);
                }
            }
            catch (Throwable throwable) {}
        } else {
            try {
                if (statusLineManager != null) {
                    IProgressMonitor progressMonitor = statusLineManager.getProgressMonitor();
                    progressMonitor.done();
                }
            }
            catch (Throwable throwable) {}
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ProgressBarJob) {
            ProgressBarJob pj = (ProgressBarJob)obj;
            return this.getName() == null ? pj.getName() == null : this.getName().equals(pj.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.start ? 1 : 2;
    }
}

