/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.AgentOverviewTableRefreshJobLight;
import com.blixx.boom.engine.AgentTreeRefreshJobLite;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.CmdRouter;
import com.blixx.boom.engine.EventStatusRefreshJob;
import com.blixx.boom.engine.EventStorage;
import com.blixx.boom.engine.EventStorageOutage;
import com.blixx.boom.engine.GActionsRepository;
import com.blixx.boom.engine.GAssignments;
import com.blixx.boom.engine.GuiClient;
import com.blixx.boom.engine.ICommandListener;
import com.blixx.boom.engine.IEventProvider;
import com.blixx.boom.engine.IEventStorageSubmit;
import com.blixx.boom.engine.IEventsSummary;
import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.NodeGroupFileJob;
import com.blixx.boom.engine.RefreshAgentTreeUIJob;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.engine.ServiceDashBoardProvider;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.exception.ConnectionException;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.FFilterManager;
import com.blixx.boom.gui.policies.FPolicyManager;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.settings.BrowserLabelManager;
import com.blixx.boom.gui.utils.ScErrorShowMessage;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.boom.gui.views.ActionTab;
import com.blixx.boom.gui.views.ActionView;
import com.blixx.boom.gui.views.AgentCardView;
import com.blixx.boom.gui.views.AgentTab;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.boom.gui.views.NodeListView;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.SCParametersException;
import com.blixx.ctrl.sc.auth.ScGetUserRole;
import com.blixx.ctrl.sc.in.ScAddNodeGroup;
import com.blixx.ctrl.sc.in.ScDeleteNodeGroup;
import com.blixx.ctrl.sc.in.ScGetAgentCMLabels;
import com.blixx.ctrl.sc.in.ScGetAgentCardSingle;
import com.blixx.ctrl.sc.in.ScGetAgentCards;
import com.blixx.ctrl.sc.in.ScGetAgentInventoryCard;
import com.blixx.ctrl.sc.in.ScGetAgentVersions;
import com.blixx.ctrl.sc.in.ScGetAllAsn;
import com.blixx.ctrl.sc.in.ScGetAssigned;
import com.blixx.ctrl.sc.in.ScGetFileAsString;
import com.blixx.ctrl.sc.in.ScGetNodeGroupPermissionTree;
import com.blixx.ctrl.sc.in.ScGetPolicyGroupsXml;
import com.blixx.ctrl.sc.in.ScGetSlaves;
import com.blixx.ctrl.sc.in.ScGetSrvTime;
import com.blixx.ctrl.sc.in.ScGetUserAttributes;
import com.blixx.ctrl.sc.in.ScLinkAgent2NodeGroup;
import com.blixx.ctrl.sc.in.ScRenameNodeGroup;
import com.blixx.ctrl.sc.in.ScUnlinkAgentFromNodeGroup;
import com.blixx.ctrl.sc.in.ScValidateCmd;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.AgentInventoryCard;
import com.blixx.shared.Assignment;
import com.blixx.shared.UserRight;
import com.blixx.shared.UserRole;
import com.blixx.shared.ext.INodeGroupRepository;
import com.blixx.shared.ext.NodeGroupForwardFilter;
import com.blixx.shared.ext.SSCLite;
import com.blixx.shared.pg.PGEntityAction;
import com.blixx.shared.pg.PGEntityPermissionFlag;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.ConcurrentHashMapMap;
import com.blixx.shared.utils.FileFilter;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.TreeObject;
import com.boom.ctrl.sc.ui.ScGetAnyUpdates;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class Repository
implements IServerAuth,
INodeGroupRepository,
ICmdPostProcess,
ICommandListener {
    public static final String REFRESH_KEY = "REFRESH";
    public static final String NOREFRESH = "NOREFRESH";
    public static final Object NOTHING = new Object();
    public static Repository m_instance = null;
    private ConcurrentHashMap<String, AgentCard> m_agentCardsMap = new ConcurrentHashMap();
    public GActionsRepository m_actionRepository = null;
    private final GroupTreeObject m_agentTree = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
    private final GroupTreeObject m_agentTreeAGENTS = new GroupTreeObject(new TreeObject("Agents", "IMAGE_FOLDER_MASTER", null));
    List<StructuredViewer> m_agentTreeViewers = new ArrayList<StructuredViewer>();
    private List<Viewer> m_nodeGroupTreeViewers = new ArrayList<Viewer>();
    private List<Viewer> m_actionsTreeViewers = new ArrayList<Viewer>();
    private List<Viewer> m_agentAssignmentsViewers = new ArrayList<Viewer>();
    private final GroupTreeObject m_binaryTree = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
    private Map<String, String> m_helps = new HashMap<String, String>();
    private UserManager m_userManager = null;
    private BrowserLabelManager m_browserLabelsManager = null;
    private GAssignments m_assignments = null;
    public static String m_sessionUUID = null;
    public static String m_user = null;
    private static String m_userTmpDir = null;
    public static String m_pass = null;
    public static String m_error = null;
    private Map<String, File> m_fetchedFiles = new HashMap<String, File>();
    public final GroupTreeObject m_nodeGroups = new GroupTreeObject(new TreeObject("_Groups", BMUI.type_folder, null));
    public String m_nodeGroupLastDigest = null;
    public ConcurrentHashMapMap<String, String> m_nodeGroups_pathToID = new ConcurrentHashMapMap();
    public ConcurrentHashMapMap<String, String> m_nodeGroups_IDToPath = new ConcurrentHashMapMap();
    public static final String NODE_GROUPS_XML = "nodeGroups.xml";
    public static File m_pluginFile = null;
    private AtomicBoolean m_agentTreeUpdateRunning = new AtomicBoolean(false);
    private ServiceDashBoardProvider m_serviceProvider = null;
    private static JobManager m_jobManager = JobManager.getInstance();
    private static UIJobManager m_uiJobManager = UIJobManager.getInstance();
    public static File m_UIProfileFromSever = null;
    private Map<String, String> m_agentVersions = new HashMap<String, String>();
    private Object m_backgroundAgentTreeUpdateLock = new Object();
    private int m_protocolVersion = 0;
    private boolean m_isOutageSupported = false;
    private CmdRouter m_cmdRouter = new CmdRouter();
    public int m_hourDiff = 0;
    public int m_minDiff = 0;
    public Calendar m_serverCalendar = null;
    public String m_serverTimeZone = null;
    public int m_serverDiffMilliseconds = 0;
    public Map<String, SSCLite> m_slaves = null;
    public Map<String, String> m_agentCMLabels = new HashMap<String, String>();
    private GuiClient m_guiClient = null;
    private boolean m_isUserFiltered = false;
    private static EventStorage m_esSubmit;
    private static EventStorage m_esOutage;
    private ConcurrentHashMap<String, Object> m_externalHostsMapping = new ConcurrentHashMap();

    static {
        try {
            m_sessionUUID = UUID.randomUUID().toString();
        }
        catch (Throwable throwable) {
            m_sessionUUID = "" + System.currentTimeMillis();
        }
        m_esSubmit = null;
        m_esOutage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Repository getInstance() {
        if (m_instance != null) return m_instance;
        Class<Repository> clazz = Repository.class;
        synchronized (Repository.class) {
            if (m_instance != null || m_user == null) return m_instance;
            int count = 0;
            while (count < 3) {
                try {
                    m_instance = new Repository();
                    m_error = null;
                    break;
                }
                catch (ConnectionException e) {
                    m_instance = null;
                    m_error = e.getMessage();
                }
                finally {
                    ++count;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instance;
        }
    }

    public static JobManager getJobManager() {
        return m_jobManager;
    }

    public static UIJobManager getUIJobManager() {
        return m_uiJobManager;
    }

    public static IEventStorageSubmit getEventStorageSubmit() {
        return m_esSubmit;
    }

    public static IEventProvider getEventProvider() {
        return m_esSubmit;
    }

    public static IEventsSummary getEventsSummary() {
        return m_esSubmit;
    }

    public static IEventStorageSubmit getOuEventStorageSubmit() {
        return m_esOutage;
    }

    public static IEventProvider getOuEventProvider() {
        return m_esOutage;
    }

    public static IEventsSummary getOuEventsSummary() {
        return m_esOutage;
    }

    public CmdRouter getCmdRouter() {
        return this.m_cmdRouter;
    }

    public boolean isUserFiltered() {
        return this.m_isUserFiltered;
    }

    private Repository() throws ConnectionException {
        this.m_agentTree.addElement(this.m_agentTreeAGENTS);
        this.m_agentTree.addElement(this.m_nodeGroups);
        this.initCmdListeners();
        m_esSubmit = EventStorage.getInstance();
        m_esOutage = EventStorageOutage.getInstance();
        this.checkPlugInVersion();
        this.m_userManager = UserManager.getInstance(this);
        this.m_browserLabelsManager = BrowserLabelManager.getInstance();
        this.fetchUserRole();
        Repository.getJobManager().setPaused(true);
        this.requestServerTime();
        this.m_guiClient = GuiClient.getInstance();
        this.loadInitData();
        NodeGroupForwardFilter.m_NGR = this;
        RTLogger.print(0, "Repository is ready");
        this.getCmdRouter().addCmdListener("GET_POLICYTREEPERMISSIONS", PolicyManager.getInstance());
        this.getCmdRouter().addCmdListener("GET_ASNTREEPERMISSIONS", PolicyManager.getInstance());
        this.getCmdRouter().addCmdListener("GET_POWERGROUPS", this.m_userManager);
        this.getCmdRouter().addCmdListener("GET_CONNECTED_USERS", this.m_userManager);
        this.getCmdRouter().addCmdListener("GETAGENTCARD_SINGLE", this);
        this.getCmdRouter().addCmdListener("GET_NODEGROUPTREEPERMISSIONS", this);
        Repository.getJobManager().setPaused(false);
    }

    @Override
    public void onCommand(String command, String action) {
        int commandCode = CMDS.m_acceptable.get(command);
        switch (commandCode) {
            case 238: {
                ScGetAgentCardSingle sc = new ScGetAgentCardSingle(this, AgentCard.class, action);
                sc.addCmdPostProcess(this);
                Repository.getJobManager().schedule(sc);
                break;
            }
            case 252: {
                ScGetNodeGroupPermissionTree sc2 = new ScGetNodeGroupPermissionTree(this);
                sc2.addCmdPostProcess(this);
                Repository.getJobManager().schedule(sc2);
                break;
            }
        }
    }

    private void initCmdListeners() {
        this.m_cmdRouter.registerCmd4Listeners("GET_SERVER_POLICIES_STATUS");
        this.m_cmdRouter.registerCmd4Listeners("GET_SERVER_POLICIES_STATUS_AOP");
        this.m_cmdRouter.registerCmd4Listeners("GET_SERVER_POLICIES_STATUS_MOD");
        this.m_cmdRouter.registerCmd4Listeners("SJOBS_LIST");
        this.m_cmdRouter.registerCmd4Listeners("SJOBS_RELOAD");
        this.m_cmdRouter.registerCmd4Listeners("GET_INOTIFY_LIST");
        this.m_cmdRouter.registerCmd4Listeners("GET_POLICYTREEPERMISSIONS");
        this.m_cmdRouter.registerCmd4Listeners("GET_POWERGROUPS");
        this.m_cmdRouter.registerCmd4Listeners("GETAGENTCARD_SINGLE");
        this.m_cmdRouter.registerCmd4Listeners("REFRESH_LDAP_SERVERSE");
        this.m_cmdRouter.registerCmd4Listeners("GET_NODEGROUPTREEPERMISSIONS");
    }

    public void postProcess(com.blixx.ctrl.sc.ServerClient sc) {
        if (sc instanceof ScGetUserAttributes) {
            Object attribute;
            String val;
            ScGetUserAttributes scgua = (ScGetUserAttributes)sc;
            if (scgua.isSuccess() && (val = (String)(attribute = scgua.getResultObject()).get("USER_AGENTS_FILTERED")) != null) {
                this.m_isUserFiltered = Boolean.parseBoolean(val);
            }
        } else if (sc instanceof ScGetAgentInventoryCard) {
            ScGetAgentInventoryCard sc1 = (ScGetAgentInventoryCard)sc;
            if (sc1.isSuccess()) {
                this.updateOpenAgentCardInventory(sc1.getResultObject());
            }
        } else if (sc instanceof ScGetAgentCards) {
            Iterator it = ((HashMap)((ScGetAgentCards)sc).getResultObject()).entrySet().iterator();
            HashMap<String, AgentCard> result = new HashMap<String, AgentCard>();
            while (it.hasNext()) {
                Map.Entry en = it.next();
                result.put((String)en.getKey(), (AgentCard)en.getValue());
            }
            this.scheduleCreateAgentCardsTree(result);
            AgentOverviewTableRefreshJobLight uJob2 = new AgentOverviewTableRefreshJobLight(Display.getDefault(), "RefreshAgentOverviewTab");
            Repository.getUIJobManager().schedule(uJob2);
        } else if (sc instanceof ScGetAssigned) {
            UIJob raa = new UIJob("raa"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Repository.this.refreshAgentAssignmentsTrees();
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(raa);
        } else if (sc instanceof ScGetNodeGroupPermissionTree) {
            try {
                this.m_nodeGroups.clearAttributesRecursive();
                this.m_nodeGroups.mergeAttributesFromTree((GroupTreeObject)sc.getResultObject());
                RefreshAgentTreeUIJob uijob = new RefreshAgentTreeUIJob(true, null);
                Repository.getUIJobManager().schedule(uijob);
            }
            catch (Exception exception) {
                RTLogger.print(3, "NODEGROUPTREEPERMISSIONS not supported by the current boom server version");
            }
        } else if (sc instanceof ScGetAgentCardSingle) {
            ScGetAgentCardSingle scc = (ScGetAgentCardSingle)sc;
            AgentCard ac = (AgentCard)scc.getResultObject();
            this.updateAgentCard(ac);
        } else if (sc instanceof ScGetAllAsn) {
            ScGetAllAsn scc = (ScGetAllAsn)sc;
            if (scc.isSuccess()) {
                this.getAllAssignments().processResult((List<Assignment>)scc.getResultObject());
            }
        } else if (sc instanceof ScGetAnyUpdates) {
            ScGetAnyUpdates scgar = (ScGetAnyUpdates)sc;
            final String res = scgar.getResultObject();
            if (res != null && res.length() > 0) {
                UIJob uJob3 = new UIJob("UI Update available"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        Shell dialog = new Shell(Display.getCurrent().getActiveShell(), 16795744);
                        MessageBox messageBox = new MessageBox(dialog, 8);
                        messageBox.setText("Server notification");
                        messageBox.setMessage(res);
                        messageBox.open();
                        return null;
                    }
                };
                Repository.getUIJobManager().schedule(uJob3);
            }
        } else {
            this.processResult(sc.m_command, sc.isSuccess(), sc.getResultObject());
        }
    }

    private void loadInitData() throws ConnectionException {
        long start = System.currentTimeMillis();
        ServerClientBatch scb = new ServerClientBatch("GETAGENTCARDS");
        scb.openSocket();
        Object res = scb.runBatch();
        if (!scb.isSuccess() || res == null) {
            System.err.println("Error fetching Agent cards");
            throw new ConnectionException("Unknown network problem");
        }
        this.m_agentCardsMap.putAll((Map)res);
        this.initExternalHostsMapping();
        start = this.printTime("Agent cards = ", start);
        scb.setCommand("GET_UI_PROFILE", null, new String[0]);
        res = scb.runBatch();
        if (scb.isSuccess() && res != null) {
            m_UIProfileFromSever = (File)res;
        }
        start = this.printTime("UIProfiles = ", start);
        scb.setCommand("REFRESH_NODEGROUPS", null, new String[0]);
        res = scb.runBatch();
        this.refreshNodeGroups();
        start = this.printTime("NodeGroups = ", start);
        ServerClient sc = new ServerClient("GET_HELPS", null, new String[0]);
        Repository.getJobManager().schedule(sc, 500L);
        this.fetchPolicies(true);
        ServerClient scp = new ServerClient("GETPOLICIES", null, null);
        Repository.getJobManager().schedule(scp, 500L);
        this.createBinariesTree();
        this.m_actionRepository = GActionsRepository.getInstance(this.getActionsDirectory());
        if (this.getRights(1007) > 1) {
            ServerClient sca = new ServerClient("GETACTIONS", this.getActionsDirectory(), null);
            Repository.getJobManager().schedule(sca, 500L);
        }
        ServerClient scas = new ServerClient("GETASSIGNMENTS", null, null);
        Repository.getJobManager().schedule(scas, 500L);
        this.removeFFiltersAndPolicies();
        if (this.getRights(1009) > 1) {
            scb.setCommand("GET_FORWARD_FILTERS", Repository.getUserPoliciesDirectory(), (String[])null);
            res = scb.runBatch();
            if (!scb.isSuccess()) {
                System.err.println("Error fetching forward filters");
                throw new ConnectionException("Unknown network problem");
            }
            start = this.printTime("FF = ", start);
            scb.setCommand("GET_FORWARD_POLICIES", Repository.getUserPoliciesDirectory(), (String[])null);
            res = scb.runBatch();
            if (!scb.isSuccess()) {
                System.err.println("Error fetching forward policies");
                throw new ConnectionException("Unknown network problem");
            }
            start = this.printTime("FP = ", start);
        }
        scb.setCommand("GETFILE", null, new String[]{ServiceDashBoardProvider.GLOBAL_SSDFILE_SRV_PATH, BMUI.type_file, String.valueOf(Repository.getUserTmpDirectory()) + "/"});
        res = scb.runBatch();
        start = this.printTime("SSD = ", start);
        scb.setCommand("GETFILE", null, new String[]{"srv/../boom.props", BMUI.type_file, String.valueOf(Repository.getUserTmpDirectory()) + "/"});
        res = scb.runBatch();
        start = this.printTime("props = ", start);
        File propsFile = new File(String.valueOf(Repository.getUserTmpDirectory()) + File.separator + "boom.props");
        if (propsFile.exists()) {
            try {
                Properties props = new Properties();
                FileInputStream inStream = new FileInputStream(propsFile);
                props.load(inStream);
                BMUI.HTTP_PORT = props.getProperty("HTTP_PORT", BMUI.HTTP_PORT);
                if (props.getProperty("SSL_KEYSTORE") != null && props.getProperty("EnSSL_PASSWORD") != null || props.getProperty("KS_FILE") != null && props.getProperty("KS_PASS_ENCODED") != null) {
                    BMUI.HTTP_PROTOCOL = "https";
                }
                inStream.close();
                propsFile.delete();
            }
            catch (Throwable throwable) {}
        }
        scb.setCommand("VALIDATE_CMD", "DISABLEOUTAGE_O", new String[0]);
        scb.runBatch();
        if (scb.isSuccess()) {
            this.m_isOutageSupported = true;
        }
        scb.setCommand("VALIDATE_CMD", "GET_SLAVES", new String[0]);
        scb.runBatch();
        if (scb.isSuccess()) {
            scb.setCommand("GET_SLAVES");
            scb.runBatch();
            if (scb.isOKFinished) {
                this.m_slaves = new LinkedHashMap<String, SSCLite>();
                ScGetSlaves scgs = (ScGetSlaves)scb.getResultObject();
                Object list = scgs.getResultObject();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SSCLite ssc = (SSCLite)iterator.next();
                    this.m_slaves.put(ssc.getHostName(), ssc);
                }
            }
        }
        scb.close();
        ScGetAgentVersions scav = new ScGetAgentVersions(this);
        scav.addCmdPostProcess(this);
        Repository.getJobManager().schedule(scav, 500L);
        this.fetchAllAssignments();
        this.requestServerTime();
        ScGetUserAttributes scgua = new ScGetUserAttributes(this);
        scgua.addCmdPostProcess(this);
        scgua.start();
        ScGetAgentCMLabels scgetAgentCMLabels = new ScGetAgentCMLabels(this);
        scgetAgentCMLabels.addCmdPostProcess(this);
        Repository.getJobManager().schedule(scgetAgentCMLabels);
        ScGetNodeGroupPermissionTree scgp2 = new ScGetNodeGroupPermissionTree(this);
        scgp2.addCmdPostProcess(this);
        Repository.getJobManager().schedule(scgp2);
    }

    private void initExternalHostsMapping() {
        if (this.m_agentCardsMap != null && this.m_agentCardsMap.size() > 0) {
            for (AgentCard ac : this.m_agentCardsMap.values()) {
                this.applyExternalHostMapping(this.m_externalHostsMapping, ac);
            }
        }
    }

    private void applyExternalHostMapping(Map<String, Object> hostnamed, AgentCard ac) {
        if (ac.isExternal()) {
            String[] arr2;
            String[] arr1;
            String[] stringArray = arr1 = ac.getAgentHost().split("\\|");
            int n = arr1.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && s.length() > 0) {
                    hostnamed.put(s, NOTHING);
                }
                ++n2;
            }
            String[] stringArray2 = arr2 = ac.getAgentHost().split("\\|");
            int n3 = arr2.length;
            n = 0;
            while (n < n3) {
                String s = stringArray2[n];
                if (s != null && s.length() > 0) {
                    hostnamed.put(s, NOTHING);
                }
                ++n;
            }
        }
    }

    public boolean isExternalHost(String hostOrIP) {
        return this.m_externalHostsMapping.keySet().contains(hostOrIP);
    }

    public void requestServerTime() {
        block17: {
            com.blixx.ctrl.sc.ServerClientBatch scb = new com.blixx.ctrl.sc.ServerClientBatch(this);
            try {
                try {
                    ScGetSrvTime scgst = new ScGetSrvTime(this);
                    ScValidateCmd scv = new ScValidateCmd(this, scgst.m_command);
                    scb.runBatch(scv);
                    if (scv.isSuccess()) {
                        scb.runBatch(scgst);
                        if (scgst.isSuccess()) {
                            Pattern p;
                            Matcher m;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z(Z)", Locale.ENGLISH);
                            String date = scgst.getResultObject();
                            Date dateServer = sdf.parse(date);
                            long deltaMillisecondsPure = dateServer.getTime() - (System.currentTimeMillis() - 500L);
                            if (Math.abs(deltaMillisecondsPure) <= Integer.MAX_VALUE && Math.abs(deltaMillisecondsPure) > 59000L) {
                                this.m_serverDiffMilliseconds = (int)deltaMillisecondsPure;
                            }
                            if ((m = (p = Pattern.compile(".*:\\d+\\s+(.*)\\(([\\+-])(\\d{2})(\\d{2})\\)")).matcher(date)).matches()) {
                                this.m_serverTimeZone = m.group(1);
                                String sign = m.group(2);
                                String diffHours = m.group(3);
                                String diffMinutes = m.group(4);
                                int hd = Integer.parseInt(diffHours);
                                int md = Integer.parseInt(diffMinutes);
                                if ("-".equals(sign)) {
                                    md *= -1;
                                    hd *= -1;
                                }
                                this.m_hourDiff = 3600000 * hd;
                                this.m_minDiff = md * 60000;
                                int offsetMillis = this.m_hourDiff + this.m_minDiff;
                                this.m_serverCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                                this.m_serverCalendar.getTimeZone().setRawOffset(offsetMillis);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(5, "ScGetSrvTime failed", e);
                    try {
                        scb.close();
                    }
                    catch (Throwable throwable) {}
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    scb.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                scb.close();
            }
            catch (Throwable throwable) {}
        }
        if (this.m_serverCalendar == null) {
            this.m_serverCalendar = Calendar.getInstance();
            this.m_serverTimeZone = this.m_serverCalendar.getTimeZone().getID();
        }
    }

    private long printTime(String str, long start) {
        long ms = System.currentTimeMillis() - start;
        RTLogger.print(0, String.valueOf(str) + ms);
        start = System.currentTimeMillis();
        return start;
    }

    public String getAgentVersion(String agentID) {
        return this.m_agentVersions.get(agentID);
    }

    public AgentCard getAgentCard(String id) {
        return id == null ? null : this.m_agentCardsMap.get(id);
    }

    public AgentCard getAgentCardByHostname(String hostname) {
        if (hostname != null) {
            for (AgentCard ac : this.m_agentCardsMap.values()) {
                if (!ac.getAgentHost().equals(hostname)) continue;
                return ac;
            }
        }
        return null;
    }

    public List<AgentCard> getExternalHosts(String hostOrIP) {
        ArrayList<AgentCard> list = new ArrayList<AgentCard>();
        if (hostOrIP == null) {
            return list;
        }
        for (Map.Entry<String, AgentCard> en : this.m_agentCardsMap.entrySet()) {
            String ip;
            int n;
            AgentCard ac = en.getValue();
            if (!ac.isExternal()) continue;
            String host = ac.getAgentHost();
            if (host.equals(hostOrIP)) {
                list.add(ac);
                continue;
            }
            if (host.indexOf(124) != -1 && host.contains(hostOrIP)) {
                String[] arr = host.split("\\|");
                boolean matches = false;
                String[] stringArray = arr;
                n = arr.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (hostOrIP.equals(s)) {
                        list.add(ac);
                        matches = true;
                        break;
                    }
                    ++n2;
                }
                if (matches) continue;
            }
            if ((ip = ac.getAgentIP()).equals(hostOrIP)) {
                list.add(ac);
                continue;
            }
            if (ip.indexOf(124) == -1 || !ip.contains(hostOrIP)) continue;
            String[] arr = ip.split("\\|");
            boolean matches = false;
            String[] stringArray = arr;
            int n3 = arr.length;
            n = 0;
            while (n < n3) {
                String s = stringArray[n];
                if (hostOrIP.equals(s)) {
                    list.add(ac);
                    matches = true;
                    break;
                }
                ++n;
            }
            if (!matches) continue;
        }
        return list;
    }

    public Collection<AgentCard> getAgentCards() {
        return this.m_agentCardsMap.values();
    }

    public void fetchBrowserLabels() {
        Map<String, String> mapping = this.fetchBrowserLabelFromServer();
        if (mapping != null) {
            if (mapping.isEmpty()) {
                this.getBrowserLabelManager().setMappingToDefault();
            } else {
                this.getBrowserLabelManager().setMapping(mapping);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> fetchBrowserLabelFromServer() {
        BufferedReader br;
        InputStream is;
        HashMap<String, String> mapping;
        block33: {
            ScGetFileAsString scf;
            String serverPath;
            block32: {
                serverPath = this.getBrowserLabelManager().getServerPath();
                mapping = new HashMap<String, String>();
                is = null;
                br = null;
                scf = new ScGetFileAsString(m_instance, serverPath, BMUI.type_file);
                scf.run();
                if (scf.isSupported()) break block32;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (is == null) return null;
                    is.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
            try {
                try {
                    if (!scf.isFileExists()) {
                        RTLogger.print(4, "server file does not exist " + serverPath + ". Using default browser labels.");
                        break block33;
                    }
                    if (scf.isSuccess()) {
                        String res = scf.getResultObject();
                        if (res != null) {
                            is = new ByteArrayInputStream(res.getBytes());
                            br = new BufferedReader(new InputStreamReader(is));
                            boolean eof = false;
                            while (!eof) {
                                String line = br.readLine();
                                if (line == null) {
                                    eof = true;
                                    continue;
                                }
                                String[] split = line.split("=");
                                if (split == null || split.length <= 0) continue;
                                String l1 = split[0].trim();
                                String l2 = "";
                                try {
                                    l2 = split[1].trim();
                                }
                                catch (Exception exception) {}
                                mapping.put(l1, l2);
                            }
                            mapping.size();
                            break block33;
                        }
                        RTLogger.print(4, "error getting server file " + serverPath);
                        mapping = null;
                        break block33;
                    }
                    RTLogger.print(4, "error getting server file " + serverPath);
                    mapping = null;
                }
                catch (Throwable e) {
                    mapping = null;
                    RTLogger.print(4, "Error getting file " + serverPath, e);
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (is == null) return mapping;
                        is.close();
                        return mapping;
                    }
                    catch (IOException iOException) {}
                    return mapping;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (br != null) {
                br.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (is == null) return mapping;
            is.close();
            return mapping;
        }
        catch (IOException iOException) {}
        return mapping;
    }

    public void fetchUserRole() throws ConnectionException {
        UserRole r;
        ScGetUserRole sc = new ScGetUserRole(this, m_user);
        sc.run();
        if (!sc.isSuccess()) {
            throw new ConnectionException(sc.getLastException() == null ? "Unknown exception" : sc.getLastException().getMessage());
        }
        UserRole resultObject = sc.getResultObject();
        if (resultObject instanceof UserRole && resultObject != null) {
            r = resultObject;
            if (BMUI.m_cleaningMode) {
                Iterator<UserRight> it = r.getRights().iterator();
                while (it.hasNext()) {
                    UserRight userRight = it.next();
                    switch (userRight.getItemID()) {
                        case 1000: 
                        case 1001: 
                        case 1002: 
                        case 1003: 
                        case 1007: {
                            break;
                        }
                        default: {
                            it.remove();
                        }
                    }
                }
            }
        } else {
            if (resultObject != null) {
                throw new ConnectionException("" + resultObject);
            }
            throw new ConnectionException("Unknown error");
        }
        this.setActivRole(r);
        this.fetchUserMgmtData();
    }

    public void fetchUserMgmtData() {
        if (this.getRights(1004) > 1 || this.getRights(1009) > 1) {
            this.m_userManager.fetchAll();
        } else {
            this.m_userManager.fetchUsers();
        }
    }

    public String fetchHelp(String id) {
        String help = null;
        ServerClient sc = new ServerClient("GET_HELP", id, null);
        sc.runInUIThread(null);
        if (sc.isSuccess()) {
            help = (String)sc.getResultObject();
            this.m_helps.put(id, help);
        }
        return help;
    }

    public void fetchActions() {
        File dir = new File(this.getActionsDirectory());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            files[i].delete();
            ++i;
        }
        ServerClient sc = new ServerClient("GETACTIONS", this.getActionsDirectory(), null);
        sc.runInUIThread(null);
        if (sc.isSuccess()) {
            this.m_actionRepository = GActionsRepository.getInstance(this.getActionsDirectory());
        }
    }

    public void fetchPolicies(final boolean refresh) {
        try {
            ScGetPolicyGroupsXml scp = new ScGetPolicyGroupsXml(this, PolicyManager.getInstance().getPolicyGroupsFilename());
            scp.addCmdPostProcess(new ICmdPostProcess(){

                public void postProcess(com.blixx.ctrl.sc.ServerClient sc) {
                    if (sc.isSuccess()) {
                        UIJob j = new UIJob("GetPolicyGroupsXml"){

                            @Override
                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (refresh) {
                                    PolicyManager.getInstance().refreshTree();
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        Repository.getUIJobManager().schedule(j);
                    }
                }
            });
            Repository.getJobManager().schedule(scp);
        }
        catch (SCParametersException sCParametersException) {}
    }

    public void fetchForwardPolicies(boolean refresh) {
        this.removeFFiltersAndPolicies();
        ServerClient sc = ServerClient.getForwardPolicies();
        sc.runInUIThread(null);
        if (sc.isSuccess()) {
            FPolicyManager.getInstance().initFPolicies();
        } else {
            RTLogger.print(1, "Error getting Forward Policies.");
        }
        if (refresh) {
            this.refreshServerFilterView();
        }
    }

    private void removeFFiltersAndPolicies() {
        File dir = new File(Repository.getUserPoliciesDirectory());
        try {
            File[] list = dir.listFiles();
            int i = 0;
            while (i < list.length) {
                if (list[i].isFile() && (list[i].getName().endsWith(".fwd.xml") || list[i].getName().endsWith(".fgf.xml"))) {
                    try {
                        list[i].delete();
                    }
                    catch (Throwable throwable) {}
                }
                ++i;
            }
        }
        catch (Throwable throwable) {}
    }

    public void fetchForwardFilters(boolean refresh) {
        ServerClient sc = ServerClient.getForwardFilters();
        sc.runInUIThread(null);
        if (sc.isSuccess()) {
            FFilterManager.getInstance().initFFilters();
        } else {
            RTLogger.print(1, "Error getting Forward Filters.");
        }
        if (refresh) {
            this.refreshForwardFilterView();
        }
    }

    private void refreshServerFilterView() {
        try {
            FPolicyManager.getInstance().refreshServerFilterView();
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error refreshing ServerFilterView: " + e.getMessage());
            RTLogger.print(2, "", e);
        }
    }

    private void refreshForwardFilterView() {
        try {
            FPolicyManager.getInstance().refreshFFilterView();
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error refreshing ForwardFilterView: " + e.getMessage());
            RTLogger.print(2, "", e);
        }
    }

    public void fetchAssignments(boolean refresh) {
        ServerClient sc = new ServerClient("GETASSIGNMENTS", null, null);
        Repository.getJobManager().schedule(sc);
    }

    private void fetchAllAssignments() {
        if (this.m_assignments == null) {
            this.m_assignments = new GAssignments(this);
        }
        if (this.getRights(1008) > 1) {
            this.m_assignments.startServerClient(500L, this);
        }
    }

    public GAssignments getAllAssignments() {
        if (this.m_assignments == null) {
            this.m_assignments = new GAssignments(this);
        }
        return this.m_assignments;
    }

    public File fetchFile(String name, String type) {
        File res = null;
        String dir = ".";
        if (type.startsWith(BMUI.type_mon) || type.startsWith(BMUI.type_msg)) {
            dir = Repository.getUserPoliciesDirectory();
        }
        String[] arr = new String[]{name, type, dir};
        ServerClient sc = ServerClient.getFile(arr);
        sc.runInUIThread(null);
        if (sc.isSuccess()) {
            Object o = sc.getResultObject();
            if (o instanceof File) {
                res = (File)o;
            }
            this.m_fetchedFiles.put(String.valueOf(name) + ":" + type, res);
        }
        return res;
    }

    public File fetchFile(ServerClientBatch scBatch, String name, String type) {
        File res = null;
        String dir = ".";
        if (type.startsWith(BMUI.type_mon) || type.startsWith(BMUI.type_msg)) {
            dir = Repository.getUserPoliciesDirectory();
        }
        String[] arr = new String[]{name, type, dir};
        scBatch.setCommand("GETFILE", null, arr);
        Object o = scBatch.runBatch();
        if (scBatch.isSuccess()) {
            if (!(o instanceof File)) {
                throw new RuntimeException("FileNotFoundOnServer");
            }
            res = (File)o;
            this.m_fetchedFiles.put(String.valueOf(name) + ":" + type, res);
        }
        return res;
    }

    public File getFetched(String name, String type) {
        return this.m_fetchedFiles.get(String.valueOf(name) + ":" + type);
    }

    public void setActivRole(UserRole role) {
        this.getUserManager().setActiveRole(role);
    }

    public int getRights(int item) {
        int level = 0;
        try {
            List<UserRight> list = this.getUserManager().getActiveRole().getRights();
            for (UserRight m : list) {
                if (m.getItemID() != item) continue;
                return m.getLevel();
            }
        }
        catch (Throwable throwable) {}
        if (level == 0 && item == 2016) {
            level = this.getRights(1000);
        }
        return level;
    }

    public int getRights(String actionGroupName) {
        int id = this.m_userManager.getUItemIDForActionGroup(actionGroupName);
        if (id == -1) {
            return 3;
        }
        return this.getRights(id);
    }

    public GroupTreeObject createBinariesTree() {
        Object o;
        String[] arr = new String[]{"boom_packages.xml", BMUI.type_file, Repository.getUserDirectory()};
        ServerClient sc = ServerClient.getFile(arr);
        sc.runInUIThread(null);
        if (sc.isSuccess() && (o = sc.getResultObject()) instanceof File) {
            File f = (File)o;
            this.parseBinaryTree(f);
        }
        return this.m_binaryTree;
    }

    private void parseBinaryTree(File f) {
        block11: {
            XMLTree xt = new XMLTree();
            FileInputStream io = null;
            try {
                try {
                    io = new FileInputStream(f);
                    List<GroupTreeObject> elements = xt.parseXML(io, true).getElements();
                    this.m_binaryTree.clean();
                    this.m_binaryTree.addElements(elements);
                }
                catch (Throwable e) {
                    RTLogger.print(1, "Binary tree creation failed: " + e.getMessage());
                    RTLogger.print(2, "", e);
                    try {
                        io.close();
                    }
                    catch (Throwable throwable) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    io.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                io.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public GroupTreeObject getBinaryTree() {
        return this.m_binaryTree;
    }

    public void setBinariesTreeSelection(String name) {
        GroupTreeObject gto = this.m_binaryTree.findFirstGroupByName(name);
        if (gto != null) {
            try {
                BinariesListView.getInstance().getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)gto), true);
            }
            catch (RuntimeException e) {
                RTLogger.print(4, "", e);
            }
            BinariesListView.getInstance().getTreeViewer().refresh();
        }
    }

    public void setBinariesTreeSelection(GroupTreeObject gto) {
        try {
            BinariesListView.getInstance().getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)gto), true);
        }
        catch (RuntimeException e) {
            RTLogger.print(4, "", e);
        }
        BinariesListView.getInstance().getTreeViewer().refresh();
    }

    public void setAssignmentTreeSelection(GroupTreeObject root_asn, String name) {
        GroupTreeObject gto = root_asn.findFirstGroupByName(name);
        if (gto != null) {
            try {
                AssignmentListView.getInstance().getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)gto), true);
            }
            catch (RuntimeException e) {
                RTLogger.print(4, "Asn tree selection ", e);
            }
            AssignmentListView.getInstance().getTreeViewer().refresh();
        }
    }

    private void refreshNodeGroups() {
        NodeGroupFileJob job = new NodeGroupFileJob("NodeGroupRefresh-" + System.currentTimeMillis());
        job.setPriority(20);
        job.schedule();
    }

    public ServiceDashBoardProvider getServiceDashBoardProvider() {
        if (this.m_serviceProvider == null) {
            this.m_serviceProvider = new ServiceDashBoardProvider();
        }
        return this.m_serviceProvider;
    }

    public void scheduleCreateAgentCardsTree(final Map<String, AgentCard> serviceClientResult) {
        if (this.m_agentTreeUpdateRunning.compareAndSet(false, true)) {
            Job job = new Job("BkgrUpdateAC" + System.currentTimeMillis()){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            UIJob uJob;
                            RTLogger.print(6, "Start update ACards");
                            boolean isTreStructureChanged = serviceClientResult == null ? true : Repository.this.updateAgentCards(serviceClientResult);
                            RTLogger.print(6, "step2 ACards");
                            if (isTreStructureChanged) {
                                RTLogger.print(4, "Going to AC tree full rebuild");
                                Repository.this.backgroundCreateAgentCardsTree(isTreStructureChanged);
                            } else {
                                RTLogger.print(4, "Going to light AC tree rebuild");
                                uJob = new AgentTreeRefreshJobLite(Repository.this, Display.getDefault(), "Refresh AT Light");
                                Repository.getUIJobManager().schedule(uJob);
                            }
                            uJob = new AgentOverviewTableRefreshJobLight(Display.getDefault(), "RefreshAgentOverviewTab");
                            Repository.getUIJobManager().schedule(uJob);
                        }
                        catch (Throwable throwable) {
                            Repository.this.m_agentTreeUpdateRunning.set(false);
                        }
                    }
                    finally {
                        Repository.this.m_agentTreeUpdateRunning.set(false);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            AgentTreeRefreshJobLite uJob = new AgentTreeRefreshJobLite(this, Display.getDefault(), "Refresh AT Light");
            Repository.getUIJobManager().schedule(uJob);
            AgentOverviewTableRefreshJobLight uJob2 = new AgentOverviewTableRefreshJobLight(Display.getDefault(), "RefreshAgentOverviewTab");
            Repository.getUIJobManager().schedule(uJob2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backgroundCreateAgentCardsTree(boolean isChanged) {
        long start = System.currentTimeMillis();
        Object object = this.m_backgroundAgentTreeUpdateLock;
        synchronized (object) {
            RTLogger.print(5, "backgroundCreateAgentCardsTree start");
            try {
                Map<Object, Object> oldElements = new HashMap();
                oldElements = this.m_agentTree.getAllElementsMap();
                for (GroupTreeObject groupTreeObject : oldElements.keySet()) {
                    if (!groupTreeObject.getTreeObject().getType().equals("IMAGE_FOLDER_SLAVE")) continue;
                    groupTreeObject.clean();
                }
                this.m_agentTreeAGENTS.clean();
                Iterator<AgentCard> iterator = this.getAgentCards().iterator();
                GroupTreeObject gto = null;
                while (iterator.hasNext()) {
                    AgentCard ac = iterator.next();
                    if (ac.getOSName().indexOf("(BS:") != -1) {
                        gto = this.addSlavesAndOSFolders(ac.getOSName(), this.m_agentTree);
                        if ("IMAGE_FOLDER_SLAVE".equals(gto.getType()) && gto.getTreeObject() instanceof TreeObject && gto.getTreeObject().getObject() instanceof Integer && (Integer)gto.getTreeObject().getObject() == 8) {
                            continue;
                        }
                    } else {
                        gto = this.m_agentTreeAGENTS.findSubGroupByName(ac.getOSName());
                        if (gto == null) {
                            String os_lowercase = ac.getOSName().toLowerCase();
                            String type = AgentCard.getParentOSImageName(os_lowercase);
                            gto = new GroupTreeObject(new TreeObject(ac.getOSName(), type, null));
                            GroupTreeObject stored = (GroupTreeObject)oldElements.get(gto);
                            if (stored != null) {
                                if (stored.hasElements().booleanValue()) {
                                    stored.clean();
                                }
                                this.m_agentTreeAGENTS.addElementNoSorting(stored);
                                gto = stored;
                            } else {
                                this.m_agentTreeAGENTS.addElementNoSorting(gto);
                            }
                        }
                    }
                    GroupTreeObjectLast acTreeElement = new GroupTreeObjectLast(ac, null, null);
                    gto.addElementNoSorting(acTreeElement);
                }
                this.m_agentTree.sortElementsRecursive();
                for (GroupTreeObject sgto : this.m_agentTree.getElements()) {
                    if (!sgto.getTreeObject().getType().equals("IMAGE_FOLDER_SLAVE") || !(gto.getTreeObject().getObject() instanceof Integer) || (Integer)gto.getTreeObject().getObject() != 8 || sgto.hasElements().booleanValue()) continue;
                    sgto.getParent().removeElement(sgto);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.m_backgroundAgentTreeUpdateLock.notifyAll();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                this.m_backgroundAgentTreeUpdateLock.notifyAll();
            }
            catch (Throwable throwable) {}
        }
        RTLogger.print(4, "BATR time(ms): " + (System.currentTimeMillis() - start));
        RefreshAgentTreeUIJob uijob = new RefreshAgentTreeUIJob(true, null);
        Repository.getUIJobManager().schedule(uijob);
        RTLogger.print(5, "backgroundCreateAgentCardsTree end");
    }

    public GroupTreeObject createAgentCardsTree(StructuredViewer comp, boolean isChanged) {
        this.addAgentTreeListener(comp);
        this.scheduleCreateAgentCardsTree(null);
        return this.m_agentTree;
    }

    public void addAgentTreeListener(StructuredViewer comp) {
        if (comp != null && !this.m_agentTreeViewers.contains(comp)) {
            this.m_agentTreeViewers.add(comp);
        }
    }

    public GroupTreeObject getAgentTree() {
        return this.m_agentTree;
    }

    public GroupTreeObject getNodeGroupTree() {
        return this.m_nodeGroups;
    }

    public void addNodeGroupTreeListener(Viewer comp) {
        if (comp != null && !this.m_nodeGroupTreeViewers.contains(comp)) {
            this.m_nodeGroupTreeViewers.add(comp);
        }
    }

    public SSCLite getSlave(String name) {
        return this.m_slaves.get(name);
    }

    public List<String> getSlaves() {
        if (this.m_slaves != null) {
            ArrayList<String> res = new ArrayList<String>(this.m_slaves.keySet());
            return res;
        }
        return this.getSlavesOld();
    }

    public List<String> getSlaves(int maxscenario) {
        if (this.m_slaves != null) {
            ArrayList<String> res = new ArrayList<String>(this.m_slaves.size());
            for (Map.Entry<String, SSCLite> en : this.m_slaves.entrySet()) {
                if (en.getValue().getScenario() > maxscenario) continue;
                res.add(en.getKey());
            }
            return res;
        }
        return this.getSlavesOld(maxscenario);
    }

    @Deprecated
    public List<String> getSlavesOld() {
        LinkedList<String> list = new LinkedList<String>();
        try {
            if (this.m_agentTree != null) {
                for (GroupTreeObject gto : this.m_agentTree.getElements()) {
                    if (!"IMAGE_FOLDER_SLAVE".equals(gto.getType())) continue;
                    list.add(gto.getTreeObject().getName());
                }
            }
        }
        catch (Throwable e) {
            RTLogger.print(5, "gsl ", e);
        }
        return list;
    }

    @Deprecated
    public List<String> getSlavesOld(int maxscenario) {
        LinkedList<String> list = new LinkedList<String>();
        try {
            if (this.m_agentTree != null) {
                for (GroupTreeObject gto : this.m_agentTree.getElements()) {
                    if (!"IMAGE_FOLDER_SLAVE".equals(gto.getType()) || (Integer)gto.getTreeObject().getObject() > maxscenario) continue;
                    list.add(gto.getTreeObject().getName());
                }
            }
        }
        catch (Throwable e) {
            RTLogger.print(5, "gslwl ", e);
        }
        return list;
    }

    private GroupTreeObject addSlavesAndOSFolders(String osLabel, GroupTreeObject rootForSlave) {
        GroupTreeObject osGTO = null;
        osLabel = osLabel.trim();
        String slaveServer = osLabel.substring(6, osLabel.indexOf(41));
        Integer scenario = Integer.valueOf("" + osLabel.charAt(4));
        GroupTreeObject slave = rootForSlave.findFirstGroupByName(slaveServer);
        if (slave == null) {
            slave = new GroupTreeObject(new TreeObject(slaveServer, "IMAGE_FOLDER_SLAVE", scenario));
            rootForSlave.addElementNoSorting(slave);
        }
        if (scenario == 8) {
            return slave;
        }
        String os = osLabel.substring(osLabel.indexOf(41) + 1);
        if (os.indexOf("(BS:") != -1) {
            osGTO = this.addSlavesAndOSFolders(os, slave);
        } else {
            String os_lowercase = os.toLowerCase();
            String type = AgentCard.getParentOSImageName(os_lowercase);
            osGTO = slave.getChild(os, type);
            if (osGTO == null) {
                osGTO = new GroupTreeObject(new TreeObject(os, type, null));
                slave.addElement(osGTO);
            }
        }
        return osGTO;
    }

    public void refreshAgentTrees(boolean completeTree, List elementsToUpdate) {
        try {
            try {
                if (elementsToUpdate != null && elementsToUpdate.size() > 500) {
                    completeTree = true;
                } else if (elementsToUpdate == null) {
                    completeTree = true;
                }
                if (this.m_agentTreeViewers.size() == 0) {
                    Repository.getInstance().m_nodeGroupLastDigest = "";
                }
                Iterator<StructuredViewer> it2 = this.m_agentTreeViewers.iterator();
                block13: while (it2.hasNext()) {
                    StructuredViewer v = it2.next();
                    if (v == null) {
                        it2.remove();
                        continue;
                    }
                    Object refresh = v.getData(REFRESH_KEY);
                    if (refresh != null && NOREFRESH == refresh) continue;
                    TreeViewer treeViewer = null;
                    try {
                        treeViewer = (TreeViewer)v;
                        if (treeViewer == null || treeViewer.getTree() == null || treeViewer.getTree().isDisposed()) {
                            it2.remove();
                            continue;
                        }
                        Object topItem = null;
                        TreeItem item = treeViewer.getTree().getTopItem();
                        if (item != null) {
                            topItem = item.getData();
                        }
                        if (completeTree) {
                            RTLogger.print(5, "refreshAgentTrees start (complete tree)");
                            Object[] expanded = treeViewer.getExpandedElements();
                            RTLogger.print(6, "refreshAgentTrees 2");
                            treeViewer.setInput((Object)this.m_agentTree);
                            RTLogger.print(6, "refreshAgentTrees 2.2");
                            if (v instanceof TreeViewer) {
                                int index = 0;
                                while (index < expanded.length) {
                                    treeViewer.setExpandedState(expanded[index], true);
                                    ++index;
                                }
                            }
                            try {
                                StructuredSelection selection = (StructuredSelection)treeViewer.getSelection();
                                if (selection != null && !selection.isEmpty()) {
                                    treeViewer.reveal(selection.getFirstElement());
                                }
                            }
                            catch (Throwable throwable) {}
                            RTLogger.print(5, "refreshAgentTrees end");
                        } else {
                            RTLogger.print(5, "updateAgentTrees start");
                            try {
                                treeViewer.update(elementsToUpdate.toArray(), null);
                            }
                            catch (Throwable throwable) {}
                            RTLogger.print(5, "updateAgentTrees end");
                        }
                        if (topItem == null || !(topItem instanceof GroupTreeObject)) continue;
                        GroupTreeObject gto = (GroupTreeObject)topItem;
                        String path = gto.getPath();
                        TreeItem[] items = treeViewer.getTree().getItems();
                        int i = 0;
                        while (i < items.length) {
                            TreeItem ti = items[i];
                            TreeItem tiFound = this.findTreeItem(path, ti);
                            if (tiFound != null) {
                                treeViewer.getTree().setTopItem(tiFound);
                                continue block13;
                            }
                            ++i;
                        }
                    }
                    catch (RuntimeException e) {
                        RTLogger.print(5, "Agent tree refresh failed.", e);
                        try {
                            if (v != null && v == NodeListView.getInstance().getTreeViewer()) continue;
                            it2.remove();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Throwable tr) {
                RTLogger.print(5, "Agent tree refresh failed.", tr);
                this.m_agentTreeUpdateRunning.compareAndSet(true, false);
            }
        }
        finally {
            this.m_agentTreeUpdateRunning.compareAndSet(true, false);
        }
    }

    public TreeItem findTreeItem(String path, TreeItem ti) {
        if (ti == null) {
            return null;
        }
        Object o = ti.getData();
        if (o != null && o instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
            if (gtol.getPath().equals(path)) {
                return ti;
            }
        } else {
            TreeItem[] items = ti.getItems();
            if (items == null) {
                return null;
            }
            int i = 0;
            while (i < items.length) {
                TreeItem tiFound = this.findTreeItem(path, items[i]);
                if (tiFound != null) {
                    return tiFound;
                }
                ++i;
            }
        }
        return null;
    }

    private void refreshAgentAssignmentsTrees() {
        Iterator<Viewer> it2 = this.m_agentAssignmentsViewers.iterator();
        while (it2.hasNext()) {
            Viewer v = it2.next();
            try {
                Object[] expanded = null;
                try {
                    expanded = ((TreeViewer)v).getExpandedElements();
                }
                catch (Throwable throwable) {}
                v.refresh();
                if (!(v instanceof TreeViewer)) continue;
                ((TreeViewer)v).getTree().setBackground(null);
                if (expanded == null) continue;
                int index = 0;
                while (index < expanded.length) {
                    ((TreeViewer)v).setExpandedState(expanded[index], true);
                    ++index;
                }
            }
            catch (RuntimeException runtimeException) {
                it2.remove();
            }
        }
    }

    private void refreshActionTrees() {
        HashMap<String, GroupTreeObjectUnsubmitted> unsubmittedGTOL_map = new HashMap<String, GroupTreeObjectUnsubmitted>();
        GroupTreeObject aTree = this.m_actionRepository.getTree();
        List<GroupTreeObject> all_elems = aTree.getAllElements();
        for (GroupTreeObject gto : all_elems) {
            if (gto == null || !(gto instanceof GroupTreeObjectUnsubmitted)) continue;
            unsubmittedGTOL_map.put(gto.getName(), (GroupTreeObjectUnsubmitted)gto);
        }
        this.m_actionRepository.init();
        HashMap<String, CTabItem> tabList = null;
        try {
            tabList = ActionView.getInstance().getTabList();
        }
        catch (Exception exception) {}
        if (tabList != null && !tabList.isEmpty()) {
            for (String name : tabList.keySet()) {
                ActionTab tab = (ActionTab)((Object)tabList.get(name));
                if (!tab.isNew()) continue;
                String actGroupName = tab.getActionGrpName();
                GroupTreeObjectUnsubmitted gtol = (GroupTreeObjectUnsubmitted)unsubmittedGTOL_map.get(tab.m_oldLabelName);
                if (gtol == null || !(gtol instanceof GroupTreeObjectUnsubmitted) || !gtol.getParent().getName().equals(actGroupName)) continue;
                try {
                    GroupTreeObject group = aTree.findFirstGroupByName(tab.getActionGrpName());
                    group.addElement(gtol);
                }
                catch (Exception e) {
                    RTLogger.print(5, "" + e);
                }
            }
        }
        Iterator<Viewer> it2 = this.m_actionsTreeViewers.iterator();
        while (it2.hasNext()) {
            Viewer v = it2.next();
            try {
                TreeViewer tv = (TreeViewer)v;
                Object[] expanded = tv.getExpandedElements();
                tv.refresh();
                int index = 0;
                while (index < expanded.length) {
                    tv.setExpandedState(expanded[index], true);
                    ++index;
                }
            }
            catch (RuntimeException runtimeException) {
                it2.remove();
            }
        }
    }

    public String getActionsDirectory() {
        return String.valueOf(Repository.getUserTmpDirectory()) + File.separator + "actions";
    }

    public GroupTreeObject getActionTree(Viewer v) {
        if (!this.m_actionsTreeViewers.contains(v)) {
            this.m_actionsTreeViewers.add(v);
        }
        return this.m_actionRepository.getTree();
    }

    public GroupTreeObject getActionTree() {
        return this.m_actionRepository.getTree();
    }

    public void processResult(String command, boolean isSuccess, Object serviceClientResult) {
        if (command.equals("GETACTIONS")) {
            this.refreshActionTrees();
        } else if (command.equals("GETAGENTCARDS")) {
            this.scheduleCreateAgentCardsTree((Map)serviceClientResult);
        } else if (command.equals("GETAGENTCARD_SINGLE")) {
            AgentCard ac = (AgentCard)serviceClientResult;
            this.updateAgentCard(ac);
        } else if (command.equals("GETPOLICIES")) {
            PolicyManager.getInstance().refreshTree();
        } else if (command.equals("REFRESH_ACKNMESSAGES")) {
            GuiClient.getInstance().refreshMessageBrowsers();
        } else if (command.equals("GET_ACKN_IDS")) {
            GuiClient.getInstance().refreshMessageBrowsers();
        } else if (command.equals("GETASSIGNED")) {
            this.refreshAgentAssignmentsTrees();
        } else if (command.equals("GETASSIGNMENTS")) {
            PolicyManager.getInstance().refreshAssignmentTree();
        } else if (command.equals("GET_FORWARD_FILTERS")) {
            this.refreshServerFilterView();
        } else if (command.equals("GET_FORWARD_POLICIES")) {
            FPolicyManager.getInstance().initFPolicies();
            this.refreshServerFilterView();
        } else if (command.equals("GET_HELPS")) {
            if (serviceClientResult != null) {
                this.m_helps = (Map)serviceClientResult;
            }
        } else if (command.equals("GET_USERS") || command.equals("GET_USERROLES")) {
            this.fetchUserMgmtData();
        } else if (command.equals("PUT_FILE")) {
            String filename = "" + serviceClientResult;
            if (filename.endsWith("srv/groups/nodeGroups.xml")) {
                this.refreshNodeGroups();
            }
        } else if (command.equals("REFRESH_NODEGROUPS")) {
            this.refreshNodeGroups();
        } else if (command.equals("GET_ALL_ASSIGNMENTS")) {
            this.getAllAssignments().refresh();
        } else if (command.equals("GET_AGENT_INVENTORY_CARD")) {
            this.updateOpenAgentCardInventory((AgentInventoryCard)serviceClientResult);
            AgentOverviewTableRefreshJobLight uJob2 = new AgentOverviewTableRefreshJobLight(Display.getDefault(), "RefreshAgentOverviewTab");
            Repository.getUIJobManager().schedule(uJob2);
        } else if (command.equals("GET_AGENT_VERSIONS")) {
            Map nm;
            if (serviceClientResult != null && (nm = (Map)serviceClientResult).size() > 0) {
                this.m_agentVersions.clear();
                this.m_agentVersions.putAll(nm);
            }
            AgentOverviewTableRefreshJobLight uJob2 = new AgentOverviewTableRefreshJobLight(Display.getDefault(), "RefreshAgentOverviewTab");
            Repository.getUIJobManager().schedule(uJob2);
        } else if (command.equals("GETFILE")) {
            if (serviceClientResult != null && serviceClientResult instanceof File) {
                File incoming = (File)serviceClientResult;
                if ("boom_packages.xml".equals(incoming.getName())) {
                    this.parseBinaryTree(incoming);
                    try {
                        BinariesListView.getInstance().refreshTree(false);
                    }
                    catch (Throwable throwable) {}
                    PolicyManager.getInstance().refreshAssignmentTree();
                } else if (incoming.getAbsolutePath().endsWith(NODE_GROUPS_XML)) {
                    this.refreshNodeGroups();
                }
            }
        } else if (command.equals("GET_SLAVES")) {
            this.m_slaves = new LinkedHashMap<String, SSCLite>();
            ScGetSlaves scgs = (ScGetSlaves)serviceClientResult;
            Object list = scgs.getResultObject();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SSCLite ssc = (SSCLite)iterator.next();
                this.m_slaves.put(ssc.getHostName(), ssc);
            }
        } else if (command.equals("GET_AGENTS_CM")) {
            if (serviceClientResult != null) {
                Map acmList = (Map)serviceClientResult;
                for (Map.Entry en : acmList.entrySet()) {
                    AgentCard ac = this.getAgentCard((String)en.getKey());
                    if (ac == null) continue;
                    ac.setAgentCardCM((AgentCardCM)en.getValue());
                }
            }
        } else if (command.equals("GET_AGENT_CM_LABELS") && serviceClientResult != null) {
            this.m_agentCMLabels.clear();
            this.m_agentCMLabels.putAll((Map)serviceClientResult);
        }
    }

    public boolean updateAgentCards(Map<String, AgentCard> resultFromClient) {
        boolean isTreeStructureChanged = false;
        LinkedList<AgentCard> onlyNewAgentCards = new LinkedList<AgentCard>();
        if (this.m_agentCardsMap == null) {
            this.m_agentCardsMap = new ConcurrentHashMap<String, AgentCard>(resultFromClient);
            return true;
        }
        if (resultFromClient != null) {
            HashMap<String, Object> externalHosts = new HashMap<String, Object>();
            HashMap<String, AgentCard> toUpdate = new HashMap<String, AgentCard>();
            HashMap processedIDs = new HashMap(resultFromClient.size(), 1.0f);
            for (AgentCard fetched : resultFromClient.values()) {
                AgentCard agentCard;
                if (fetched.isExternal()) {
                    this.applyExternalHostMapping(externalHosts, fetched);
                }
                if ((agentCard = this.getAgentCard(fetched.getAgentID())) != null) {
                    int changeLevel = agentCard.updateFrom(fetched);
                    if (changeLevel > 0) {
                        toUpdate.put(agentCard.getID(), agentCard);
                        if (changeLevel > 1) {
                            isTreeStructureChanged = true;
                        }
                    }
                } else {
                    fetched.m_forceRefresh = 2;
                    isTreeStructureChanged = true;
                    this.m_agentCardsMap.put(fetched.getID(), fetched);
                    onlyNewAgentCards.add(fetched);
                }
                processedIDs.put(fetched.getAgentID(), null);
            }
            this.m_externalHostsMapping.putAll(externalHosts);
            this.m_externalHostsMapping.keySet().retainAll(externalHosts.keySet());
            this.updateOpenAgentCardTabs(toUpdate);
            ArrayList<String> toDelete = new ArrayList<String>();
            Iterator<AgentCard> itA = this.getAgentCards().iterator();
            while (itA.hasNext()) {
                AgentCard ac = itA.next();
                if (processedIDs.containsKey(ac.getAgentID())) continue;
                ac.m_forceRefresh = 3;
                isTreeStructureChanged = true;
                itA.remove();
                toDelete.add(ac.toString());
            }
            this.deleteOpenAgentCardTabs(toDelete);
        }
        if (onlyNewAgentCards.size() > 0) {
            EventStatusRefreshJob rfrJob = new EventStatusRefreshJob(onlyNewAgentCards);
            JobManager.getInstance().schedule(rfrJob);
        }
        return isTreeStructureChanged;
    }

    public void updateOpenAgentCardTabs(final Map<String, AgentCard> acMap) {
        UIJob uJob = new UIJob(Display.getDefault(), "acu" + System.currentTimeMillis()){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    Repository.this.gui_updateOpenedAC(acMap);
                }
                catch (Throwable throwable) {}
                return Status.OK_STATUS;
            }
        };
        Repository.getUIJobManager().schedule(uJob);
    }

    public void updateOpenAgentCardInventory(final AgentInventoryCard aci) {
        UIJob uJob = new UIJob(Display.getDefault(), "aci" + aci.getID()){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                block6: {
                    try {
                        CTabFolder folder;
                        AgentCard ac = Repository.this.getAgentCard(aci.getID());
                        if (ac != null) {
                            ac.setInventoryCard(aci);
                            Repository.this.m_agentVersions.put(ac.getID(), aci.getAttribute(AgentInventoryCard.getPath("VERSION")));
                        }
                        if ((folder = AgentCardView.getInstance().getFolder()) == null) break block6;
                        CTabItem[] openTabs = folder.getItems();
                        int i = 0;
                        while (i < openTabs.length) {
                            if (openTabs[i] instanceof AgentTab) {
                                AgentTab opened = (AgentTab)openTabs[i];
                                AgentCard agentCard = opened.getAgentCard();
                                String ID = agentCard.getID();
                                if (aci.getID().equals(ID)) {
                                    opened.udpateAgentInventoryCard(aci);
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {}
                }
                return Status.OK_STATUS;
            }
        };
        Repository.getUIJobManager().schedule(uJob);
    }

    public void updateAgentCard(AgentCard ac) {
        AgentCard acUI1 = this.getAgentCard(ac.getAgentID());
        if (acUI1 == null) {
            return;
        }
        int refreshType = acUI1.updateFrom(ac);
        final List<GroupTreeObject> treeObjectList = this.m_agentTree.findElements(acUI1.getName(), acUI1.getType());
        treeObjectList.addAll(this.m_agentTree.findLinksByName(acUI1.getName(), acUI1.getType()));
        final AgentCard acUI = acUI1;
        switch (refreshType) {
            case 0: {
                break;
            }
            case 1: {
                UIJob uJob = new UIJob(Display.getDefault(), "updAC" + acUI.getAgentID()){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            HashMap<String, AgentCard> m = new HashMap<String, AgentCard>(1);
                            m.put(acUI.getAgentID(), acUI);
                            Repository.this.gui_updateOpenedAC(m);
                        }
                        catch (Throwable throwable) {}
                        for (StructuredViewer tv : Repository.this.m_agentTreeViewers) {
                            tv.update(treeObjectList.toArray(), null);
                        }
                        return Status.OK_STATUS;
                    }
                };
                Repository.getUIJobManager().schedule(uJob);
                break;
            }
            case 2: {
                ArrayList<GroupTreeObject> additionalRefreshElements = new ArrayList<GroupTreeObject>(2);
                for (GroupTreeObject agentGtol : treeObjectList) {
                    GroupTreeObject osGtoOld = agentGtol.getParent();
                    if (osGtoOld.getName().equals(ac.getOSName())) continue;
                    osGtoOld.removeElement(agentGtol);
                    if (osGtoOld.getElements().size() == 0) {
                        osGtoOld.getParent().removeElement(osGtoOld);
                        additionalRefreshElements.add(osGtoOld.getParent());
                    }
                    if (ac.getOSName().indexOf("(BS:") != -1) {
                        GroupTreeObject gtoSlaveOS = this.addSlavesAndOSFolders(ac.getOSName(), this.m_agentTree);
                        gtoSlaveOS.addElement(agentGtol);
                        additionalRefreshElements.add(gtoSlaveOS);
                        continue;
                    }
                    String os_lowercase = ac.getOSName().toLowerCase();
                    String type = AgentCard.getParentOSImageName(os_lowercase);
                    GroupTreeObject newOsGto = osGtoOld.getParent().getChild(ac.getOSName(), type);
                    if (newOsGto == null) {
                        newOsGto = new GroupTreeObject(new TreeObject(ac.getOSName(), type, null));
                        osGtoOld.getParent().addElement(newOsGto);
                        additionalRefreshElements.add(osGtoOld.getParent());
                    }
                    newOsGto.addElement(agentGtol);
                    additionalRefreshElements.add(newOsGto);
                }
                additionalRefreshElements.addAll(treeObjectList);
                treeObjectList.clear();
                treeObjectList.addAll(additionalRefreshElements);
                final boolean isStructureChange = refreshType == 2;
                UIJob uJob2 = new UIJob(Display.getDefault(), "rfrAC" + acUI.getAgentID()){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            HashMap<String, AgentCard> m = new HashMap<String, AgentCard>(1);
                            m.put(acUI.getAgentID(), acUI);
                            Repository.this.gui_updateOpenedAC(m);
                        }
                        catch (Throwable throwable) {}
                        Repository.getUIJobManager().schedule(new RefreshAgentTreeUIJob(isStructureChange, treeObjectList));
                        return Status.OK_STATUS;
                    }
                };
                Repository.getUIJobManager().schedule(uJob2);
                RTLogger.print(5, "UI refresh single agent (%s) job scheduled", acUI.getAgentID());
                break;
            }
        }
    }

    public void deleteOpenAgentCardTabs(final List<String> name) {
        UIJob uJob = new UIJob(Display.getDefault(), "acd" + System.currentTimeMillis()){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    CTabFolder folder = AgentCardView.getInstance().getFolder();
                    CTabItem[] openTabs = folder.getItems();
                    int i = 0;
                    while (i < openTabs.length) {
                        if (name.contains(openTabs[i].getText())) {
                            openTabs[i].dispose();
                            return Status.OK_STATUS;
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {}
                return Status.OK_STATUS;
            }
        };
        Repository.getUIJobManager().schedule(uJob);
    }

    public String getHelp(String id) {
        String help = this.m_helps.get(id);
        if (help == null && id.length() > 30) {
            help = this.fetchHelp(id);
        }
        return help;
    }

    public void addAgentAssignmentsViewer(Viewer v) {
        this.m_agentAssignmentsViewers.add(v);
    }

    public static void setUserDirectory(String profileDir, String user, String server) {
        if (server == null || server.length() == 0) {
            server = "localhost";
        }
        if (!profileDir.endsWith("/") && !profileDir.endsWith("\\")) {
            profileDir = String.valueOf(profileDir) + '/';
        }
        m_userTmpDir = String.valueOf(profileDir) + FileUtils.getValidFileName(user) + "_" + FileUtils.getValidFileName(server);
        try {
            File expectedDir;
            String oldDirectoryPath = String.valueOf(profileDir) + user + "_" + server;
            File oldProfile = new File(oldDirectoryPath);
            if (oldProfile.exists() && oldProfile.isDirectory() && !(expectedDir = new File(m_userTmpDir)).exists() && !oldProfile.renameTo(expectedDir)) {
                new ShowMessageBox("Warning", "Old profile directory: " + oldProfile.getAbsolutePath() + "\ncan not be renamed to a new: " + expectedDir.getAbsolutePath() + "\nProbably some files locked by another application...", 1);
            }
        }
        catch (Throwable throwable) {}
    }

    public static String getUserDirectory() {
        return m_userTmpDir;
    }

    public static String getUserTmpDirectory() {
        return String.valueOf(Repository.getUserDirectory()) + File.separator + "tmp";
    }

    public static String getUserPoliciesDirectory() {
        return String.valueOf(Repository.getUserDirectory()) + File.separator + "policies" + File.separator;
    }

    public void checkPlugInVersion() {
        block11: {
            try {
                ProtectionDomain pDomain = this.getClass().getProtectionDomain();
                CodeSource cSource = pDomain.getCodeSource();
                URL loc = cSource.getLocation();
                String filename = loc.getFile();
                int st = filename.indexOf("com.blixx.boom.gui_");
                if (st != -1) {
                    filename = filename.substring(st);
                    String version1 = filename.replace("com.blixx.boom.gui_", "");
                    version1 = version1.replace(".jar", "");
                    String[] arr = version1.split("\\Q.\\E");
                    int h = Integer.parseInt(arr[0]);
                    int t = Integer.parseInt(arr[1]);
                    int d = 0;
                    try {
                        d = Integer.parseInt(arr[2]);
                    }
                    catch (Throwable throwable) {}
                    BMUI.GUI_VERSION = h + "." + t + "." + d;
                    BMUI.GUI_VERSION_INT = 100000 * h + 1000 * t + d;
                    try {
                        String url = loc.toString();
                        url = url.replace(" ", "%20");
                        m_pluginFile = new File(new URI(url));
                        RTLogger.print(1, "plugin file: " + m_pluginFile.getCanonicalPath());
                        return;
                    }
                    catch (Throwable e) {
                        RTLogger.print(1, "plugin file err ", e);
                    }
                }
                String loc1 = Platform.getInstallLocation().getURL().getFile();
                File pluginDir = new File(loc1 = String.valueOf(loc1) + File.separator + "plugins");
                if (!pluginDir.exists() || !pluginDir.isDirectory()) break block11;
                File[] list = pluginDir.listFiles(new FileFilter(".jar"));
                int i = 0;
                while (i < list.length) {
                    File f = list[i];
                    if (f.isFile() && f.getName().startsWith("com.blixx.boom.gui_")) {
                        m_pluginFile = f;
                        RTLogger.print(1, "plugin file: " + m_pluginFile.getCanonicalPath());
                        String version1 = f.getName().replace("com.blixx.boom.gui_", "");
                        version1 = version1.replace(".jar", "");
                        String[] arr = version1.split("\\Q.\\E");
                        int h = Integer.parseInt(arr[0]);
                        int t = Integer.parseInt(arr[1]);
                        int d = 0;
                        try {
                            d = Integer.parseInt(arr[2]);
                        }
                        catch (Throwable throwable) {}
                        BMUI.GUI_VERSION = h + "." + t + "." + d;
                        BMUI.GUI_VERSION_INT = 100000 * h + 1000 * t + d;
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                RTLogger.print(1, "plugin file err2 ", e);
            }
        }
    }

    public BrowserLabelManager getBrowserLabelManager() {
        return this.m_browserLabelsManager;
    }

    public UserManager getUserManager() {
        return this.m_userManager;
    }

    public static void scheduleAnyUpdate() {
        ScGetAnyUpdates sc = new ScGetAnyUpdates(Repository.getInstance(), BMUI.GUI_VERSION_INT);
        sc.addCmdPostProcess(Repository.getInstance());
        m_jobManager.schedule(sc, 10000L);
    }

    @Override
    public String getHostName() {
        return BMUI.localhost;
    }

    @Override
    public String getPasswordEncrypted() {
        return m_pass;
    }

    @Override
    public int getPort() {
        return BMUI.port;
    }

    @Override
    public int getProtocolVersion() {
        return this.m_protocolVersion;
    }

    @Override
    public String getSessionID() {
        return m_sessionUUID;
    }

    @Override
    public String getUser() {
        return m_user;
    }

    @Override
    public void setProtocolVersion(int arg0) {
        this.m_protocolVersion = arg0;
    }

    @Override
    public void setVersionUnknown() {
        this.m_protocolVersion = 0;
    }

    @Override
    public ArrayList<String> getAssociatedAgentIDs(NodeGroupForwardFilter filter) {
        ArrayList<String> list = new ArrayList<String>();
        for (String pat : filter.getPaths()) {
            Map<String, Object> array = this.m_nodeGroups_pathToID.getHashMap(pat);
            if (array == null || array.size() <= 0) continue;
            list.addAll(array.keySet());
        }
        return list;
    }

    @Override
    public Map<String, Object> getAssociatedAgentIDsMap(NodeGroupForwardFilter filter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String pat : filter.getPaths()) {
            Map<String, Object> array = this.m_nodeGroups_pathToID.getHashMap(pat);
            if (array == null || array.size() <= 0) continue;
            map.putAll(array);
        }
        return map;
    }

    @Override
    public ArrayList<String> getAssociatedAgentIDsByNGOID(String oid) {
        ArrayList<String> agentIDs = new ArrayList<String>();
        String[] oidArr = oid.split("\\Q|\\E");
        int j = 0;
        while (j < oidArr.length) {
            try {
                Map<String, Object> array;
                GroupTreeObject ng = this.getNodeGroupTree().findByOID(oidArr[j]);
                if (ng != null && (array = this.m_nodeGroups_pathToID.getHashMap(ng.getPath())) != null) {
                    agentIDs.addAll(array.keySet());
                }
            }
            catch (Throwable throwable) {}
            ++j;
        }
        return agentIDs;
    }

    @Override
    public Map<String, Object> getAssociatedAgentIDsByNGOIDMap(String oid) {
        HashMap<String, Object> agentIDs = new HashMap<String, Object>();
        String[] oidArr = oid.split("\\Q|\\E");
        int j = 0;
        while (j < oidArr.length) {
            try {
                Map<String, Object> array;
                GroupTreeObject ng = this.getNodeGroupTree().findByOID(oidArr[j]);
                if (ng != null && (array = this.m_nodeGroups_pathToID.getHashMap(ng.getPath())) != null) {
                    agentIDs.putAll(array);
                }
            }
            catch (Throwable throwable) {}
            ++j;
        }
        return agentIDs;
    }

    public boolean isOutageSupported() {
        return this.m_isOutageSupported;
    }

    public String getAgentCMLabel(String fieldName) {
        String label = this.m_agentCMLabels.get(fieldName);
        return label == null ? fieldName : label;
    }

    public String getAgentCMDataType(String label) {
        if (this.m_agentCMLabels.containsKey(label)) {
            return label;
        }
        for (String attr : this.m_agentCMLabels.keySet()) {
            String l = this.m_agentCMLabels.get(attr);
            if (!l.equals(label)) continue;
            return attr;
        }
        return label;
    }

    @Override
    public void addNodeGroup(String path) {
        ScAddNodeGroup sc = new ScAddNodeGroup(this, path);
        sc.addCmdPostProcess(new ScErrorShowMessage("Error adding node group: " + path));
        Repository.getJobManager().schedule(sc);
    }

    @Override
    public boolean deleteNodeGroup(List<String> paths) {
        ScDeleteNodeGroup sc = new ScDeleteNodeGroup(this, paths);
        sc.addCmdPostProcess(new ScErrorShowMessage("Error deleting node groups: " + paths));
        Repository.getJobManager().schedule(sc);
        return true;
    }

    @Override
    public void linkAgent(String path, List<String> agentIDs) {
        ScLinkAgent2NodeGroup sc = new ScLinkAgent2NodeGroup(this, path, agentIDs);
        sc.addCmdPostProcess(new ScErrorShowMessage("Error linking agent to node group: " + path));
        Repository.getJobManager().schedule(sc);
    }

    @Override
    public void renameNodeGroup(String oldPath, String newPath) {
        ScRenameNodeGroup sc = new ScRenameNodeGroup(this, oldPath, newPath);
        sc.addCmdPostProcess(new ScErrorShowMessage("Error renaming node group: " + oldPath));
        Repository.getJobManager().schedule(sc);
    }

    @Override
    public boolean unlinkAgent(List<String> paths) {
        ScUnlinkAgentFromNodeGroup sc = new ScUnlinkAgentFromNodeGroup(this, paths);
        sc.addCmdPostProcess(new ScErrorShowMessage("Error unlinking agent from node group: " + paths));
        Repository.getJobManager().schedule(sc);
        return true;
    }

    private void gui_updateOpenedAC(Map<String, AgentCard> acMap) {
        CTabFolder folder = AgentCardView.getInstance().getFolder();
        if (folder != null) {
            CTabItem[] openTabs = folder.getItems();
            int i = 0;
            while (i < openTabs.length) {
                AgentTab opened;
                String ID;
                if (openTabs[i] instanceof AgentTab && acMap.containsKey(ID = (opened = (AgentTab)openTabs[i]).getAgentCard().getID())) {
                    AgentCard ac = acMap.get(ID);
                    boolean wasDirty = opened.isDirty();
                    if (!wasDirty) {
                        opened.udpateFields(ac);
                        opened.setDirty(wasDirty);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public List<String> getNodeGroupPathes(String agentID) {
        return null;
    }

    public boolean isServerOnline() {
        return this.m_guiClient == null ? false : this.m_guiClient.isONLINE();
    }

    public boolean isPermittedAgentModify(AbstractAgentCard ac) {
        String agentID = ac.getAgentID();
        return this.isPermittedAgentModify(agentID);
    }

    public boolean isPermittedAgentModify(String agentID) {
        boolean isGuest = this.getRights(1002) == 2;
        PGEntityPermissionFlag flagPriority = isGuest ? PGEntityPermissionFlag.ENFORCE : PGEntityPermissionFlag.RESTRICT;
        List<GroupTreeObjectLast> linkedAgents = this.getNodeGroupTree().findLinksByName(agentID, "agt");
        if (linkedAgents != null && linkedAgents.size() > 0) {
            for (GroupTreeObjectLast gtol : linkedAgents) {
                String modifyPermit = gtol.findTopAttribute(PGEntityAction.MODIFY.name());
                if (modifyPermit == null || flagPriority != PGEntityPermissionFlag.valueOf(modifyPermit)) continue;
                return isGuest;
            }
        } else if (isGuest) {
            return false;
        }
        return !isGuest;
    }

    public boolean isPermittedNodeGroupModify(GroupTreeObject folder) {
        if (folder != null) {
            String modifyAttr = folder.findTopAttribute(PGEntityAction.MODIFY.name());
            String readAttr = folder.findTopAttribute(PGEntityAction.READ.name());
            if (modifyAttr != null && modifyAttr.equals(PGEntityPermissionFlag.RESTRICT.name()) || readAttr != null && readAttr.equals(PGEntityPermissionFlag.RESTRICT.name())) {
                return false;
            }
        }
        return true;
    }

    public void cleanDataOnReconnect() {
        this.m_agentCardsMap.clear();
    }
}

