/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.GAssignments;
import com.blixx.boom.engine.Repository;
import com.blixx.shared.DeploymentStatus;
import com.blixx.shared.utils.GroupTreeObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class RunningAssignmentsProvider
implements IStructuredContentProvider {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public CellLabelProvider labelProvider = new CellLabelProvider(){

        public String getToolTipText(Object element) {
            StringBuffer htmlStr = new StringBuffer();
            htmlStr.append("<html>").append("<head><style type=\"text/css\">").append("body { margin-left:5px; margin-right:5px; margin-top:5px; margin-bottom:5px }").append("</style></head><body bgcolor='#FFFFE1'><font face='Arial' size='1' color='#000000'>");
            if (element instanceof DeploymentStatus) {
                DeploymentStatus ds = (DeploymentStatus)element;
                for (String filename : ds.getFileNames()) {
                    htmlStr.append(filename).append(" ");
                }
            }
            htmlStr.append("</font></body></html>");
            return htmlStr.toString();
        }

        public Point getToolTipShift(Object object) {
            return new Point(3, 3);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 50;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 9999999;
        }

        public void update(ViewerCell cell) {
            DeploymentStatus asn = null;
            int columnIndex = cell.getColumnIndex();
            if (!(cell.getElement() instanceof DeploymentStatus)) {
                return;
            }
            asn = (DeploymentStatus)cell.getElement();
            String result = RunningAssignmentsProvider.this.getColumnText(asn, columnIndex);
            Image image = RunningAssignmentsProvider.this.getColumnImage(asn, columnIndex);
            cell.setText(result);
            cell.setImage(image);
        }
    };

    public Object[] getElements(Object arg0) {
        return Repository.getInstance().getAllAssignments().getRunningDeployments().toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }

    public Image getColumnImage(DeploymentStatus asn, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (asn.getType().equals("UPKG") || asn.getType().equals("PKG")) {
                    return BMUI.IMAGE_PKG;
                }
                if (asn.getType().equals("UNDEPLOY_POLICES") || asn.getType().equals("POLICY")) {
                    int monCount = 0;
                    int msgCount = 0;
                    List<String> files = asn.getFileNames();
                    int i = 0;
                    while (i < files.size()) {
                        String f = files.get(i);
                        if (f.endsWith("mon.xml")) {
                            ++monCount;
                        } else {
                            ++msgCount;
                        }
                        ++i;
                    }
                    if (msgCount > 0 && monCount == 0) {
                        return BMUI.IMAGE_MSG;
                    }
                    if (monCount > 0 && msgCount == 0) {
                        return BMUI.IMAGE_MON;
                    }
                    return BMUI.IMAGE_NAG;
                }
                if (!asn.getType().equals("JAR")) break;
                return BMUI.IMAGE_PC;
            }
        }
        return null;
    }

    public String getColumnText(DeploymentStatus asn, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "" + asn.getFileNames().size();
            }
            case 2: {
                return asn.getFileNames().toString();
            }
            case 3: {
                return GAssignments.getDeploymentState(asn.getState());
            }
            case 4: {
                return asn.getType().startsWith("U") ? "Undeploy" : "Deploy";
            }
            case 5: {
                String oid = asn.getAcid();
                if (oid != null && oid.length() == 32) {
                    GroupTreeObject nodeGroup = Repository.getInstance().getAgentTree().findByOID(oid);
                    if (nodeGroup != null) {
                        oid = nodeGroup.getPath();
                    }
                    return oid;
                }
                String str = asn.getAcid();
                AgentCard ac1 = Repository.getInstance().getAgentCard(asn.getAcid());
                if (ac1 != null) {
                    str = ac1.toString().replace("(X)", "");
                }
                return str;
            }
            case 6: {
                return this.sdf.format(new Date(asn.getInitTime()));
            }
            case 7: {
                return this.sdf.format(new Date(asn.getExpireTime()));
            }
        }
        return null;
    }
}

