/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.GUIJob;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.TlsUtils;
import com.blixx.boom.exception.ConnectionException;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.ctrl.sc.IRunnableExt;
import com.blixx.ctrl.sc.in.ScGetAgentOutagePolicy;
import com.blixx.ctrl.sc.in.ScGetAgentServerPolicies;
import com.blixx.ctrl.sc.in.ScGetAssigned;
import com.blixx.ctrl.sc.in.ScGetModifyServerPolicies;
import com.blixx.ctrl.sc.in.ScGetModifyServerPolicy;
import com.blixx.ctrl.sc.in.ScGetServerPolicies;
import com.blixx.ctrl.sc.in.ScGetServerPolicy;
import com.blixx.ctrl.sc.in.ScGetSlaves;
import com.blixx.log.RTLogger;
import com.blixx.shared.AgentInventoryCard;
import com.blixx.shared.Assignment;
import com.blixx.shared.IODataStream;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.UItem;
import com.blixx.shared.User;
import com.blixx.shared.UserRole;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.ArchiveDetails;
import com.blixx.shared.utils.VersionComparator;
import com.blixx.shared.utils.ZIP;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ServerClient
implements IRunnableExt {
    public static final String CMD_GPV = "GPV";
    protected static Integer m_detectedServerProtocolVersion = 2;
    private static ExecutorService m_executor = new ThreadPoolExecutor(0, 50, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    protected String m_action = null;
    protected String[] m_parameters = null;
    public String m_command = null;
    protected Object m_result = null;
    protected boolean isFinished = false;
    protected boolean isOKFinished = false;
    protected IODataStream[] m_object = null;
    protected SEvent[] m_events = null;
    protected boolean m_isFinished = false;
    protected int m_timeout = -1;

    public static Integer getDetectedServerProtocolVersion() {
        return BMUI.m_activateTls ? 0 : m_detectedServerProtocolVersion;
    }

    public static void setDetectedServerProtocolVersion(int version) {
    }

    public static void resetDetectedServerProtocolVersion() {
    }

    public ServerClient(String command, String action, String[] parameters) {
        this.m_command = command;
        this.m_action = action;
        this.m_parameters = parameters;
    }

    public ServerClient(String command, String action, IODataStream[] objects) {
        this.m_command = command;
        this.m_action = action;
        this.m_object = objects;
    }

    public ServerClient(String command, String action, SEvent[] objects) {
        this.m_command = command;
        this.m_action = action;
        this.m_events = objects;
    }

    public static ServerClient putAnnotation(String msgID, String annot) {
        return new ServerClient("PUT_ANNOT", msgID, new String[]{annot});
    }

    public static ServerClient deleteFiles(String[] params) {
        return new ServerClient("DELETEPOLICY", null, params);
    }

    public static ServerClient updateAssignmentTree(String[] params) {
        return new ServerClient("ASSIGNMENTTREEUPDATE2", null, params);
    }

    public static ServerClient updateAssignmentTree(String treePath, String newElem, String action, String type) {
        return new ServerClient("ASSIGNMENTTREEUPDATE2", null, new String[]{treePath, newElem, action, type});
    }

    public static ServerClient getFile(String[] name_type_dir) {
        return new ServerClient("GETFILE", null, name_type_dir);
    }

    public static ServerClient getFileSlave(String[] name_type_slave_dir) {
        return new ServerClient("GETFILE_SLAVE", null, name_type_slave_dir);
    }

    public static ServerClient deleteAction(String actionID) {
        return new ServerClient("UPDATEACTIONTREE", "DELETE", new String[]{actionID});
    }

    public static ServerClient deleteActionGrp(String name) {
        return new ServerClient("UPDATEACTIONTREE", "DELETE_GRP", new String[]{name});
    }

    public static ServerClient moveAction(String id, String newGroup) {
        return new ServerClient("UPDATEACTIONTREE", "MOVE", new String[]{id, newGroup});
    }

    public static ServerClient renameActionGrp(String oldName, String newName) {
        return new ServerClient("UPDATEACTIONTREE", "RENAME_GRP", new String[]{oldName, newName});
    }

    public static ServerClient addGrp(String newName) {
        return new ServerClient("UPDATEACTIONTREE", "ADD_GRP", new String[]{newName});
    }

    public static ServerClient getAllAssignments() {
        return new ServerClient("GET_ALL_ASSIGNMENTS", null, new String[0]);
    }

    public static ServerClient deleteFile(String path) {
        return new ServerClient("DELETE_FILE", path, new String[0]);
    }

    public static ServerClient createFile(String path) {
        return new ServerClient("CREATE_FILE", path, new String[0]);
    }

    public static ServerClient deleteFolder(String path) {
        return new ServerClient("DELETE_FOLDER", path, new String[0]);
    }

    public static ServerClient createFolder(String path) {
        return new ServerClient("CREATE_FOLDER", path, new String[0]);
    }

    public static ServerClient renameFile(String path, String newPath) {
        return new ServerClient("RENAME_FILE", path, new String[]{newPath});
    }

    public static ServerClient putFile(String path, String tempFilePath) {
        return new ServerClient("PUT_FILE", path, new String[]{tempFilePath});
    }

    public static ServerClient renamePackage(String path, String newPath) {
        return new ServerClient("RENAME_PKG", path, new String[]{newPath});
    }

    public static ServerClient triggerDelayedDeployments(String[] agentIDs) {
        return new ServerClient("DEPLOYMENT_TRIGGER", null, agentIDs);
    }

    public static ServerClient triggerDelayedDeploymentsFiltered(String[] assignmentsIDs) {
        return new ServerClient("DEPLOYMENT_TRIGGER_FILTERED", null, assignmentsIDs);
    }

    public static ServerClient cancelDelayedDeployments(String[] assignmentsIDs) {
        return new ServerClient("DEPLOYMENT_CANCEL", null, assignmentsIDs);
    }

    public static ServerClient getForwardFilters() {
        return new ServerClient("GET_FORWARD_FILTERS", null, new String[0]);
    }

    public static ServerClient getForwardPolicies() {
        return new ServerClient("GET_FORWARD_POLICIES", null, new String[0]);
    }

    public static ServerClient putForwardFilters(String filters_fgf_xml) {
        return new ServerClient("PUT_FORWARD_FILTERS", filters_fgf_xml, new String[0]);
    }

    public static ServerClient updateForwardPolicy(String name, String filters_fgf_xml) {
        return new ServerClient("UPDATE_FORWARD_POLICIES", name, new String[]{filters_fgf_xml});
    }

    public static ServerClient deleteForwardPolicy(String name) {
        return new ServerClient("DELETE_FORWARD_POLICIES", name, new String[0]);
    }

    public static ServerClient activateForwardPolicy(String name, boolean active) {
        return new ServerClient("ACTIVATE_FORWARD_POLICIES", name, new String[]{"" + active});
    }

    public static ServerClient getMIBS() {
        return new ServerClient("GET_MIBS", null, new String[0]);
    }

    public static ServerClient searchPolicies(String searchText, String[] properties) {
        return new ServerClient("CMD_SEARCH_POLICIES", searchText, properties);
    }

    @Override
    public void run() {
        try {
            try {
                this.runInUIThread(null);
                GUIJob job = GUIJob.getRepositoryRefresh(this.m_command, this.isSuccess(), this.getResultObject());
                Repository.getUIJobManager().schedule(job);
            }
            catch (Throwable throwable) {
                this.m_isFinished = true;
            }
        }
        finally {
            this.m_isFinished = true;
        }
    }

    @Override
    public synchronized void start() {
        boolean started = false;
        do {
            try {
                m_executor.execute(this);
                started = true;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                try {
                    Thread.sleep(10L);
                }
                catch (Throwable throwable) {}
            }
        } while (!started);
    }

    /*
     * Loose catch block
     */
    public IStatus runInUIThread(IProgressMonitor monitor) {
        SDataInputStream is;
        SDataOutputStream os;
        Socket sock;
        block32: {
            sock = null;
            os = null;
            is = null;
            sock = new Socket();
            sock.bind(null);
            sock.setSoTimeout(60000);
            sock.setTcpNoDelay(true);
            sock.setSoLinger(true, 1);
            if (this.m_timeout > 0) {
                sock.setSoTimeout(this.m_timeout);
            }
            sock.connect(new InetSocketAddress(BMUI.localhost, (int)BMUI.port), 20000);
            is = new SDataInputStream(sock.getInputStream());
            os = new SDataOutputStream(sock.getOutputStream(), ServerClient.getDetectedServerProtocolVersion());
            if (BMUI.m_activateTls) {
                sock = TlsUtils.upgradeToTLS(sock);
            }
            String str = is.readUTF();
            os.setVersion(is.getLastProtocolVersion());
            int res = this.processServerQuestion(str, os, is);
            if (res == 0) {
                if (m_detectedServerProtocolVersion == null) {
                    ServerClient.detectProtocolVersion(os, is);
                }
                this.runCommand(is, os);
                os.writeUTF("EXIT");
                break block32;
            }
            Status status = new Status(2, "com.blixx.boom.gui", "Server connection failed 2.");
            this.isFinished = true;
            try {
                os.write(0);
                os.close();
            }
            catch (Throwable throwable) {}
            try {
                is.close();
            }
            catch (Throwable throwable) {}
            RTLogger.print(3, String.valueOf(this.m_command) + " is finished");
            try {
                sock.close();
            }
            catch (Throwable throwable) {}
            return status;
            catch (Throwable e) {
                Status status2;
                try {
                    RTLogger.print(1, "", e);
                    status2 = new Status(2, "com.blixx.boom.gui", e.getMessage());
                    this.isFinished = true;
                }
                catch (Throwable throwable) {
                    this.isFinished = true;
                    try {
                        os.write(0);
                        os.close();
                    }
                    catch (Throwable throwable2) {}
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {}
                    RTLogger.print(3, String.valueOf(this.m_command) + " is finished");
                    try {
                        sock.close();
                    }
                    catch (Throwable throwable4) {}
                    throw throwable;
                }
                try {
                    os.write(0);
                    os.close();
                }
                catch (Throwable throwable) {}
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
                RTLogger.print(3, String.valueOf(this.m_command) + " is finished");
                try {
                    sock.close();
                }
                catch (Throwable throwable) {}
                return status2;
            }
        }
        this.isFinished = true;
        try {
            os.write(0);
            os.close();
        }
        catch (Throwable throwable) {}
        try {
            is.close();
        }
        catch (Throwable throwable) {}
        RTLogger.print(3, String.valueOf(this.m_command) + " is finished");
        try {
            sock.close();
        }
        catch (Throwable throwable) {}
        return Status.OK_STATUS;
    }

    public static void detectProtocolVersion(SDataOutputStream os, SDataInputStream is) {
        try {
            os.writeUTF("VALIDATE_CMD");
            os.writeUTF(CMD_GPV);
            String status = is.readUTF();
            if (status.equals("T")) {
                os.writeUTF(CMD_GPV);
                is.readInt();
            }
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error protocol version detection.", e);
        }
    }

    public void setTimeout(int milliseconds) {
        this.m_timeout = milliseconds;
    }

    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        RTLogger.print(3, String.valueOf(this.m_command) + " is started");
        Integer codeI = CMDS.m_acceptable.get(this.m_command);
        int code = -1;
        if (codeI != null) {
            code = codeI;
        }
        boolean processed = true;
        switch (code) {
            case 17: {
                this.requestJOB(is, os);
                break;
            }
            case 24: {
                this.requestAgentCards(is, os);
                break;
            }
            case 27: {
                this.requestPolicies(is, os);
                break;
            }
            case 28: {
                this.requestAssignments(is, os);
                break;
            }
            case 29: {
                this.requestAllAssignments(is, os);
                break;
            }
            case 35: {
                if (this.m_parameters != null && this.m_parameters.length == 2 && "boom_packages.xml".equals(this.m_parameters[0])) {
                    this.m_parameters = new String[]{this.m_parameters[0], this.m_parameters[1], Repository.getUserDirectory()};
                }
                this.requestFile(is, os);
                break;
            }
            case 36: {
                this.requestFileSlave(is, os);
                break;
            }
            case 30: 
            case 204: {
                this.pushFile(is, os);
                break;
            }
            case 32: {
                this.policyTreeUpdate(is, os);
                break;
            }
            case 34: {
                this.assignmentTreeUpdate(is, os);
                break;
            }
            case 31: {
                this.deleteFile(is, os);
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 117: {
                this.deploy(is, os);
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                this.acknmsg(is, os);
                break;
            }
            case 56: {
                ScGetAssigned sc = new ScGetAssigned(Repository.getInstance(), this.m_action);
                sc.processAssigned(is, os);
                break;
            }
            case 37: {
                this.requestActions(is, os);
                break;
            }
            case 58: {
                this.updateAction(is, os);
                break;
            }
            case 71: {
                this.m_command = "GET_ACKN_IDSA";
                this.getAcknIDsA(is, os);
                break;
            }
            case 73: {
                this.getAcknIDs(is, os);
                break;
            }
            case 74: {
                this.getAcknIDsA(is, os);
                break;
            }
            case 76: {
                this.getHelps(is, os);
                break;
            }
            case 77: {
                this.getHelp(is, os);
                break;
            }
            case 78: {
                this.getVersions(is, os);
                break;
            }
            case 80: {
                this.getUsers(is, os);
                break;
            }
            case 81: {
                this.getUserRoles(is, os);
                break;
            }
            case 82: {
                this.getUItems(is, os);
                break;
            }
            case 79: {
                this.getUserRole(is, os);
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                this.processObjects(is, os);
                break;
            }
            case 89: {
                this.processGetAnnotation(is, os);
                break;
            }
            case 90: {
                this.processPutAnnotation(is, os);
                break;
            }
            case 59: {
                this.processUpdateActionTree(is, os);
                break;
            }
            case 65: {
                this.processPutFile(is, os);
                break;
            }
            case 67: {
                this.processDeleteFile(is, os);
                break;
            }
            case 118: {
                this.processDeleteFolder(is, os);
                break;
            }
            case 66: {
                this.processRenameFile(is, os);
                break;
            }
            case 68: {
                this.processCreateFile(is, os);
                break;
            }
            case 69: {
                this.processCreateFolder(is, os);
                break;
            }
            case 70: {
                this.processRenameFile(is, os);
                break;
            }
            case 51: 
            case 127: {
                this.processDeploymentTrigger(is, os);
                break;
            }
            case 52: {
                this.processDeploymentCancel(is, os);
                break;
            }
            case 91: {
                this.processGetForwardFilters(is, os);
                break;
            }
            case 92: {
                this.processPutForwardFilters(is, os);
                break;
            }
            case 93: {
                this.processGetForwardPolicies(is, os);
                break;
            }
            case 94: {
                this.processUpdateForwardPolicies(is, os);
                break;
            }
            case 95: {
                this.processDeleteForwardPolicies(is, os);
                break;
            }
            case 96: {
                this.processActivateForwardPolicy(is, os);
                break;
            }
            case 98: {
                this.processCheckUpdate(is, os);
                break;
            }
            case 99: {
                this.processGUIUpdate(is, os);
                break;
            }
            case 116: {
                this.processValidate(is, os);
                break;
            }
            case 100: {
                this.processGetArchived(is, os);
                break;
            }
            case 101: {
                this.getAgentInventoryCard(is, os);
                break;
            }
            case 102: {
                this.processTriggerAgentInventory(is, os);
                break;
            }
            case 108: {
                this.requestMIBS(is, os);
                break;
            }
            case 131: 
            case 132: {
                this.processOwnDisown(is, os);
                break;
            }
            case 201: {
                this.putFileSlave(is, os);
                break;
            }
            case 130: {
                this.searchPolicies(is, os);
                break;
            }
            case 126: {
                this.getConnectedUsers(is, os);
                break;
            }
            case 203: {
                this.processReopenIndi(is, os);
                break;
            }
            case 125: {
                this.sendCmdToOtherUIs(is, os);
                break;
            }
            case 124: {
                this.processSetSJobConfig(is, os);
                break;
            }
            case 104: {
                this.getPoliciesDetails(is, os);
                break;
            }
            case 103: {
                this.processAnyUpdate(is, os);
                break;
            }
            case 109: {
                this.getUIProfile(is, os);
                break;
            }
            case 110: {
                this.processUpdateIndications(is, os);
                break;
            }
            case 111: {
                this.triggerMasterUpdate(is, os);
                break;
            }
            case 113: {
                this.getAgentVersions(is, os);
                break;
            }
            case 115: {
                this.getBinPkgZip(is, os);
                break;
            }
            case 119: {
                this.processSJobList(is, os);
                break;
            }
            case 120: {
                this.processSetSJobReload(is, os);
                break;
            }
            case 121: {
                this.processSJobSetActive(is, os);
                break;
            }
            case 122: {
                this.processSJobTrigger(is, os);
                break;
            }
            case 123: {
                this.processGestSJobConfig(is, os);
                break;
            }
            case 134: {
                ScGetServerPolicy scgsop = new ScGetServerPolicy(null, this.m_action);
                this.m_result = scgsop;
                scgsop.runDirect(is, os);
                this.isOKFinished = scgsop.isSuccess();
                break;
            }
            case 139: {
                ScGetAgentOutagePolicy scgaop = new ScGetAgentOutagePolicy(null, this.m_action);
                this.m_result = scgaop;
                scgaop.runDirect(is, os);
                this.isOKFinished = scgaop.isSuccess();
                break;
            }
            case 144: {
                ScGetModifyServerPolicy scm = new ScGetModifyServerPolicy(null, this.m_action);
                this.m_result = scm;
                scm.runDirect(is, os);
                this.isOKFinished = scm.isSuccess();
                break;
            }
            case 138: {
                ScGetServerPolicies scsps = new ScGetServerPolicies(null);
                this.m_result = scsps;
                scsps.runDirect(is, os);
                this.isOKFinished = scsps.isSuccess();
                break;
            }
            case 143: {
                ScGetAgentServerPolicies scaos = new ScGetAgentServerPolicies(null);
                this.m_result = scaos;
                scaos.runDirect(is, os);
                this.isOKFinished = scaos.isSuccess();
                break;
            }
            case 148: {
                ScGetModifyServerPolicies scmps = new ScGetModifyServerPolicies(null);
                this.m_result = scmps;
                scmps.runDirect(is, os);
                this.isOKFinished = scmps.isSuccess();
                break;
            }
            case 157: {
                ScGetSlaves scSL = new ScGetSlaves(null);
                this.m_result = scSL;
                scSL.runDirect(is, os);
                this.isOKFinished = scSL.isSuccess();
                break;
            }
            case 205: {
                throw new RuntimeException("deprecated");
            }
            case 211: {
                throw new RuntimeException("deprecated");
            }
            default: {
                processed = false;
            }
        }
        if (!processed && this.m_command.equals("REFRESH_NODEGROUPS")) {
            this.processRefreshNodeGroups(is, os);
        }
    }

    private void getPoliciesDetails(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("GET_POLICIES_DETAILS");
        String validation = is.readUTF();
        if (validation.equals("F")) {
            this.m_result = null;
        } else {
            os.writeUTF("GET_POLICIES_DETAILS");
            int size = is.readInt();
            HashMap<String, String[]> details = new HashMap<String, String[]>();
            int i = 0;
            while (i < size) {
                String line = is.readUTF();
                String[] rr = line.split("\u25ba");
                String[] arr = new String[rr.length - 1];
                System.arraycopy(rr, 1, arr, 0, arr.length);
                details.put(rr[0], arr);
                ++i;
            }
            this.m_result = details;
            this.isOKFinished = true;
        }
    }

    private void processAnyUpdate(SDataInputStream is, SDataOutputStream os) {
        try {
            os.writeUTF("GET_ANYUPDATE");
            os.writeInt(BMUI.GUI_VERSION_INT);
            this.m_result = is.readUTF();
            this.isOKFinished = true;
        }
        catch (Throwable throwable) {
            this.isOKFinished = false;
        }
    }

    private void getUIProfile(SDataInputStream is, SDataOutputStream os) throws IOException, FileNotFoundException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("GET_UI_PROFILE");
        String validation = is.readUTF();
        if (validation.equals("F")) {
            this.m_result = null;
        } else {
            String status;
            os.writeUTF("GET_UI_PROFILE");
            String fullPath = String.valueOf(Repository.getUserTmpDirectory()) + File.separator + "profile.xml";
            is.readUTF();
            long size = is.readLong();
            if (size > 0L) {
                is.readFile(fullPath);
            }
            if ((status = is.readUTF()).equals("T")) {
                this.isOKFinished = true;
                this.m_result = new File(fullPath);
            } else {
                this.isOKFinished = false;
                this.m_result = null;
            }
        }
    }

    private void processUpdateIndications(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("UPDATE_INDICATION");
        String validation = is.readUTF();
        if (validation.equals("F")) {
            this.m_result = null;
        } else if (this.m_events == null || this.m_events.length == 0) {
            this.isOKFinished = true;
        } else {
            os.writeUTF("UPDATE_INDICATION");
            int i = 0;
            os.writeBoolean(i < this.m_events.length);
            while (i < this.m_events.length) {
                SEvent se = this.m_events[i];
                if (se instanceof SEventFwd) {
                    SEventFwd sef = (SEventFwd)se;
                    sef.sendSv2(os);
                } else {
                    se.sendS(os);
                }
                os.writeBoolean(i + 1 < this.m_events.length);
                ++i;
            }
            is.readUTF();
            this.isOKFinished = true;
        }
    }

    private void triggerMasterUpdate(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("TRIGGER_MASTER_UPDATE");
        os.writeUTF(this.m_action);
        os.writeUTF(this.m_parameters[0]);
        String validation = is.readUTF();
        validation.equals("T");
    }

    private void getAgentVersions(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("GET_AGENT_VERSIONS");
        String validation = is.readUTF();
        if (!validation.equals("T")) {
            this.m_result = null;
            this.isOKFinished = false;
        } else {
            os.writeUTF("GET_AGENT_VERSIONS");
            String versions = is.readUTF();
            is.readUTF();
            StringTokenizer st = new StringTokenizer(versions, "|");
            HashMap<String, String> verMap = new HashMap<String, String>();
            while (st.hasMoreTokens()) {
                String idplusver = st.nextToken();
                if (idplusver.length() < 37) continue;
                String id = idplusver.substring(0, 36);
                String ver = idplusver.substring(36).intern();
                verMap.put(id, ver);
            }
            this.m_result = verMap;
            this.isOKFinished = true;
        }
    }

    private void getBinPkgZip(SDataInputStream is, SDataOutputStream os) throws IOException, FileNotFoundException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("GET_BINPKG_ZIP");
        String validation = is.readUTF();
        if (!validation.equals("T")) {
            this.m_result = null;
            this.isOKFinished = false;
        } else {
            os.writeUTF("GET_BINPKG_ZIP");
            os.writeUTF(this.m_action);
            String status = is.readUTF();
            String message = is.readUTF();
            this.m_result = message;
            if ("T".equals(status)) {
                String filename = is.readUTF();
                long size = is.readLong();
                String tmpFile = String.valueOf(Repository.getUserTmpDirectory()) + File.separator + filename;
                if (size > 0L) {
                    is.readFile(tmpFile);
                    this.m_result = tmpFile;
                } else {
                    this.m_result = null;
                }
                this.isOKFinished = true;
            } else {
                this.isOKFinished = false;
            }
        }
    }

    private void processSJobList(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("SJOBS_LIST");
        this.m_result = is.readUTF();
        String res = is.readUTF();
        this.isOKFinished = "T".equals(res);
    }

    private void processSetSJobReload(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("SJOBS_RELOAD");
        this.m_result = is.readUTF();
        this.isOKFinished = "T".equals(this.m_result);
    }

    private void processSJobSetActive(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("SJOBS_SETACTIVE");
        os.writeUTF(this.m_action);
        os.writeUTF(this.m_parameters[0]);
        this.m_result = is.readUTF();
        this.isOKFinished = "T".equals(this.m_result);
    }

    private void processSJobTrigger(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("SJOBS_TRIGGER");
        os.writeUTF(this.m_action);
        this.m_result = is.readUTF();
        this.isOKFinished = "T".equals(this.m_result);
    }

    private void processGestSJobConfig(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("SJOBS_GETCONFIG");
        os.writeUTF(this.m_action);
        this.m_result = is.readUTF();
        String res = is.readUTF();
        this.isOKFinished = "T".equals(res);
    }

    private void processSetSJobConfig(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("SJOBS_SETCONFIG");
        os.writeUTF(this.m_action);
        this.m_result = is.readUTF();
        this.isOKFinished = "T".equals(this.m_result);
    }

    private void sendCmdToOtherUIs(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("SEND_CMD");
        os.writeUTF(this.m_action);
        if (this.m_parameters != null && this.m_parameters.length > 0) {
            os.writeUTF(this.m_parameters[0]);
            os.writeInt(this.m_parameters.length - 1);
            int i = 1;
            while (i < this.m_parameters.length) {
                os.writeUTF(this.m_parameters[i]);
                ++i;
            }
        } else {
            os.writeUTF("");
            os.writeInt(0);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        } else {
            this.m_result = status;
        }
    }

    private void processReopenIndi(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeInt(this.m_parameters.length);
        int i = 0;
        while (i < this.m_parameters.length) {
            os.writeUTF(this.m_parameters[i]);
            ++i;
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void getConnectedUsers(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("GET_CONNECTED_USERS");
        String users = is.readUTF();
        String[] arr = users.split("\\Q\u25ba\\E");
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(arr));
        this.m_result = list;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void searchPolicies(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("CMD_SEARCH_POLICIES");
        if (this.m_action == null) {
            os.writeUTF("");
        } else {
            os.writeUTF(this.m_action);
        }
        if (this.m_parameters == null || this.m_parameters.length == 0) {
            os.writeInt(0);
        } else {
            os.writeInt(this.m_parameters.length);
            int i = 0;
            while (i < this.m_parameters.length) {
                os.writeUTF(this.m_parameters[i]);
                ++i;
            }
        }
        int size = is.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < size) {
            String result = is.readUTF();
            map.put(result, "");
            ++i;
        }
        this.m_result = map;
        String status = is.readUTF();
        this.isOKFinished = "T".equals(status);
    }

    private void processOwnDisown(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeInt(this.m_parameters.length);
        int i = 0;
        while (i < this.m_parameters.length) {
            os.writeUTF(this.m_parameters[i]);
            ++i;
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void putFileSlave(SDataInputStream is, SDataOutputStream os) throws IOException, FileNotFoundException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeUTF(this.m_parameters[1]);
        FileInputStream fis = new FileInputStream(this.m_parameters[0]);
        os.writeFile(fis);
        fis.close();
        this.m_result = this.m_action;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void processRefreshNodeGroups(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        this.m_command = "GETFILE";
        this.m_action = null;
        this.m_parameters = new String[]{"srv/groups/nodeGroups.xml", BMUI.type_file, String.valueOf(Repository.getUserTmpDirectory()) + "/"};
        this.requestFile(is, os);
        this.m_command = "REFRESH_NODEGROUPS";
        this.isOKFinished = true;
    }

    private void requestMIBS(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("GET_MIBS");
        String validation = is.readUTF();
        if (!validation.equals("T")) {
            StringBuilder sb = new StringBuilder("Server does not support this feature. Please upgrade the ").append("BOOM").append(" Server!");
            this.m_result = sb.toString();
            this.isOKFinished = false;
            return;
        }
        os.writeUTF("GET_MIBS");
        String tmpZip = String.valueOf(Repository.getUserTmpDirectory()) + File.separator + "mibs" + System.currentTimeMillis() + ".zip";
        is.readFile(tmpZip);
        String ok = is.readUTF();
        if (ok.equals("T")) {
            ZIP zip = new ZIP();
            try {
                zip.unzip(tmpZip, String.valueOf(Repository.getUserDirectory()) + File.separator + "mibs");
            }
            catch (Throwable throwable) {}
            File tz = new File(tmpZip);
            try {
                tz.delete();
            }
            catch (Throwable throwable) {}
            this.isOKFinished = true;
            this.m_result = "mibs are loaded";
        } else {
            this.isOKFinished = false;
            this.m_result = "Error getting mibs from the server";
        }
    }

    private void processTriggerAgentInventory(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("TRIGGER_AGENT_INVENTORY_CARD");
        String validation = is.readUTF();
        if (validation.equals("F")) {
            this.m_result = null;
        } else {
            os.writeUTF("TRIGGER_AGENT_INVENTORY_CARD");
            os.writeUTF(this.m_action);
            String status = is.readUTF();
            status.equals("T");
            this.isOKFinished = true;
        }
    }

    private void getAgentInventoryCard(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("GET_AGENT_INVENTORY_CARD");
        String validation = is.readUTF();
        if (validation.equals("F")) {
            this.m_result = null;
        } else {
            os.writeUTF("GET_AGENT_INVENTORY_CARD");
            os.writeUTF(this.m_action);
            AgentInventoryCard aci = new AgentInventoryCard(this.m_action);
            aci.read(is);
            String status = is.readUTF();
            status.equals("T");
            this.m_result = aci;
            this.isOKFinished = true;
        }
    }

    private void processGetArchived(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("GET_ARCHIVED");
        String validation = is.readUTF();
        if (validation.equals("F")) {
            this.m_result = null;
        } else {
            ArchiveDetails ad = new ArchiveDetails();
            this.m_result = ad;
            os.writeUTF("GET_ARCHIVED");
            os.writeLong(Long.parseLong(this.m_parameters[0]));
            os.writeLong(Long.parseLong(this.m_parameters[1]));
            os.writeUTF(this.m_parameters[2]);
            int bbbSize = -1;
            while ((bbbSize = is.readInt()) > 0) {
                byte[] bbi = new byte[bbbSize];
                is.readFully(bbi);
                ByteArrayInputStream bis = new ByteArrayInputStream(bbi);
                SDataInputStream byteIS = new SDataInputStream(bis);
                while (byteIS.readBoolean()) {
                    SEventFwd e = new SEventFwd();
                    try {
                        e.readSv2(byteIS);
                    }
                    catch (Throwable throwable) {
                        RTLogger.print(4, "Reading of an archived SEvent failed " + bbbSize);
                        throw new RuntimeException("Failed");
                    }
                    ad.m_events.add(e);
                }
            }
            this.m_result = ad;
            ad.m_restRecords = is.readInt();
            ad.m_minStime = is.readLong();
            is.readUTF();
        }
    }

    private void processValidate(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        String status = is.readUTF();
        this.isOKFinished = status.equals("T");
    }

    private void processCheckUpdate(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        this.m_result = is.readUTF();
        String status = is.readUTF();
        status.equals("T");
        this.isOKFinished = true;
    }

    private void processGUIUpdate(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        String filename = is.readUTF();
        long size = is.readLong();
        if (size == 0L) {
            RTLogger.print(1, "Update failed. File not found on the server.");
            this.isOKFinished = false;
        } else {
            String name = String.valueOf(Repository.m_pluginFile.getParentFile().getCanonicalPath()) + File.separator + filename;
            is.readFile(name);
            RTLogger.print(1, "Update GUI file stored: " + name);
            this.isOKFinished = true;
        }
        is.readUTF();
    }

    private void processDeploymentTrigger(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeInt(this.m_parameters.length);
        int i = 0;
        while (i < this.m_parameters.length) {
            os.writeUTF(this.m_parameters[i]);
            ++i;
        }
        String status = is.readUTF();
        this.isOKFinished = status.equals("T");
    }

    private void processDeploymentCancel(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeInt(this.m_parameters.length);
        int i = 0;
        while (i < this.m_parameters.length) {
            os.writeUTF(this.m_parameters[i]);
            ++i;
        }
        String status = is.readUTF();
        status.equals("T");
        this.isOKFinished = true;
    }

    private void processPutFile(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        FileInputStream fis = new FileInputStream(this.m_parameters[0]);
        os.writeFile(fis);
        fis.close();
        this.m_result = this.m_action;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void processDeleteFile(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        } else {
            this.m_result = status;
        }
    }

    private void processRenameFile(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeUTF(this.m_parameters[0]);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        } else {
            this.m_result = status;
        }
    }

    private void processCreateFile(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        } else {
            this.m_result = status;
        }
    }

    private void processDeleteFolder(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        } else {
            this.m_result = status;
        }
    }

    private void processCreateFolder(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        } else {
            this.m_result = status;
        }
    }

    private void processUpdateActionTree(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeInt(this.m_parameters.length);
        int i = 0;
        while (i < this.m_parameters.length) {
            os.writeUTF(this.m_parameters[i]);
            ++i;
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        } else {
            this.m_result = status;
        }
    }

    private void processGetAnnotation(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        int expected = is.readInt();
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        while (i < expected) {
            al.add(is.readUTF());
            ++i;
        }
        this.m_result = al;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void processPutAnnotation(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeUTF(this.m_parameters[0]);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void processObjects(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeInt(this.m_object.length);
        int i = 0;
        while (i < this.m_object.length) {
            this.m_object[i].send(os);
            ++i;
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
            this.m_result = "Success";
        } else {
            this.m_result = "Failed";
        }
    }

    private void getHelps(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        HashMap<String, String> helps = new HashMap<String, String>();
        int size = is.readInt();
        int i = 0;
        while (i < size) {
            String id = is.readUTF();
            String help = is.readUTF();
            if (help.length() == 0) {
                help = "";
            }
            helps.put(id, help);
            ++i;
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
            this.m_result = helps;
        }
    }

    private void getHelp(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        String status;
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        String help = is.readUTF();
        if (help.length() == 0) {
            help = "";
        }
        if ((status = is.readUTF()).equals("T")) {
            this.isOKFinished = true;
            this.m_result = help;
        }
    }

    private void requestJOB(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeInt(this.m_parameters.length);
        int i = 0;
        while (i < this.m_parameters.length) {
            os.writeUTF(this.m_parameters[i]);
            ++i;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (RuntimeException runtimeException) {}
        String OK = is.readUTF();
        if (OK.equals("T")) {
            this.isOKFinished = true;
            RTLogger.print(3, "JOB is done");
        } else {
            RTLogger.print(3, "JOB FAILED");
        }
    }

    private void requestAgentCards(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        HashMap<String, AgentCard> al = new HashMap<String, AgentCard>();
        os.writeUTF(this.m_command);
        int size = is.readInt();
        int i = 0;
        while (i < size) {
            AgentCard ac = new AgentCard();
            ac.read(is);
            al.put(ac.getAgentID(), ac);
            RTLogger.print(6, "AC: " + ac + " " + ac.getMode());
            ++i;
        }
        this.m_result = al;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void requestPolicies(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        is.readLong();
        File zipFile = new File(PolicyManager.getInstance().getPolicyGroupsFilename());
        is.readFile(zipFile.getCanonicalPath());
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void requestAssignments(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        is.readLong();
        File zipFile = new File(PolicyManager.getInstance().getAssignmentGroupsFilename());
        is.readFile(zipFile.getCanonicalPath());
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
            PolicyManager.getInstance().processResult();
        }
    }

    private void requestAllAssignments(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        ArrayList<Assignment> result = new ArrayList<Assignment>();
        int c = 0;
        while (is.readBoolean()) {
            Assignment asn = new Assignment();
            asn.read(is);
            result.add(asn);
            ++c;
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
            this.m_result = result;
            RTLogger.print(5, "Assignments count: " + c);
            Repository.getInstance().getAllAssignments().processResult(result);
        }
    }

    private void requestActions(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        if (this.m_action == null) {
            this.m_action = Repository.getInstance().getActionsDirectory();
        }
        if (!this.m_action.endsWith(File.separator)) {
            this.m_action = String.valueOf(this.m_action) + File.separator;
        }
        try {
            File tempDir = new File(this.m_action);
            File[] files = tempDir.listFiles();
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
        }
        catch (Throwable throwable) {
            RTLogger.print(2, "Can't clean up dir " + this.m_action);
        }
        int filesCount = is.readInt();
        int j = 0;
        while (j < filesCount) {
            String filename = is.readUTF();
            long size = is.readLong();
            if (size > 0L) {
                File file = new File(String.valueOf(this.m_action) + filename);
                is.readFile(file.getCanonicalPath());
            }
            ++j;
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int processServerQuestion(String question, SDataOutputStream os, SDataInputStream is) throws IOException, ConnectionException {
        int res = 0;
        if (question.equalsIgnoreCase("login")) {
            os.writeUTF(String.valueOf(Repository.m_user) + '\u25ba' + Repository.m_sessionUUID);
            String nextToken = is.readUTF();
            if (!nextToken.equalsIgnoreCase("password")) throw new ConnectionException("login name unknown");
            os.writeUTF(Repository.m_pass);
            String response = is.readUTF();
            if (response.equals("OK")) return res;
            throw new ConnectionException(response);
        }
        if (!question.equalsIgnoreCase("valid")) return res;
        RTLogger.print(2, "Login is still valid");
        return 7;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean isSuccess() {
        return this.isOKFinished;
    }

    public Object getResultObject() {
        return this.m_result;
    }

    private void deploy(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        int size = this.m_parameters.length / 2;
        RTLogger.print(5, "sizeofdeploy=" + size);
        os.writeInt(size);
        int i = 0;
        while (i < this.m_parameters.length) {
            String objectType = this.m_parameters[i];
            String objectName = this.m_parameters[i + 1];
            os.writeUTF(objectType);
            os.writeUTF(objectName);
            i += 2;
        }
        this.m_result = is.readUTF();
        String status = is.readUTF();
        this.isOKFinished = status.equals("T");
    }

    private void acknmsg(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        int i = 0;
        int max = 10000;
        while (i < this.m_parameters.length) {
            os.writeUTF(this.m_command);
            StringBuffer sb = new StringBuffer();
            int j = 0;
            while (j < max && i < this.m_parameters.length) {
                sb.append(this.m_parameters[i]);
                ++i;
                sb.append(',');
                ++j;
            }
            os.writeUTF(sb.toString());
            this.m_result = is.readUTF();
            String status = is.readUTF();
            if (status.equals("T")) {
                this.isOKFinished = true;
                continue;
            }
            this.isOKFinished = false;
            break;
        }
    }

    private void requestFile(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        String objectName = this.m_parameters[0];
        String objectType = this.m_parameters[1];
        String dir = this.m_parameters[2];
        os.writeUTF(this.m_command);
        os.writeUTF(objectName);
        os.writeUTF(objectType);
        String filename = is.readUTF();
        long size = is.readLong();
        File wFile = null;
        if (size >= 0L) {
            File dirF;
            RTLogger.print(5, "F: " + filename + " size=" + size);
            String addDir = "";
            if (filename.indexOf(47) != -1) {
                addDir = filename.substring(0, filename.lastIndexOf(47));
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                if (addDir.startsWith("/")) {
                    addDir = addDir.substring(1);
                }
            }
            if (!dir.endsWith("/") && !dir.endsWith("\\")) {
                dir = String.valueOf(dir) + "/";
            }
            if (!(dirF = new File(String.valueOf(dir) + addDir)).exists()) {
                dirF.mkdirs();
            }
            wFile = new File(dirF, filename);
            if (size > 0L) {
                is.readFile(wFile.getCanonicalPath());
            } else {
                wFile.delete();
                wFile.createNewFile();
            }
        } else {
            RTLogger.print(5, "Requested file not found. Object name: " + objectName + " type=" + objectType);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = size >= 0L;
            this.m_result = wFile;
        }
    }

    private void requestFileSlave(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        String objectName = this.m_parameters[0];
        String objectType = this.m_parameters[1];
        String slaveServer = this.m_parameters[2];
        String dir = this.m_parameters[3];
        os.writeUTF(this.m_command);
        os.writeUTF(objectName);
        os.writeUTF(objectType);
        os.writeUTF(slaveServer);
        String filename = is.readUTF();
        long size = is.readLong();
        File wFile = null;
        if (size >= 0L) {
            File dirF;
            RTLogger.print(5, "F: " + filename + " size=" + size);
            String addDir = "";
            if (filename.indexOf(47) != -1) {
                addDir = filename.substring(0, filename.lastIndexOf(47));
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                if (addDir.startsWith("/")) {
                    addDir = addDir.substring(1);
                }
            }
            if (!dir.endsWith("/") && !dir.endsWith("\\")) {
                dir = String.valueOf(dir) + "/";
            }
            if (!(dirF = new File(String.valueOf(dir) + addDir)).exists()) {
                dirF.mkdirs();
            }
            wFile = new File(dirF, filename);
            if (size > 0L) {
                is.readFile(wFile.getCanonicalPath());
            } else {
                wFile.delete();
                wFile.createNewFile();
            }
        } else {
            RTLogger.print(5, "Requested file not found. Object name: " + objectName + " type=" + objectType);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = size >= 0L;
            this.m_result = wFile;
        }
    }

    protected void getVersions(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        String objectName = this.m_parameters[0];
        String objectType = this.m_parameters[1];
        os.writeUTF(this.m_command);
        os.writeUTF(objectName);
        os.writeUTF(objectType);
        int size = is.readInt();
        ArrayList<String> versions = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            versions.add(is.readUTF());
            ++i;
        }
        Collections.sort(versions, new VersionComparator());
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = size != 0;
            this.m_result = versions;
        }
    }

    private void pushFile(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        String objectName = this.m_parameters[0];
        String objectType = this.m_parameters[1];
        String file = this.m_parameters[2];
        String treePath = this.m_parameters[3];
        os.writeUTF(this.m_command);
        os.writeUTF(objectName);
        os.writeUTF(objectType);
        File f = new File(file);
        long size = f.length();
        os.writeUTF(f.getName());
        os.writeUTF(treePath);
        os.writeLong(size);
        FileInputStream fis = new FileInputStream(f);
        try {
            os.writeFile(fis);
            this.m_result = is.readUTF();
            String status = is.readUTF();
            this.isOKFinished = status.equals("T");
        }
        catch (Throwable throwable) {
            try {
                fis.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            fis.close();
        }
        catch (Throwable throwable) {}
    }

    private void policyTreeUpdate(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        String treePath = this.m_parameters[0];
        String newElement = this.m_parameters[1];
        String action = this.m_parameters[2];
        os.writeUTF(this.m_command);
        os.writeUTF(treePath);
        os.writeUTF(newElement);
        os.writeUTF(action);
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void assignmentTreeUpdate(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        int size = this.m_parameters.length;
        os.writeInt(size / 4);
        int i = 0;
        while (i < size) {
            String treePath = this.m_parameters[i];
            String newElement = this.m_parameters[i + 1];
            String action = this.m_parameters[i + 2];
            String type = this.m_parameters[i + 3];
            os.writeUTF(treePath);
            os.writeUTF(newElement);
            os.writeUTF(action);
            os.writeUTF(type);
            i += 4;
        }
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void deleteFile(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        int size = this.m_parameters.length;
        os.writeInt(size / 3);
        int i = 0;
        while (i < size) {
            String name = this.m_parameters[i];
            String type = this.m_parameters[i + 1];
            String filename = this.m_parameters[i + 2];
            os.writeUTF(name);
            os.writeUTF(type);
            os.writeUTF(filename);
            i += 3;
        }
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void updateAction(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        this.m_object[0].send(os);
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void getAcknIDs(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        LinkedList<String> ids = new LinkedList<String>();
        while (is.readBoolean()) {
            String ID = is.readUTF();
            ids.add(ID);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        Repository.getEventStorageSubmit().checkAcknIDs(ids);
    }

    private void getAcknIDsA(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        String allIDs_separatedByComma = is.readUTF();
        String[] ids = allIDs_separatedByComma.split(",");
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        List<String> al = Arrays.asList(ids);
        Repository.getEventStorageSubmit().checkAcknIDs(al);
    }

    private void getUsers(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        int size = is.readInt();
        ArrayList<User> al = new ArrayList<User>(size);
        int i = 0;
        while (i < size) {
            User u = new User();
            u.read(is);
            al.add(u);
            RTLogger.print(5, "User: " + u);
            ++i;
        }
        this.m_result = al;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void getUserRoles(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        int size = is.readInt();
        ArrayList<UserRole> al = new ArrayList<UserRole>(size);
        int i = 0;
        while (i < size) {
            UserRole u = UserRole.createNewRole();
            u.read(is);
            al.add(u);
            RTLogger.print(5, "UserRole: " + u);
            ++i;
        }
        this.m_result = al;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void getUItems(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        int size = is.readInt();
        ArrayList<UItem> al = new ArrayList<UItem>(size);
        int i = 0;
        while (i < size) {
            UItem u = new UItem(new HashMap());
            u.read(is);
            al.add(u);
            RTLogger.print(5, "UItem: " + u);
            ++i;
        }
        this.m_result = al;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void getUserRole(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_parameters[0]);
        String isOK = is.readUTF();
        if (isOK.equals("T")) {
            UserRole urole = UserRole.createNewRole();
            this.m_result = urole.read(is);
        } else {
            this.m_result = isOK;
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void extractZip(File zipFile) {
        try {
            ZipInputStream in = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                int len;
                File nf = new File(zipFile.getParent(), entry.getName());
                FileOutputStream out = new FileOutputStream(nf);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
            }
            in.close();
        }
        catch (IOException e) {
            RTLogger.print(3, "", e);
        }
    }

    private void processGetForwardPolicies(SDataInputStream is, SDataOutputStream os) throws IOException {
        File ldir;
        os.writeUTF(this.m_command);
        int size = is.readInt();
        if (this.m_action == null) {
            this.m_action = Repository.getUserPoliciesDirectory();
        }
        if (!(ldir = new File(this.m_action)).exists()) {
            ldir.mkdirs();
        }
        File[] fpList = ldir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(BMUI.file_extension_fwd);
            }
        });
        int i = 0;
        while (i < fpList.length) {
            File oldCached = fpList[i];
            oldCached.delete();
            ++i;
        }
        i = 0;
        while (i < size) {
            String filename = is.readUTF();
            long filesize = is.readLong();
            if (filesize > 0L) {
                File fwdFile = new File(this.m_action, filename);
                is.readFile(fwdFile.getCanonicalPath());
            }
            ++i;
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void processGetForwardFilters(SDataInputStream is, SDataOutputStream os) throws IOException {
        String status;
        if (this.m_action == null) {
            this.m_action = Repository.getUserPoliciesDirectory();
        }
        os.writeUTF(this.m_command);
        String filename = is.readUTF();
        long filesize = is.readLong();
        if (filesize > 0L) {
            is.readFile(String.valueOf(this.m_action) + File.separator + filename);
        }
        if ((status = is.readUTF()).equals("T")) {
            this.isOKFinished = true;
            this.m_result = String.valueOf(this.m_action) + File.separator + filename;
        }
    }

    private void processPutForwardFilters(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        FileInputStream fis = new FileInputStream(this.m_action);
        os.writeFile(fis);
        fis.close();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void processUpdateForwardPolicies(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        FileInputStream fis = new FileInputStream(this.m_parameters[0]);
        os.writeFile(fis);
        fis.close();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void processDeleteForwardPolicies(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void processActivateForwardPolicy(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeBoolean(Boolean.parseBoolean(this.m_parameters[0]));
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(this.m_command);
        if (this.m_action != null) {
            res.append(" ").append(this.m_action);
        }
        if (this.m_parameters != null) {
            int i = 0;
            while (i < this.m_parameters.length) {
                res.append(" ").append(this.m_parameters[i]);
                ++i;
            }
        }
        return res.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerClient) {
            ServerClient sc = (ServerClient)obj;
            if ((this.m_command == sc.m_command || this.m_command != null && this.m_command.equals(sc.m_command)) && (this.m_action == sc.m_action || this.m_action != null && this.m_action.equals(sc.m_action))) {
                if (this.m_parameters == sc.m_parameters) {
                    return true;
                }
                if (this.m_parameters != null && sc.m_parameters != null && this.m_parameters.length == sc.m_parameters.length && this.m_parameters.length < 10) {
                    int i = 0;
                    while (i < this.m_parameters.length) {
                        if (!(this.m_parameters[i] == sc.m_parameters[i] || this.m_parameters[i] != null && this.m_parameters[i].equals(sc.m_parameters[i]))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.m_command == null ? 0 : this.m_command.hashCode();
    }
}

