/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventFilterGroup;
import com.blixx.boom.engine.IEventProvider;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.EventsAndStatus;
import com.blixx.shared.ext.IServiceStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;

public class ServiceDashBoard
extends EventFilter
implements IServiceStatus,
Comparable<ServiceDashBoard> {
    private int m_AVnormal = 0;
    private int m_AVwarn = 0;
    private int m_AVmin = 0;
    private int m_AVmaj = 0;
    private int m_AVcrit = 0;
    private int m_AVMAX = 1;
    private int m_KPInormal = 0;
    private int m_KPIwarn = 0;
    private int m_KPImin = 0;
    private int m_KPImaj = 0;
    private int m_KPIcrit = 0;
    public int m_normal = 0;
    public int m_warn = 0;
    public int m_min = 0;
    public int m_maj = 0;
    public int m_crit = 0;
    private Map<String, SEventFwd> m_IDs = new HashMap<String, SEventFwd>();
    private Map<String, EventFilterGroup> m_filters = new HashMap<String, EventFilterGroup>();
    private String m_name = null;
    private String m_id = null;
    private String m_description = "";
    private int m_serviceMode = 0;
    private boolean m_isChanged = false;
    private EventsAndStatus EaS;
    private AtomicBoolean m_selected = new AtomicBoolean(false);
    private IEventProvider m_eventStorage = null;

    public ServiceDashBoard(String name, IEventProvider ep) {
        this(name, UUID.randomUUID().toString(), ep);
    }

    public ServiceDashBoard(String name, String id, IEventProvider ep) {
        this.m_name = name;
        this.m_id = id;
        this.m_isLocked = true;
        this.m_eventStorage = ep;
    }

    public boolean isGlobalOnly() {
        return this.m_serviceMode == 0;
    }

    public boolean isOverloaded() {
        return this.m_serviceMode == 1;
    }

    public boolean isLocalOnly() {
        return this.m_serviceMode == 2;
    }

    public void setMode(int mode) {
        this.m_serviceMode = mode;
    }

    public int getMode() {
        return this.m_serviceMode;
    }

    public void setChanged() {
        this.m_isChanged = true;
    }

    public boolean isChanged() {
        return this.m_isChanged;
    }

    public String getID() {
        return this.m_id;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDecription(String descr) {
        this.m_description = descr;
    }

    public void addFilters(EventFilterGroup filter) {
        if (filter != null && filter.getName() != null) {
            this.m_filters.put(filter.getName(), filter);
        }
    }

    public void removeFilters(EventFilterGroup filter) {
        if (filter != null && filter.getName() != null) {
            this.m_filters.remove(filter.getName());
        }
    }

    public IServiceStatus getFilterGroupByName(String name) {
        if (name != null && name.length() > 0 && this.m_filters.containsKey(name)) {
            return this.m_filters.get(name);
        }
        return null;
    }

    public Map<String, EventFilterGroup> getFilters() {
        return this.m_filters;
    }

    public Boolean hasFilterGroup(String name) {
        return this.m_filters.containsKey(name);
    }

    public void summarize() {
        this.m_IDs.clear();
        this.EaS = null;
        this.m_AVnormal = 0;
        this.m_AVwarn = 0;
        this.m_AVmin = 0;
        this.m_AVmaj = 0;
        this.m_AVcrit = 0;
        this.m_AVMAX = 1;
        this.m_KPInormal = 0;
        this.m_KPIwarn = 0;
        this.m_KPImin = 0;
        this.m_KPImaj = 0;
        this.m_KPIcrit = 0;
        this.m_normal = 0;
        this.m_warn = 0;
        this.m_min = 0;
        this.m_maj = 0;
        this.m_crit = 0;
        Iterator<String> itfff = this.m_filters.keySet().iterator();
        while (itfff.hasNext()) {
            this.m_filters.get(itfff.next()).cleanMaxis();
        }
        Iterator<String> it = this.m_eventStorage.getActive();
        block1: while (it.hasNext()) {
            String ID = it.next();
            SEventFwd event = (SEventFwd)this.m_eventStorage.getActive(ID);
            for (String nameF : this.m_filters.keySet()) {
                EventFilterGroup efg = this.m_filters.get(nameF);
                if (!efg.isMatched(event)) continue;
                this.applyEvent(event);
                continue block1;
            }
        }
        this.m_isChanged = false;
    }

    private void applyEvent(SEventFwd event) {
        block28: {
            block27: {
                this.m_IDs.put(event.getID(), event);
                if (event.getTypeA() <= 0) break block27;
                switch (event.getSeverityInt()) {
                    case 5: {
                        ++this.m_AVcrit;
                        this.m_AVMAX = 5;
                        break;
                    }
                    case 4: {
                        ++this.m_AVmaj;
                        if (this.m_AVMAX < 4) {
                            this.m_AVMAX = 4;
                            break;
                        }
                        break block28;
                    }
                    case 3: {
                        ++this.m_AVmin;
                        if (this.m_AVMAX < 3) {
                            this.m_AVMAX = 3;
                            break;
                        }
                        break block28;
                    }
                    case 2: {
                        ++this.m_AVwarn;
                        if (this.m_AVMAX < 2) {
                            this.m_AVMAX = 2;
                            break;
                        }
                        break block28;
                    }
                    case 1: {
                        ++this.m_AVnormal;
                        if (this.m_AVMAX < 1) {
                            this.m_AVMAX = 1;
                            break;
                        }
                        break block28;
                    }
                }
                break block28;
            }
            if (event.getTypeK() > 0) {
                switch (event.getSeverityInt()) {
                    case 5: {
                        ++this.m_KPIcrit;
                        break;
                    }
                    case 4: {
                        ++this.m_KPImaj;
                        break;
                    }
                    case 3: {
                        ++this.m_KPImin;
                        break;
                    }
                    case 2: {
                        ++this.m_KPIwarn;
                        break;
                    }
                    case 1: {
                        ++this.m_KPInormal;
                        break;
                    }
                }
            } else {
                switch (event.getSeverityInt()) {
                    case 5: {
                        ++this.m_crit;
                        break;
                    }
                    case 4: {
                        ++this.m_maj;
                        break;
                    }
                    case 3: {
                        ++this.m_min;
                        break;
                    }
                    case 2: {
                        ++this.m_warn;
                        break;
                    }
                    case 1: {
                        ++this.m_normal;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public int getStatusAV() {
        return this.m_AVMAX;
    }

    @Override
    public int getStatusKPI() {
        int res = 0;
        if (this.getKPIcrit() > 0) {
            res = 5;
        } else if (this.getKPImaj() > 0) {
            res = 4;
        } else if (this.getKPImin() > 0) {
            res = 3;
        } else if (this.getKPIwarn() > 0) {
            res = 2;
        } else if (this.getKPInormal() > 0) {
            res = 1;
        }
        return res;
    }

    @Override
    public int getStatusOther() {
        int res = 0;
        if (this.getcrit() > 0) {
            res = 5;
        } else if (this.getmaj() > 0) {
            res = 4;
        } else if (this.getmin() > 0) {
            res = 3;
        } else if (this.getwarn() > 0) {
            res = 2;
        } else if (this.getnormal() > 0) {
            res = 1;
        }
        return res;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public double getKpiWAverage() {
        int sum = this.getKPITotal();
        if (sum == 0) {
            return 0.0;
        }
        double val = (double)this.m_KPInormal / (double)sum * Math.exp(1.0) + (double)this.m_KPIwarn / (double)sum * Math.exp(2.0) + (double)this.m_KPImin / (double)sum * Math.exp(3.0) + (double)this.m_KPImaj / (double)sum * Math.exp(4.0) + (double)this.m_KPIcrit / (double)sum * Math.exp(5.0);
        val = Math.log(val) / Math.log(Math.exp(5.0)) - 0.1;
        return val;
    }

    public int getKPITotal() {
        return this.m_KPIcrit + this.m_KPImaj + this.m_KPImin + this.m_KPIwarn + this.m_KPInormal;
    }

    public int getAVTotal() {
        return this.m_AVcrit + this.m_AVmaj + this.m_AVmin + this.m_AVwarn + this.m_AVnormal;
    }

    public int getSize() {
        return this.m_IDs.size();
    }

    public Map<String, SEventFwd> getIDs() {
        return this.m_IDs;
    }

    public int getcrit() {
        return this.m_crit;
    }

    public int getAVnormal() {
        return this.m_AVnormal;
    }

    public int getAVwarn() {
        return this.m_AVwarn;
    }

    public int getAVmin() {
        return this.m_AVmin;
    }

    public int getAVmaj() {
        return this.m_AVmaj;
    }

    public int getAVcrit() {
        return this.m_AVcrit;
    }

    public int getKPInormal() {
        return this.m_KPInormal;
    }

    public int getKPIwarn() {
        return this.m_KPIwarn;
    }

    public int getKPImin() {
        return this.m_KPImin;
    }

    public int getKPImaj() {
        return this.m_KPImaj;
    }

    public int getKPIcrit() {
        return this.m_KPIcrit;
    }

    public int getnormal() {
        return this.m_normal;
    }

    public int getwarn() {
        return this.m_warn;
    }

    public int getmin() {
        return this.m_min;
    }

    public int getmaj() {
        return this.m_maj;
    }

    @Override
    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        this.cleanCounters();
        int size = elements.length;
        ArrayList<Object> out = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            Object element = elements[i];
            if (this.select(viewer, parent, element)) {
                out.add(element);
            } else {
                this.countInvisible(element);
            }
            ++i;
        }
        this.m_filtered = elements.length - out.size();
        return out.toArray();
    }

    @Override
    public Object[] filter(Viewer viewer, TreePath parentPath, Object[] elements) {
        Object[] arr = this.filter(viewer, parentPath.getLastSegment(), elements);
        return arr;
    }

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        SEvent event = (SEvent)element;
        for (String nameF : this.m_filters.keySet()) {
            EventFilterGroup efg = this.m_filters.get(nameF);
            if (!efg.isMatched(event)) continue;
            return true;
        }
        return false;
    }

    private void countInvisible(Object element) {
        int sev = ((SEvent)element).getSeverityInt();
        if (sev < 0) {
            sev += 6;
        }
        switch (sev) {
            case 0: {
                ++this.m_inactiveUnknown;
                break;
            }
            case 1: {
                ++this.m_inactiveNormal;
                break;
            }
            case 2: {
                ++this.m_inactiveWarning;
                break;
            }
            case 3: {
                ++this.m_inactiveMinor;
                break;
            }
            case 4: {
                ++this.m_inactiveMajor;
                break;
            }
            case 5: {
                ++this.m_inactiveCritical;
                break;
            }
        }
    }

    private void cleanCounters() {
        this.m_inactiveUnknown = 0;
        this.m_inactiveNormal = 0;
        this.m_inactiveWarning = 0;
        this.m_inactiveMinor = 0;
        this.m_inactiveMajor = 0;
        this.m_inactiveCritical = 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ServiceDashBoard) {
            ServiceDashBoard sd = (ServiceDashBoard)obj;
            return this.getID().equals(sd.getID()) && this.getName().equals(sd.getName()) && this.getDescription().equals(sd.getDescription()) && this.getMode() == sd.getMode() && this.equalMaps(this.getFilters(), sd.getFilters());
        }
        return this.toString().equals("" + obj);
    }

    public boolean equalMaps(Map<String, EventFilterGroup> m1, Map<String, EventFilterGroup> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        for (String key : m1.keySet()) {
            if (m1.get(key).equals(m2.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public EventsAndStatus getEvents() {
        if (this.EaS == null) {
            this.EaS = new EventsAndStatus();
            this.EaS.addAll(this.m_IDs.values());
        }
        return this.EaS;
    }

    @Override
    public void invalidateStatus() {
    }

    public boolean isSelected() {
        return this.m_selected.get();
    }

    public void setSelected(boolean selected) {
        this.m_selected.set(selected);
    }

    @Override
    public int compareTo(ServiceDashBoard o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isIdenticalByAttributes(ServiceDashBoard sdb) {
        try {
            EventFilterGroup second;
            Map.Entry<String, EventFilterGroup> entry;
            if (!this.getID().equals(this.getID()) || !this.getName().equals(this.getName()) || !this.getDescription().equals(this.getDescription()) || this.m_filters.size() != sdb.m_filters.size()) return false;
            Iterator<Map.Entry<String, EventFilterGroup>> it = this.m_filters.entrySet().iterator();
            do {
                if (!it.hasNext()) {
                    return true;
                }
                entry = it.next();
                if (!sdb.m_filters.containsKey(entry.getKey())) {
                    return false;
                }
                second = sdb.m_filters.get(entry.getKey());
            } while (entry.getValue().equals(second));
            return false;
        }
        catch (Throwable throwable) {}
        return false;
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public String getLabelOrName() {
        return this.getName();
    }
}

