/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventFilterGroup;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.FilterFactory;
import com.blixx.ctrl.sc.in.ScDeleteFile;
import com.blixx.ctrl.sc.in.ScGetFile;
import com.blixx.log.RTLogger;
import com.blixx.shared.SecureDocumentBuilderFactory;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.Node;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceDashBoardProvider
extends FilterFactory
implements IRefreshable {
    public static int VIEW_ID = 2002;
    public static final String ID = "ID";
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String SSD_LIST = "SSD_LIST";
    public static final String SSD = "SSD";
    public static String SSDFILE = "ssd.xml";
    public static String GLOBAL_SSDFILE = "global.ssd.xml";
    public static final String GLOBAL_SSDFILE_SRV_PATH = "srv/services/" + GLOBAL_SSDFILE;
    private Map<String, ServiceDashBoard> m_efGroup = new HashMap<String, ServiceDashBoard>();
    Boolean m_isLocalChangesAllowed = null;
    private List<IRefreshable> m_refreshable = new ArrayList<IRefreshable>();
    private String currentUserRole = null;
    public static String GLOBAL_STREEFILE = "stree.xml";
    public static final String GLOBAL_STREEFILE_SRV_PATH = "srv/services/" + GLOBAL_STREEFILE;

    public ServiceDashBoardProvider() {
        this.reload();
        this.refresh();
        Repository.getEventProvider().registerRefreshable(this, false);
    }

    public ServiceDashBoardProvider(String userRoleID) {
        this.currentUserRole = userRoleID;
        this.reload();
        this.refresh();
        Repository.getEventProvider().registerRefreshable(this, false);
    }

    public boolean isLocalChangesAllowed() {
        if (this.m_isLocalChangesAllowed == null) {
            int rights = Repository.getInstance().getRights(VIEW_ID);
            this.m_isLocalChangesAllowed = rights > 0 && rights < 3 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return this.m_isLocalChangesAllowed;
    }

    public void reload() {
        File local;
        File global = this.getGlobalFile();
        if (global.exists() && global.canRead() && global.length() > 0L) {
            this.loadGlobalFile(global);
        }
        if ((local = this.getLocalFile()).exists() && local.canRead() && local.length() > 0L) {
            this.loadLocalFile(local);
        }
    }

    public void loadGlobalFile(File file) {
        try {
            this.m_efGroup.clear();
            if (file.length() == 0L) {
                return;
            }
            FileInputStream fio = new FileInputStream(file);
            try {
                Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fio);
                Element top = doc.getDocumentElement();
                NodeList nl = top.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    org.w3c.dom.Node item = nl.item(i);
                    String node = item.getNodeName();
                    if (node.equals(SSD)) {
                        ServiceDashBoard efg = this.createServiceObject(item);
                        efg.setMode(0);
                        efg.setChanged();
                        this.m_efGroup.put(efg.getID(), efg);
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                RTLogger.print(1, "Error parsing xml file: " + e.getMessage());
                RTLogger.print(2, "", e);
            }
            try {
                fio.close();
            }
            catch (Throwable throwable) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            RTLogger.print(1, "Error loading file " + file.getPath());
        }
    }

    public void loadLocalFile(File file) {
        if (!this.isLocalChangesAllowed()) {
            return;
        }
        try {
            if (file.length() == 0L) {
                return;
            }
            boolean resaveLocalFile = false;
            FileInputStream fio = new FileInputStream(file);
            try {
                Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fio);
                Element top = doc.getDocumentElement();
                NodeList nl = top.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    org.w3c.dom.Node item = nl.item(i);
                    String node = item.getNodeName();
                    if (node.equals(SSD)) {
                        ServiceDashBoard efg = this.createServiceObject(item);
                        if (this.m_efGroup.containsKey(efg.getID())) {
                            if (!efg.equals(this.m_efGroup.get(efg.getID()))) {
                                efg.setMode(1);
                                this.m_efGroup.put(efg.getID(), efg);
                            } else {
                                efg.setMode(0);
                                resaveLocalFile = true;
                            }
                        } else {
                            efg.setMode(2);
                            this.m_efGroup.put(efg.getID(), efg);
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                RTLogger.print(1, "Error parsing xml file: " + e.getMessage());
                RTLogger.print(2, "", e);
            }
            try {
                fio.close();
            }
            catch (Throwable throwable) {}
            if (resaveLocalFile) {
                this.saveLocalFile();
            }
        }
        catch (Throwable throwable) {
            RTLogger.print(1, "Error loading file " + file.getPath());
        }
    }

    private ServiceDashBoard createServiceObject(org.w3c.dom.Node item) {
        String name = ((Element)item).getAttribute(NAME);
        String id = ((Element)item).getAttribute(ID);
        String description = ((Element)item).getAttribute(DESCRIPTION);
        if (id == null || id.length() == 0) {
            id = UUID.randomUUID().toString();
        }
        ServiceDashBoard efg = new ServiceDashBoard(name, id, Repository.getEventProvider());
        efg.setDecription(description);
        NodeList fl = item.getChildNodes();
        int j = 0;
        while (j < fl.getLength()) {
            String fnode = fl.item(j).getNodeName();
            if (fnode.equals(FILTER_LIST)) {
                ArrayList<EventFilter> list = this.processElement((Element)fl.item(j), null);
                String groupName = ((Element)fl.item(j)).getAttribute(NAME);
                EventFilterGroup group = new EventFilterGroup(groupName);
                group.addFilters(list);
                efg.addFilters(group);
            }
            ++j;
        }
        return efg;
    }

    public void saveLocalFile() {
        if (!this.isLocalChangesAllowed()) {
            return;
        }
        this.saveFile(this.getLocalFile(), true);
    }

    public void saveGlobalFile() {
        if (!this.isLocalChangesAllowed()) {
            return;
        }
        this.saveFile(this.getGlobalFile(), false);
    }

    private void saveFile(File file, boolean localOnly) {
        Document doc = null;
        try {
            doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement(SSD_LIST);
            Iterator<Map.Entry<String, ServiceDashBoard>> it = this.m_efGroup.entrySet().iterator();
            while (it.hasNext()) {
                ServiceDashBoard efg = it.next().getValue();
                if (localOnly && efg.isGlobalOnly()) continue;
                Element ssc = doc.createElement(SSD);
                ssc.setAttribute(NAME, efg.getName());
                ssc.setAttribute(ID, efg.getID());
                ssc.setAttribute(DESCRIPTION, efg.getDescription());
                root.appendChild(ssc);
                Map<String, EventFilterGroup> list = efg.getFilters();
                for (Map.Entry<String, EventFilterGroup> en : list.entrySet()) {
                    EventFilterGroup group = en.getValue();
                    Element fl = doc.createElement(FILTER_LIST);
                    fl.setAttribute(NAME, group.getName());
                    List<EventFilter> filters = group.getFilters();
                    int k = 0;
                    while (k < filters.size()) {
                        EventFilter ef = filters.get(k);
                        FilterFactory.addFilter(doc, fl, ef);
                        ++k;
                    }
                    ssc.appendChild(fl);
                }
            }
            doc.appendChild(root);
            this.writeXml(doc, file);
        }
        catch (Throwable e) {
            RTLogger.print(2, "", e);
        }
    }

    public void removeService(String ID) {
        if (!this.isLocalChangesAllowed()) {
            return;
        }
        this.m_efGroup.remove(ID);
    }

    public void replaceService(ServiceDashBoard service) {
        if (!this.isLocalChangesAllowed()) {
            return;
        }
        this.m_efGroup.put(service.getID(), service);
    }

    public void createService(String name) {
        if (!this.isLocalChangesAllowed()) {
            return;
        }
        if (this.getServiceByName(name) != null) {
            return;
        }
        ServiceDashBoard service = new ServiceDashBoard(name, Repository.getEventProvider());
        service.setMode(2);
        this.m_efGroup.put(service.getID(), service);
    }

    public ServiceDashBoard getServiceByID(String ID) {
        return this.m_efGroup.get(ID);
    }

    public ServiceDashBoard getServiceByName(String name) {
        if (name != null) {
            Iterator<Map.Entry<String, ServiceDashBoard>> it = this.m_efGroup.entrySet().iterator();
            while (it.hasNext()) {
                ServiceDashBoard sdb = it.next().getValue();
                if (!name.equals(sdb.getName())) continue;
                return sdb;
            }
        }
        return null;
    }

    public Map<String, ServiceDashBoard> getServices() {
        return this.m_efGroup;
    }

    @Override
    public void refresh() {
        Iterator<Map.Entry<String, ServiceDashBoard>> it = this.m_efGroup.entrySet().iterator();
        while (it.hasNext()) {
            ServiceDashBoard sdb = it.next().getValue();
            sdb.summarize();
        }
        for (final IRefreshable r : this.m_refreshable) {
            UIJob uijob = new UIJob(Display.getCurrent(), "refresh_" + r){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    block4: {
                        try {
                            r.refresh();
                        }
                        catch (Throwable e) {
                            if (!e.getMessage().contains("disposed")) break block4;
                            try {
                                ServiceDashBoardProvider.this.m_refreshable.remove(r);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uijob);
        }
    }

    public void addRefreshable(IRefreshable comp) {
        if (!this.m_refreshable.contains(comp)) {
            this.m_refreshable.add(comp);
        }
    }

    public void uploadToServer() {
        block7: {
            if (!this.isLocalChangesAllowed()) {
                return;
            }
            boolean isOK = true;
            try {
                this.saveGlobalFile();
                ServerClient sc = ServerClient.putFile(this.getServerPath(), this.getGlobalFile().getCanonicalPath());
                sc.runInUIThread(null);
                isOK = sc.isSuccess();
                if (isOK) {
                    if (this.getCurrentUserRole() != null) {
                        try {
                            this.getLocalFile().delete();
                        }
                        catch (Throwable throwable) {}
                        this.loadGlobalFile(this.getGlobalFile());
                    }
                    new ShowMessageBox("Server update", "Service Dashboard configuration saved", 2);
                    this.refresh();
                    break block7;
                }
                new ShowMessageBox("Server update", "Service Dashboard configuration was not saved", 1);
            }
            catch (Throwable throwable) {
                RTLogger.print(3, "Upload of the SSD file was failed");
                new ShowMessageBox("Server update", "Service Dashboard configuration was not saved", 1);
            }
        }
    }

    public void uploadCubeToServer() {
        try {
            ServerClient sc = ServerClient.putFile(this.getCubeServerPath(), this.getCubeFile().getCanonicalPath());
            sc.runInUIThread(null);
            boolean isOK = sc.isSuccess();
            if (isOK) {
                new ShowMessageBox("Server update", "Service tree configuration saved", 2);
            }
        }
        catch (Throwable e) {
            RTLogger.print(3, "Upload of the service cube file was failed");
            new ShowMessageBox("Server update", "Service tree configuration was not saved\n" + e.getMessage(), 1);
        }
    }

    public void loadFromServer() {
        ScGetFile sc = new ScGetFile(Repository.getInstance(), this.getServerPath(), BMUI.type_file, this.getTmpDirectory());
        sc.run();
        File global = this.getGlobalFile();
        if (!sc.isSuccess()) {
            if (global.exists()) {
                global.delete();
            }
            try {
                global.getParentFile().mkdirs();
                global.createNewFile();
            }
            catch (Throwable throwable) {}
        }
        if (global.exists() && global.canRead()) {
            this.loadGlobalFile(global);
            this.loadLocalFile(this.getLocalFile());
        }
    }

    public void loadFromServer(String userRoleID) {
        this.currentUserRole = userRoleID;
        this.loadFromServer();
        this.loadCubeFromServer();
        this.refresh();
    }

    public void deleteDashBoard() {
        ScDeleteFile sc = new ScDeleteFile(Repository.getInstance(), this.getServerPath());
        sc.run();
        if (sc.isSuccess()) {
            RTLogger.print(2, "Deleted service dashboard for user role: " + this.currentUserRole);
        }
    }

    public String getTmpDirectory() {
        if (this.currentUserRole == null) {
            return Repository.getUserTmpDirectory();
        }
        return String.valueOf(Repository.getUserTmpDirectory()) + File.separator + this.currentUserRole;
    }

    public String getServerPath() {
        if (this.currentUserRole == null) {
            return GLOBAL_SSDFILE_SRV_PATH;
        }
        return "srv/services/" + this.currentUserRole + "/" + GLOBAL_SSDFILE;
    }

    public String getCubeServerPath() {
        if (this.currentUserRole == null) {
            return GLOBAL_STREEFILE_SRV_PATH;
        }
        return "srv/services/" + this.currentUserRole + "/" + GLOBAL_STREEFILE;
    }

    public File getLocalFile() {
        return new File(String.valueOf(this.getTmpDirectory()) + File.separator + SSDFILE);
    }

    public File getGlobalFile() {
        return new File(String.valueOf(this.getTmpDirectory()) + File.separator + GLOBAL_SSDFILE);
    }

    public File getCubeFile() {
        return new File(String.valueOf(this.getTmpDirectory()) + File.separator + GLOBAL_STREEFILE);
    }

    public String getCurrentUserRole() {
        return this.currentUserRole;
    }

    public void loadCubeFromServer() {
        ServerClient sc = ServerClient.getFile(new String[]{this.getCubeServerPath(), BMUI.type_file, this.getTmpDirectory()});
        sc.runInUIThread(null);
        sc.isSuccess();
    }

    public void initCube(GCube cube) {
        File m_streefile = this.getCubeFile();
        if (m_streefile.exists() && m_streefile.canRead() && m_streefile.length() > 0L) {
            cube.loadXML(m_streefile);
        } else {
            Node root = new Node(cube, "servicesROOT", 0.0, 0.0, 0.0, "Services", "root");
            cube.addRoot(root);
        }
    }
}

