/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.AllAssignmentTableProvider;
import com.blixx.boom.engine.GAssignments;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.shared.Assignment;
import com.blixx.shared.DeploymentStatus;
import com.blixx.shared.utils.GroupTreeObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class TableSorter
extends ViewerSorter {
    private String column = null;
    private int dir = 1024;

    public TableSorter(String column, int dir) {
        this.column = column;
        this.dir = dir;
    }

    public void setConfig(String column, int direction) {
        this.column = column;
        this.dir = direction;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int returnValue = 0;
        if (e1 instanceof Assignment && e2 instanceof Assignment) {
            returnValue = this.compareAssignment((Assignment)e1, (Assignment)e2);
        } else if (e1 instanceof DeploymentStatus && e2 instanceof DeploymentStatus) {
            returnValue = this.compareDeploymentStatus((DeploymentStatus)e1, (DeploymentStatus)e2);
        }
        if (this.dir == 1024) {
            returnValue *= -1;
        }
        return returnValue;
    }

    public int compareAssignment(Assignment e1Assign, Assignment e2Assign) {
        int returnValue = 0;
        String e1Str = "";
        String e2Str = "";
        if (this.column == "Type") {
            e1Str = String.valueOf(e1Assign.getType()) + e1Assign.getName();
            e2Str = String.valueOf(e2Assign.getType()) + e2Assign.getName();
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "Name") {
            e1Str = String.valueOf(e1Assign.getName()) + "/" + e1Assign.getType();
            e2Str = String.valueOf(e2Assign.getName()) + "/" + e2Assign.getType();
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "Status") {
            AgentCard ac1 = Repository.getInstance().getAgentCard(e1Assign.getAgentID());
            AgentCard ac2 = Repository.getInstance().getAgentCard(e2Assign.getAgentID());
            e1Str = String.valueOf(ac1.getIconnameForAgent()) + ac1.isDisabled();
            e2Str = String.valueOf(ac2.getIconnameForAgent()) + ac2.isDisabled();
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "Agent") {
            e1Str = String.valueOf(e1Assign.getAgentID()) + e1Assign.getName();
            e2Str = String.valueOf(e2Assign.getAgentID()) + e2Assign.getName();
            AgentCard ac = Repository.getInstance().getAgentCard(e1Assign.getAgentID());
            if (ac != null) {
                e1Str = String.valueOf(ac.toString()) + "/" + e1Assign.getType() + "/" + e1Assign.getName();
            }
            if ((ac = Repository.getInstance().getAgentCard(e2Assign.getAgentID())) != null) {
                e2Str = String.valueOf(ac.toString()) + "/" + e2Assign.getType() + "/" + e2Assign.getName();
            }
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "User") {
            e1Str = String.valueOf(e1Assign.getUser()) + "/" + e1Assign.getName();
            e2Str = String.valueOf(e2Assign.getUser()) + "/" + e2Assign.getName();
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "Creation Time") {
            long diff = e1Assign.getFtime() - e2Assign.getFtime();
            returnValue = diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        } else if (this.column == "Modification Time") {
            long diff = e1Assign.getUtime() - e2Assign.getUtime();
            returnValue = diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        } else if (this.column == "Assignment Groups") {
            AllAssignmentTableProvider p = AssignmentsSummaryView.getInstance().getTableProvider_deploymentQueue();
            e1Str = p.getAllRelatedAsnGroups(e1Assign);
            e2Str = p.getAllRelatedAsnGroups(e2Assign);
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "Action") {
            if (e1Assign.getLock() == 1) {
                e1Str = AssignmentsSummaryView.DEPLOY;
            } else if (e1Assign.getLock() == 2) {
                e1Str = AssignmentsSummaryView.REDEPLOY;
            } else if (e1Assign.getLock() == 3) {
                e1Str = AssignmentsSummaryView.UNDEPLOY;
            } else if (e1Assign.getLock() > 3) {
                e1Str = AssignmentsSummaryView.CANCEL_DEPLOYMENT;
            }
            if (e2Assign.getLock() == 1) {
                e2Str = AssignmentsSummaryView.DEPLOY;
            } else if (e2Assign.getLock() == 2) {
                e2Str = AssignmentsSummaryView.REDEPLOY;
            } else if (e2Assign.getLock() == 3) {
                e2Str = AssignmentsSummaryView.UNDEPLOY;
            } else if (e2Assign.getLock() > 3) {
                e2Str = AssignmentsSummaryView.CANCEL_DEPLOYMENT;
            }
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "Time") {
            long diff;
            long e2Time;
            long e1Time = e1Assign.getUtime();
            if (e1Time == 0L) {
                e1Time = e1Assign.getFtime();
            }
            if ((e2Time = e2Assign.getUtime()) == 0L) {
                e2Time = e2Assign.getFtime();
            }
            returnValue = (diff = e1Time - e2Time) > 0L ? 1 : (diff < 0L ? -1 : 0);
        }
        return returnValue;
    }

    public int compareDeploymentStatus(DeploymentStatus e1DplStatus, DeploymentStatus e2DplStatus) {
        int returnValue = 0;
        String e1Str = "";
        String e2Str = "";
        if (this.column == "Type") {
            e1Str = String.valueOf(e1DplStatus.getType()) + e1DplStatus.getFileNames().toString();
            e2Str = String.valueOf(e2DplStatus.getType()) + e2DplStatus.getFileNames().toString();
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "Size") {
            e1Str = "" + e1DplStatus.getFileNames().size();
            e2Str = "" + e2DplStatus.getFileNames().size();
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "Name") {
            e1Str = e1DplStatus.getFileNames().toString();
            e2Str = e2DplStatus.getFileNames().toString();
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "Status") {
            e1Str = GAssignments.getDeploymentState(e1DplStatus.getState());
            e2Str = GAssignments.getDeploymentState(e2DplStatus.getState());
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "Action") {
            e1Str = e1DplStatus.getType().startsWith("U") ? "Undeploy" : "Deploy";
            e2Str = e2DplStatus.getType().startsWith("U") ? "Undeploy" : "Deploy";
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "Agent") {
            String oid1 = e1DplStatus.getAcid();
            if (oid1 != null && oid1.length() == 32) {
                GroupTreeObject nodeGroup = Repository.getInstance().getAgentTree().findByOID(oid1);
                if (nodeGroup != null) {
                    oid1 = nodeGroup.getPath();
                }
                e1Str = oid1;
            } else {
                String str = e1DplStatus.getAcid();
                AgentCard ac = Repository.getInstance().getAgentCard(str);
                if (ac != null) {
                    str = ac.toString().replace("(X)", "");
                }
                e1Str = str;
            }
            String oid2 = e2DplStatus.getAcid();
            if (oid2 != null && oid2.length() == 32) {
                GroupTreeObject nodeGroup = Repository.getInstance().getAgentTree().findByOID(oid2);
                if (nodeGroup != null) {
                    oid2 = nodeGroup.getPath();
                }
                e2Str = oid2;
            } else {
                String str = e2DplStatus.getAcid();
                AgentCard ac = Repository.getInstance().getAgentCard(str);
                if (ac != null) {
                    str = ac.toString().replace("(X)", "");
                }
                e2Str = str;
            }
            returnValue = e1Str.compareToIgnoreCase(e2Str);
        } else if (this.column == "Start Time") {
            long diff = e1DplStatus.getInitTime() - e2DplStatus.getInitTime();
            returnValue = diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        } else if (this.column == "Expire Time") {
            long diff = e1DplStatus.getExpireTime() - e2DplStatus.getExpireTime();
            returnValue = diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        }
        return returnValue;
    }
}

