/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.ServerClient;
import com.blixx.shared.io.SDataOutputStream;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TlsUtils {
    public static Socket upgradeToTLS(Socket originalPlainSocket) throws Exception {
        SDataOutputStream os = new SDataOutputStream(originalPlainSocket.getOutputStream(), ServerClient.getDetectedServerProtocolVersion());
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, new TrustManager[]{new BoomUITrustManager()}, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(originalPlainSocket, originalPlainSocket.getInetAddress().getHostAddress(), originalPlainSocket.getPort(), false);
        sslSocket.setUseClientMode(true);
        os.writeUTF("+");
        os.flush();
        sslSocket.startHandshake();
        return sslSocket;
    }

    public static class BoomUITrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

