/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.engine;

import com.blixx.boom.engine.UIJob;
import com.blixx.log.RTLogger;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class UIJobManager
extends Thread {
    public LinkedBlockingQueue<UIJob> m_queue = new LinkedBlockingQueue();
    private static UIJobManager m_instance = null;
    private boolean m_testOnly = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized UIJobManager getTestInstance() {
        if (m_instance != null) return m_instance;
        Class<UIJobManager> clazz = UIJobManager.class;
        synchronized (UIJobManager.class) {
            if (m_instance != null) return m_instance;
            m_instance = new UIJobManager();
            UIJobManager.m_instance.m_testOnly = true;
            m_instance.start();
            m_instance.setName("UIJM");
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UIJobManager getInstance() {
        if (m_instance != null) return m_instance;
        Class<UIJobManager> clazz = UIJobManager.class;
        synchronized (UIJobManager.class) {
            if (m_instance != null) return m_instance;
            m_instance = new UIJobManager();
            m_instance.start();
            m_instance.setName("UIJM");
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instance;
        }
    }

    private UIJobManager() {
    }

    private UIJobManager(Runnable target, String name) {
        super(target, name);
    }

    private UIJobManager(Runnable target) {
        super(target);
    }

    private UIJobManager(String name) {
        super(name);
    }

    private UIJobManager(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
    }

    private UIJobManager(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    private UIJobManager(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    private UIJobManager(ThreadGroup group, String name) {
        super(group, name);
    }

    public void schedule(UIJob client) {
        if (this.m_queue.size() > 10) {
            RTLogger.print(3, new StringBuffer("UI queue ").append(this.m_queue.size()).append(' ').append(this.m_queue.toString()));
        }
        if (client == null || this.m_queue.contains(client)) {
            return;
        }
        client.m_isFinished = false;
        while (!this.m_queue.add(client)) {
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void run() {
        while (!this.m_testOnly && !PlatformUI.isWorkbenchRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            Thread.sleep(2000L);
        }
        catch (Throwable throwable) {}
        while (true) {
            try {
                while (true) {
                    UIJob job;
                    if ((job = this.m_queue.poll(10L, TimeUnit.SECONDS)) == null) {
                        continue;
                    }
                    try {
                        Display disp = Display.getDefault();
                        if (disp == null || disp.isDisposed()) continue;
                        long start = System.currentTimeMillis();
                        disp.syncExec((Runnable)job);
                        long delta = System.currentTimeMillis() - start;
                        if (delta > 1000L) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("Slow ui job discovered: ").append(job.getName()).append(" delta ms=").append(delta);
                            RTLogger.print(2, sb.toString());
                        }
                        Thread.yield();
                    }
                    catch (Throwable e) {
                        RTLogger.print(4, "UIJob failed", e);
                    }
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public boolean removeJob(UIJob job) {
        return this.m_queue.remove(job);
    }
}

