/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.settings.GenAttribute;
import com.blixx.boom.gui.settings.GenAttributeProps;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class GlobalStatus
extends WorkbenchWindowControlContribution {
    public static final String ID = "com.blixx.boom.gui.globalstatus";
    public static GlobalStatus m_instance = null;
    private static Label label;
    private static Label m_status;
    private static Label m_statusConection;
    private static AtomicBoolean m_errorState;
    private static String m_text;
    private Composite m_composite;
    private static Timer timer;
    private TimerTask task = null;

    static {
        m_status = null;
        m_statusConection = null;
        m_errorState = new AtomicBoolean(false);
        m_text = null;
        timer = new Timer("clock2", false);
    }

    protected Control createControl(Composite parent) {
        String text = "...                       ";
        if (m_text != null) {
            text = m_text;
        }
        m_instance = this;
        this.m_composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(5, false);
        this.m_composite.setLayout((Layout)layout);
        GUIDisplayElements m_gui = new GUIDisplayElements();
        label = m_gui.addTextField(this.m_composite, null, "", 1, 1, 0, 1, null);
        this.setUITime(label);
        if (this.task != null) {
            this.task.cancel();
        }
        timer.purge();
        this.task = new TimerTask(){

            @Override
            public void run() {
                UIJob uiJob = new UIJob("clcki2refr"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (GlobalStatus.this.setUITime(label)) {
                            GlobalStatus.this.getParent().update(true);
                        }
                        return null;
                    }
                };
                UIJobManager.getInstance().schedule(uiJob);
            }
        };
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(12, 1);
        timer.schedule(this.task, cal.getTime(), 10000L);
        m_status = new Label(this.m_composite, 16384);
        m_status.setText(text);
        if (m_errorState.get()) {
            m_status.setForeground(BMUI.color_critical);
        } else {
            m_status.setForeground(BMUI.color_black);
        }
        m_statusConection = new Label(this.m_composite, 16384);
        m_statusConection.setText("\u25cf");
        this.setConnectionActive(false);
        return this.m_composite;
    }

    protected boolean setUITime(Label st) {
        boolean isUpdateLayout = false;
        try {
            GenAttribute ga = UISettings.getInstance().getGenAttributes().get(GenAttributeProps.GEN_SHOW_UI_TIME);
            if (ga == null || "true".equalsIgnoreCase(ga.getValue())) {
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm '" + Repository.getInstance().m_serverTimeZone + "'(Z)");
                Calendar uiTime = Calendar.getInstance();
                uiTime.add(14, Repository.getInstance().m_serverDiffMilliseconds);
                String time = simpleDateFormat2.format(uiTime.getTime());
                isUpdateLayout = st.getText() == null || st.getText().length() == 0;
                StringBuilder sb = new StringBuilder(time);
                st.setText(sb.toString());
            } else {
                isUpdateLayout = st.getText() == null || st.getText().length() > 0;
                st.setText("");
            }
            GlobalStatus.m_instance.m_composite.layout(true);
        }
        catch (Throwable throwable) {}
        return isUpdateLayout;
    }

    protected int computeWidth(Control control) {
        if (GlobalStatus.m_instance.m_composite == control) {
            return control.computeSize((int)-1, (int)-1, (boolean)true).x;
        }
        return 0;
    }

    public void setConnectionActive(boolean isActive) {
        if (isActive) {
            m_statusConection.setForeground(BMUI.color_green);
        } else {
            m_statusConection.setForeground(BMUI.color_lightGrey);
        }
    }

    public void setStatus(String message, boolean isError) {
        try {
            m_text = message;
            m_status.setText(message);
            m_statusConection.setBackground(BMUI.color_light_green);
            if (m_errorState.compareAndSet(!isError, isError)) {
                if (m_errorState.get()) {
                    m_status.setForeground(BMUI.color_critical);
                } else {
                    m_status.setForeground(BMUI.color_black);
                }
            }
            this.getParent().update(true);
        }
        catch (Throwable throwable) {}
    }

    public boolean isDynamic() {
        return true;
    }
}

