/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.views.actions.CheckUpdateAction;
import com.blixx.boom.gui.views.actions.OpenBrowserAction;
import com.blixx.log.RTLogger;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AboutDialog
extends StatusDialog
implements DisposeListener {
    private Composite m_compTop = null;
    private Composite m_comp1 = null;
    private Composite m_comp2 = null;
    private Text m_address = null;
    private Text m_guiVersion = null;
    private Label m_icon = null;
    private Label m_contact = null;
    private Label m_copyright = null;
    private Link m_link = null;
    private List<CompanyInfo> m_companies = new ArrayList<CompanyInfo>(1);
    private String m_versionText = "";
    private boolean m_hasUpdate = false;
    public static String m_aboutFile = "about.conf";

    public AboutDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle("   About BOOM");
        this.setImage(BMUI.IMAGE_PRODUCT);
        this.checkForUpdate();
        this.readAboutConfigFile();
    }

    protected Control createDialogArea(Composite parent) {
        try {
            this.m_compTop = new Composite(parent, 0);
            this.m_compTop.setBackground(BMUI.color_white);
            this.m_compTop.addDisposeListener((DisposeListener)this);
            this.m_compTop.setLayout((Layout)new GridLayout(2, false));
            GridData gdData = new GridData(4, 4, true, true, 1, 1);
            gdData.widthHint = 650;
            this.m_compTop.setLayoutData((Object)gdData);
            this.m_icon = new Label(this.m_compTop, 0);
            this.m_icon.setImage(BMUI.IMAGE_ABOUT);
            this.m_icon.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
            this.m_comp1 = new Composite(this.m_compTop, 0);
            this.m_comp1.setBackground(BMUI.color_white);
            this.m_comp1.setLayout((Layout)new GridLayout(1, false));
            gdData = new GridData();
            gdData.widthHint = 650;
            this.m_comp1.setLayoutData((Object)gdData);
            Iterator<CompanyInfo> it = this.m_companies.iterator();
            while (it.hasNext()) {
                CompanyInfo ci = it.next();
                this.m_contact = new Label(this.m_comp1, 0);
                this.m_contact.setBackground(BMUI.color_white);
                this.m_contact.setText(ci.m_companyName_str);
                this.m_contact.setFont(BMUI.font_arial8_bold);
                gdData = new GridData();
                gdData.horizontalIndent = 15;
                this.m_contact.setLayoutData((Object)gdData);
                this.m_address = new Text(this.m_comp1, 2);
                this.m_address.setBackground(BMUI.color_white);
                this.m_address.setEditable(false);
                this.m_address.setText(ci.m_contactInfo_sb.toString());
                gdData = new GridData(768);
                gdData.horizontalIndent = 12;
                this.m_address.setLayoutData((Object)gdData);
                this.m_link = new Link(this.m_comp1, 0);
                this.m_link.setText("<a href=\"" + ci.m_url_str + " \">" + ci.m_url_str + "</a>");
                this.m_link.setBackground(BMUI.color_white);
                GridData gd = new GridData();
                gd.horizontalIndent = 15;
                this.m_link.setLayoutData((Object)gd);
                final OpenBrowserAction on = new OpenBrowserAction(ci.m_url_str);
                this.m_link.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        on.run();
                    }
                });
                if (!it.hasNext()) continue;
                new Label(this.m_comp1, 0);
            }
            this.m_guiVersion = new Text(this.m_comp1, 2);
            this.m_guiVersion.setBackground(BMUI.color_white);
            this.m_guiVersion.setEditable(false);
            this.m_guiVersion.setText("BOOM Client Version  " + BMUI.GUI_VERSION + this.m_versionText);
            gdData = new GridData(768);
            gdData.horizontalIndent = 12;
            gdData.verticalIndent = 80;
            this.m_guiVersion.setLayoutData((Object)gdData);
            this.m_comp2 = new Composite(parent, 0);
            GridLayout gdLayout = new GridLayout(1, false);
            gdLayout.marginRight = 5;
            this.m_comp2.setLayout((Layout)gdLayout);
            this.m_comp2.setLayoutData((Object)new GridData(131072, 128, true, true, 1, 1));
            for (CompanyInfo ci : this.m_companies) {
                if (ci.m_copyright_str == null || ci.m_copyright_str.length() <= 0) continue;
                this.m_copyright = new Label(this.m_comp2, 0);
                this.m_copyright.setText(ci.m_copyright_str);
            }
        }
        catch (Throwable throwable) {}
        return parent;
    }

    /*
     * Loose catch block
     */
    public void readAboutConfigFile() {
        block47: {
            try {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + m_aboutFile);
                if (is == null) {
                    RTLogger.print(1, "error reading " + m_aboutFile + " or file does not exist - AboutDialog will be empty");
                    break block47;
                }
                DataInputStream dis = null;
                BufferedReader br = null;
                try {
                    dis = new DataInputStream(is);
                    br = new BufferedReader(new InputStreamReader((InputStream)dis, Charset.forName("UTF-8")));
                    String strLine = null;
                    CompanyInfo ci = new CompanyInfo();
                    while ((strLine = br.readLine()) != null) {
                        if (strLine.contains("@next@")) {
                            this.m_companies.add(ci);
                            ci = new CompanyInfo();
                            continue;
                        }
                        if (strLine.startsWith("Copyright")) {
                            ci.m_copyright_str = String.valueOf(strLine.trim()) + " ";
                            continue;
                        }
                        if (strLine.startsWith("http")) {
                            ci.m_url_str = strLine;
                            continue;
                        }
                        if (strLine.startsWith("www")) {
                            ci.m_url_str = "http:\\\\" + strLine;
                            continue;
                        }
                        if (ci.m_companyName_str == null) {
                            if (strLine.trim().length() == 0) continue;
                            ci.m_companyName_str = strLine;
                            continue;
                        }
                        ci.m_contactInfo_sb.append(strLine).append("\n");
                    }
                    this.m_companies.add(ci);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    RTLogger.print(1, String.valueOf(m_aboutFile) + " not found");
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        dis.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                    break block47;
                }
                catch (IOException iOException) {
                    RTLogger.print(1, "error reading " + m_aboutFile + " file");
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        dis.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                    break block47;
                }
                catch (Throwable e) {
                    RTLogger.print(1, e.getMessage());
                    {
                        catch (Throwable throwable) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable2) {}
                            try {
                                dis.close();
                            }
                            catch (Throwable throwable3) {}
                            try {
                                is.close();
                            }
                            catch (Throwable throwable4) {}
                            throw throwable;
                        }
                    }
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        dis.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                    break block47;
                }
                try {
                    br.close();
                }
                catch (Throwable throwable) {}
                try {
                    dis.close();
                }
                catch (Throwable throwable) {}
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
            catch (Exception e) {
                RTLogger.print(1, "Error reading about.conf file");
                RTLogger.print(1, "" + e.getStackTrace());
            }
        }
    }

    public void checkForUpdate() {
        ServerClient sc = new ServerClient("CHECK_UPDATE", BMUI.GUI_VERSION, null);
        sc.setTimeout(5000);
        sc.runInUIThread(null);
        if (sc.isSuccess()) {
            String res = "" + sc.getResultObject();
            if (res.equalsIgnoreCase("NoUpdates")) {
                this.m_versionText = "\nYour software is up to date.";
            } else {
                this.m_versionText = "\nA new version is available: " + sc.getResultObject();
                this.m_hasUpdate = true;
            }
        } else {
            this.m_versionText = "\nServer unreachable.";
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        ((GridData)c.getLayoutData()).horizontalAlignment = 0x1000000;
        return c;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        this.getButton(0).setFocus();
        this.createButton(parent, 11, "Update GUI", false);
        this.getButton(11).setEnabled(this.m_hasUpdate);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            super.close();
        } else if (buttonId == 11) {
            CheckUpdateAction cua = new CheckUpdateAction((Dialog)this);
            cua.run();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_compTop.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_comp1.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_comp2.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_address.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_guiVersion.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_icon.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_contact.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_copyright.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_link.dispose();
        }
        catch (Throwable throwable) {}
    }

    public class CompanyInfo {
        private String m_companyName_str = null;
        private String m_url_str = "";
        private StringBuffer m_contactInfo_sb = new StringBuffer();
        private String m_copyright_str = "";
    }
}

