/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActionAndHostGroupDialog
extends InputDialog
implements ModifyListener {
    private String m_initialValue = null;
    private String m_actionGrpName = null;

    public ActionAndHostGroupDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, String actionGrpName, IInputValidator validator) {
        super(parentShell, dialogTitle, dialogMessage, actionGrpName == null ? "" : actionGrpName, validator);
        this.m_initialValue = initialValue;
        this.m_actionGrpName = actionGrpName;
    }

    protected int getInputTextStyle() {
        return 2308;
    }

    protected Control createDialogArea(Composite parent) {
        GUIDisplayElements gui = new GUIDisplayElements();
        Composite comp = (Composite)super.createDialogArea(parent);
        ((GridLayout)comp.getLayout()).marginWidth = 15;
        ((GridLayout)comp.getLayout()).marginTop = 5;
        Text inputField = this.getText();
        ((GridData)inputField.getLayoutData()).widthHint = 500;
        ((GridData)inputField.getLayoutData()).verticalIndent = 2;
        gui.addDefaultTextContentMenu(inputField, true);
        if (this.m_actionGrpName != null && this.m_actionGrpName.length() > 0) {
            inputField.setText(this.m_actionGrpName);
        }
        inputField.addModifyListener((ModifyListener)this);
        return comp;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    public void modifyText(ModifyEvent e) {
        Text text = (Text)e.getSource();
        String fName = text.getText().trim();
        if (fName.length() == 0) {
            text.setBackground(BMUI.color_critical);
            text.setToolTipText("Empty Group Name!");
        } else if (fName.length() > 255) {
            text.setBackground(BMUI.color_critical);
            text.setToolTipText("Group Name is too long (max. 255 chars)!");
        } else if (fName.startsWith(".")) {
            text.setBackground(BMUI.color_critical);
            text.setToolTipText("Group Name does not start with a '.' !");
        } else if (this.getValidator().isValid(fName) != null) {
            text.setBackground(BMUI.color_critical);
            text.setToolTipText(this.getValidator().isValid(fName));
            this.getButton(0).setEnabled(false);
        } else if (this.m_initialValue != null && this.m_initialValue.equals(fName)) {
            text.setBackground(BMUI.color_white);
            text.setToolTipText("");
            this.getButton(0).setEnabled(true);
        } else {
            text.setBackground(BMUI.color_white);
            text.setToolTipText("");
            this.getButton(0).setEnabled(true);
        }
    }
}

