/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddAgentDialog
extends InputDialog
implements SelectionListener,
ModifyListener {
    private boolean isTls = true;
    private int portInt = TLS_PORT;
    private String portStr = "";
    private boolean isPortDirty = false;
    private String hostnameOrIp = "";
    private boolean isHostOrIpValid = false;
    private boolean isPortValid = false;
    private GUIDisplayElements m_gui = new GUIDisplayElements();
    private static final String HOSTNAME_OR_IP = "HOSTNAME_OR_IP";
    private static final String PORT = "PORT";
    private Text hostOrIpField;
    private Text portField;
    private static int DEFAULT_PORT = 23021;
    private static int TLS_PORT = 23031;
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^([A-Za-z]){1}([A-Za-z0-9-.]*)$");
    private static final Pattern IP_V4_PATTERN = Pattern.compile("((25[0-5])|(2[0-4]\\d)|(1\\d\\d)|([1-9]\\d)|\\d)(\\.((25[0-5])|(2[0-4]\\d)|(1\\d\\d)|([1-9]\\d)|\\d)){3}");
    public static final Pattern IPV6_ALL = Pattern.compile("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))");

    public AddAgentDialog(Shell parent) {
        super(parent, "Add new Agent", "", "", null);
        this.setTls(true);
    }

    protected int getInputTextStyle() {
        return 2308;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gdLayout = new GridLayout(2, false);
        gdLayout.verticalSpacing = 5;
        gdLayout.horizontalSpacing = 5;
        gdLayout.marginHeight = 5;
        gdLayout.marginWidth = 5;
        comp.setLayout((Layout)gdLayout);
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hostOrIpField = this.m_gui.addInputFieldSingle(comp, HOSTNAME_OR_IP, "Hostname or IP: ", "", 1, 1, 5, 1, 200, this);
        this.portField = this.m_gui.addInputFieldSingle(comp, PORT, "Port: ", "", 1, 1, 5, 1, 200, this);
        this.setPortFieldToDefault();
        this.setPortFieldDecoration(true, true);
        Composite comp2 = new Composite(comp, 0);
        comp2.setLayout((Layout)gdLayout);
        comp2.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_gui.addCheckbox(comp2, "CHECKBOX", " TLS? ", this.isTls, this).setSelection(this.isTls);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button ok = this.createButton(parent, 0, "Create", true);
        ok.setEnabled(false);
        this.createButton(parent, 1, "Cancel", false);
    }

    public void modifyText(ModifyEvent e) {
        String fieldName = "";
        String value = "";
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text field = (Text)obj;
            fieldName = (String)field.getData();
            value = field.getText().trim();
            if (fieldName.equals(HOSTNAME_OR_IP)) {
                this.setHostnameOrIp(value);
                this.validateHostOrIP();
            } else if (fieldName.equals(PORT)) {
                this.setPortStr(value);
                this.setPortDirty(true);
                this.validatePort();
            } else {
                return;
            }
            boolean isInputValid = this.isHostOrIpValid() && this.isPortValid();
            this.getButton(0).setEnabled(isInputValid);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Button b = (Button)e.widget;
        this.setTls(b.getSelection());
        if (!this.isPortDirty()) {
            this.setPortFieldToDefault();
            this.setPortFieldDecoration(true, true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        }
    }

    private void validateHostOrIP() {
        if (this.isValidHostName() || this.isValidIPAddress()) {
            this.hostOrIpField.setBackground(null);
            this.hostOrIpField.setToolTipText(null);
            this.setHostOrIpValid(true);
        } else {
            this.hostOrIpField.setBackground(BMUI.color_light_red);
            this.hostOrIpField.setToolTipText("Invalid Hostname or IP Address!");
            this.setHostOrIpValid(false);
        }
    }

    private void validatePort() {
        if (this.getPortStr().isEmpty()) {
            this.setPortFieldToDefault();
            this.setPortFieldDecoration(true, true);
            this.setPortValid(true);
        } else {
            try {
                int port = Integer.parseInt(this.getPortStr());
                this.setPortValid(port <= 65535);
                if (this.isPortValid()) {
                    this.setPortInt(port);
                    this.setPortFieldDecoration(false, true);
                } else {
                    this.setPortFieldDecoration(false, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setPortValid(false);
                this.setPortFieldDecoration(false, false);
            }
        }
    }

    public boolean isValidHostName() {
        String hostname = this.getHostnameOrIp();
        if (hostname == null || hostname.isEmpty()) {
            return false;
        }
        return HOSTNAME_PATTERN.matcher(hostname).matches();
    }

    public boolean isValidIPAddress() {
        String ip = this.getHostnameOrIp();
        return AddAgentDialog.isIPv4Address(ip) || AddAgentDialog.isIPv6(ip);
    }

    public static boolean isIPv4Address(String input) {
        return IP_V4_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6(String input) {
        return IPV6_ALL.matcher(input).matches();
    }

    private void setPortFieldToDefault() {
        int defaultPort = this.isTls() ? TLS_PORT : DEFAULT_PORT;
        this.portField.removeModifyListener((ModifyListener)this);
        this.portField.setText("" + defaultPort);
        this.portField.addModifyListener((ModifyListener)this);
        this.setPortStr("" + defaultPort);
        this.setPortInt(defaultPort);
        this.setPortValid(true);
        this.setPortDirty(false);
    }

    private void setPortFieldDecoration(boolean isDefault, boolean isValid) {
        if (isDefault) {
            this.portField.setBackground(null);
            this.portField.setForeground(BMUI.color_darkGrey2);
            this.portField.setToolTipText(this.isTls() ? "TLS Default Port!" : "Default Port for no TLS!");
        } else if (isValid) {
            this.portField.setBackground(null);
            this.portField.setForeground(BMUI.color_black);
            this.portField.setToolTipText(null);
        } else {
            this.portField.setBackground(BMUI.color_light_red);
            this.portField.setForeground(BMUI.color_black);
            this.portField.setToolTipText("Invalid Port!");
        }
    }

    public String getHostnameOrIp() {
        return this.hostnameOrIp;
    }

    public void setHostnameOrIp(String hostnameOrIp) {
        this.hostnameOrIp = hostnameOrIp;
    }

    public boolean isTls() {
        return this.isTls;
    }

    private void setTls(boolean isTls) {
        this.isTls = isTls;
    }

    private String getPortStr() {
        return this.portStr;
    }

    private void setPortStr(String portStr) {
        this.portStr = portStr;
    }

    public int getPortInt() {
        return this.portInt;
    }

    private void setPortInt(int portInt) {
        this.portInt = portInt;
    }

    private boolean isPortDirty() {
        return this.isPortDirty;
    }

    private void setPortDirty(boolean isPortDirty) {
        this.isPortDirty = isPortDirty;
    }

    private boolean isHostOrIpValid() {
        return this.isHostOrIpValid;
    }

    private void setHostOrIpValid(boolean isHostOrIpValid) {
        this.isHostOrIpValid = isHostOrIpValid;
    }

    private boolean isPortValid() {
        return this.isPortValid;
    }

    private void setPortValid(boolean isPortValid) {
        this.isPortValid = isPortValid;
    }
}

