/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.ServerJobTabComposite;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.ListAttribute;
import com.blixx.shared.jobs.MapAttribute;
import com.blixx.shared.jobs.SelectAttribute;
import java.util.List;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AdmConfigEditDialog
extends StatusDialog
implements ModifyListener {
    private AbstractAttribute m_attribute = null;
    private String m_actionType = null;
    private String m_widgetType = null;
    private String m_value2Edit = null;
    private String m_res_key = null;
    private String m_res_value = null;
    private Composite m_dialogArea = null;
    private Text m_key_field = null;
    private static String KEY = "KEY";
    private static String VALUE = "VALUE";

    public AdmConfigEditDialog(Shell parentShell, String widgetType, String actionType, String value, AbstractAttribute attribute) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setImage(null);
        this.setTitle("  " + actionType + " Attribute");
        this.m_attribute = attribute;
        this.m_widgetType = widgetType;
        this.m_actionType = actionType;
        this.m_value2Edit = value;
    }

    protected Control createDialogArea(Composite parent) {
        GUIDisplayElements gui = new GUIDisplayElements();
        gui.centerShell(parent.getShell(), Display.getCurrent());
        this.m_dialogArea = new Composite(parent, 0);
        GridLayout gdLayout = new GridLayout(2, false);
        gdLayout.marginTop = 5;
        gdLayout.marginRight = 10;
        gdLayout.marginLeft = 10;
        this.m_dialogArea.setLayout((Layout)gdLayout);
        this.m_dialogArea.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.m_widgetType.equals(ServerJobTabComposite.TYPE_MAP)) {
            gui.addTextField(this.m_dialogArea, null, "Key: ", 1, 1, 1, 1, null);
            gui.addTextField(this.m_dialogArea, null, "value: ", 1, 1, 1, 1, null);
            this.m_key_field = gui.addInputFieldSingle(this.m_dialogArea, KEY, null, "", 1, 1, 0, 0, 200, this);
            gui.addInputFieldSingle(this.m_dialogArea, VALUE, null, "", 1, 1, 0, 0, 200, this);
        } else if (this.m_widgetType.equals(ServerJobTabComposite.TYPE_LIST) || this.m_widgetType.equals(ServerJobTabComposite.TYPE_COMBO)) {
            this.m_key_field = gui.addInputFieldSingle(this.m_dialogArea, KEY, "Value: ", "", 1, 1, 0, 0, 200, this);
            if (this.m_actionType.equals(ServerJobTabComposite.EDIT) && this.m_value2Edit != null) {
                this.m_key_field.setText(this.m_value2Edit);
            }
        }
        return this.m_dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button b = this.createButton(parent, 0, "Save", true);
        b.setEnabled(false);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.cancelPressed();
        } else if (buttonId == 0) {
            if (this.m_widgetType.equals(ServerJobTabComposite.TYPE_MAP)) {
                Object map = ((MapAttribute)this.m_attribute).getValue();
                if (map.containsKey(this.m_res_key)) {
                    new ShowMessageBox(" Add Attribute", "Key does already exist!", 1);
                } else {
                    super.okPressed();
                }
            } else if (this.m_widgetType.equals(ServerJobTabComposite.TYPE_LIST)) {
                Object list = ((ListAttribute)this.m_attribute).getValue();
                if (list.contains(this.m_res_key)) {
                    new ShowMessageBox(" Add Attribute", "Attribute does already exist!", 1);
                } else {
                    super.okPressed();
                }
            } else if (this.m_widgetType.equals(ServerJobTabComposite.TYPE_COMBO)) {
                List<String> list = ((SelectAttribute)this.m_attribute).getList();
                if (list.contains(this.m_res_key)) {
                    new ShowMessageBox(" Add Attribute", "Attribute does already exist!", 1);
                } else {
                    super.okPressed();
                }
            }
        }
    }

    protected void cancelPressed() {
        try {
            this.m_dialogArea.dispose();
        }
        catch (Exception exception) {}
        super.cancelPressed();
    }

    protected void okPressed() {
        try {
            this.m_dialogArea.dispose();
        }
        catch (Exception exception) {}
        super.okPressed();
    }

    public Object getResult() {
        if (this.m_widgetType.equals(ServerJobTabComposite.TYPE_MAP)) {
            if (this.m_res_key != null && this.m_res_value != null) {
                String[] result = new String[]{this.m_res_key, this.m_res_value};
                return result;
            }
        } else if ((this.m_widgetType.equals(ServerJobTabComposite.TYPE_LIST) || this.m_widgetType.equals(ServerJobTabComposite.TYPE_COMBO)) && this.m_res_key != null) {
            return this.m_res_key;
        }
        return null;
    }

    public void modifyText(ModifyEvent e) {
        String name = null;
        if (e.getSource() instanceof Text) {
            Text field = (Text)e.getSource();
            name = (String)field.getData();
            if (name.equals(KEY)) {
                this.m_res_key = field.getText().trim();
            } else if (name.equals(VALUE)) {
                this.m_res_value = field.getText().trim();
            }
        }
        boolean isValid = true;
        if (this.m_widgetType.equals(ServerJobTabComposite.TYPE_MAP)) {
            if (this.m_res_key == null || this.m_res_key.length() == 0 || this.m_res_value == null || this.m_res_value.length() == 0) {
                isValid = false;
            }
        } else if ((this.m_widgetType.equals(ServerJobTabComposite.TYPE_LIST) || this.m_widgetType.equals(ServerJobTabComposite.TYPE_LIST)) && (this.m_res_key == null || this.m_res_key.length() == 0)) {
            isValid = false;
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(isValid);
        }
    }
}

