/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.AgentCMTableProvider;
import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.shared.AgentCardCM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AgentCMAddAttributeDialog
extends StatusDialog
implements ModifyListener {
    private AgentCMTableProvider m_agentCM_tp = null;
    private AgentCard m_ac = null;
    private String m_current_dataType = null;
    private String m_current_value = null;
    private Text m_dataType_field = null;
    private boolean doModify = false;
    private boolean m_isExternalHost = false;
    private GUIDisplayElements m_gui = null;
    private Composite m_parentComp = null;
    private Composite m_dialogArea = null;
    private static String ATTRIBUTES = "ATTRIBUTES";
    private static String VALUE = "VALUE";

    public AgentCMAddAttributeDialog(Shell parentShell, AgentCard ac, AgentCMTableProvider agentCM_tp, String dataType_to_modify, String value_to_modify) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setTitle("  Add Custom Attribute");
        this.m_agentCM_tp = agentCM_tp;
        this.m_ac = ac;
        if (dataType_to_modify != null && value_to_modify != null) {
            this.setTitle("  Edit Custom Attribute");
            this.doModify = true;
            this.m_current_dataType = dataType_to_modify;
            this.m_current_value = value_to_modify;
        }
        this.m_isExternalHost = this.m_ac.isExternal();
        this.m_gui = new GUIDisplayElements();
    }

    protected Control createDialogArea(Composite parent) {
        this.m_parentComp = parent;
        this.m_gui = new GUIDisplayElements();
        this.m_gui.centerShell(this.m_parentComp.getShell(), Display.getCurrent());
        this.m_dialogArea = new Composite(this.m_parentComp, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginTop = 10;
        gl.marginRight = 10;
        gl.marginLeft = 10;
        gl.verticalSpacing = 10;
        this.m_dialogArea.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 600;
        this.m_dialogArea.setLayoutData((Object)gd);
        if (!this.doModify) {
            String[] labels = this.getAvailableLabels();
            String label = labels.length > 0 ? labels[0] : "";
            this.m_gui.addTextField(this.m_dialogArea, null, "Attribute:  ", 1, 1, 0, 0, null);
            CCombo attribute_combo = this.m_gui.addDropDown(this.m_dialogArea, ATTRIBUTES, labels, label, 1, 1, 3, null);
            ((GridData)attribute_combo.getLayoutData()).horizontalAlignment = 16384;
            attribute_combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CCombo cc = (CCombo)e.getSource();
                    String label = cc.getText();
                    AgentCMAddAttributeDialog.this.m_current_dataType = Repository.getInstance().getAgentCMDataType(label);
                    AgentCMAddAttributeDialog.this.m_dataType_field.setText(AgentCMAddAttributeDialog.this.getDataType_label(AgentCMAddAttributeDialog.this.m_current_dataType));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.m_current_dataType = Repository.getInstance().getAgentCMDataType(label);
            this.m_dataType_field = this.m_gui.addTextReadOnlyNoBorder(this.m_dialogArea, "Type:  ", this.getDataType_label(this.m_current_dataType), 1, 1, 0, 0, null);
            Text value_field = this.m_gui.addInputFieldSingle(this.m_dialogArea, VALUE, "Value: ", "", 1, 1, 0, 0, 60, this);
            value_field.setBackground(BMUI.color_critical);
        } else {
            String label = Repository.getInstance().getAgentCMLabel(this.m_current_dataType);
            this.m_gui.addTextReadOnlyNoBorder(this.m_dialogArea, "Attribute:  ", label, 1, 1, 0, 0, null);
            this.m_dataType_field = this.m_gui.addTextReadOnlyNoBorder(this.m_dialogArea, "Type:  ", this.getDataType_label(this.m_current_dataType), 1, 1, 0, 0, null);
            this.m_gui.addInputFieldSingle(this.m_dialogArea, VALUE, "Value: ", this.m_current_value, 1, 1, 0, 0, 60, this);
        }
        ((GridData)this.m_dataType_field.getLayoutData()).widthHint = 60;
        ((GridData)this.m_dataType_field.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_dataType_field.getLayoutData()).grabExcessHorizontalSpace = true;
        return this.m_dialogArea;
    }

    public String[] getAvailableLabels() {
        Map<String, Object> agentCM_attributes = this.m_agentCM_tp.getACMs();
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> generalAttributes = new ArrayList<String>(Arrays.asList(AgentCardCM.ATTRIBUTES));
        for (String attr : generalAttributes) {
            if (attr.equals("ID") || attr.equals("LIT") || attr.equals("EID") && !this.m_isExternalHost || agentCM_attributes.containsKey(attr)) continue;
            String label = Repository.getInstance().getAgentCMLabel(attr);
            labels.add(label);
        }
        ArrayList<String> customAttributes = new ArrayList<String>(AgentCardCM.CUSTOM_ATTRIBUTES);
        Collections.sort(customAttributes);
        for (String attr : customAttributes) {
            if (agentCM_attributes.containsKey(attr)) continue;
            String label = Repository.getInstance().getAgentCMLabel(attr);
            labels.add(label);
        }
        return labels.toArray(new String[0]);
    }

    public String getDataType_label(String type) {
        String text = "";
        if (type != null) {
            if (type.equals("EMAIL") || type.equals("EID") || type.equals("ACID")) {
                text = "varchar(255)";
            } else if (type.equals("CONTACT") || type.startsWith("VARCHAR")) {
                text = "varchar(1024)";
            } else if (type.equals("LIT") || type.startsWith("BIGINT")) {
                text = "bigint(20)";
            } else if (type.startsWith("INT")) {
                text = "int(11)";
            } else if (type.startsWith("DOUBLE")) {
                text = "double";
            } else if (type.startsWith("TIMESTAMP")) {
                text = "timestamp  yyyy-[m]m-[d]d hh:mm:ss";
            }
        }
        return text;
    }

    public void modifyText(ModifyEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text text = (Text)obj;
            String data = (String)text.getData();
            String value = text.getText().trim();
            if (data.equals(VALUE)) {
                try {
                    AgentCardCM m_acm = new AgentCardCM(this.m_ac.getID());
                    m_acm.validateNameValue(this.m_current_dataType, value);
                    this.m_current_value = value;
                    text.setBackground(BMUI.color_white);
                    this.setDirty(true);
                }
                catch (Exception exception) {
                    this.m_current_value = null;
                    text.setBackground(BMUI.color_critical);
                    this.setDirty(false);
                }
            }
        }
    }

    public void setDirty(boolean b) {
        try {
            this.getButton(0).setEnabled(b);
        }
        catch (Exception exception) {}
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btn = this.createButton(parent, 0, "OK", true);
        btn.setEnabled(false);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.cancelPressed();
        } else if (buttonId == 0) {
            super.okPressed();
        }
    }

    public String get_dataType() {
        return this.m_current_dataType;
    }

    public Object getValue() {
        return this.m_current_value;
    }

    public boolean close() {
        Control[] controls = this.m_dialogArea.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
        return super.close();
    }
}

