/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.AgentTreeFilter;
import com.blixx.boom.gui.utils.AgentTreeFilterExcludeExternal;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.StyledTreeLabelProvider;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AgentTreeDialog
extends Dialog
implements SelectionListener,
KeyListener {
    private static final String APPLY = "APPLY";
    private TreeViewer m_viewer;
    private Set<AgentCard> m_selectedAgents = new HashSet<AgentCard>();
    private String m_title = null;
    private Text m_searchText;
    private boolean isHideExternal = false;

    public AgentTreeDialog(Shell parentShell, String title) {
        super(parentShell);
        this.m_title = title;
        this.setShellStyle(1040);
        AgentTreeDialog.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
    }

    public AgentTreeDialog(Shell parentShell, String title, boolean hideExternal) {
        this(parentShell, title);
        this.isHideExternal = hideExternal;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComp = (Composite)super.createDialogArea(parent);
        parentComp.setLayout((Layout)new GridLayout(1, false));
        parentComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite search = new Composite(parentComp, 0);
        search.setLayout((Layout)new GridLayout(3, false));
        search.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label icon = new Label(search, 0);
        icon.setImage(BMUI.IMAGE_FILTERED);
        Composite searchTextComp = new Composite(search, 0);
        searchTextComp.setLayout((Layout)new GridLayout(1, false));
        searchTextComp.setLayoutData((Object)new GridData(4, 4, true, true));
        searchTextComp.setBackground(BMUI.color_white);
        this.m_searchText = new Text(searchTextComp, 0);
        this.m_searchText.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_searchText.addKeyListener((KeyListener)this);
        GUIDisplayElements gui = new GUIDisplayElements();
        gui.addButton(search, APPLY, "Apply", true, this);
        Composite comp = new Composite(parentComp, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        gd.widthHint = 600;
        gd.heightHint = 500;
        comp.setLayoutData((Object)gd);
        this.m_viewer = new STreeViewer(comp, 268438274);
        this.m_viewer.setUseHashlookup(true);
        this.m_viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        gd = new GridData(4, 4, true, true, 1, 1);
        this.m_viewer.getTree().setLayoutData((Object)gd);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider());
        this.m_viewer.setInput((Object)Repository.getInstance().getAgentTree());
        this.m_viewer.expandToLevel(2);
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getViewer().getSelection();
                Object obj = selection.getFirstElement();
                if (!(obj instanceof GroupTreeObjectLast)) {
                    AgentTreeDialog.this.m_viewer.setExpandedState((Object)((GroupTreeObject)obj), !AgentTreeDialog.this.m_viewer.getExpandedState((Object)((GroupTreeObject)obj)));
                }
            }
        });
        if (this.isHideExternal) {
            this.hideExternal();
        }
        this.createTreeContentMenu(this.m_viewer);
        Repository.getInstance().addAgentTreeListener((StructuredViewer)this.m_viewer);
        return parentComp;
    }

    public void createTreeContentMenu(final TreeViewer treeViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        treeViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new ExpandCollapseAction(treeViewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(treeViewer, "CollapseAll"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(4, "", e);
                }
            }
        });
    }

    protected void okPressed() {
        StructuredSelection sel = (StructuredSelection)this.m_viewer.getSelection();
        ViewerFilter[] filters = this.m_viewer.getFilters();
        try {
            if (!sel.isEmpty()) {
                for (GroupTreeObject gto : sel) {
                    this.addIfAgentCard(gto, filters);
                }
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(4, "", e);
        }
        super.okPressed();
    }

    public List<AgentCard> getSelectedAgentCards(boolean excludeLocked) {
        if (excludeLocked) {
            ArrayList<AgentCard> selectedUnlocked = new ArrayList<AgentCard>(this.m_selectedAgents.size());
            for (AgentCard ac : this.m_selectedAgents) {
                if (!Repository.getInstance().isPermittedAgentModify(ac)) continue;
                selectedUnlocked.add(ac);
            }
            return selectedUnlocked;
        }
        return new ArrayList<AgentCard>(this.m_selectedAgents);
    }

    private void addIfAgentCard(GroupTreeObject gto, ViewerFilter[] filters) {
        block6: {
            block4: {
                Object o;
                block5: {
                    AgentCard ac;
                    if (!(gto instanceof GroupTreeObjectLast)) break block4;
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto;
                    int i = 0;
                    while (filters != null && i < filters.length) {
                        if (!filters[i].select(null, null, (Object)gto)) {
                            return;
                        }
                        ++i;
                    }
                    o = gtol.getTreeObject().getObject();
                    if (o != null && !(o instanceof String)) break block5;
                    String linkedID = gtol.getLinkedPath();
                    if (linkedID != null && (ac = Repository.getInstance().getAgentCard(linkedID)) != null) {
                        this.m_selectedAgents.add(ac);
                    }
                    break block6;
                }
                if (!(o instanceof AgentCard)) break block6;
                AgentCard ac = (AgentCard)o;
                this.m_selectedAgents.add(ac);
                break block6;
            }
            List<GroupTreeObject> al = gto.getElements();
            for (GroupTreeObject gto2 : al) {
                this.addIfAgentCard(gto2, filters);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String name = (String)b.getData();
            if (name == null) {
                return;
            }
            if (name.equals(APPLY)) {
                AgentTreeFilter atf = new AgentTreeFilter(this.m_searchText.getText());
                this.m_viewer.setFilters(new ViewerFilter[]{atf});
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.widget instanceof Text && e.keyCode == 13) {
            AgentTreeFilter atf = new AgentTreeFilter(this.m_searchText.getText());
            this.m_viewer.setFilters(new ViewerFilter[]{atf});
        }
    }

    public void hideExternal() {
        AgentTreeFilterExcludeExternal filter = new AgentTreeFilterExcludeExternal();
        this.m_viewer.addFilter((ViewerFilter)filter);
    }
}

