/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.policies.FFilterManager;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.actions.SelectNodeGroupsAction;
import com.blixx.shared.ext.ForwardFilter;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AttributeFilterDialog
extends StatusDialog
implements ModifyListener,
SelectionListener,
DisposeListener {
    private Shell m_parentShell = null;
    private ForwardFilter m_filter = null;
    private boolean m_isPatternValid = true;
    private GUIDisplayElements m_gui;
    private Composite m_comp = null;
    private Text m_name_field = null;
    private Text m_description_field = null;
    private CCombo m_attribute_combo = null;
    private Label m_label = null;
    private StyledText m_pattern_field = null;
    private Button m_selectNodeGroup_btn = null;
    public String m_name = null;
    public String m_attribute = null;
    public String m_description = null;
    public String m_pattern = ".*";
    private static String FILTER_NAME = "FILTER_NAME";
    private static String FILTER_DESCRIPTION = "FILTER_DESCRIPTION";
    private static String ATTRIBUTES = "ATTRIBUTES";
    private static String SELECT_NODE_GROUPS = "SELECT_NODE_GROUPS";
    private static String SELECT_AGENT_IDS = "SELECT_AGENT_IDS";
    private static String PATTERN = "PATTERN";
    private static String JAVA_PATTERN = "Java Pattern: ";
    private static String GROUP_PATHS = "Group Paths: ";
    private static String AGENT_IDS = "Agent IDs: ";

    public AttributeFilterDialog(Shell parentShell, ForwardFilter ff) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setTitle(" Attribute Filter");
        this.m_parentShell = parentShell;
        this.m_filter = ff;
    }

    protected Control createDialogArea(Composite parent) {
        this.setImage(BMUI.IMAGE_FILTERED);
        this.m_gui = new GUIDisplayElements();
        this.m_comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginTop = 15;
        gl.marginWidth = 15;
        this.m_comp.setLayout((Layout)gl);
        this.m_comp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_comp.addDisposeListener((DisposeListener)this);
        this.m_name_field = this.m_gui.addInputFieldSingle(this.m_comp, FILTER_NAME, "Name: ", "", 2, 1, 1, 1, 450, this);
        ((GridData)this.m_name_field.getLayoutData()).horizontalAlignment = 4;
        this.m_description_field = this.m_gui.addInputFieldMultiLine(this.m_comp, FILTER_DESCRIPTION, "Description: ", "", 2, 1, 150, 450, 1, 1, this);
        ((GridData)this.m_description_field.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_description_field.getLayoutData()).verticalAlignment = 4;
        ((GridData)this.m_description_field.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.m_description_field.getLayoutData()).grabExcessVerticalSpace = true;
        this.m_attribute_combo = this.m_gui.addDropDown(this.m_comp, ATTRIBUTES, "Type: ", ForwardFilter.TYPES, ForwardFilter.TYPES[0], null, 1, 1, 1, 1, this);
        ((GridData)this.m_attribute_combo.getLayoutData()).horizontalAlignment = 1;
        this.m_attribute_combo.setVisibleItemCount(7);
        this.m_selectNodeGroup_btn = this.m_gui.addButton(this.m_comp, SELECT_NODE_GROUPS, "Select", false, this);
        this.m_selectNodeGroup_btn.setVisible(false);
        this.m_label = new Label(this.m_comp, 0);
        this.m_label.setText(JAVA_PATTERN);
        this.m_pattern_field = new StyledText(this.m_comp, 2052);
        this.m_pattern_field.setData((Object)PATTERN);
        this.m_pattern_field.setText(".*");
        this.m_pattern_field.setEditable(true);
        GridData gd = new GridData(4, 128, true, false, 2, 1);
        gd.widthHint = 450;
        this.m_pattern_field.setLayoutData((Object)gd);
        this.m_pattern_field.addModifyListener((ModifyListener)this);
        if (this.m_filter != null) {
            Properties p = this.m_filter.getProperties();
            this.m_name_field.setText(p.getProperty("NAME"));
            this.m_description_field.setText(p.getProperty("DESCRIPTION"));
            String pattern = p.getProperty("PATTERN");
            if (pattern.toLowerCase().startsWith("java=")) {
                pattern = p.getProperty("PATTERN").substring(5);
            }
            int pos = 0;
            String ATTRIBUTE = p.getProperty("ATTRIBUTE");
            int i = 0;
            while (i < ForwardFilter.TYPES.length) {
                if (ATTRIBUTE.equalsIgnoreCase(ForwardFilter.TYPES[i])) {
                    pos = i;
                    break;
                }
                ++i;
            }
            this.m_attribute_combo.select(pos);
            String attribute = this.m_attribute_combo.getText();
            if ("NODEGROUP".equals(attribute)) {
                this.m_selectNodeGroup_btn.setVisible(true);
                this.m_selectNodeGroup_btn.setEnabled(true);
                this.m_selectNodeGroup_btn.setData((Object)SELECT_NODE_GROUPS);
                this.m_label.setText(GROUP_PATHS);
            } else if ("AGENTID".equals(attribute)) {
                this.m_selectNodeGroup_btn.setVisible(true);
                this.m_selectNodeGroup_btn.setEnabled(true);
                this.m_selectNodeGroup_btn.setData((Object)SELECT_AGENT_IDS);
                this.m_label.setText(AGENT_IDS);
            }
            this.m_pattern_field.setText(pattern);
        }
        return this.m_comp;
    }

    public void validate(String patternNew) {
        block11: {
            block7: {
                if (patternNew == null) {
                    patternNew = "";
                }
                int length = patternNew.length();
                boolean isValidated = false;
                try {
                    Pattern.compile(patternNew);
                    isValidated = true;
                }
                catch (PatternSyntaxException patternSyntaxException) {}
                if (length <= 0 || !isValidated) break block7;
                this.m_pattern = patternNew.toLowerCase().startsWith("java=") ? patternNew : "java=" + patternNew;
                this.m_isPatternValid = true;
                this.m_pattern_field.setBackground(BMUI.defaultBackground);
                StyleRange range = new StyleRange();
                range.foreground = BMUI.color_black;
                range.start = 0;
                range.length = this.m_pattern_field.getText().length();
                this.m_pattern_field.setStyleRange(range);
                boolean started = false;
                int start = -1;
                int brackets = 0;
                int i = 0;
                while (i < patternNew.length()) {
                    block9: {
                        block10: {
                            block8: {
                                if (patternNew.charAt(i) != '(') break block8;
                                if (i > 0 && patternNew.charAt(i - 1) == '\\' || i < patternNew.length() && patternNew.charAt(i + 1) == '?' && patternNew.charAt(i + 2) == ':') break block9;
                                if (!started) {
                                    started = true;
                                    start = i;
                                }
                                ++brackets;
                                break block10;
                            }
                            if (started && patternNew.charAt(i) == ')') {
                                --brackets;
                            }
                        }
                        if (started && brackets == 0) {
                            StyleRange range1 = new StyleRange();
                            range1.foreground = BMUI.color_lightblue;
                            range1.start = start;
                            range1.length = i + 1 - start;
                            this.m_pattern_field.setStyleRange(range1);
                            started = false;
                        }
                    }
                    ++i;
                }
                break block11;
            }
            this.m_isPatternValid = false;
            this.m_pattern_field.setBackground(BMUI.color_critical);
            StyleRange range = new StyleRange();
            range.foreground = BMUI.color_black;
            range.start = 0;
            range.length = this.m_pattern_field.getText().length();
            this.m_pattern_field.setStyleRange(range);
        }
    }

    public void checkButtonStatus() {
        if (this.m_name_field.getText().trim().length() <= 0 || this.m_pattern_field.getText().length() <= 0 || !this.m_isPatternValid) {
            this.m_gui.enableField(this.getButton(0), false);
        } else {
            this.m_gui.enableField(this.getButton(0), true);
        }
    }

    protected void okPressed() {
        this.m_name = this.m_name_field.getText().trim();
        this.m_description = this.m_description_field.getText().trim();
        this.m_attribute = this.m_attribute_combo.getText();
        this.m_pattern = this.m_pattern_field.getText().trim();
        if (this.m_attribute.equals("NODEGROUP") || this.m_attribute.equals("AGENTID")) {
            if (this.m_pattern.toLowerCase().startsWith("java=")) {
                this.m_pattern = this.m_pattern.substring(5);
            }
        } else if (!this.m_pattern.toLowerCase().startsWith("java=")) {
            this.m_pattern = "java=" + this.m_pattern;
        }
        super.okPressed();
    }

    protected Button getButton(int id) {
        return super.getButton(id);
    }

    public void modifyText(ModifyEvent e) {
        StyledText field;
        String fieldName = null;
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text field2 = (Text)obj;
            fieldName = (String)field2.getData();
            if (fieldName.equals(FILTER_NAME)) {
                boolean isValid = true;
                String value = field2.getText().trim();
                if ("".equals(value)) {
                    isValid = false;
                } else if (this.m_filter != null) {
                    String currName = this.m_filter.getName();
                    if (!value.equals(currName) && FFilterManager.getInstance().getFilter(value) != null) {
                        isValid = false;
                    }
                } else if (FFilterManager.getInstance().getFilter(value) != null) {
                    isValid = false;
                }
                if (isValid) {
                    field2.setBackground(BMUI.color_white);
                } else {
                    field2.setBackground(BMUI.color_critical);
                }
            }
        } else if (obj instanceof StyledText && (fieldName = (String)(field = (StyledText)obj).getData()) == PATTERN) {
            try {
                Properties p = this.m_filter.getProperties();
                String attribute = p.getProperty("ATTRIBUTE");
                if (!attribute.equals("NODEGROUP") && !attribute.equals("AGENTID")) {
                    this.validate(this.m_pattern_field.getText().trim());
                } else if (this.m_pattern_field.getText().length() > 0) {
                    this.m_pattern_field.setBackground(BMUI.defaultBackground);
                } else {
                    this.m_pattern_field.setBackground(BMUI.color_critical);
                }
            }
            catch (Throwable throwable) {}
        }
        this.checkButtonStatus();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        CCombo combo;
        String data;
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button b = (Button)obj;
            String name = (String)b.getData();
            if (name.equals(SELECT_NODE_GROUPS) || name.equals(SELECT_AGENT_IDS)) {
                SelectNodeGroupsAction selectNodeGroupsAction = new SelectNodeGroupsAction(this.m_parentShell, this.m_pattern_field.getText().trim(), name.equals(SELECT_AGENT_IDS));
                selectNodeGroupsAction.run();
                String selectedNodeGroups = selectNodeGroupsAction.getSelectedNodeGroups();
                if (selectedNodeGroups != null) {
                    this.m_pattern_field.removeModifyListener((ModifyListener)this);
                    this.m_pattern_field.setText(selectedNodeGroups);
                    this.m_pattern_field.addModifyListener((ModifyListener)this);
                    if (selectedNodeGroups.length() > 0) {
                        this.m_pattern_field.setBackground(BMUI.defaultBackground);
                        this.m_isPatternValid = true;
                    } else {
                        this.m_pattern_field.setBackground(BMUI.color_critical);
                        this.m_isPatternValid = false;
                    }
                    this.checkButtonStatus();
                }
            }
        } else if (obj instanceof CCombo && (data = (String)(combo = (CCombo)obj).getData()).equals(ATTRIBUTES)) {
            String value = combo.getText();
            if (value.equals("NODEGROUP")) {
                this.m_gui.enableField(this.m_selectNodeGroup_btn, true);
                this.m_selectNodeGroup_btn.setVisible(true);
                this.m_selectNodeGroup_btn.setData((Object)SELECT_NODE_GROUPS);
                this.m_label.setText(GROUP_PATHS);
                this.m_gui.setEditable(this.m_pattern_field, false);
                this.m_pattern_field.setText("");
            } else if (value.equals("AGENTID")) {
                this.m_gui.enableField(this.m_selectNodeGroup_btn, true);
                this.m_selectNodeGroup_btn.setVisible(true);
                this.m_selectNodeGroup_btn.setData((Object)SELECT_AGENT_IDS);
                this.m_label.setText(AGENT_IDS);
                this.m_gui.setEditable(this.m_pattern_field, false);
                this.m_pattern_field.setText("");
            } else {
                this.m_gui.enableField(this.m_selectNodeGroup_btn, false);
                this.m_selectNodeGroup_btn.setVisible(false);
                this.m_label.setText(JAVA_PATTERN);
                this.m_gui.setEditable(this.m_pattern_field, true);
                if (this.m_pattern_field.getText().length() > 0) {
                    this.m_pattern_field.setBackground(BMUI.defaultBackground);
                } else {
                    this.m_pattern_field.setBackground(BMUI.color_critical);
                }
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_name_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_description_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_attribute_combo.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_label.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_pattern_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_comp.dispose();
        }
        catch (Throwable throwable) {}
    }
}

