/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.policies.FFilterManager;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.shared.ext.ForwardFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AttributeFilterListDialog
extends Dialog {
    private Composite m_comp = null;
    private TableViewer m_tv = null;
    List<ForwardFilter> m_selection = new ArrayList<ForwardFilter>();
    public static String ATTRIBUTE_FILTER_COL_NUMBER = "Number";
    public Listener sortListener = new Listener(){

        public void handleEvent(Event e) {
            if (e.type == 13) {
                TableColumn sortColumn = AttributeFilterListDialog.this.m_tv.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = AttributeFilterListDialog.this.m_tv.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    AttributeFilterListDialog.this.m_tv.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                AttributeFilterListDialog.this.m_tv.getTable().setSortDirection(dir);
                AttributeFilterListDialog.this.m_tv.refresh(true, false);
            }
        }
    };

    public AttributeFilterListDialog() {
        super(Display.getCurrent().getActiveShell());
        super.setShellStyle(66704);
    }

    protected Control createDialogArea(Composite parent) {
        this.m_comp = new Composite(parent, 0);
        this.m_comp.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 700;
        gd.heightHint = 300;
        this.m_comp.setLayoutData((Object)gd);
        Table table = new Table(this.m_comp, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        table.setLayout((Layout)gl);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 100;
        gd.widthHint = 200;
        table.setLayoutData((Object)gd);
        TableColumn col1 = new TableColumn(table, 16384);
        col1.setText(ATTRIBUTE_FILTER_COL_NUMBER);
        col1.setAlignment(131072);
        col1.setWidth(50);
        col1.addListener(13, this.sortListener);
        TableColumn col2 = new TableColumn(table, 16384);
        col2.setText("Name");
        col2.setWidth(150);
        col2.addListener(13, this.sortListener);
        TableColumn col3 = new TableColumn(table, 16384);
        col3.setText("Attribute");
        col3.setWidth(100);
        col3.addListener(13, this.sortListener);
        TableColumn col4 = new TableColumn(table, 16384);
        col4.setText("Pattern");
        col4.setWidth(250);
        col4.addListener(13, this.sortListener);
        TableColumn col5 = new TableColumn(table, 16384);
        col5.setText("Description");
        col5.setWidth(350);
        col5.addListener(13, this.sortListener);
        this.m_tv = new TableViewer(table);
        FFilterManager filterManager = FFilterManager.getInstance();
        this.m_tv.setContentProvider((IContentProvider)filterManager);
        this.m_tv.setLabelProvider((IBaseLabelProvider)filterManager);
        this.m_tv.setInput((Object)filterManager.getElements(null));
        this.m_tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection sel = (StructuredSelection)AttributeFilterListDialog.this.m_tv.getSelection();
                if (sel.size() == 0) {
                    AttributeFilterListDialog.this.getButton(0).setEnabled(false);
                } else {
                    AttributeFilterListDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this.m_tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AttributeFilterListDialog.this.okPressed();
            }
        });
        table.setSortColumn(col1);
        table.setSortDirection(1024);
        this.m_tv.setComparator((ViewerComparator)ServerFilterView.getAttrFilterTableComparator(table));
        return this.m_comp;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("   Filters");
        newShell.setImage(BMUI.IMAGE_PRODUCT);
    }

    protected void okPressed() {
        this.m_selection.clear();
        StructuredSelection sel = (StructuredSelection)this.m_tv.getSelection();
        if (!sel.isEmpty()) {
            for (ForwardFilter ff : sel) {
                this.m_selection.add(ff);
            }
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Cancel", false);
        this.createButton(parent, 0, "OK", true);
        this.getButton(0).setFocus();
        this.getButton(0).setEnabled(false);
    }

    public boolean close() {
        try {
            this.m_tv.getTable().dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_comp.dispose();
        }
        catch (Throwable throwable) {}
        return super.close();
    }

    public List<ForwardFilter> getSelection() {
        return this.m_selection;
    }
}

