/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.PVDialog;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.PatternValidator;
import com.blixx.boom.gui.views.CondVFilterTableProvider;
import com.blixx.boom.gui.views.FilterCondDetails;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CondVFilterDialog
implements ShellListener,
ModifyListener,
SelectionListener {
    private Shell m_shell = null;
    private List<String> m_toVfilter = null;
    private int m_selIndex = -1;
    private Action m_action = null;
    private String m_variable = null;
    private String m_pattern = null;
    private GUIDisplayElements m_gui = null;
    private Text m_variableName_field = null;
    private StyledText m_pattern_field = null;
    private Button m_cancel_btn = null;
    private Button m_save_btn = null;
    private boolean m_isPatternValid = false;
    private PatternValidator m_patternValidator = null;
    private static String VARIABLE_NAME = "VARIABLE_NAME";
    private static String PATTERN = "PATTERN";
    private static String BUTTON_VALIDATE = "BUTTON_VALIDATE";
    private static String BUTTON_CANCEL = "BUTTON_CANCEL";
    private static String BUTTON_SAVE = "BUTTON_SAVE";

    public CondVFilterDialog(Shell parentShell, int selIndex, List<String> toVfilter, String variable, String pattern, Action action) {
        int style = 1265;
        this.m_shell = parentShell != null ? new Shell(parentShell, style) : new Shell(Display.getCurrent().getActiveShell(), style);
        this.m_shell.addShellListener((ShellListener)this);
        this.m_shell.setLayout((Layout)new GridLayout(1, false));
        this.m_shell.setSize(500, 160);
        this.m_shell.setImage(BMUI.IMAGE_PRODUCT);
        if (variable == null && pattern == null) {
            this.m_shell.setText("  Add Match Variables");
        } else {
            this.m_shell.setText("  Edit Match Variables");
        }
        this.m_selIndex = selIndex;
        this.m_action = action;
        this.m_patternValidator = new PatternValidator();
        this.m_toVfilter = toVfilter;
        this.m_variable = variable == null ? "" : variable;
        this.m_pattern = pattern == null ? "" : pattern;
        this.createContents((Composite)this.m_shell);
    }

    protected Control createContents(Composite parent) {
        this.m_gui = new GUIDisplayElements();
        Composite m_comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginTop = 5;
        gl.marginWidth = 10;
        m_comp.setLayout((Layout)gl);
        m_comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_variableName_field = this.m_gui.addInputFieldSingle(m_comp, VARIABLE_NAME, "Variable: ", this.m_variable, 2, 1, 0, 0, 60, this);
        this.m_variableName_field.setToolTipText("Use <$varName> syntax here");
        this.m_variableName_field.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 32) {
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.createContentAssist((Control)this.m_variableName_field, this.m_toVfilter.toArray(new String[0]));
        this.m_gui.addTextField(m_comp, null, "Simplified Pattern: ", 1, 1, 0, 0, BMUI.font_arial8);
        this.m_pattern_field = new StyledText(m_comp, 2052);
        this.m_pattern_field.setData((Object)PATTERN);
        this.m_pattern_field.setText(this.m_pattern);
        this.m_pattern_field.setEditable(true);
        this.m_pattern_field.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_pattern_field.addModifyListener((ModifyListener)this);
        this.m_isPatternValid = this.m_patternValidator.validatePattern(PatternValidator.SIMPLIFIED, this.m_pattern_field);
        this.m_gui.addButton(m_comp, BUTTON_VALIDATE, " Validate Pattern", true, 90, 20, 1, this);
        Composite tmp = new Composite(m_comp, 0);
        tmp.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Composite compBtn = new Composite(m_comp, 0);
        gl = new GridLayout(2, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        compBtn.setLayout((Layout)gl);
        compBtn.setLayoutData((Object)new GridData(131072, 1024, true, false, 3, 1));
        this.m_save_btn = this.m_gui.addButton(compBtn, BUTTON_SAVE, " Save ", false, 90, 20, 0, this);
        this.m_save_btn.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_cancel_btn = this.m_gui.addButton(compBtn, BUTTON_CANCEL, "  Cancel  ", true, 90, 20, 0, this);
        this.m_cancel_btn.setLayoutData((Object)new GridData(4, 128, false, false));
        return parent;
    }

    public SimpleContentProposalProvider createContentAssist(Control ct, String[] proposals) {
        char[] autoActivationCharacters = new char[]{};
        SimpleContentProposalProvider defaultProposalProvider = null;
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            defaultProposalProvider = new SimpleContentProposalProvider(proposals);
            new ContentProposalAdapter(ct, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)defaultProposalProvider, keyStroke, autoActivationCharacters);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return defaultProposalProvider;
    }

    public String getVariable() {
        return this.m_variable;
    }

    public String getPattern() {
        return this.m_pattern;
    }

    public void setPattern(String pattern) {
        this.m_pattern_field.setText(pattern);
        this.checkButtonStatus();
    }

    public void checkButtonStatus() {
        if (this.m_variableName_field.getText().trim().length() > 0 && this.m_isPatternValid) {
            this.m_gui.enableField(this.m_save_btn, true);
        } else {
            this.m_gui.enableField(this.m_save_btn, false);
        }
    }

    public void open() {
        this.m_shell.open();
    }

    public void modifyText(ModifyEvent e) {
        StyledText field;
        String name;
        if (e.getSource() instanceof StyledText && (name = (String)(field = (StyledText)e.getSource()).getData()).equals(PATTERN)) {
            this.m_isPatternValid = this.m_patternValidator.validatePattern(PatternValidator.SIMPLIFIED, this.m_pattern_field);
        }
        this.checkButtonStatus();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String btnName = (String)b.getData();
            if (btnName.equals(BUTTON_VALIDATE)) {
                String pattern = this.m_pattern_field.getText().trim();
                if (pattern.equals("")) {
                    pattern = "<*>";
                }
                PVDialog pvd = new PVDialog(pattern, this.m_shell, PatternValidator.SIMPLIFIED, true, this);
                pvd.open();
            } else if (btnName.equals(BUTTON_CANCEL)) {
                if (this.m_action instanceof FilterCondDetails.EditCondVFilterAction) {
                    ((FilterCondDetails.EditCondVFilterAction)this.m_action).resetDirtyStatus();
                } else if (this.m_action instanceof FilterCondDetails.AddCondVFilterAction) {
                    ((FilterCondDetails.AddCondVFilterAction)this.m_action).resetDirtyStatus();
                }
                this.m_shell.dispose();
            } else if (btnName.equals(BUTTON_SAVE)) {
                StringBuffer sb_old = new StringBuffer();
                sb_old.append(this.m_variable).append(CondVFilterTableProvider.EQUAL).append(this.m_pattern);
                String newVariable = this.m_variableName_field.getText().trim();
                String newPattern = this.m_pattern_field.getText().trim();
                StringBuffer sb_new = new StringBuffer();
                sb_new.append(newVariable).append(CondVFilterTableProvider.EQUAL).append(newPattern);
                if (this.m_action instanceof FilterCondDetails.EditCondVFilterAction) {
                    ((FilterCondDetails.EditCondVFilterAction)this.m_action).updateTable(this.m_selIndex, sb_old.toString(), sb_new.toString());
                } else if (this.m_action instanceof FilterCondDetails.AddCondVFilterAction) {
                    ((FilterCondDetails.AddCondVFilterAction)this.m_action).addCondVFilter(sb_new.toString());
                }
                this.m_shell.dispose();
            }
        }
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellClosed(ShellEvent e) {
        try {
            this.m_variableName_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_pattern_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_cancel_btn.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_save_btn.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_shell.dispose();
        }
        catch (Throwable throwable) {}
        this.m_shell = null;
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }
}

