/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.FilterCondDetails;
import com.blixx.boom.gui.views.MonitorCondDetails;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CustomerAttributesDialog
implements ShellListener,
ModifyListener,
SelectionListener {
    private Shell m_shell = null;
    private boolean m_isReadOnly = false;
    private Object m_condDetails = null;
    private GUIDisplayElements m_gui;
    private ScrolledComposite m_sc = null;
    private Composite m_mainComp = null;
    private Button m_cancel_btn = null;
    private Button m_save_btn = null;
    private static String SAVE = "SAVE";
    private static String CANCEL = "CANCEL";
    private boolean m_disposed = false;
    public List<String> m_customAttributes = new ArrayList<String>(15);
    public List<List<Text>> m_guiElementList = new ArrayList<List<Text>>();

    public CustomerAttributesDialog(List<String> customAttributes, boolean isReadOnly, Object condDetails) {
        this.m_customAttributes = customAttributes;
        this.m_isReadOnly = isReadOnly;
        this.m_condDetails = condDetails;
        this.m_shell = new Shell(Display.getCurrent().getActiveShell(), 1137);
        this.m_shell.addShellListener((ShellListener)this);
        this.m_shell.setLayout((Layout)new GridLayout(1, false));
        this.createDialogArea((Composite)this.m_shell);
        this.m_shell.setText(" Custom Attributes");
        this.m_shell.setImage(BMUI.IMAGE_PRODUCT);
    }

    protected Control createDialogArea(Composite parent) {
        this.m_gui = new GUIDisplayElements();
        this.m_sc = new ScrolledComposite(parent, 768);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        this.m_sc.setLayout((Layout)new GridLayout(1, false));
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_sc.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                ScrolledComposite sc = (ScrolledComposite)event.widget;
                int wheelCount = event.count;
                wheelCount = (int)Math.ceil((float)wheelCount / 3.0f);
                while (wheelCount < 0) {
                    sc.getVerticalBar().setIncrement(8);
                    ++wheelCount;
                }
                while (wheelCount > 0) {
                    sc.getVerticalBar().setIncrement(-8);
                    --wheelCount;
                }
            }
        });
        this.m_mainComp = new Composite((Composite)this.m_sc, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 20;
        gl.marginHeight = 10;
        this.m_mainComp.setLayout((Layout)gl);
        this.m_mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_gui.addTextField(this.m_mainComp, null, "", 1, 1, 1, 1, null);
        this.m_gui.addTextField(this.m_mainComp, null, " Attribute Name", 1, 1, 1, 1, null);
        this.m_gui.addTextField(this.m_mainComp, null, " Attribute Value", 1, 1, 1, 1, null);
        ArrayList<Text> list = null;
        Text t_Name = null;
        Text t_Value = null;
        String name = "";
        String value = "";
        this.m_guiElementList.clear();
        int i = 0;
        while (i < 15) {
            list = new ArrayList<Text>();
            name = "";
            value = "";
            String attr = this.m_customAttributes.get(i);
            int index = attr.indexOf(61);
            if (index != -1) {
                name = attr.substring(0, index);
                value = attr.substring(index + 1);
            }
            t_Name = this.m_gui.addInputFieldSingle(this.m_mainComp, "CAN" + (i + 1), "CA " + (i + 1) + ": ", name, 1, 1, 1, 1, 140, this);
            t_Value = this.m_gui.addInputFieldSingle(this.m_mainComp, "CAV" + (i + 1), null, value, 1, 1, 1, 1, 180, this);
            if (this.m_isReadOnly) {
                this.m_gui.enableField(t_Name, false);
                this.m_gui.enableField(t_Value, false);
            }
            list.add(t_Name);
            list.add(t_Value);
            this.m_guiElementList.add(list);
            ++i;
        }
        Composite btn_comp = new Composite(parent, 0);
        gl = new GridLayout(2, true);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        btn_comp.setLayout((Layout)gl);
        btn_comp.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.m_save_btn = this.m_gui.addButton(btn_comp, SAVE, " Save ", false, this);
        this.m_save_btn.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_cancel_btn = this.m_gui.addButton(btn_comp, CANCEL, " Cancel ", true, this);
        this.m_cancel_btn.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_sc.setContent((Control)this.m_mainComp);
        this.m_sc.setMinSize(this.m_mainComp.computeSize(-1, -1, true));
        return this.m_sc;
    }

    private void save() {
        List<Text> elems = null;
        String t_name = null;
        String t_value = null;
        this.m_customAttributes.clear();
        int i = 0;
        while (i < this.m_guiElementList.size()) {
            elems = this.m_guiElementList.get(i);
            t_name = elems.get(0).getText().trim();
            t_value = elems.get(1).getText().trim();
            if (t_name.length() == 0 || t_value.length() == 0) {
                this.m_customAttributes.add("");
            } else {
                String val = String.valueOf(t_name) + "=" + t_value;
                if (val.length() > 1024) {
                    val = val.substring(0, 1024);
                }
                this.m_customAttributes.add(val);
            }
            ++i;
        }
        if (this.m_condDetails instanceof MonitorCondDetails) {
            ((MonitorCondDetails)this.m_condDetails).updateCustomAttributes(this.m_customAttributes);
        } else if (this.m_condDetails instanceof FilterCondDetails) {
            ((FilterCondDetails)this.m_condDetails).updateCustomAttributes(this.m_customAttributes);
        }
        this.close();
    }

    public void open() {
        this.m_shell.pack();
        this.m_shell.open();
    }

    public void close() {
        this.m_shell.close();
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() instanceof Text) {
            try {
                Text t = (Text)e.getSource();
                String fname = (String)t.getData();
                Pattern p = Pattern.compile(".*(\\d+)");
                Matcher m = p.matcher(fname);
                if (m.matches()) {
                    int canumber = Integer.parseInt(m.group(1));
                    List<Text> elems = this.m_guiElementList.get(canumber - 1);
                    Text t_name = elems.get(0);
                    Text t_value = elems.get(1);
                    if (fname.startsWith("CAN") && t.getText().indexOf(61) != -1) {
                        t_name.setBackground(BMUI.color_light_red);
                        t_name.setToolTipText("The '=' character is not allowed for Attribute Name!");
                        this.m_gui.enableField(this.m_save_btn, false);
                    } else {
                        String caTotalText = String.valueOf(t_name.getText().trim()) + '=' + t_value.getText().trim();
                        if (caTotalText.length() > 1024) {
                            t_name.setBackground(BMUI.color_light_red);
                            t_name.setToolTipText("CA is too long.");
                            t_value.setBackground(BMUI.color_light_red);
                            t_name.setToolTipText("CA is too long.");
                            this.m_gui.enableField(this.m_save_btn, false);
                        } else {
                            t_name.setBackground(null);
                            t_name.setToolTipText(null);
                            t_value.setBackground(null);
                            t_value.setToolTipText(null);
                            this.m_gui.enableField(this.m_save_btn, true);
                        }
                    }
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o instanceof Button) {
            Button btn = (Button)o;
            String name = (String)btn.getData();
            if (name.equals(SAVE)) {
                this.save();
            } else if (name.equals(CANCEL)) {
                this.close();
            }
        }
    }

    public void shellActivated(ShellEvent e) {
        this.m_shell.moveAbove(null);
    }

    public void shellClosed(ShellEvent e) {
        this.m_disposed = true;
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public boolean isDisposed() {
        return this.m_disposed;
    }
}

