/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventFilterAgentAndHost;
import com.blixx.boom.engine.IEventsSummary;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.gui.dialogs.FilterTableProvider;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.settings.BrowserLabelManager;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.utils.FilterFactory;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.calendar.CalendarDialog;
import com.blixx.boom.gui.utils.calendar.SWTCalListener;
import com.blixx.boom.gui.views.StyledTreeLabelProvider;
import com.blixx.boom.gui.views.actions.OpenFilterAction;
import com.blixx.boom.gui.views.actions.SaveFilterAction;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.HashMapArray;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EventFilterDialog2
implements SelectionListener,
ModifyListener,
ShellListener,
MouseListener {
    public EventFilterDialog2 evDialog = null;
    public Shell m_shell = null;
    public EventFilter m_selectedFilter = null;
    public TableViewer m_message_tv = null;
    public TableViewer m_filter_tv = null;
    public TreeViewer m_treeViewer = null;
    public FilterTableProvider m_tableProvider = null;
    private FilterFactory m_filterFactory = null;
    private CTabItem m_tab = null;
    public Map<String, EventFilter> m_historyFilters = null;
    public GUIDisplayElements m_gde = null;
    private int m_type_a = 0;
    private int m_type_k = 0;
    public Composite m_compMain = null;
    private Table m_fitler_table = null;
    public org.eclipse.swt.widgets.List m_history_list = null;
    public CCombo m_column_Combo = null;
    private CCombo m_condition_Combo = null;
    private Label m_textMatch_label = null;
    private Label m_filterName = null;
    private Text m_label = null;
    private Text m_matchExisting_field = null;
    private Text m_match_field = null;
    private Button m_unknown_check = null;
    private Button m_normal_check = null;
    private Button m_warning_check = null;
    private Button m_minor_check = null;
    private Button m_major_check = null;
    private Button m_critical_check = null;
    private List<Object> m_sev_elems = null;
    private Text m_year_field = null;
    private Text m_month_field = null;
    private Text m_day_field = null;
    private Text m_hrs_field = null;
    private Text m_min_field = null;
    private Text m_sec_field = null;
    private Label m_date_label = null;
    private Label m_dateFormat_label = null;
    private Label m_time_label = null;
    private Label m_timeFormat_label = null;
    private Button m_isNot_check = null;
    private Button m_match_check = null;
    private Button m_selectExisting_btn = null;
    private Button m_caseSensitive_check = null;
    private Button m_typeA_check = null;
    private Button m_typeK_check = null;
    public Button m_addAsNew_button = null;
    public Button m_delFilter_button = null;
    public Button m_delFilterHistory_button = null;
    public Button m_loadFromFile_button = null;
    public Button m_saveToFile_button = null;
    public Button m_moveToHistory_button = null;
    public Button m_moveToCurrent_button = null;
    private Button m_close_button = null;
    public Button m_apply_button = null;
    private Group m_grp_condition = null;
    private Group m_grp_textMatch = null;
    public Group m_grp_severity = null;
    public Group m_grp_dateMatch = null;
    private Label m_calendar_icon = null;
    private static final String LABEL = "LABEL";
    public static final String NEW_FILTER = "*** New Filter ***";
    private static final String FILTER_TABLE = "FILTER_TABLE";
    private static final String HISTORY_LIST = "HISTOREY_LIST";
    private static final String COLUMN_COMBO = "COLUMNS_COMBO";
    private static final String CONDITION_COMBO = "CONDITION_COMBO";
    private static final String SELECT_EXISTING_VALUES_BTN = "SELECT_EXISTING_VALUES_BTN";
    private static final String MATCH_CHECK = "MATCH_CHECK";
    private static final String MATCH_FIELD = "MATCH_FIELD";
    private static final String CASE_SENSITIVE_CHECK = "CASE_SENSITIVE_CHECK";
    private static final String YEAR_FIELD = "YEAR_FIELD";
    private static final String MONTH_FIELD = "MONTH_FIELD";
    private static final String DAY_FIELD = "DAY_FIELD";
    private static final String HRS_FIELD = "HRS_FIELD";
    private static final String MIN_FIELD = "MIN_FIELD";
    private static final String SEC_FIELD = "SEC_FIELD";
    private static final String ISNOT = "ISNOT";
    private static final String TYPE_A = "TYPE_A";
    private static final String TYPE_K = "TYPE_K";
    public static final String ADD_AS_NEW = "ADD_AS_NEW";
    public static final String DEL_FILTER = "DEL_FILTER";
    public static final String LOAD_FROM_FILE = "LOAD_FROM_FILE";
    public static final String SAVE_TO_FILE = "SAVE_TO_FILE";
    private static final String MOVE_TO_HISTORY = "MOVE_TO_HISTORY";
    private static final String MOVE_TO_CURRENT = "ADD_TO_CURRENT";
    private static final String DEL_FROM_HISTORY = "DEL_FROM_HISTORY";
    public static final String APPLY = "APPLY";
    private static final String CLOSE = "CLOSE";
    private static final String LESS = "<";
    private static final String BIGGER = ">";
    private static final String EXACTLY = "EXACTLY";
    private static final String ENDS_WITH = "ENDS WITH";
    private static final String STARTS_WITH = "STARTS WITH";
    private static final String CONTAINS = "CONTAINS";
    public static Map<String, Integer> m_colIndices = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> m_condTextIndices = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> m_condDupIndices = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> m_condSevIndices = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> m_sevIndices = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> m_condTimeIndices = new LinkedHashMap<String, Integer>();
    private static Map<String, Integer> m_condOwnerIndices = new LinkedHashMap<String, Integer>();
    public static List<String> m_colList = null;
    private static List<String> m_condText_List = null;
    private static List<String> m_condDup_List = null;
    private static List<String> m_condSev_List = null;
    private static List<String> m_condTime_List = null;
    private static List<String> m_condOwner_List = null;
    private static BrowserLabelManager m_browserLabelManager = null;
    private Set<String> m_owners = new TreeSet<String>();
    public static final char SEPARATOR_DEFAULT = '\u25ba';
    private IEventsSummary m_eventStorageSummary = null;

    static {
        m_browserLabelManager = Repository.getInstance().getBrowserLabelManager();
        m_colIndices.put(m_browserLabelManager.getLabel("Agent"), 0);
        m_colIndices.put(m_browserLabelManager.getLabel("Application"), 1);
        m_colIndices.put(m_browserLabelManager.getLabel("Duplicates"), 2);
        m_colIndices.put(m_browserLabelManager.getLabel("Group"), 3);
        m_colIndices.put(m_browserLabelManager.getLabel("Host"), 4);
        m_colIndices.put(m_browserLabelManager.getLabel("Object"), 5);
        m_colIndices.put(m_browserLabelManager.getLabel("Severity"), 6);
        m_colIndices.put(m_browserLabelManager.getLabel("Text"), 7);
        m_colIndices.put(m_browserLabelManager.getLabel("Time"), 8);
        m_colIndices.put(m_browserLabelManager.getLabel("SrvTime"), 9);
        m_colIndices.put(m_browserLabelManager.getLabel("Source"), 10);
        m_colIndices.put(m_browserLabelManager.getLabel("CA name"), 11);
        m_colIndices.put(m_browserLabelManager.getLabel("CA value"), 12);
        m_colIndices.put(m_browserLabelManager.getLabel("SlaveServerName"), 13);
        m_colIndices.put(m_browserLabelManager.getLabel("ID"), 14);
        m_colIndices.put(m_browserLabelManager.getLabel("Owned"), 15);
        m_colIndices.put(m_browserLabelManager.getLabel("Node group"), 16);
        m_colIndices.put(m_browserLabelManager.getLabel("AgentID"), 17);
        m_colIndices.put(m_browserLabelManager.getLabel("Node group [Hosts]"), 18);
        m_colIndices.put(m_browserLabelManager.getLabel("Key"), 19);
        m_condTextIndices.put(CONTAINS, 0);
        m_condTextIndices.put(STARTS_WITH, 1);
        m_condTextIndices.put(ENDS_WITH, 2);
        m_condTextIndices.put(EXACTLY, 3);
        m_condDupIndices.put(EXACTLY, 0);
        m_condDupIndices.put(LESS, 1);
        m_condDupIndices.put(BIGGER, 2);
        m_condOwnerIndices.put(EXACTLY, 0);
        m_condTimeIndices.put(LESS, 0);
        m_condTimeIndices.put(BIGGER, 1);
        m_condSevIndices.put(CONTAINS, 0);
        m_condSevIndices.put(EXACTLY, 1);
        m_sevIndices.put("unknown", 0);
        m_sevIndices.put("normal", 1);
        m_sevIndices.put("warning", 2);
        m_sevIndices.put("minor", 3);
        m_sevIndices.put("major", 4);
        m_sevIndices.put("critical", 5);
        m_colList = new ArrayList<String>(m_colIndices.keySet());
        m_condText_List = new ArrayList<String>(m_condTextIndices.keySet());
        m_condDup_List = new ArrayList<String>(m_condDupIndices.keySet());
        m_condSev_List = new ArrayList<String>(m_condSevIndices.keySet());
        m_condTime_List = new ArrayList<String>(m_condTimeIndices.keySet());
        m_condOwner_List = new ArrayList<String>(m_condOwnerIndices.keySet());
    }

    public EventFilterDialog2(TableViewer tv, String title, CTabItem tab, IEventsSummary eventStorage) {
        this.m_eventStorageSummary = eventStorage;
        this.evDialog = this;
        this.m_message_tv = tv;
        this.m_tab = tab;
        this.m_historyFilters = new HashMap<String, EventFilter>();
        this.m_filterFactory = new FilterFactory();
        this.m_owners.add("Me");
        this.m_owners.add("Me+Nobody");
        this.m_owners.add("Nobody");
        this.m_owners.add("Other");
        int style = 1265;
        this.m_shell = new Shell(Display.getCurrent().getActiveShell(), style);
        this.m_shell.setLayout((Layout)new GridLayout(1, false));
        this.m_shell.setText(title);
        this.setImage();
        this.m_shell.addShellListener((ShellListener)this);
    }

    public void setImage() {
        this.m_shell.setImage(BMUI.IMAGE_FILTERED);
    }

    protected void createContents(Composite parent) {
        this.m_gde = new GUIDisplayElements();
        this.m_compMain = new Composite(parent, 0);
        GridLayout gdl = new GridLayout(2, false);
        gdl.marginBottom = 2;
        gdl.marginTop = 2;
        gdl.marginLeft = 2;
        gdl.marginRight = 2;
        this.m_compMain.setLayout((Layout)gdl);
        this.m_compMain.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite compLeft = new Composite(this.m_compMain, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        compLeft.setLayout((Layout)gl);
        compLeft.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createFilterListSection(compLeft);
        Composite compUpDownBtn = new Composite(compLeft, 0);
        gl = new GridLayout(3, true);
        gl.marginHeight = 0;
        compUpDownBtn.setLayout((Layout)gl);
        compUpDownBtn.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.m_moveToHistory_button = this.m_gde.addButton(compUpDownBtn, MOVE_TO_HISTORY, " DOWN ", false, 120, 10, 1, this);
        this.m_moveToCurrent_button = this.m_gde.addButton(compUpDownBtn, MOVE_TO_CURRENT, " UP ", false, 120, 10, 1, this);
        this.createHistoryList(compLeft);
        Composite compRight = new Composite(this.m_compMain, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        compRight.setLayout((Layout)gl);
        compRight.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.createFilterDetails(compRight);
        this.createButtonBar(compRight);
        this.loadHistory();
        this.updateHistoryList(null);
        this.updateFilterDetails();
    }

    public void createFilterListSection(Composite parent) {
        Group grp_filterList = new Group(parent, 32);
        grp_filterList.setText("Current Filters ");
        grp_filterList.setLayout((Layout)new GridLayout(2, false));
        grp_filterList.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_fitler_table = new Table((Composite)grp_filterList, 268503842);
        this.m_fitler_table.setHeaderVisible(false);
        this.m_fitler_table.setLinesVisible(false);
        this.m_fitler_table.setData((Object)FILTER_TABLE);
        this.m_fitler_table.addMouseListener((MouseListener)this);
        GridData gdData = new GridData(1808);
        gdData.verticalSpan = 3;
        gdData.widthHint = 250;
        gdData.heightHint = 130;
        this.m_fitler_table.setLayoutData((Object)gdData);
        TableColumn col1 = new TableColumn(this.m_fitler_table, 0x1000000);
        col1.setWidth(20);
        TableColumn col2 = new TableColumn(this.m_fitler_table, 16384);
        col2.setWidth(248);
        this.m_filter_tv = new TableViewer(this.m_fitler_table);
        this.m_tableProvider = new FilterTableProvider(this.m_message_tv, this.m_filter_tv, this.evDialog);
        this.m_filter_tv.setContentProvider((IContentProvider)this.m_tableProvider);
        this.m_filter_tv.setLabelProvider((IBaseLabelProvider)this.m_tableProvider);
        this.m_filter_tv.setInput((Object)this.m_tableProvider.getElements(null));
        this.m_filter_tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSource() instanceof TableViewer) {
                    TableItem[] itemList = EventFilterDialog2.this.m_filter_tv.getTable().getSelection();
                    if (itemList.length > 0) {
                        EventFilterDialog2.this.m_selectedFilter = (EventFilter)((Object)itemList[0].getData());
                        EventFilterDialog2.this.updateFilterDetails();
                    }
                    EventFilterDialog2.this.m_gde.enableField(EventFilterDialog2.this.m_moveToHistory_button, true);
                    EventFilterDialog2.this.m_delFilter_button.setEnabled(true);
                    EventFilterDialog2.this.deactivateFilterHistorySection();
                }
            }
        });
        if (this.m_filter_tv.getTable().getItemCount() > 0) {
            this.m_filter_tv.getTable().select(0);
            this.m_selectedFilter = (EventFilter)((Object)this.m_filter_tv.getTable().getItem(0).getData());
        }
        this.m_delFilter_button = this.m_gde.addButton((Composite)grp_filterList, DEL_FILTER, " Delete ", true, 120, 10, 1, this);
        ((GridData)this.m_delFilter_button.getLayoutData()).grabExcessVerticalSpace = true;
        this.m_loadFromFile_button = this.m_gde.addButton((Composite)grp_filterList, LOAD_FROM_FILE, " Import ", true, 120, 10, 1, this);
        ((GridData)this.m_loadFromFile_button.getLayoutData()).horizontalAlignment = 1024;
        this.m_saveToFile_button = this.m_gde.addButton((Composite)grp_filterList, SAVE_TO_FILE, " Export ", true, 120, 10, 1, this);
        ((GridData)this.m_saveToFile_button.getLayoutData()).horizontalAlignment = 1024;
    }

    public void createHistoryList(Composite parent) {
        Group grp_history = new Group(parent, 32);
        grp_history.setText("Filter History: ");
        grp_history.setLayout((Layout)new GridLayout(2, false));
        grp_history.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_history_list = new org.eclipse.swt.widgets.List((Composite)grp_history, 2818);
        this.m_history_list.setData((Object)HISTORY_LIST);
        GridData gd = new GridData(250, 100);
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.m_history_list.setLayoutData((Object)gd);
        this.m_history_list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof org.eclipse.swt.widgets.List) {
                    org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)e.getSource();
                    if (list.isDisposed()) {
                        return;
                    }
                    String[] selection = list.getSelection();
                    if (selection.length > 0) {
                        String fLabel = selection[0];
                        EventFilterDialog2.this.setFilterListSelection(selection);
                        if (EventFilterDialog2.this.m_historyFilters.containsKey(fLabel)) {
                            EventFilterDialog2.this.m_selectedFilter = EventFilterDialog2.this.m_historyFilters.get(fLabel);
                            EventFilterDialog2.this.updateFilterDetails();
                        }
                    }
                    EventFilterDialog2.this.activateFilterHistorySection();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_delFilterHistory_button = this.m_gde.addButton((Composite)grp_history, DEL_FROM_HISTORY, " Delete ", false, 120, 10, 1, this);
    }

    public void createFilterDetails(Composite parent) {
        Group grp_filterDetails = new Group(parent, 32);
        grp_filterDetails.setText("Filter Details");
        grp_filterDetails.setLayout((Layout)new GridLayout(2, false));
        grp_filterDetails.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_filterName = this.m_gde.addTextField((Composite)grp_filterDetails, null, NEW_FILTER, 2, 1, 0, 0, BMUI.font_arial8_bold);
        ((GridData)this.m_filterName.getLayoutData()).widthHint = 40;
        ((GridData)this.m_filterName.getLayoutData()).horizontalAlignment = 4;
        this.m_filterName.setForeground(BMUI.color_critical);
        this.m_label = this.m_gde.addInputFieldSingle((Composite)grp_filterDetails, LABEL, "Label: ", "", 1, 1, 0, 0, 120, this);
        ((GridData)this.m_label.getLayoutData()).horizontalAlignment = 4;
        Group grpCol = new Group((Composite)grp_filterDetails, 32);
        grpCol.setText("Select Column");
        grpCol.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 128, true, false, 2, 1);
        gd.verticalIndent = 5;
        grpCol.setLayoutData((Object)gd);
        this.m_column_Combo = this.m_gde.addDropDown((Composite)grpCol, COLUMN_COMBO, null, m_colList.toArray(new String[0]), m_colList.get(0), null, 2, 1, 1, 1, this);
        ((GridData)this.m_column_Combo.getLayoutData()).widthHint = 40;
        ((GridData)this.m_column_Combo.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_column_Combo.getLayoutData()).grabExcessHorizontalSpace = true;
        this.m_column_Combo.setVisibleItemCount(15);
        this.m_grp_condition = new Group((Composite)grp_filterDetails, 32);
        this.m_grp_condition.setText("Select Condition");
        this.m_grp_condition.setLayout((Layout)new GridLayout(1, false));
        this.m_grp_condition.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_isNot_check = this.m_gde.addCheckbox((Composite)this.m_grp_condition, ISNOT, "NOT", false, 1, 1, 1, this);
        this.m_condition_Combo = this.m_gde.addDropDown((Composite)this.m_grp_condition, CONDITION_COMBO, null, m_condText_List.toArray(new String[0]), m_condText_List.get(0), null, 1, 1, 1, 1, this);
        ((GridData)this.m_condition_Combo.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_condition_Combo.getLayoutData()).grabExcessHorizontalSpace = true;
        this.m_condition_Combo.setVisibleItemCount(30);
        this.m_grp_textMatch = new Group((Composite)grp_filterDetails, 32);
        this.m_grp_textMatch.setText("Text Matching");
        GridLayout gl = new GridLayout(3, false);
        gl.verticalSpacing = 0;
        this.m_grp_textMatch.setLayout((Layout)gl);
        this.m_grp_textMatch.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_textMatch_label = this.m_gde.addTextField((Composite)this.m_grp_textMatch, null, "Existing Values: ", 1, 1, 1, 1, null);
        this.m_matchExisting_field = this.m_gde.addTextReadOnly((Composite)this.m_grp_textMatch, null, "", 1, 1, 1, 1, null, null);
        this.m_matchExisting_field.setBackground(BMUI.color_white);
        ((GridData)this.m_matchExisting_field.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.m_matchExisting_field.getLayoutData()).horizontalAlignment = 4;
        this.m_selectExisting_btn = this.m_gde.addButton((Composite)this.m_grp_textMatch, SELECT_EXISTING_VALUES_BTN, "...", true, 120, 60, 1, this);
        this.m_match_check = this.m_gde.addCheckbox((Composite)this.m_grp_textMatch, MATCH_CHECK, "Free Text:", false, 1, 1, 1, this);
        this.m_match_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_textMatch, MATCH_FIELD, null, "", 2, 1, 1, 1, 150, this);
        ((GridData)this.m_match_field.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.m_match_field.getLayoutData()).horizontalAlignment = 4;
        this.m_gde.enableField(this.m_match_field, false);
        this.m_gde.addTextField((Composite)this.m_grp_textMatch, null, "", 1, 1, 1, 1, null);
        this.m_caseSensitive_check = this.m_gde.addCheckbox((Composite)this.m_grp_textMatch, CASE_SENSITIVE_CHECK, "Case Sensitive", false, 2, 1, 1, this);
        this.m_sev_elems = new ArrayList<Object>();
        this.m_grp_severity = new Group((Composite)grp_filterDetails, 32);
        this.m_grp_severity.setText("Severity");
        gl = new GridLayout(9, false);
        gl.verticalSpacing = 0;
        this.m_grp_severity.setLayout((Layout)gl);
        this.m_grp_severity.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_unknown_check = this.m_gde.addCheckbox((Composite)this.m_grp_severity, "", null, false, 1, 1, 1, this);
        Label unknown_icon = new Label((Composite)this.m_grp_severity, 0);
        unknown_icon.setImage(BMUI.IMAGE_UNKNOWN);
        Label unknown_label = new Label((Composite)this.m_grp_severity, 0);
        unknown_label.setText("unknown");
        this.m_sev_elems.add(this.m_unknown_check);
        this.m_sev_elems.add(unknown_icon);
        this.m_sev_elems.add(unknown_label);
        this.m_normal_check = this.m_gde.addCheckbox((Composite)this.m_grp_severity, "", null, false, 1, 1, 1, this);
        ((GridData)this.m_normal_check.getLayoutData()).horizontalIndent = 30;
        Label normal_icon = new Label((Composite)this.m_grp_severity, 0);
        normal_icon.setImage(BMUI.IMAGE_NORMAL);
        Label normal_label = new Label((Composite)this.m_grp_severity, 0);
        normal_label.setText("normal");
        this.m_sev_elems.add(this.m_normal_check);
        this.m_sev_elems.add(normal_icon);
        this.m_sev_elems.add(normal_label);
        this.m_warning_check = this.m_gde.addCheckbox((Composite)this.m_grp_severity, "", null, false, 1, 1, 1, this);
        ((GridData)this.m_warning_check.getLayoutData()).horizontalIndent = 30;
        Label warning_icon = new Label((Composite)this.m_grp_severity, 0);
        warning_icon.setImage(BMUI.IMAGE_WARNING);
        Label warning_label = new Label((Composite)this.m_grp_severity, 0);
        warning_label.setText("warning");
        this.m_sev_elems.add(this.m_warning_check);
        this.m_sev_elems.add(warning_icon);
        this.m_sev_elems.add(warning_label);
        this.m_minor_check = this.m_gde.addCheckbox((Composite)this.m_grp_severity, "", null, false, 1, 1, 1, this);
        Label minor_icon = new Label((Composite)this.m_grp_severity, 0);
        minor_icon.setImage(BMUI.IMAGE_MINOR);
        Label minor_label = new Label((Composite)this.m_grp_severity, 0);
        minor_label.setText("minor");
        this.m_sev_elems.add(this.m_minor_check);
        this.m_sev_elems.add(minor_icon);
        this.m_sev_elems.add(minor_label);
        this.m_major_check = this.m_gde.addCheckbox((Composite)this.m_grp_severity, "", null, false, 1, 1, 1, this);
        ((GridData)this.m_major_check.getLayoutData()).horizontalIndent = 30;
        Label major_icon = new Label((Composite)this.m_grp_severity, 0);
        major_icon.setImage(BMUI.IMAGE_MAJOR);
        Label major_label = new Label((Composite)this.m_grp_severity, 0);
        major_label.setText("major");
        this.m_sev_elems.add(this.m_major_check);
        this.m_sev_elems.add(major_icon);
        this.m_sev_elems.add(major_label);
        this.m_critical_check = this.m_gde.addCheckbox((Composite)this.m_grp_severity, "", null, false, 1, 1, 1, this);
        ((GridData)this.m_critical_check.getLayoutData()).horizontalIndent = 30;
        Label critical_icon = new Label((Composite)this.m_grp_severity, 0);
        critical_icon.setImage(BMUI.IMAGE_CRITICAL);
        Label critical_label = new Label((Composite)this.m_grp_severity, 0);
        critical_label.setText("critical");
        this.m_sev_elems.add(this.m_critical_check);
        this.m_sev_elems.add(critical_icon);
        this.m_sev_elems.add(critical_label);
        this.enableTextMatching(true, false, true, false);
        this.m_grp_dateMatch = new Group((Composite)grp_filterDetails, 32);
        this.m_grp_dateMatch.setText("Time Matching");
        this.m_grp_dateMatch.setLayout((Layout)new GridLayout(12, false));
        this.m_grp_dateMatch.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Calendar cal = Calendar.getInstance();
        this.m_date_label = this.m_gde.addTextField((Composite)this.m_grp_dateMatch, null, "Date: ", 1, 1, 1, 1, null);
        ((GridData)this.m_date_label.getLayoutData()).verticalAlignment = 0x1000000;
        this.m_year_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_dateMatch, YEAR_FIELD, null, "" + cal.get(1), 1, 1, 1, 1, 30, this);
        this.m_year_field.setTextLimit(4);
        this.m_month_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_dateMatch, MONTH_FIELD, null, "" + cal.get(2), 1, 1, 1, 1, 15, this);
        this.m_month_field.setTextLimit(2);
        this.m_day_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_dateMatch, DAY_FIELD, null, "" + cal.get(5), 1, 1, 1, 1, 15, this);
        this.m_day_field.setTextLimit(2);
        this.m_calendar_icon = new Label((Composite)this.m_grp_dateMatch, 0);
        this.m_calendar_icon.setImage(BMUI.IMAGE_CALENDAR);
        this.m_calendar_icon.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                CalendarDialog cd = new CalendarDialog(EventFilterDialog2.this.m_shell);
                SWTCalListener calendar2 = new SWTCalListener();
                cd.addDateChangedListener(calendar2);
                cd.setBlockOnOpen(true);
                cd.open();
                EventFilterDialog2.this.m_year_field.setText(calendar2.getYear());
                EventFilterDialog2.this.m_month_field.setText(calendar2.getMonth());
                EventFilterDialog2.this.m_day_field.setText(calendar2.getDay());
            }
        });
        this.m_dateFormat_label = this.m_gde.addTextField((Composite)this.m_grp_dateMatch, null, "yyyy/mm/dd  ", 1, 1, 1, 1, null);
        ((GridData)this.m_dateFormat_label.getLayoutData()).verticalAlignment = 0x1000000;
        this.m_time_label = this.m_gde.addTextField((Composite)this.m_grp_dateMatch, null, "Time: ", 1, 1, 1, 20, null);
        ((GridData)this.m_time_label.getLayoutData()).verticalAlignment = 0x1000000;
        this.m_hrs_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_dateMatch, HRS_FIELD, null, "00", 1, 1, 1, 1, 15, this);
        this.m_hrs_field.setTextLimit(2);
        this.m_min_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_dateMatch, MIN_FIELD, null, "00", 1, 1, 1, 1, 15, this);
        this.m_min_field.setTextLimit(2);
        this.m_sec_field = this.m_gde.addInputFieldSingle((Composite)this.m_grp_dateMatch, SEC_FIELD, null, "00", 1, 1, 1, 1, 15, this);
        this.m_sec_field.setTextLimit(2);
        this.m_timeFormat_label = this.m_gde.addTextField((Composite)this.m_grp_dateMatch, null, "h/m/s", 1, 1, 1, 1, null);
        ((GridData)this.m_timeFormat_label.getLayoutData()).verticalAlignment = 0x1000000;
        Composite comp = new Composite((Composite)grp_filterDetails, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.m_typeA_check = this.m_gde.addCheckbox(comp, TYPE_A, "AND +Availability", false, 1, 1, 5, this);
        this.m_typeK_check = this.m_gde.addCheckbox(comp, TYPE_K, "AND +KPI", false, 1, 1, 5, this);
    }

    public void createButtonBar(Composite parent) {
        Composite compButton = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compButton.setLayout((Layout)gl);
        GridData gd = new GridData(131072, 128, true, true, 2, 1);
        gd.verticalIndent = 10;
        compButton.setLayoutData((Object)gd);
        this.m_addAsNew_button = this.m_gde.addButton(compButton, ADD_AS_NEW, " Add As New ", true, 120, 60, 1, this);
        this.m_addAsNew_button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_apply_button = this.m_gde.addButton(compButton, APPLY, " Apply ", true, 120, 60, 1, this);
        this.m_apply_button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_close_button = this.m_gde.addButton(compButton, CLOSE, " Close ", true, 120, 60, 1, this);
        this.m_close_button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
    }

    public void fillConditionCombo(String colType) {
        this.m_condition_Combo.removeAll();
        if (colType == null) {
            return;
        }
        if (colType.equals("Duplicates")) {
            this.m_condition_Combo.setItems(m_condDup_List.toArray(new String[0]));
        } else if (colType.equals("Severity")) {
            this.m_condition_Combo.setItems(m_condSev_List.toArray(new String[0]));
        } else if (colType.equals("Time") || colType.equals("SrvTime")) {
            this.m_condition_Combo.setItems(m_condTime_List.toArray(new String[0]));
        } else if (colType.equals("Owned")) {
            this.m_condition_Combo.setItems(m_condOwner_List.toArray(new String[0]));
        } else {
            this.m_condition_Combo.setItems(m_condText_List.toArray(new String[0]));
        }
        if (this.m_condition_Combo.getItemCount() > 0) {
            this.m_condition_Combo.select(0);
        }
    }

    public void updateTextMatchSection(String colType) {
        this.m_matchExisting_field.setText("");
        if (colType.equals("Time") || colType.equals("SrvTime")) {
            this.enableTimeMatching(true);
            this.enableCondSection(true, false, true);
            this.enableTextMatching(false, false, false, false);
        } else if (colType.equals("Severity")) {
            this.enableTimeMatching(false);
            this.enableCondSection(false, false, false);
            this.enableTextMatching(false, false, false, true);
        } else if (colType.equals("Duplicates") || colType.equals("Text")) {
            this.enableTimeMatching(false);
            this.enableCondSection(true, false, true);
            this.enableTextMatching(true, false, true, false);
        } else if (colType.equals("Owned")) {
            this.enableTimeMatching(false);
            this.enableCondSection(true, false, true);
            this.enableTextMatching(true, true, false, false);
        } else {
            this.enableTimeMatching(false);
            this.enableCondSection(true, true, true);
            this.enableTextMatching(true, true, false, false);
        }
    }

    private ArrayList<String> getExistingValuesList(String colType) {
        ArrayList<String> existingValues = new ArrayList<String>();
        if (colType == null) {
            this.enableTextMatching(true, false, true, false);
            this.enableTimeMatching(false);
            this.enableCondSection(true, true, true);
            return existingValues;
        }
        Set<Object> keySet = new TreeSet();
        if (colType.equals("Application")) {
            keySet = new TreeSet(this.m_eventStorageSummary.getApplications().keySet());
        } else if (colType.equals("Group")) {
            keySet = new TreeSet(this.m_eventStorageSummary.getMsgGrps().keySet());
        } else if (colType.equals("Host")) {
            keySet = new TreeSet();
            for (String hostAgent : this.m_eventStorageSummary.getHosts().keySet()) {
                keySet.add(hostAgent.split("\u25ba")[0]);
            }
        } else if (colType.equals("Object")) {
            keySet = new TreeSet(this.m_eventStorageSummary.getObjects().keySet());
        } else if (colType.equals("Agent")) {
            keySet = new TreeSet();
            for (AgentCard ac : Repository.getInstance().getAgentCards()) {
                keySet.add(ac.getAgentHost());
            }
        } else if (colType.equals("Owned")) {
            keySet = this.m_owners;
        } else if (colType.equals("Node group")) {
            GroupTreeObject nodeGroups = Repository.getInstance().getNodeGroupTree();
            for (GroupTreeObject nodeGroup : nodeGroups.getAllGroups()) {
                keySet.add(nodeGroup.getPath().replace("/root/_Groups/", ""));
            }
        }
        existingValues.addAll(keySet);
        return existingValues;
    }

    public void updateHistoryList(List<String> selection) {
        if (this.m_history_list.getItemCount() > 0) {
            this.m_history_list.removeAll();
        }
        for (String fLabel : this.m_historyFilters.keySet()) {
            this.m_history_list.add(fLabel);
        }
        this.setHistoryListSelection(selection);
    }

    public void setHistoryListSelection(List<String> selection) {
        if (selection == null || selection.size() < 1) {
            return;
        }
        String[] items = new String[selection.size()];
        int i = 0;
        while (i < selection.size()) {
            items[i] = selection.get(i);
            ++i;
        }
        this.m_history_list.setSelection(items);
    }

    public void updateFilterDetails() {
        if (this.m_selectedFilter == null || this.m_selectedFilter instanceof EventFilterAgentAndHost || this.m_selectedFilter instanceof ServiceDashBoard) {
            this.newFilterDetails();
            this.m_gde.enableField(this.m_apply_button, false);
            return;
        }
        EventFilter ef = this.m_selectedFilter;
        boolean columnFound = false;
        String[] labels = this.m_column_Combo.getItems();
        int i = 0;
        while (i < labels.length) {
            String name = m_browserLabelManager.getName(labels[i]);
            if (name.equals(ef.m_column)) {
                this.m_column_Combo.select(i);
                columnFound = true;
                break;
            }
            ++i;
        }
        String colName = ef.m_column;
        String colLabel = m_browserLabelManager.getLabel(colName);
        if (!columnFound) {
            this.m_column_Combo.add(colLabel);
            this.m_column_Combo.select(this.m_column_Combo.getItems().length - 1);
            this.enableTextMatching(true, false, true, false);
            this.m_match_field.setText(ef.m_pattern);
            this.m_caseSensitive_check.setSelection(ef.m_caseSensitive);
            this.m_label.setText(ef.getLabel());
            this.m_gde.enableField(this.m_apply_button, true);
            return;
        }
        this.m_gde.enableField(this.m_apply_button, true);
        String efStr = ef.toString();
        this.m_filterName.setText(efStr);
        this.m_filterName.setForeground(BMUI.color_black);
        if (efStr.indexOf("|") != -1) {
            efStr = efStr.replaceAll("\\|", "\n");
        }
        this.m_filterName.setToolTipText(efStr);
        this.m_label.setText(ef.getLabel());
        this.fillConditionCombo(colName);
        if (colName.equals("Time") || colName.equals("SrvTime")) {
            this.enableCondSection(true, false, true);
            this.m_isNot_check.setSelection(ef.m_isNOT);
            this.m_condition_Combo.select(m_condTimeIndices.get(EventFilterDialog2.getCondition(ef.m_mode)).intValue());
        } else {
            boolean isNotEnabled = true;
            if (colName.equals("Duplicates")) {
                this.m_condition_Combo.select(m_condDupIndices.get(EventFilterDialog2.getCondition(ef.m_mode)).intValue());
            } else if (colName.equals("Severity")) {
                this.m_condition_Combo.select(m_condSevIndices.get(EventFilterDialog2.getCondition(ef.m_mode)).intValue());
            } else if (colName.equals("Owned")) {
                this.m_condition_Combo.select(m_condOwnerIndices.get(EventFilterDialog2.getCondition(ef.m_mode)).intValue());
                isNotEnabled = false;
            } else {
                this.m_condition_Combo.select(m_condTextIndices.get(EventFilterDialog2.getCondition(ef.m_mode)).intValue());
            }
            this.enableCondSection(true, isNotEnabled, true);
            this.m_isNot_check.setSelection(ef.m_isNOT);
        }
        if (colName.equals("Severity")) {
            this.enableTextMatching(false, false, false, true);
            this.enableTimeMatching(false);
            try {
                String[] sList = ef.m_pattern.split("\\|");
                int i2 = 0;
                while (i2 < sList.length) {
                    if (sList[i2].equals("unknown")) {
                        this.m_unknown_check.setSelection(true);
                    } else if (sList[i2].equals("normal")) {
                        this.m_normal_check.setSelection(true);
                    } else if (sList[i2].equals("warning")) {
                        this.m_warning_check.setSelection(true);
                    } else if (sList[i2].equals("minor")) {
                        this.m_minor_check.setSelection(true);
                    } else if (sList[i2].equals("major")) {
                        this.m_major_check.setSelection(true);
                    } else if (sList[i2].equals("critical")) {
                        this.m_critical_check.setSelection(true);
                    }
                    ++i2;
                }
            }
            catch (PatternSyntaxException e) {
                RTLogger.print(1, "Error splitting filter severity pattern=" + ef.m_pattern + "  " + e.getMessage());
                RTLogger.print(2, "", e);
            }
        } else if (colName.equals("Time") || colName.equals("SrvTime")) {
            this.enableTextMatching(false, false, false, false);
            this.enableTimeMatching(true);
            String[] list = ef.m_pattern.split(" ");
            String date = list[0];
            String time = list[1];
            String[] dateList = date.split("-");
            String[] timeLIst = time.split(":");
            this.m_year_field.setText(dateList[0]);
            this.m_month_field.setText(dateList[1]);
            this.m_day_field.setText(dateList[2]);
            this.m_hrs_field.setText(timeLIst[0]);
            this.m_min_field.setText(timeLIst[1]);
            this.m_sec_field.setText(timeLIst[2]);
        } else {
            this.enableTimeMatching(false);
            ArrayList<String> existingValues = this.getExistingValuesList(colName);
            if (!existingValues.isEmpty() && ef.m_pattern != null && ef.m_pattern.length() > 0) {
                if (existingValues.contains(ef.m_pattern)) {
                    this.enableTextMatching(true, true, false, false);
                    this.m_gde.enableField(this.m_matchExisting_field, true);
                    this.m_gde.enableField(this.m_selectExisting_btn, true);
                    this.m_matchExisting_field.setText(ef.m_pattern);
                } else {
                    this.enableTextMatching(true, false, true, false);
                    this.m_match_field.setText(ef.m_pattern);
                    this.m_caseSensitive_check.setSelection(ef.m_caseSensitive);
                }
            } else {
                this.enableTextMatching(true, false, true, false);
                this.m_match_field.setText(ef.m_pattern == null ? "" : ef.m_pattern);
                this.m_caseSensitive_check.setSelection(ef.m_caseSensitive);
            }
        }
        this.m_typeA_check.setSelection(ef.m_Availability == 1);
        this.m_typeK_check.setSelection(ef.m_KPIs == 1);
        this.m_type_a = ef.m_Availability;
        this.m_type_k = ef.m_KPIs;
    }

    public void newFilterDetails() {
        this.m_selectedFilter = null;
        this.m_filterName.setText(NEW_FILTER);
        this.m_filterName.setForeground(BMUI.color_critical);
        this.m_label.setText("");
        int selIndex = 0;
        this.m_column_Combo.select(selIndex);
        String colName = m_browserLabelManager.getName(this.m_column_Combo.getItem(selIndex));
        this.fillConditionCombo(colName);
        this.updateTextMatchSection(colName);
    }

    public void enableCondSection(boolean group, boolean checkbox, boolean combo) {
        if (!group) {
            combo = false;
            checkbox = false;
        }
        this.m_grp_condition.setEnabled(group);
        this.m_gde.enableField(this.m_isNot_check, checkbox);
        this.m_isNot_check.setSelection(false);
        this.m_gde.enableField(this.m_condition_Combo, combo);
    }

    public void enableTextMatching(boolean group, boolean existingValues, boolean text, boolean severity) {
        if (!group) {
            text = false;
            existingValues = false;
        }
        this.m_grp_textMatch.setEnabled(group);
        this.m_textMatch_label.setEnabled(existingValues);
        this.m_gde.enableField(this.m_matchExisting_field, existingValues);
        this.m_gde.enableField(this.m_selectExisting_btn, existingValues);
        this.m_gde.enableField(this.m_match_check, text);
        this.m_match_check.setSelection(text);
        this.m_gde.enableField(this.m_caseSensitive_check, text);
        if (!text) {
            this.m_match_field.setText("");
            this.m_caseSensitive_check.setSelection(false);
        }
        this.m_gde.enableField(this.m_match_field, text);
        if (group && !severity) {
            this.m_gde.enableField(this.m_match_check, true);
        }
        if (!this.m_grp_severity.isDisposed()) {
            this.m_grp_severity.setEnabled(severity);
            this.m_unknown_check.setSelection(false);
            this.m_normal_check.setSelection(false);
            this.m_warning_check.setSelection(false);
            this.m_minor_check.setSelection(false);
            this.m_major_check.setSelection(false);
            this.m_critical_check.setSelection(false);
            int i = 0;
            while (i < this.m_sev_elems.size()) {
                this.m_gde.enableField(this.m_sev_elems.get(i), severity);
                ++i;
            }
        }
    }

    public void enableTimeMatching(boolean group) {
        if (this.m_grp_dateMatch.isDisposed()) {
            return;
        }
        this.m_grp_dateMatch.setEnabled(group);
        this.m_date_label.setEnabled(group);
        this.m_calendar_icon.setEnabled(group);
        this.m_dateFormat_label.setEnabled(group);
        this.m_time_label.setEnabled(group);
        this.m_timeFormat_label.setEnabled(group);
        this.m_gde.enableField(this.m_year_field, group);
        this.m_gde.enableField(this.m_month_field, group);
        this.m_gde.enableField(this.m_day_field, group);
        this.m_gde.enableField(this.m_hrs_field, group);
        this.m_gde.enableField(this.m_min_field, group);
        this.m_gde.enableField(this.m_sec_field, group);
    }

    public int deleteFilter() {
        int selCount = this.m_filter_tv.getTable().getSelectionCount();
        if (selCount > 0) {
            ArrayList<String> list = new ArrayList<String>();
            TableItem[] itemList = this.m_filter_tv.getTable().getSelection();
            int i = 0;
            while (i < itemList.length) {
                TableItem item = itemList[i];
                EventFilter ef = (EventFilter)((Object)item.getData());
                if (!ef.m_isLocked) {
                    list.add(ef.toString());
                }
                ++i;
            }
            ViewFilterAction.removeFilter(this.m_tab, this.m_message_tv, list.toArray(new String[0]));
            Iterator<EventFilter> remain = ViewFilterAction.getActiveFiltersIterator(this.m_message_tv);
            if (remain.hasNext()) {
                EventFilter ef = remain.next();
                this.m_tableProvider.updateTable(ef);
            } else {
                this.m_tableProvider.updateTable(null);
            }
            this.updateFilterDetails();
            this.deactivateFilterHistorySection();
        }
        return this.m_filter_tv.getTable().getItemCount();
    }

    public void loadHistory() {
        File file = new File(String.valueOf(Repository.getUserDirectory()) + File.separator + "filterHistory.xml");
        if (file.exists() || file.canRead()) {
            HashMapArray<TableViewer, EventFilter> hma = this.m_filterFactory.loadFilter(file, null);
            this.m_historyFilters.clear();
            List<EventFilter> list = hma.getArray(null);
            for (EventFilter ef : list) {
                this.m_historyFilters.put(ef.getLabelOrName(), ef);
            }
        } else {
            RTLogger.print(1, "Required file: " + file.getPath() + " not found. Exit.");
        }
    }

    public void moveToHistory() {
        ArrayList<String> list = new ArrayList<String>();
        TableItem[] itemList = this.m_filter_tv.getTable().getSelection();
        int i = 0;
        while (i < itemList.length) {
            EventFilter ef = (EventFilter)((Object)itemList[i].getData());
            String fLabel = ef.getLabelOrName();
            if (!this.m_historyFilters.containsKey(fLabel)) {
                this.m_historyFilters.put(fLabel, ef);
                list.add(fLabel);
            }
            ++i;
        }
        this.saveHistory();
        this.updateHistoryList(list);
    }

    public void saveHistory() {
        boolean success = true;
        String path = String.valueOf(Repository.getUserDirectory()) + File.separator + "filterHistory.xml";
        try {
            File file = new File(path);
            if (file.exists()) {
                success = file.delete();
            }
            if (success) {
                Collection<EventFilter> c = this.m_historyFilters.values();
                this.m_filterFactory.storeFilter(file, c.iterator());
            } else {
                RTLogger.print(4, "File exists, error deleting file");
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error saving file" + path, e);
        }
    }

    public int deleteFromHistory() {
        String[] selection = this.m_history_list.getSelection();
        int i = 0;
        while (i < selection.length) {
            String fLabel = selection[i];
            String fName = m_browserLabelManager.getName(fLabel);
            if (this.m_historyFilters.containsKey(fName)) {
                this.m_historyFilters.remove(fName);
            } else if (this.m_historyFilters.containsKey(fLabel)) {
                this.m_historyFilters.remove(fLabel);
            }
            ++i;
        }
        this.saveHistory();
        this.updateHistoryList(null);
        if (this.m_history_list.getItemCount() > 0) {
            this.m_history_list.setSelection(0);
        }
        return this.m_history_list.getItemCount();
    }

    public void moveToCurrent() {
        EventFilter selected = null;
        EventFilter ef = null;
        String[] selection = this.m_history_list.getSelection();
        int i = 0;
        while (i < selection.length) {
            String fLabel = selection[i];
            ef = this.m_historyFilters.get(fLabel);
            if (ef != null) {
                ef.m_tv = this.m_message_tv;
                ViewFilterAction.addFilter(null, this.m_message_tv, ef);
                if (selected == null) {
                    selected = ef;
                }
            }
            ++i;
        }
        this.m_tableProvider.updateTable(selected);
        this.m_filter_tv.getTable().deselectAll();
        this.updateFilterDetails();
    }

    public EventFilter saveFilter(boolean addAsNew) {
        EventFilter currentFilter;
        String matchText = null;
        String severityStr = null;
        String time1Str = null;
        if (this.m_selectedFilter != null && this.m_filter_tv != null && (currentFilter = ViewFilterAction.getFilterByName(this.m_message_tv, this.m_selectedFilter.toString())) != null && !addAsNew && currentFilter.m_isLocked) {
            this.updateFilterDetails();
            return null;
        }
        if (this.m_column_Combo.getText() == null || this.m_column_Combo.getText().trim().length() <= 0) {
            return null;
        }
        if (this.m_grp_textMatch.isEnabled()) {
            if (this.m_match_check.getSelection()) {
                if (this.m_match_field.getText() == null || this.m_match_field.getText().trim().length() <= 0) {
                    return null;
                }
                matchText = this.m_match_field.getText().trim();
            } else if (!this.m_match_check.getSelection() && this.m_matchExisting_field.isEnabled()) {
                if (this.m_matchExisting_field.getText() == null || this.m_matchExisting_field.getText().trim().length() <= 0) {
                    return null;
                }
                matchText = this.m_matchExisting_field.getText();
            }
        } else if (!this.m_grp_severity.isDisposed() && this.m_grp_severity.isEnabled()) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.m_unknown_check.getSelection()) {
                list.add("unknown");
            }
            if (this.m_normal_check.getSelection()) {
                list.add("normal");
            }
            if (this.m_warning_check.getSelection()) {
                list.add("warning");
            }
            if (this.m_minor_check.getSelection()) {
                list.add("minor");
            }
            if (this.m_major_check.getSelection()) {
                list.add("major");
            }
            if (this.m_critical_check.getSelection()) {
                list.add("critical");
            }
            StringBuffer tmpStr = new StringBuffer();
            int i = 0;
            while (i < list.size()) {
                tmpStr.append((String)list.get(i)).append("|");
                ++i;
            }
            if (tmpStr.charAt(tmpStr.length() - 1) == '|') {
                severityStr = tmpStr.substring(0, tmpStr.length() - 1);
            }
        } else if (!this.m_grp_dateMatch.isDisposed() && this.m_grp_dateMatch.isEnabled()) {
            int sec;
            int min;
            int hrs;
            int day;
            int month;
            int year;
            block44: {
                block43: {
                    try {
                        year = Integer.parseInt(this.m_year_field.getText().trim().isEmpty() ? "0" : this.m_year_field.getText().trim());
                        month = Integer.parseInt(this.m_month_field.getText().trim().isEmpty() ? "0" : this.m_month_field.getText().trim());
                        day = Integer.parseInt(this.m_day_field.getText().trim().isEmpty() ? "0" : this.m_day_field.getText().trim());
                        hrs = Integer.parseInt(this.m_hrs_field.getText().trim().isEmpty() ? "0" : this.m_hrs_field.getText().trim());
                        min = Integer.parseInt(this.m_min_field.getText().trim().isEmpty() ? "0" : this.m_min_field.getText().trim());
                        sec = Integer.parseInt(this.m_sec_field.getText().trim().isEmpty() ? "0" : this.m_sec_field.getText().trim());
                        if (year >= 2000 && year <= 2099 && month >= 1 && month <= 12 && day >= 1 && day <= 31 && (month != 2 && month != 4 && month != 6 && month != 9 && month != 11 || day <= 30) && (month != 2 || !new GregorianCalendar().isLeapYear(year) || day <= 29) && (month != 2 || new GregorianCalendar().isLeapYear(year) || day <= 28)) break block43;
                        new ShowMessageBox("Date Validation", "   Invalid Date!            ", 1);
                        return null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                }
                if (hrs >= 0 && hrs <= 23 && min >= 0 && min <= 59 && sec >= 0 && sec <= 59) break block44;
                new ShowMessageBox("Time Validation", "   Invalid time!            ", 1);
                return null;
            }
            time1Str = String.valueOf(this.checkLeadingZeros(year)) + "-" + this.checkLeadingZeros(month) + "-" + this.checkLeadingZeros(day) + " " + this.checkLeadingZeros(hrs) + ":" + this.checkLeadingZeros(min) + ":" + this.checkLeadingZeros(sec) + ":000";
        }
        int mode = 0;
        boolean isNot = false;
        if (this.m_grp_condition.isEnabled()) {
            if (this.m_condition_Combo.isEnabled()) {
                String text = this.m_condition_Combo.getText();
                if (text.equals(CONTAINS)) {
                    mode = 3;
                } else if (text.equals(STARTS_WITH)) {
                    mode = 1;
                } else if (text.equals(ENDS_WITH)) {
                    mode = 2;
                } else if (text.equals(EXACTLY)) {
                    mode = 4;
                } else if (text.equals(BIGGER)) {
                    mode = 5;
                } else if (text.equals(LESS)) {
                    mode = 6;
                }
            }
            if (this.m_isNot_check.isEnabled()) {
                isNot = this.m_isNot_check.getSelection();
            }
        }
        if (!addAsNew) {
            this.removeFilter(this.m_selectedFilter);
        }
        EventFilter ef = null;
        String colLabel = this.m_column_Combo.getText();
        String colName = m_browserLabelManager.getName(colLabel);
        if (!this.m_grp_dateMatch.isDisposed() && this.m_grp_dateMatch.isEnabled()) {
            if (time1Str != null) {
                ef = new EventFilter(this.m_label.getText().trim(), colName, time1Str, this.m_caseSensitive_check.getSelection(), mode, this.m_message_tv, false, this.m_type_a, this.m_type_k, isNot);
            }
        } else {
            ef = !this.m_grp_severity.isDisposed() && this.m_grp_severity.isEnabled() ? new EventFilter(this.m_label.getText().trim(), colName, severityStr, this.m_caseSensitive_check.getSelection(), 3, this.m_message_tv, false, this.m_type_a, this.m_type_k, isNot) : new EventFilter(this.m_label.getText().trim(), colName, matchText, this.m_caseSensitive_check.getSelection(), mode, this.m_message_tv, false, this.m_type_a, this.m_type_k, isNot);
        }
        if (ef != null) {
            this.addFilter(ef);
            this.updateFilterDetails();
        }
        return ef;
    }

    public void removeFilter(EventFilter ef) {
        if (ef == null) {
            return;
        }
        EventFilter oldFilter = ViewFilterAction.getFilterByName(this.m_message_tv, ef.toString());
        if (oldFilter != null) {
            ViewFilterAction.removeFilter(this.m_tab, this.m_message_tv, new String[]{ef.toString()});
        }
    }

    public void addFilter(EventFilter ef) {
        EventFilter oldFilter = ViewFilterAction.getFilterByName(this.m_message_tv, ef.toString());
        if (oldFilter == null) {
            ViewFilterAction.addFilter(this.m_tab, this.m_message_tv, ef);
            this.m_tableProvider.updateTable(ef);
            this.m_selectedFilter = ef;
        } else {
            this.m_selectedFilter = oldFilter;
            int ii = 0;
            while (ii < this.m_filter_tv.getTable().getItemCount()) {
                TableItem ti = this.m_filter_tv.getTable().getItem(ii);
                EventFilter filter = (EventFilter)((Object)ti.getData());
                if (filter.toString().equals(oldFilter.toString())) {
                    this.m_filter_tv.getTable().setSelection(ii);
                    break;
                }
                ++ii;
            }
        }
    }

    public String checkLeadingZeros(int value) {
        String newValue = null;
        newValue = "" + value;
        if (value < 10) {
            newValue = "0" + value;
        }
        return newValue;
    }

    public static String getCondition(int mode) {
        String condition = "";
        switch (mode) {
            case 1: {
                condition = STARTS_WITH;
                break;
            }
            case 2: {
                condition = ENDS_WITH;
                break;
            }
            case 3: {
                condition = CONTAINS;
                break;
            }
            case 4: {
                condition = EXACTLY;
                break;
            }
            case 5: {
                condition = BIGGER;
                break;
            }
            case 6: {
                condition = LESS;
                break;
            }
        }
        return condition;
    }

    public void deactivateFilterHistorySection() {
        this.m_history_list.deselectAll();
        this.m_delFilterHistory_button.setEnabled(false);
        this.m_moveToCurrent_button.setEnabled(false);
    }

    public void activateFilterHistorySection() {
        if (this.m_history_list.getItemCount() > 0) {
            this.m_history_list.select(0);
        }
        this.m_delFilterHistory_button.setEnabled(true);
        this.m_moveToCurrent_button.setEnabled(true);
        this.m_moveToHistory_button.setEnabled(false);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof org.eclipse.swt.widgets.List) {
            this.moveToCurrent();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button button = (Button)obj;
            if (button.isDisposed()) {
                return;
            }
            String fieldName = (String)button.getData();
            if (fieldName.equals(TYPE_A)) {
                this.m_type_a = button.getSelection() ? 1 : 0;
            } else if (fieldName.equals(TYPE_K)) {
                this.m_type_k = button.getSelection() ? 1 : 0;
            } else if (fieldName.equals(SELECT_EXISTING_VALUES_BTN)) {
                String colName = m_browserLabelManager.getName(this.m_column_Combo.getText());
                ExistingValuesDialog dialog = null;
                dialog = colName.equals("Node group") ? new ExistingValuesDialog(this.m_shell, colName) : new ExistingValuesDialog(this.m_shell, this.getExistingValuesList(colName));
                dialog.setBlockOnOpen(true);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    String value = dialog.getSelection();
                    this.m_matchExisting_field.setText(value == null ? "" : value.replace("/root/_Groups/", ""));
                }
            } else if (fieldName.equals(MATCH_CHECK)) {
                String colName = m_browserLabelManager.getName(this.m_column_Combo.getText());
                if (colName.equals("Duplicates") || colName.equals("Text")) {
                    this.m_match_check.setSelection(true);
                }
                this.m_textMatch_label.setEnabled(!this.m_match_check.getSelection());
                this.m_gde.enableField(this.m_matchExisting_field, !this.m_match_check.getSelection());
                this.m_gde.enableField(this.m_selectExisting_btn, !this.m_match_check.getSelection());
                this.m_gde.enableField(this.m_match_field, this.m_match_check.getSelection());
                this.m_gde.enableField(this.m_caseSensitive_check, this.m_match_check.getSelection());
            } else if (fieldName.equals(ADD_AS_NEW)) {
                this.saveFilter(true);
                UISettings.getInstance().storeAndReload();
            } else if (fieldName.equals(APPLY)) {
                this.saveFilter(false);
                UISettings.getInstance().storeAndReload();
            } else if (fieldName.equals(DEL_FILTER)) {
                int count = this.deleteFilter();
                if (count == 0) {
                    this.m_delFilter_button.setEnabled(false);
                    this.m_moveToHistory_button.setEnabled(false);
                }
                UISettings.getInstance().storeAndReload();
            } else if (fieldName.equals(MOVE_TO_HISTORY)) {
                this.moveToHistory();
                this.activateFilterHistorySection();
            } else if (fieldName.equals(LOAD_FROM_FILE)) {
                OpenFilterAction action = new OpenFilterAction(this.m_tab, this.m_message_tv);
                action.run();
                this.m_filter_tv.getTable().setSelection(0);
                this.m_tableProvider.updateTable(null);
                this.updateFilterDetails();
            } else if (fieldName.equals(SAVE_TO_FILE)) {
                SaveFilterAction action = new SaveFilterAction(this.m_message_tv);
                action.run();
            } else if (fieldName.equals(MOVE_TO_CURRENT)) {
                this.moveToCurrent();
                this.deactivateFilterHistorySection();
                this.m_moveToHistory_button.setEnabled(false);
                this.m_delFilter_button.setEnabled(false);
            } else if (fieldName.equals(DEL_FROM_HISTORY)) {
                int num = this.deleteFromHistory();
                if (num == 0) {
                    this.deactivateFilterHistorySection();
                }
            } else if (fieldName.equals(CLOSE)) {
                this.m_shell.dispose();
            }
        } else if (obj instanceof CCombo) {
            CCombo combo = (CCombo)obj;
            String value = combo.getText();
            if (combo.getData().equals(COLUMN_COMBO)) {
                String colName = m_browserLabelManager.getName(value);
                this.fillConditionCombo(colName);
                this.updateTextMatchSection(colName);
            }
        }
    }

    public void setFilterListSelection(String[] selection) {
        if (selection != null && selection.length > 0) {
            String fLabel = selection[0];
            int ii = 0;
            while (ii < this.m_filter_tv.getTable().getItemCount()) {
                TableItem ti = this.m_filter_tv.getTable().getItem(ii);
                EventFilter ef = (EventFilter)((Object)ti.getData());
                if (ef.getLabelOrName().equals(fLabel)) {
                    this.m_filter_tv.getTable().deselectAll();
                    this.m_filter_tv.getTable().setSelection(ii);
                    return;
                }
                ++ii;
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text text = (Text)obj;
            String name = (String)text.getData();
            String value = text.getText();
            if (YEAR_FIELD.equals(name)) {
                this.m_year_field.setBackground(BMUI.defaultBackground);
                if (value.length() > 0 && value.length() < 4) {
                    this.m_year_field.setBackground(BMUI.color_critical);
                } else if (value.length() == 4) {
                    try {
                        Integer.parseInt(this.m_year_field.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_year_field.setBackground(BMUI.color_critical);
                    }
                }
            } else if (MONTH_FIELD.equals(name)) {
                this.m_month_field.setBackground(BMUI.defaultBackground);
                if (value.length() > 0) {
                    try {
                        Integer.parseInt(this.m_month_field.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_month_field.setBackground(BMUI.color_critical);
                    }
                }
            } else if (DAY_FIELD.equals(name)) {
                this.m_day_field.setBackground(BMUI.defaultBackground);
                if (value.length() > 0) {
                    try {
                        Integer.parseInt(this.m_day_field.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_day_field.setBackground(BMUI.color_critical);
                    }
                }
            } else if (HRS_FIELD.equals(name)) {
                this.m_hrs_field.setBackground(BMUI.defaultBackground);
                if (value.length() > 0) {
                    try {
                        Integer.parseInt(this.m_hrs_field.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_hrs_field.setBackground(BMUI.color_critical);
                    }
                }
            } else if (MIN_FIELD.equals(name)) {
                this.m_min_field.setBackground(BMUI.defaultBackground);
                if (value.length() > 0) {
                    try {
                        Integer.parseInt(this.m_min_field.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_min_field.setBackground(BMUI.color_critical);
                    }
                }
            } else if (SEC_FIELD.equals(name)) {
                this.m_sec_field.setBackground(BMUI.defaultBackground);
                if (value.length() > 0) {
                    try {
                        Integer.parseInt(this.m_sec_field.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_sec_field.setBackground(BMUI.color_critical);
                    }
                }
            }
        }
    }

    public void open() {
        this.m_shell.setSize(760, 460);
        this.createContents((Composite)this.m_shell);
        this.m_shell.open();
        this.m_shell.pack();
    }

    public void shellClosed(ShellEvent e) {
        try {
            Control[] controls = this.m_compMain.getChildren();
            int i = 0;
            while (i < controls.length) {
                if (!controls[i].isDisposed()) {
                    controls[i].dispose();
                }
                ++i;
            }
            this.m_compMain.dispose();
            this.m_shell.dispose();
            this.m_shell = null;
        }
        catch (Throwable e1) {
            RTLogger.print(4, "", e1);
        }
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        Table t;
        if (e.getSource() instanceof Table && e.button == 1 && (t = (Table)e.getSource()).getData().equals(FILTER_TABLE)) {
            EventFilter ef = null;
            try {
                TableItem item = t.getItem(new Point(5, e.y));
                if (item != null) {
                    int h = item.getBounds().height;
                    int pos = e.y / h;
                    item = t.getItem(pos);
                    if (item == null) {
                        return;
                    }
                } else {
                    return;
                }
                ef = (EventFilter)((Object)item.getData());
                int columnIndex = this.getColumnIndex(e.x);
                if (columnIndex == 0) {
                    if (ef.m_isLocked) {
                        item.setChecked(!item.getChecked());
                        return;
                    }
                    ef.m_isActive = !ef.m_isActive;
                    item.setChecked(ef.m_isActive);
                    ViewerFilter[] filters = ViewFilterAction.getFilters(this.m_message_tv).toArray(new EventFilter[0]);
                    this.m_message_tv.setFilters(filters);
                }
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
    }

    public int getColumnIndex(int position) {
        int colIndex = -1;
        int start = 0;
        int end = 0;
        LinkedHashMap<Integer, Integer> m = new LinkedHashMap<Integer, Integer>();
        TableColumn[] colList = this.m_filter_tv.getTable().getColumns();
        int index = 0;
        while (index < colList.length) {
            m.put(index, colList[index].getWidth());
            ++index;
        }
        index = 0;
        while (index < m.size()) {
            if (index > 0) {
                start += Integer.valueOf(((Integer)m.get(index - 1)).toString()).intValue();
            }
            end = start + Integer.valueOf(((Integer)m.get(index)).toString());
            if (position >= start && position <= end) {
                colIndex = index;
                break;
            }
            ++index;
        }
        return colIndex;
    }

    public class ExistingValuesDialog
    extends StatusDialog {
        private final String LIST = "LIST";
        private final String TREE = "TREE";
        private ArrayList<String> m_values;
        private String m_selection;
        private String m_colName;
        private String m_type;

        public ExistingValuesDialog(Shell parentShell, ArrayList<String> values) {
            super(parentShell);
            this.LIST = "LIST";
            this.TREE = "TREE";
            this.m_values = null;
            this.m_selection = null;
            this.m_colName = null;
            this.m_type = null;
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
            this.setImage(BMUI.IMAGE_PRODUCT);
            this.setTitle("Existing Values");
            this.m_type = "LIST";
            this.m_values = values;
        }

        public ExistingValuesDialog(Shell parentShell, String colName) {
            super(parentShell);
            this.LIST = "LIST";
            this.TREE = "TREE";
            this.m_values = null;
            this.m_selection = null;
            this.m_colName = null;
            this.m_type = null;
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
            this.setImage(BMUI.IMAGE_PRODUCT);
            this.setTitle("Existing Values");
            this.m_colName = colName;
            this.m_type = "TREE";
        }

        protected Control createDialogArea(Composite parent) {
            Composite m_comp = new Composite(parent, 0);
            m_comp.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    try {
                        ((Composite)e.getSource()).dispose();
                    }
                    catch (Throwable throwable) {}
                }
            });
            m_comp.setLayout((Layout)new GridLayout(1, false));
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 350;
            gd.heightHint = 450;
            m_comp.setLayoutData((Object)gd);
            if (this.m_type.equals("LIST")) {
                this.createExistingValuesList(m_comp);
            } else if (this.m_colName.equals("Node group")) {
                this.createExistingValuesNodeGroupTree(m_comp);
            }
            return m_comp;
        }

        protected void createExistingValuesList(Composite parent) {
            org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, 2816);
            GridData gd = new GridData(4, 4, true, true);
            list.setLayoutData((Object)gd);
            int i = 0;
            while (i < this.m_values.size()) {
                if (!this.m_values.get(i).isEmpty()) {
                    list.add(this.m_values.get(i));
                }
                ++i;
            }
            list.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)e.getSource();
                    String[] selection = list.getSelection();
                    ExistingValuesDialog.this.m_selection = selection[0];
                    ((ExistingValuesDialog)ExistingValuesDialog.this).EventFilterDialog2.this.m_gde.enableField(ExistingValuesDialog.this.getButton(0), true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        protected void createExistingValuesNodeGroupTree(Composite parent) {
            final STreeViewer treeViewer = new STreeViewer(parent, 0x10000B00);
            treeViewer.setUseHashlookup(true);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 250;
            gd.heightHint = 250;
            treeViewer.getTree().setLayoutData((Object)gd);
            treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
            treeViewer.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider());
            treeViewer.setInput(Repository.getInstance().getNodeGroupTree());
            treeViewer.expandAll();
            treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection sel = (StructuredSelection)treeViewer.getSelection();
                    if (!sel.isEmpty()) {
                        Object o = sel.getFirstElement();
                        if (!(o instanceof GroupTreeObjectLast)) {
                            ExistingValuesDialog.this.m_selection = ((GroupTreeObject)o).getPath();
                            ((ExistingValuesDialog)ExistingValuesDialog.this).EventFilterDialog2.this.m_gde.enableField(ExistingValuesDialog.this.getButton(0), true);
                        } else {
                            ((ExistingValuesDialog)ExistingValuesDialog.this).EventFilterDialog2.this.m_gde.enableField(ExistingValuesDialog.this.getButton(0), false);
                        }
                    }
                }
            });
            treeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    GUIDisplayElements gui = new GUIDisplayElements();
                    StructuredSelection sel = (StructuredSelection)event.getViewer().getSelection();
                    if (!sel.isEmpty()) {
                        Object o = sel.getFirstElement();
                        if (!(o instanceof GroupTreeObjectLast)) {
                            ExistingValuesDialog.this.m_selection = ((GroupTreeObject)o).getPath();
                            gui.enableField(ExistingValuesDialog.this.getButton(0), true);
                        } else {
                            gui.enableField(ExistingValuesDialog.this.getButton(0), false);
                        }
                    }
                }
            });
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.getButton(0).setEnabled(false);
            this.getButton(1).setEnabled(true);
        }

        public String getSelection() {
            return this.m_selection;
        }

        protected void okPressed() {
            super.okPressed();
        }

        protected void cancelPressed() {
            super.cancelPressed();
        }
    }
}

