/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventFilterGroup;
import com.blixx.boom.engine.IEventProvider;
import com.blixx.boom.engine.IEventsSummary;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.engine.ServiceDashBoardProvider;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.EventFilterDialog2;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.policies.ViewLabelProvider;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.DashBoardServicesView;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.OpenServiceFilterAction;
import com.blixx.boom.gui.views.actions.SaveServiceFilterAction;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;

public class EventFilterServiceDialog
extends EventFilterDialog2 {
    private static final String EXPORT = "EXPORT";
    private static final String IMPORT = "IMPORT";
    private ServiceDashBoard m_service = null;
    private ServiceDashBoardProvider m_serviceProvider = null;
    private GroupTreeObject m_serviceTree = null;
    private GroupTreeObject m_serviceGTO = null;
    private Button m_delete_button = null;
    private Button m_add_group_button = null;
    private Button m_import_button = null;
    private Button m_export_button = null;
    private EventFilterGroup m_selectedEFG = null;
    private EventFilterGroup m_currentEFG = null;
    private static String DELETE = "DELELETE";
    private static String ADD_GROUP = "ADD_GROUP";
    private static String SAVE = "SAVE";
    private static String CANCEL = "CANCEL";
    private TreeEditor m_treeEditor = null;
    private boolean m_isNew = false;
    private MessageBrowserTab eventsBrowserTab;

    public EventFilterServiceDialog(String title, ServiceDashBoard service, ServiceDashBoardProvider serviceProvider, boolean isNew, IEventProvider esProvider, IEventsSummary esSummary) {
        super(null, title, null, esSummary);
        this.m_service = new ServiceDashBoard(service.getName(), service.getID(), esProvider);
        this.m_service.setMode(service.getMode());
        this.m_service.setDecription(service.getDescription());
        for (EventFilterGroup efg : service.getFilters().values()) {
            List<EventFilter> filters = efg.getFilters();
            EventFilterGroup efgNew = new EventFilterGroup(efg.getName());
            int i = 0;
            while (i < filters.size()) {
                EventFilter ef = filters.get(i);
                efgNew.addFilter(ef);
                ++i;
            }
            this.m_service.addFilters(efgNew);
        }
        this.m_serviceProvider = serviceProvider;
        this.m_isNew = isNew;
    }

    @Override
    public void setImage() {
        this.m_shell.setImage(BMUI.IMAGE_SDASH);
    }

    @Override
    protected void createContents(Composite parent) {
        super.createContents(parent);
        LinkedHashMap colIndices = new LinkedHashMap(m_colIndices);
        colIndices.remove("Severity");
        colIndices.remove("Time");
        colIndices.remove("SrvTime");
        ArrayList colList = new ArrayList(colIndices.keySet());
        String[] list = colList.toArray(new String[0]);
        this.m_column_Combo.setItems(list);
        int sel = 0;
        int i = 0;
        while (i < list.length) {
            if (list[i].equals((String)colList.get(0))) {
                sel = i;
            }
            ++i;
        }
        this.m_column_Combo.select(sel);
        Control[] controls = this.m_grp_severity.getChildren();
        int i2 = 0;
        while (i2 < controls.length) {
            controls[i2].dispose();
            ++i2;
        }
        this.m_grp_severity.dispose();
        controls = this.m_grp_dateMatch.getChildren();
        i2 = 0;
        while (i2 < controls.length) {
            controls[i2].dispose();
            ++i2;
        }
        this.m_grp_dateMatch.dispose();
        Composite comp = new Composite(this.m_compMain, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        CTabFolder folder = new CTabFolder(comp, 2816);
        folder.setSimple(false);
        folder.setBorderVisible(false);
        folder.setBackground(BMUI.color_unknown);
        folder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.eventsBrowserTab = new MessageBrowserTab(DashBoardServicesView.getInstance().getSite(), folder, 0, folder.getItemCount(), "Service: " + this.m_service.getName(), true, MessageBrowserTab.NEW_TAB, null);
        this.eventsBrowserTab.setData(this.m_service);
        folder.setSelection((CTabItem)this.eventsBrowserTab);
        this.m_message_tv = this.eventsBrowserTab.tableViewer;
        ((GridData)this.eventsBrowserTab.tableViewer.getTable().getLayoutData()).heightHint = 100;
        ((GridData)this.eventsBrowserTab.tableViewer.getTable().getLayoutData()).widthHint = 500;
        this.m_gde.enableField(this.m_addAsNew_button, false);
        this.m_gde.enableField(this.m_apply_button, false);
        Composite compButton = new Composite(this.m_compMain, 0);
        compButton.setLayout((Layout)new GridLayout(2, true));
        compButton.setLayoutData((Object)new GridData(131072, 1024, true, false, 2, 1));
        Button m_save_button = this.m_gde.addButton(compButton, SAVE, "  Save  ", true, 120, 60, 1, this);
        m_save_button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Button m_cancel_button = this.m_gde.addButton(compButton, CANCEL, "  Cancel  ", true, 120, 60, 1, this);
        m_cancel_button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Map<String, EventFilterGroup> map = this.m_service.getFilters();
        for (Map.Entry<String, EventFilterGroup> en : map.entrySet()) {
            EventFilterGroup efg = en.getValue();
            List<EventFilter> filters = efg.getFilters();
            for (EventFilter ef : filters) {
                ef.m_tv = this.m_message_tv;
                ef.m_isLocked = true;
            }
        }
        this.applyFiltersToTable(this.m_service);
    }

    @Override
    public void createFilterListSection(Composite parent) {
        Group grp_filterList = new Group(parent, 32);
        grp_filterList.setText("Current Filters: ");
        grp_filterList.setLayout((Layout)new GridLayout(2, false));
        grp_filterList.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite m_mainComp = new Composite((Composite)grp_filterList, 0);
        GridLayout gl = new GridLayout(1, false);
        m_mainComp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true, 1, 4);
        gd.widthHint = 250;
        gd.heightHint = 130;
        m_mainComp.setLayoutData((Object)gd);
        this.m_treeViewer = new STreeViewer(m_mainComp, 2820);
        this.m_treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        final Tree tree = this.m_treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, null));
        this.m_treeViewer.setInput((Object)this.createTree());
        this.m_treeViewer.expandAll();
        this.m_treeEditor = new TreeEditor(tree);
        this.m_treeEditor.grabHorizontal = true;
        this.m_treeEditor.horizontalAlignment = 16384;
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (tree.getSelectionCount() == 1) {
                    TreeItem item = tree.getSelection()[0];
                    GroupTreeObject gto = (GroupTreeObject)item.getData();
                    if (!gto.getTreeObject().getType().equals(BMUI.type_folder)) {
                        return;
                    }
                    RenameEFGAction editAction = new RenameEFGAction(EventFilterServiceDialog.this.m_treeViewer, EventFilterServiceDialog.this.m_message_tv, EventFilterServiceDialog.this.m_selectedEFG);
                    editAction.run();
                }
            }
        });
        this.m_treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (obj instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast ef_gtol = (GroupTreeObjectLast)obj;
                    EventFilterServiceDialog.this.m_selectedFilter = (EventFilter)((Object)ef_gtol.getTreeObject().getObject());
                    EventFilterServiceDialog.this.m_selectedEFG = null;
                    EventFilterServiceDialog.this.m_currentEFG = (EventFilterGroup)ef_gtol.getParent().getTreeObject().getObject();
                    EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_delete_button, true);
                    EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_import_button, false);
                    EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_export_button, false);
                    EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_addAsNew_button, true);
                    EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_apply_button, true);
                    EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_moveToCurrent_button, false);
                    EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_moveToHistory_button, true);
                    EventFilterServiceDialog.this.updateFilterDetails();
                    EventFilterServiceDialog.this.applyFiltersToTable(EventFilterServiceDialog.this.m_selectedFilter);
                    EventFilterServiceDialog.this.m_history_list.deselectAll();
                } else if (obj instanceof GroupTreeObject) {
                    GroupTreeObject gto = (GroupTreeObject)obj;
                    Object o = gto.getTreeObject().getObject();
                    if (o instanceof ServiceDashBoard) {
                        ServiceDashBoard service = (ServiceDashBoard)o;
                        EventFilterServiceDialog.this.m_selectedEFG = null;
                        EventFilterServiceDialog.this.m_currentEFG = null;
                        EventFilterServiceDialog.this.m_selectedFilter = null;
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_delete_button, false);
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_import_button, false);
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_export_button, false);
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_addAsNew_button, false);
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_apply_button, false);
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_moveToCurrent_button, false);
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_moveToHistory_button, false);
                        EventFilterServiceDialog.this.applyFiltersToTable(service);
                    } else if (o instanceof EventFilterGroup) {
                        EventFilterGroup eventFilterGroup = (EventFilterGroup)o;
                        EventFilterServiceDialog.this.m_currentEFG = eventFilterGroup;
                        EventFilterServiceDialog.this.m_selectedEFG = eventFilterGroup;
                        EventFilterServiceDialog.this.m_selectedFilter = null;
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_delete_button, true);
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_import_button, true);
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_export_button, true);
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_addAsNew_button, true);
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_apply_button, false);
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_moveToCurrent_button, false);
                        EventFilterServiceDialog.this.m_gde.enableField(EventFilterServiceDialog.this.m_moveToHistory_button, false);
                        EventFilterServiceDialog.this.applyFiltersToTable(EventFilterServiceDialog.this.m_selectedEFG);
                    }
                }
            }
        });
        this.createContentMenu();
        this.m_add_group_button = this.m_gde.addButton((Composite)grp_filterList, ADD_GROUP, " Add Group ", true, 120, 10, 1, this);
        ((GridData)this.m_add_group_button.getLayoutData()).horizontalAlignment = 4;
        this.m_delete_button = this.m_gde.addButton((Composite)grp_filterList, DELETE, " Delete ", true, 120, 10, 1, this);
        ((GridData)this.m_delete_button.getLayoutData()).horizontalAlignment = 4;
        this.m_import_button = this.m_gde.addButton((Composite)grp_filterList, IMPORT, " Import ", true, 120, 10, 1, this);
        ((GridData)this.m_import_button.getLayoutData()).horizontalAlignment = 4;
        this.m_export_button = this.m_gde.addButton((Composite)grp_filterList, EXPORT, " Export ", true, 120, 10, 1, this);
        ((GridData)this.m_export_button.getLayoutData()).horizontalAlignment = 4;
    }

    @Override
    public void updateHistoryList(List<String> selection) {
        if (this.m_history_list.getItemCount() > 0) {
            this.m_history_list.removeAll();
        }
        for (String fName : this.m_historyFilters.keySet()) {
            EventFilter ef = (EventFilter)((Object)this.m_historyFilters.get(fName));
            if (ef.m_column.equals("Severity") || ef.m_column.equals("Time") || ef.m_column.equals("SrvTime")) continue;
            this.m_history_list.add(fName);
        }
        this.setHistoryListSelection(selection);
    }

    @Override
    public void createButtonBar(Composite parent) {
        Composite compButton = new Composite(parent, 0);
        compButton.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData(131072, 128, true, true, 2, 1);
        gd.verticalIndent = 10;
        compButton.setLayoutData((Object)gd);
        this.m_addAsNew_button = this.m_gde.addButton(compButton, "ADD_AS_NEW", " Add As New ", true, 120, 60, 1, this);
        this.m_addAsNew_button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_apply_button = this.m_gde.addButton(compButton, "APPLY", " Apply ", true, 120, 60, 1, this);
        this.m_apply_button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
    }

    public GroupTreeObject createTree() {
        this.m_serviceTree = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
        this.m_serviceGTO = new GroupTreeObject(new TreeObject(this.m_service.getName(), "IMAGE_FOLDER_SDASH", this.m_service));
        Map<String, EventFilterGroup> map = this.m_service.getFilters();
        for (Map.Entry<String, EventFilterGroup> en : map.entrySet()) {
            EventFilterGroup efg = en.getValue();
            GroupTreeObject efgGTO = new GroupTreeObject(new TreeObject(efg.getName(), BMUI.type_folder, efg));
            List<EventFilter> filters = efg.getFilters();
            for (EventFilter ef : filters) {
                GroupTreeObjectLast efGTO = new GroupTreeObjectLast(new TreeObject(ef.getLabelOrName(), BMUI.type_filter, (Object)ef), null, "fgf");
                try {
                    efgGTO.addElementNoSorting(efGTO);
                }
                catch (Throwable throwable) {}
            }
            this.m_serviceGTO.addElementNoSorting(efgGTO);
        }
        this.m_serviceTree.addElementNoSorting(this.m_serviceGTO);
        return this.m_serviceTree;
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setMenu(menu);
        DashBoardServicesView.getInstance().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_treeViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection ssel = (StructuredSelection)EventFilterServiceDialog.this.m_treeViewer.getSelection();
                    if (ssel.size() == 1) {
                        GroupTreeObject o = (GroupTreeObject)ssel.getFirstElement();
                        if (o instanceof GroupTreeObjectLast) {
                            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                            manager.add((IAction)new DeleteFilterAction(gtol));
                        } else {
                            GroupTreeObject gto = o;
                            String type = gto.getTreeObject().getType();
                            if (type.equals("IMAGE_FOLDER_SDASH")) {
                                manager.add((IAction)new AddFilterGroupAction());
                                manager.add((IAction)new RenameServiceAction());
                            } else if (type.equals(BMUI.type_folder)) {
                                manager.add((IAction)new RenameEFGAction(EventFilterServiceDialog.this.m_treeViewer, EventFilterServiceDialog.this.m_message_tv, EventFilterServiceDialog.this.m_selectedEFG));
                                manager.add((IAction)new AddFilterGroupAction());
                                manager.add((IAction)new DeleteFilterGroupAction(gto));
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new OpenServiceFilterAction(EventFilterServiceDialog.this.m_treeViewer, gto, EventFilterServiceDialog.this.m_message_tv, EventFilterServiceDialog.this.m_selectedEFG));
                                manager.add((IAction)new SaveServiceFilterAction(EventFilterServiceDialog.this.m_message_tv, EventFilterServiceDialog.this.m_selectedEFG));
                            }
                        }
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(EventFilterServiceDialog.this.m_treeViewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(EventFilterServiceDialog.this.m_treeViewer, "CollapseAll"));
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void refreshTree() {
        Object[] expanded = this.m_treeViewer.getExpandedElements();
        this.m_treeViewer.setInput((Object)this.createTree());
        int i = 0;
        while (i < expanded.length) {
            this.m_treeViewer.setExpandedState(expanded[i], true);
            ++i;
        }
    }

    public void applyFiltersToTable(EventFilterGroup efg) {
        this.removeCurrentFilters();
        if (efg != null) {
            List<EventFilter> filterList = efg.getFilters();
            int i = 0;
            while (i < filterList.size()) {
                EventFilter ef = filterList.get(i);
                ViewFilterAction.addFilter(null, this.m_message_tv, ef);
                ++i;
            }
        }
        this.eventsBrowserTab.setText("Group: " + efg.getName());
    }

    public void applyFiltersToTable(ServiceDashBoard service) {
        this.removeCurrentFilters();
        if (service != null) {
            ViewFilterAction.addFilter(null, this.m_message_tv, service);
        }
        this.eventsBrowserTab.setText("Service: " + service.getLabelOrName());
    }

    public void applyFiltersToTable(EventFilter eventFilter) {
        this.removeCurrentFilters();
        if (eventFilter != null) {
            ViewFilterAction.addFilter(null, this.m_message_tv, eventFilter);
        }
        this.eventsBrowserTab.setText("Filter: " + eventFilter.getLabelOrName());
    }

    private void removeCurrentFilters() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<EventFilter> it = ViewFilterAction.getActiveFiltersIterator(this.m_message_tv);
        while (it.hasNext()) {
            EventFilter ef = it.next();
            list.add(ef.getLabelOrName());
        }
        if (list.size() > 0) {
            ViewFilterAction.removeFilter(null, this.m_message_tv, list.toArray(new String[0]));
        }
    }

    @Override
    public void removeFilter(EventFilter ef) {
        if (ef == null) {
            return;
        }
        EventFilter filter = ef;
        this.m_currentEFG.removeFilter(filter);
    }

    @Override
    public void addFilter(EventFilter ef) {
        if (this.m_currentEFG == null) {
            return;
        }
        boolean ef_exist = this.m_currentEFG.hasFilter(ef);
        if (!ef_exist) {
            this.m_currentEFG.addFilter(ef);
            this.refreshTree();
            GroupTreeObject efgGTO = this.m_serviceGTO.findFirstGroupByName(this.m_currentEFG.getName());
            GroupTreeObjectLast efGTOL = efgGTO.findElement(ef.getLabelOrName(), BMUI.type_filter);
            this.m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)efGTOL), true);
            this.m_selectedFilter = ef;
            this.m_selectedEFG = null;
        } else {
            GroupTreeObject efg_GTO = this.m_serviceGTO.findFirstGroupByName(this.m_currentEFG.getName());
            GroupTreeObjectLast fitlerGTOL = efg_GTO.findElement(ef.getLabelOrName(), BMUI.type_filter);
            this.m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)fitlerGTOL), true);
            this.m_selectedFilter = ef;
            this.m_selectedEFG = null;
        }
    }

    @Override
    public int deleteFilter() {
        EventFilter ef_toDelete = null;
        if (this.m_selectedFilter != null && this.m_currentEFG != null) {
            ef_toDelete = this.m_selectedFilter;
            this.m_currentEFG.removeFilter(ef_toDelete);
            this.refreshTree();
        } else {
            GroupTreeObject o;
            StructuredSelection ssel = (StructuredSelection)this.m_treeViewer.getSelection();
            if (ssel.size() > 0 && (o = (GroupTreeObject)ssel.getFirstElement()) instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                ef_toDelete = (EventFilter)((Object)gtol.getTreeObject().getObject());
                EventFilterGroup efg = (EventFilterGroup)gtol.getParent().getTreeObject().getObject();
                efg.removeFilter(ef_toDelete);
                this.m_currentEFG = efg;
            }
        }
        GroupTreeObject efgGTO = new GroupTreeObject(new TreeObject(this.m_currentEFG.getName(), BMUI.type_folder, this.m_currentEFG));
        this.m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)efgGTO), true);
        this.m_selectedEFG = this.m_currentEFG;
        this.m_selectedFilter = null;
        return this.m_treeViewer.getTree().getItemCount();
    }

    @Override
    public EventFilter saveFilter(boolean addAsNew) {
        EventFilter ef = super.saveFilter(addAsNew);
        ef.m_isLocked = true;
        return ef;
    }

    @Override
    public void moveToCurrent() {
        if (this.m_currentEFG == null) {
            return;
        }
        int efCount = 0;
        EventFilter ef = null;
        EventFilter efSelect = null;
        String[] selection = this.m_history_list.getSelection();
        int i = 0;
        while (i < selection.length) {
            String fName = selection[i];
            ef = (EventFilter)((Object)this.m_historyFilters.get(fName));
            if (ef != null) {
                ef.m_tv = this.m_message_tv;
                if (!this.m_currentEFG.hasFilter(ef)) {
                    this.m_currentEFG.addFilter(ef);
                    ++efCount;
                }
                efSelect = ef;
            }
            ++i;
        }
        if (efCount > 0) {
            this.refreshTree();
        }
        if (efSelect != null) {
            GroupTreeObject efg_GTO = this.m_serviceGTO.findFirstGroupByName(this.m_currentEFG.getName());
            GroupTreeObjectLast fitlerGTOL = efg_GTO.findElement(efSelect.getLabelOrName(), BMUI.type_filter);
            this.m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)fitlerGTOL), true);
            this.m_selectedFilter = efSelect;
            this.m_selectedEFG = null;
            this.updateFilterDetails();
        }
    }

    @Override
    public void moveToHistory() {
        int efCount = 0;
        ArrayList<String> list = new ArrayList<String>();
        StructuredSelection ssel = (StructuredSelection)this.m_treeViewer.getSelection();
        for (Object o : ssel) {
            if (!(o instanceof GroupTreeObjectLast)) continue;
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
            EventFilter ef = (EventFilter)((Object)gtol.getTreeObject().getObject());
            String fName = ef.getLabelOrName();
            if (!this.m_historyFilters.containsKey(fName)) {
                this.m_historyFilters.put(fName, ef);
                ++efCount;
            }
            list.add(fName);
        }
        if (efCount > 0) {
            this.saveHistory();
            this.updateHistoryList(list);
        }
        if (list.size() > 0) {
            String[] items = new String[list.size()];
            int i = 0;
            while (i < list.size()) {
                items[i] = (String)list.get(i);
                ++i;
            }
            this.m_history_list.setSelection(items);
        }
    }

    @Override
    public void setFilterListSelection(String[] selection) {
    }

    @Override
    public void open() {
        super.open();
        this.m_shell.setSize(760, 600);
        this.m_shell.pack();
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button button = (Button)e.getSource();
            String fieldName = (String)button.getData();
            ISelection iSelect = this.m_treeViewer.getSelection();
            Object obj = ((IStructuredSelection)iSelect).getFirstElement();
            if (fieldName.equals(DELETE)) {
                if (obj instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
                    DeleteFilterAction deleteAction = new DeleteFilterAction(gtol);
                    deleteAction.run();
                } else if (obj instanceof GroupTreeObject) {
                    GroupTreeObject gto = (GroupTreeObject)obj;
                    DeleteFilterGroupAction deleteAction = new DeleteFilterGroupAction(gto);
                    deleteAction.run();
                }
            } else if (fieldName.equals(IMPORT)) {
                if (obj instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
                    OpenServiceFilterAction action = new OpenServiceFilterAction(this.m_treeViewer, gtol.getParent(), this.m_message_tv, this.m_selectedEFG);
                    action.run();
                    this.refreshTree();
                } else if (obj instanceof GroupTreeObject) {
                    GroupTreeObject gto = (GroupTreeObject)obj;
                    OpenServiceFilterAction action = new OpenServiceFilterAction(this.m_treeViewer, gto, this.m_message_tv, this.m_selectedEFG);
                    action.run();
                    this.refreshTree();
                }
            } else if (fieldName.equals(EXPORT)) {
                SaveServiceFilterAction action = new SaveServiceFilterAction(this.m_message_tv, this.m_selectedEFG);
                action.run();
            } else if (fieldName.equals(ADD_GROUP)) {
                AddFilterGroupAction addGroupAction = new AddFilterGroupAction();
                addGroupAction.run();
            } else if (fieldName.equals(SAVE)) {
                if (this.m_isNew) {
                    this.m_isNew = false;
                }
                if (!this.m_service.isLocalOnly()) {
                    this.m_service.setMode(1);
                }
                this.m_serviceProvider.replaceService(this.m_service);
                this.m_serviceProvider.saveLocalFile();
                this.m_service.setChanged();
                this.m_shell.dispose();
                DashBoardServicesView.m_openEFSDialogs.remove(this.m_service.getID());
                this.m_serviceProvider.refresh();
            } else if (fieldName.equals(CANCEL)) {
                this.m_shell.dispose();
                DashBoardServicesView.m_openEFSDialogs.remove(this.m_service.getID());
            } else {
                super.widgetSelected(e);
            }
        } else {
            super.widgetSelected(e);
        }
    }

    @Override
    public void shellClosed(ShellEvent e) {
        super.shellClosed(e);
        DashBoardServicesView.m_openEFSDialogs.remove(this.m_service.getID());
    }

    public class AddFilterGroupAction
    extends Action {
        public AddFilterGroupAction() {
            super("addFilterGroupAction");
            this.setText("Add Filter Group");
            this.setId("addfiltergroupaction");
            if (Repository.getInstance().getRights(1000) < 3) {
                this.setEnabled(false);
            }
        }

        public void run() {
            String name;
            InputDialog id = new InputDialog(EventFilterServiceDialog.this.m_shell, " Add Filter Group", "Please enter a Filter Group Name:", "", null);
            id.setBlockOnOpen(true);
            int res = id.open();
            if (res == 0 && (name = id.getValue()) != null && name.length() > 0) {
                if (EventFilterServiceDialog.this.m_service.getFilterGroupByName(name) != null) {
                    new ShowMessageBox("Event Filter Group", "Filter name does already exist!", 8);
                    this.run();
                } else {
                    EventFilterGroup efg = new EventFilterGroup(name);
                    EventFilterServiceDialog.this.m_service.addFilters(efg);
                    EventFilterServiceDialog.this.refreshTree();
                    GroupTreeObject newEFG_GTO = EventFilterServiceDialog.this.m_serviceGTO.findFirstGroupByName(efg.getName());
                    EventFilterServiceDialog.this.m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)newEFG_GTO), true);
                    EventFilterGroup eventFilterGroup = efg;
                    EventFilterServiceDialog.this.m_currentEFG = eventFilterGroup;
                    EventFilterServiceDialog.this.m_selectedEFG = eventFilterGroup;
                }
            }
        }
    }

    public class DeleteFilterAction
    extends Action {
        public DeleteFilterAction(GroupTreeObjectLast gtol) {
            super("deleteFilterction");
            this.setText("Delete Filter");
            this.setId("deletefilteraction");
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            if (gtol == null) {
                this.setEnabled(false);
            }
        }

        public void run() {
            EventFilterServiceDialog.this.deleteFilter();
        }
    }

    public class DeleteFilterGroupAction
    extends Action {
        private GroupTreeObject m_gto;

        public DeleteFilterGroupAction(GroupTreeObject gto) {
            super("deleteFilterGroupAction");
            this.m_gto = null;
            this.setText("Delete Filter Group");
            this.setId("deletefiltergroupaction");
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            if (Repository.getInstance().getRights(1000) < 3) {
                this.setEnabled(false);
            }
            if (gto == null || gto.getTreeObject().getType().equals("IMAGE_FOLDER_SDASH")) {
                this.setEnabled(false);
            }
            this.m_gto = gto;
        }

        public void run() {
            EventFilterServiceDialog.this.m_service.removeFilters((EventFilterGroup)this.m_gto.getTreeObject().getObject());
            EventFilterServiceDialog.this.refreshTree();
            EventFilterServiceDialog.this.m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)EventFilterServiceDialog.this.m_serviceGTO), true);
            EventFilterServiceDialog.this.m_currentEFG = null;
            EventFilterServiceDialog.this.m_selectedEFG = null;
        }
    }

    public class RenameEFGAction
    extends Action {
        private EventFilterGroup m_selectedEFG;
        private TreeViewer m_treeViewer;

        public RenameEFGAction(TreeViewer treeViewer, TableViewer message_tv, EventFilterGroup selectedEFG) {
            super("RenameEventFilterGroup");
            this.m_selectedEFG = null;
            this.m_treeViewer = null;
            this.setText("Rename Filter Group");
            this.setId("renameeventfiltergroup");
            this.m_treeViewer = treeViewer;
            this.m_selectedEFG = selectedEFG;
            if (this.m_selectedEFG == null) {
                this.setEnabled(false);
            }
        }

        public void run() {
            final TreeItem item = this.m_treeViewer.getTree().getSelection()[0];
            final Text text = new Text((Composite)this.m_treeViewer.getTree(), 2048);
            text.setText(item.getText());
            text.selectAll();
            text.setFocus();
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent event) {
                    item.setText(text.getText());
                    text.dispose();
                }
            });
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    switch (event.keyCode) {
                        case 13: {
                            EventFilterServiceDialog.this.m_service.removeFilters(RenameEFGAction.this.m_selectedEFG);
                            String newName = text.getText();
                            item.setText(newName);
                            RenameEFGAction.this.m_selectedEFG.setName(newName);
                            EventFilterServiceDialog.this.m_service.addFilters(RenameEFGAction.this.m_selectedEFG);
                        }
                        case 27: {
                            text.dispose();
                        }
                    }
                }
            });
            EventFilterServiceDialog.this.m_treeEditor.setEditor((Control)text, item);
        }
    }

    public class RenameServiceAction
    extends Action {
        public RenameServiceAction() {
            super("renameServiceName");
            this.setText("Rename");
            this.setId("renameServiceName");
            if (Repository.getInstance().getRights(1000) < 3) {
                this.setEnabled(false);
            }
        }

        public void run() {
            String name;
            InputDialog id = new InputDialog(EventFilterServiceDialog.this.m_shell, " Rename", "Service Name:", EventFilterServiceDialog.this.m_service.getName(), null);
            id.setBlockOnOpen(true);
            int res = id.open();
            if (res == 0 && (name = id.getValue()) != null && name.length() > 0) {
                EventFilterServiceDialog.this.m_service.setName(name);
                EventFilterServiceDialog.this.m_serviceProvider.replaceService(EventFilterServiceDialog.this.m_service);
                EventFilterServiceDialog.this.refreshTree();
            }
        }
    }
}

