/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileDialog
extends InputDialog
implements ModifyListener {
    private String m_initalValue = null;
    private String m_fileName = null;

    public FileDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, String fileName, IInputValidator validator) {
        super(parentShell, dialogTitle, dialogMessage, initialValue == null ? "" : initialValue, validator);
        this.m_initalValue = initialValue;
        this.m_fileName = fileName;
    }

    protected int getInputTextStyle() {
        return 2308;
    }

    protected Control createDialogArea(Composite parent) {
        GUIDisplayElements gui = new GUIDisplayElements();
        Composite comp = (Composite)super.createDialogArea(parent);
        ((GridLayout)comp.getLayout()).marginWidth = 15;
        ((GridLayout)comp.getLayout()).marginTop = 5;
        Text inputField = this.getText();
        ((GridData)inputField.getLayoutData()).widthHint = 500;
        ((GridData)inputField.getLayoutData()).verticalIndent = 2;
        gui.addDefaultTextContentMenu(inputField, true);
        if (this.m_fileName != null && this.m_fileName.length() > 0) {
            inputField.setText(this.m_fileName);
        }
        inputField.addModifyListener((ModifyListener)this);
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button ok = this.createButton(parent, 0, "Save", true);
        ok.setEnabled(false);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    public void modifyText(ModifyEvent e) {
        Text text = (Text)e.getSource();
        String fName = text.getText().trim();
        NameValidatorFile validator = new NameValidatorFile();
        if (fName.length() == 0) {
            text.setBackground(BMUI.color_critical);
            text.setToolTipText("Empty file name!");
        } else if (fName.length() > 255) {
            text.setBackground(BMUI.color_critical);
            text.setToolTipText("file name is too long (max. 255 chars)!");
        } else if (fName.startsWith(".")) {
            text.setBackground(BMUI.color_critical);
            text.setToolTipText("file name does not start with a '.' !");
        } else if (validator.isValid(fName) != null) {
            text.setBackground(BMUI.color_critical);
            text.setToolTipText(validator.isValid(fName));
            this.getButton(0).setEnabled(false);
        } else if (this.m_initalValue != null && this.m_initalValue.equals(fName)) {
            text.setBackground(BMUI.color_white);
            text.setToolTipText("");
            this.getButton(0).setEnabled(true);
        } else {
            text.setBackground(BMUI.color_white);
            text.setToolTipText("");
            this.getButton(0).setEnabled(true);
        }
    }
}

