/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventFilterAgentAndHost;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.gui.dialogs.EventFilterDialog2;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableItem;

public class FilterTableProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private ArrayList<EventFilter> m_elements = null;
    private TableViewer m_message_tv = null;
    private TableViewer m_filter_tv = null;
    private EventFilterDialog2 m_evDialog = null;

    public FilterTableProvider(TableViewer message_tv, TableViewer filter_tv, EventFilterDialog2 evDialog) {
        this.m_message_tv = message_tv;
        this.m_filter_tv = filter_tv;
        this.m_elements = new ArrayList();
        this.m_evDialog = evDialog;
        this.loadFilters();
    }

    public void loadFilters() {
        this.m_elements = new ArrayList();
        Iterator<EventFilter> it = ViewFilterAction.getActiveFiltersIterator(this.m_message_tv);
        while (it.hasNext()) {
            EventFilter ef = it.next();
            if (ef instanceof EventFilterAgentAndHost || ef instanceof ServiceDashBoard || ef.m_tv != this.m_message_tv) continue;
            this.m_elements.add(ef);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.m_elements.toArray();
    }

    public void updateTable(EventFilter ef) {
        this.m_evDialog.m_selectedFilter = ef;
        this.loadFilters();
        this.m_filter_tv.refresh();
        TableItem[] itemList = this.m_filter_tv.getTable().getItems();
        if (ef != null) {
            int i = 0;
            while (i < itemList.length) {
                if (itemList[i].getText(1).equals(ef.toString())) {
                    this.m_filter_tv.getTable().setSelection(i);
                }
                ++i;
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        EventFilter ef = (EventFilter)((Object)element);
        switch (columnIndex) {
            case 0: {
                TableItem[] items = this.m_filter_tv.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].getData() == ef) {
                        items[i].setChecked(ef.m_isActive);
                        break;
                    }
                    ++i;
                }
                return "";
            }
            case 1: {
                return ef.getLabelOrName();
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

